/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.appgen.component.ConditionAdapterInterface;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.StoreModelitem;
import jp.jasminesoft.jfc.appgen.component.appschema.ConditionUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditiongroup;
import jp.jasminesoft.jfc.gen.appschema.IConditiongroupChoice;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditiongroupAdapter
implements ConditionAdapterInterface {
    private static final Logger logger = LogManager.getLogger(ConditiongroupAdapter.class);
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected final Conditiongroup conditiongroup;
    protected StoreModel storeModel;
    private static final Set<String> PATTERN;
    private static final Condition USERIDJSHPARAM_CONDITION;
    private static final Condition JGROUPIDJSHPARAM_CONDITION;

    public ConditiongroupAdapter(Conditiongroup conditiongroup) {
        this.conditiongroup = conditiongroup;
        this.storeModel = new StoreModel(ConditionUtils.getStoreModel(conditiongroup));
    }

    @Override
    public boolean isConditionGroup() {
        return true;
    }

    public String code() {
        if (!this.isConformedToPattern()) {
            logger.error(rman.getValue("criteriaConverter.illegal.implicit", new Object[]{this.getActionId(), this.conditiongroup}));
            return "";
        }
        if (this.conditiongroup.sizeContent() == 3) {
            return this.code01();
        }
        if (this.conditiongroup.sizeContent() == 2) {
            return this.code02();
        }
        logger.error(rman.getValue("criteriaConverter.illegal.implicit", new Object[]{this.getActionId(), this.conditiongroup}));
        return "";
    }

    private String getActionId() {
        Action action = ConditionUtils.getAction(this.conditiongroup);
        if (action == null) {
            return "";
        }
        return action.getId();
    }

    private String code01() {
        String useridjshparam = this.getUseridjshparam();
        String jgroupidjshparam = this.getJgroupidjshparam();
        StringBuilder sb = new StringBuilder().append("        List<Criterion> disjunction = new ArrayList<Criterion>();").append("\n").append("        List<Criterion> conjunction = new ArrayList<Criterion>();").append("\n").append("        conjunction.add(CriteriaUtils.eq(").append(this.criteriaParameter(useridjshparam)).append("meta.").append(useridjshparam).append(",").append("\n").append("                new PermissionEvaluator(user(), \"jgroup\", \"manager\").evaluate(").append("\n").append("                        null, user().getUsername())));").append("\n").append("        conjunction.add(CriteriaUtils.eq(").append(this.criteriaParameter(jgroupidjshparam)).append("meta.").append(jgroupidjshparam).append(",").append("\n").append("                new PermissionEvaluator(user(), \"admin\", \"all\").evaluate(").append("\n").append("                        null, ArrayUtils.toObject(user().getSubGroupIds()))));").append("\n").append("        disjunction.add(CriteriaUtils.and(conjunction));").append("\n").append("        disjunction.add(CriteriaUtils.eq(").append(this.criteriaParameter(useridjshparam)).append("meta.").append(useridjshparam).append(",").append("\n").append("                new PermissionEvaluator(user(), \"admin\", \"all\").evaluate(").append("\n").append("                        null, user().getUsername())));").append("\n").append("        criteria.add(CriteriaUtils.or(disjunction));").append("\n");
        return sb.toString();
    }

    private String code02() {
        String useridjshparam = this.getUseridjshparam();
        String jgroupidjshparam = this.getJgroupidjshparam();
        StringBuilder sb = new StringBuilder().append("        List<Criterion> criterions = new ArrayList<Criterion>();").append("\n").append("        criterions.add(CriteriaUtils.eq(").append(this.criteriaParameter(jgroupidjshparam)).append("meta.").append(jgroupidjshparam).append(",").append("\n").append("                new PermissionEvaluator(user(), \"admin\",  \"all\").evaluate(").append("\n").append("                        null, ArrayUtils.toObject(user().getSubGroupIds()))));").append("\n").append("        criterions.add(CriteriaUtils.eq(").append(this.criteriaParameter(useridjshparam)).append("meta.").append(useridjshparam).append(",").append("\n").append("                new PermissionEvaluator(user(), \"admin\", \"all\").evaluate(").append("\n").append("                        null, user().getUsername())));").append("\n").append("        criteria.add(CriteriaUtils.or(criterions));").append("\n");
        return sb.toString();
    }

    private String criteriaParameter(String itemName) {
        StoreModelitem storeModelitem = this.storeModel.getModelitem(itemName);
        if (storeModelitem.isChild() || storeModelitem.isReference() || storeModelitem.isMultiple() || storeModelitem.isCheckbox()) {
            return "\n                criteria, ";
        }
        return "";
    }

    private String getUseridjshparam() {
        return this.lookupTargetConditionName(USERIDJSHPARAM_CONDITION);
    }

    private String getJgroupidjshparam() {
        return this.lookupTargetConditionName(JGROUPIDJSHPARAM_CONDITION);
    }

    private String lookupTargetConditionName(Condition target) {
        for (IConditiongroupChoice c : this.conditiongroup.getContent()) {
            if (!Condition.class.isInstance(c)) continue;
            Condition original = (Condition)c;
            Condition copy = this.cloneCondition(original);
            copy.setName(null);
            copy.setEmptycase(null);
            copy.setMatchtype(null);
            copy.setStartPrefix(null);
            copy.setEndPrefix(null);
            copy.setIgnoreModelitemCheck(null);
            copy.setNo(null);
            copy.setRestrictFixedValue(null);
            copy.setUseAndOrSearch(null);
            copy.setUseindex(null);
            copy.setValidCode(null);
            if (!target.makeTextDocument().equals(copy.makeTextDocument())) continue;
            return AppSchemaUtil.getChildPart(original.getName());
        }
        return "";
    }

    private boolean isConformedToPattern() {
        for (IConditiongroupChoice c : this.conditiongroup.getContent()) {
            if (!Condition.class.isInstance(c)) {
                return false;
            }
            Condition condition = this.cloneCondition((Condition)c);
            condition.setName(null);
            condition.setEmptycase(null);
            condition.setMatchtype(null);
            condition.setStartPrefix(null);
            condition.setEndPrefix(null);
            condition.setIgnoreModelitemCheck(null);
            condition.setNo(null);
            condition.setRestrictFixedValue(null);
            condition.setUseAndOrSearch(null);
            condition.setUseindex(null);
            condition.setValidCode(null);
            if (PATTERN.contains(condition.makeTextDocument())) continue;
            return false;
        }
        return true;
    }

    private Condition cloneCondition(Condition c) {
        try {
            return new Condition(c.makeDocument());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        Condition condition = new Condition();
        condition.setType("username");
        condition.setCond("EQ");
        condition.setImplicit(true);
        condition.setExceptPermname("jgroup");
        condition.setExceptPermaction("manager");
        set.add(condition.makeTextDocument());
        JGROUPIDJSHPARAM_CONDITION = new Condition();
        JGROUPIDJSHPARAM_CONDITION.setType("jgroupid");
        JGROUPIDJSHPARAM_CONDITION.setCond("EQ");
        JGROUPIDJSHPARAM_CONDITION.setImplicit(true);
        JGROUPIDJSHPARAM_CONDITION.setExceptPermname("admin");
        JGROUPIDJSHPARAM_CONDITION.setExceptPermaction("all");
        set.add(JGROUPIDJSHPARAM_CONDITION.makeTextDocument());
        USERIDJSHPARAM_CONDITION = new Condition();
        USERIDJSHPARAM_CONDITION.setType("username");
        USERIDJSHPARAM_CONDITION.setCond("EQ");
        USERIDJSHPARAM_CONDITION.setImplicit(true);
        USERIDJSHPARAM_CONDITION.setExceptPermname("admin");
        USERIDJSHPARAM_CONDITION.setExceptPermaction("all");
        USERIDJSHPARAM_CONDITION.setOperator("OR");
        set.add(USERIDJSHPARAM_CONDITION.makeTextDocument());
        PATTERN = Collections.unmodifiableSet(set);
    }
}

