/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.ArrayList;
import jp.jasminesoft.jfc.appgen.component.filter.StoreModelFilter;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Subdatabase;

public class DatabaseAdapter {
    protected Database database;

    public DatabaseAdapter(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getDialect() {
        return DbTypeManager.getHibernateDialect(this.database);
    }

    public String[] getModelIds() {
        Project project = this.getProject();
        Model[] storeModels = new StoreModelFilter().filter(project.rGetRNodes());
        ArrayList<String> list = new ArrayList<String>();
        for (Model storeModel : storeModels) {
            if (!this.database.getName().equals(storeModel.getSubdatabase())) continue;
            list.add(storeModel.getId());
        }
        return list.toArray(new String[list.size()]);
    }

    public Project getProject() {
        if (this.database == null) {
            return null;
        }
        IRNode irNode = this.database.rGetParentRNode();
        if (irNode instanceof Subdatabase) {
            irNode = irNode.rGetParentRNode();
        }
        return (Project)irNode.rGetParentRNode();
    }
}

