/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.ArrayList;
import java.util.HashMap;
import jp.jasminesoft.jfc.appgen.component.BaseModel;
import jp.jasminesoft.jfc.appgen.component.LpButtonfield;
import jp.jasminesoft.jfc.appgen.component.LpContainerItem;
import jp.jasminesoft.jfc.appgen.component.LpItem;
import jp.jasminesoft.jfc.appgen.component.LpModelitem;
import jp.jasminesoft.jfc.appgen.component.ModelType;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Buttonfield;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LpModel
extends BaseModel {
    private static final Logger logger = LogManager.getLogger(LpModel.class);

    public LpModel(Model lpModel) {
        super(lpModel);
        if (!ModelType.PRESENTATION.equals((Object)ModelType.modelTypeValue(lpModel))) {
            throw new IllegalArgumentException("model type is not presentation. [type: " + lpModel.getType() + "]");
        }
    }

    public LpButtonfield[] getButtonfields() {
        ArrayList<LpButtonfield> list = new ArrayList<LpButtonfield>();
        for (Buttonfield buttonfield : ModelUtils.getButtonfields(this.model)) {
            list.add(new LpButtonfield(this.model, buttonfield));
        }
        return list.toArray(new LpButtonfield[list.size()]);
    }

    public LpItem[] getModelitems() {
        ArrayList<LpItem> list = new ArrayList<LpItem>();
        HashMap<String, LpContainerItem> containers = new HashMap<String, LpContainerItem>();
        for (Modelitem modelitem : ModelUtils.getModelitems(this.model)) {
            if (AppSchemaUtil.isGenerationModelitem(modelitem.getName(), this.model)) continue;
            if (!AppSchemaUtil.hasChildPart(modelitem.getName())) {
                list.add(new LpModelitem(this.model, modelitem));
                continue;
            }
            String parent = AppSchemaUtil.getParentPart(modelitem.getName());
            LpContainerItem containerItem = (LpContainerItem)containers.get(parent);
            if (containerItem == null) {
                containerItem = new LpContainerItem(this.model, parent);
                containers.put(parent, containerItem);
                list.add(containerItem);
            }
            containerItem.addChild(new LpModelitem(this.model, modelitem));
        }
        return list.toArray(new LpItem[list.size()]);
    }

    public Model getStoreModel() {
        return AppSchemaUtil.getStoreModel(this.model);
    }
}

