/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.List;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.appgen.component.AbstractModelitem;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Chartype;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.util.StringUtil;

public class PresentationModelitem
extends AbstractModelitem {
    public PresentationModelitem(Model model, Modelitem modelitem) {
        super(model, modelitem);
    }

    public List<Chartype> getChartypes() {
        return AppSchemaUtil.getChartypes(this.modelitem);
    }

    public String chartypesArrayCodes() {
        List<Chartype> chartypes = this.getChartypes();
        if (chartypes.size() == 1 && "number".equals(chartypes.get(0).getContent())) {
            return "new SingleChartype(NUMBER)";
        }
        return chartypes.stream().map(chartype -> this.newInstanceCode((Chartype)chartype)).collect(Collectors.joining(", "));
    }

    private String newInstanceCode(Chartype chartype) {
        StringBuilder codes = new StringBuilder();
        String type = chartype.getContent();
        codes.append("new ");
        if (type.startsWith("any-character:")) {
            String anyChars = StringUtils.removeStart((String)type, (String)"any-character:");
            codes.append("CtAnyCharacter").append("(\"").append(StringUtil.convertJavaString((String)anyChars)).append("\"");
            if (chartype.getMaxlength() > 0 || chartype.getMinlength() > 0) {
                codes.append(", ");
            }
        } else if ("mailaddress".equals(type) || "date".equals(type) || "date:yyyyMMdd".equals(type) || "date:yyyyMM".equals(type) || "time".equals(type) || "datetime".equals(type)) {
            codes.append("SingleChartype(").append(StringUtils.substringBefore((String)type, (String)":").toUpperCase());
            if (StringUtils.isNotEmpty((String)StringUtils.substringAfter((String)type, (String)":"))) {
                codes.append("_").append(StringUtils.substringAfter((String)type, (String)":"));
            }
        } else {
            codes.append("Ct" + StoreModel.normalizeClassName(type.replace("-", "_"))).append("(");
        }
        if (chartype.getMaxlength() > 0 || chartype.getMinlength() > 0) {
            codes.append(chartype.getMaxlength());
            codes.append(", ");
            codes.append(chartype.getMinlength());
        }
        codes.append(")");
        return codes.toString();
    }
}

