/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.appgen.component.AbstractPrimarykey;
import jp.jasminesoft.jfc.appgen.component.BaseModel;
import jp.jasminesoft.jfc.appgen.component.CompositePrimarykey;
import jp.jasminesoft.jfc.appgen.component.ModelType;
import jp.jasminesoft.jfc.appgen.component.SimplePrimarykey;
import jp.jasminesoft.jfc.appgen.component.SimpleTransactionModelitem;
import jp.jasminesoft.jfc.appgen.component.StoreModelitem;
import jp.jasminesoft.jfc.appgen.component.TransactionModelitem;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Cascade;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Transaction;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoreModel
extends BaseModel {
    private static final Logger logger = LogManager.getLogger(StoreModel.class);
    public static final String DEFALUT_SESSION_FACTORY_BEAN_ID = "sessionFactory";
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public StoreModel(Model storeModel) {
        super(storeModel);
        if (!ModelType.STORE.equals((Object)ModelType.modelTypeValue(storeModel))) {
            throw new IllegalArgumentException("model type is not store. [type: " + storeModel.getType() + "]");
        }
    }

    public boolean isCompositeKey() {
        return this.getPrimarykey().isCompositeKey();
    }

    public AbstractPrimarykey getPrimarykey() {
        PrimaryKey[] primarykeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(this.model, this.getProject());
        if (primarykeys.length > 1) {
            return new CompositePrimarykey(this.model, primarykeys);
        }
        return new SimplePrimarykey(this.model, primarykeys[0]);
    }

    public StoreModelitem[] getModelitems() {
        ArrayList<StoreModelitem> list = new ArrayList<StoreModelitem>();
        for (Modelitem modelitem : ModelUtils.getModelitems(this.model)) {
            if (AppSchemaUtil.isGenerationModelitem(modelitem.getName(), this.model)) continue;
            list.add(new StoreModelitem(this.model, modelitem));
        }
        return list.toArray(new StoreModelitem[list.size()]);
    }

    public StoreModelitem[] getSortedModelitems() {
        StoreModelitem[] storeModelitems = this.getModelitems();
        return this.sort(storeModelitems);
    }

    private StoreModelitem[] sort(StoreModelitem[] storeModelitems) {
        List<StoreModelitem> list = Arrays.asList(storeModelitems);
        LinkedHashSet<StoreModelitem> sortedSet = new LinkedHashSet<StoreModelitem>();
        for (int i = 0; i < list.size(); ++i) {
            StoreModelitem storeModelitem = list.get(i);
            if (!storeModelitem.isReference()) {
                sortedSet.add(storeModelitem);
                continue;
            }
            for (StoreModelitem relatedModelitem : storeModelitem.getRelatedModelitems()) {
                if (i >= list.indexOf(relatedModelitem)) continue;
                sortedSet.add(relatedModelitem);
            }
            sortedSet.add(storeModelitem);
        }
        return sortedSet.toArray(new StoreModelitem[sortedSet.size()]);
    }

    public StoreModelitem getModelitem(String modelitemName) {
        Modelitem modelitem = AppSchemaUtil.getModelitem(modelitemName, this.model);
        if (modelitem != null) {
            return new StoreModelitem(this.model, modelitem);
        }
        for (Modelitem mitem : ModelUtils.getModelitems(this.model)) {
            if (!mitem.getName().equals(modelitemName)) continue;
            return new StoreModelitem(this.model, mitem);
        }
        throw new IllegalStateException(modelitemName + " is not included in " + this.model.getId() + " model.");
    }

    public StoreModel[] getReferenceModels() {
        TreeSet<StoreModel> set = new TreeSet<StoreModel>(new Comparator<StoreModel>(){

            @Override
            public int compare(StoreModel s1, StoreModel s2) {
                return s1.getPackage().compareTo(s2.getPackage());
            }
        });
        for (StoreModelitem storeModelitem : this.getModelitems()) {
            StoreModelitem referenceModelitem;
            if (storeModelitem.isRelatoin()) {
                set.add(storeModelitem.getRoleidModelitem().getStoreModel());
            }
            if ((referenceModelitem = storeModelitem.getForeignkeyReferenceModelitem()) == null) continue;
            set.add(referenceModelitem.getStoreModel());
        }
        return set.toArray(new StoreModel[set.size()]);
    }

    public String getEntityServiceClassName() {
        return this.getBeanName() + "EntityService";
    }

    public String getMetaClassName() {
        return this.getBeanName() + "Meta";
    }

    public String getEntityHelperClassName() {
        return AppSchemaUtil.getHelperClassBeanName4Dicon(this.model, this.getProject());
    }

    public String getCriteriaConverterName() {
        return this.getBeanName() + "CriteriaConverter";
    }

    public String getVariableName() {
        return StoreModel.normalizeName(this.model.getId());
    }

    public String getLockName() {
        return AppSchemaUtil.getModelLockKey(null, this.model);
    }

    public boolean hasTransactionModels() {
        return !ArrayUtils.isEmpty((Object[])this.getTransactionModels());
    }

    public boolean hasTransactionModels(String actionType) {
        return !ArrayUtils.isEmpty((Object[])this.getTransactionModels(actionType));
    }

    public StoreModel[] getTransactionModels() {
        TreeSet<StoreModel> transactionModels = new TreeSet<StoreModel>(new Comparator<StoreModel>(){

            @Override
            public int compare(StoreModel s1, StoreModel s2) {
                return s1.getPackage().compareTo(s2.getPackage());
            }
        });
        transactionModels.addAll(Arrays.asList(this.getTransactionModels("insert")));
        transactionModels.addAll(Arrays.asList(this.getTransactionModels("update")));
        transactionModels.addAll(Arrays.asList(this.getTransactionModels("delete")));
        return transactionModels.toArray(new StoreModel[transactionModels.size()]);
    }

    public StoreModel[] getTransactionModels(String actionType) {
        LinkedHashSet<StoreModel> transactionModels = new LinkedHashSet<StoreModel>();
        for (TransactionModelitem item : this.getTransactionModelitems(actionType)) {
            transactionModels.add(item.getRelationModel());
        }
        return transactionModels.toArray(new StoreModel[transactionModels.size()]);
    }

    public TransactionModelitem[] getTransactionModelitems(String actionType) {
        LinkedHashSet<TransactionModelitem> transactionModelitems = new LinkedHashSet<TransactionModelitem>();
        if ("insert".equals(actionType) || "update".equals(actionType)) {
            transactionModelitems.addAll(Arrays.asList(this.getTypeRefTransactionModelitems()));
        }
        Action action = AppSchemaUtil.getActionByModelIdAndType(this.getProject(), this.model.getId(), actionType);
        for (Transaction transaction : AppSchemaUtil.getTransaction(action)) {
            Model relatoinModel = AppSchemaUtil.getModel(this.getProject(), transaction.getContent());
            if (relatoinModel == null) {
                logger.warn(rman.getValue("pbean.illegal.transaction.notfound", new Object[]{transaction.getContent()}));
                continue;
            }
            Modelitem modelitem = AppSchemaUtil.getModelitem(transaction.getKey(), this.model);
            if (modelitem == null) {
                logger.warn(rman.getValue("pbean.illegal.transaction.notfound", new Object[]{transaction.getKey()}));
                continue;
            }
            SimpleTransactionModelitem transactionModelitem = new SimpleTransactionModelitem(this.model, modelitem, relatoinModel);
            transactionModelitems.add(transactionModelitem);
        }
        return transactionModelitems.toArray(new TransactionModelitem[transactionModelitems.size()]);
    }

    public TransactionModelitem[] getTypeRefTransactionModelitems() {
        Map<String, Set<Modelitem>> copyMap = AppSchemaUtil.createRefTargetItemWithRelatedItemMapWithStoreRefmodel(this.model, this.getProject());
        LinkedHashSet<TransactionModelitem> transactionModelitems = new LinkedHashSet<TransactionModelitem>();
        for (String key : copyMap.keySet()) {
            for (Modelitem modelitem : copyMap.get(key)) {
                Relation relation = AppSchemaUtil.getRelationTypeIsRef(modelitem);
                if (relation == null) {
                    throw new IllegalStateException("relatoin/@type must be 'ref'. modelitem : " + modelitem);
                }
                Modelitem relatedModelitem = AppSchemaUtil.getModelitem(relation.getRelateditem(), this.model);
                TransactionModelitem transactionModelitem = new TransactionModelitem(this.model, relatedModelitem);
                transactionModelitem.setLinkedItems(copyMap.get(key).toArray(new Modelitem[copyMap.get(key).size()]));
                transactionModelitems.add(transactionModelitem);
            }
        }
        return transactionModelitems.toArray(new TransactionModelitem[transactionModelitems.size()]);
    }

    public String getShowListProcessBeanClassName() {
        Action action = AppSchemaUtil.getActionByModelIdAndType(this.getProject(), this.model.getId(), "showList");
        return AppSchemaUtil.createProcessBeanName(action, null);
    }

    public boolean hasCascadeDeleteModels() {
        return !ArrayUtils.isEmpty((Object[])this.getCascadeDeleteModels());
    }

    public StoreModel[] getCascadeDeleteModels() {
        Action deleteAction = AppSchemaUtil.getActionByModelIdAndType(this.getProject(), this.model.getId(), "delete");
        if (deleteAction == null) {
            return new StoreModel[0];
        }
        Object[] cascades = AppSchemaUtil.getCascade(deleteAction);
        if (ArrayUtils.isEmpty((Object[])cascades)) {
            return new StoreModel[0];
        }
        ArrayList<StoreModel> list = new ArrayList<StoreModel>();
        for (Object cascade : cascades) {
            Model model = AppSchemaUtil.getModel(this.getProject(), ((Cascade)cascade).getContent());
            if (model == null) continue;
            list.add(new StoreModel(model));
        }
        return list.toArray(new StoreModel[list.size()]);
    }

    public boolean hasRelatedModels() {
        return !ArrayUtils.isEmpty((Object[])this.getRelatedModels());
    }

    public StoreModel[] getRelatedModels() {
        TreeSet<StoreModel> relatedModels = new TreeSet<StoreModel>(new Comparator<StoreModel>(){

            @Override
            public int compare(StoreModel s1, StoreModel s2) {
                return s1.getPackage().compareTo(s2.getPackage());
            }
        });
        relatedModels.addAll(Arrays.asList(this.getTransactionModels()));
        relatedModels.addAll(Arrays.asList(this.getCascadeDeleteModels()));
        return relatedModels.toArray(new StoreModel[relatedModels.size()]);
    }

    public boolean hasForeignkey() {
        return ArrayUtils.isNotEmpty((Object[])this.getForeignkey());
    }

    public StoreModelitem[] getForeignkey() {
        return (StoreModelitem[])Arrays.stream(this.getSortedModelitems()).filter(storeModelitem -> storeModelitem.isForeignkey()).toArray(StoreModelitem[]::new);
    }

    public StoreModelitem getForeignkeyByRefname(String targetid, String refname) {
        for (ForeignKey foreignKey : AppSchemaUtil.getForeignKey(this.model)) {
            String f_refname = AppSchemaUtil.getForeignKeyTargetItemName(foreignKey);
            if (!foreignKey.getIdref().equals(targetid)) continue;
            if (!refname.equals(f_refname)) {
                Model r_model;
                PrimaryKey[] r_pkeys;
                Relation rel;
                Modelitem mitem = AppSchemaUtil.getModelitem(foreignKey.getName(), this.model);
                if (mitem == null || (rel = AppSchemaUtil.getRelation(mitem)) == null || (r_pkeys = AppSchemaUtil.getPrimaryKey(r_model = (Model)rel.getIdrefAsIRNode())) == null || r_pkeys.length <= 1) continue;
                for (PrimaryKey r_pkey : r_pkeys) {
                    String _f_refname = f_refname + "_" + r_pkey.getName();
                    if (!refname.equals(_f_refname)) continue;
                    return this.getModelitem(_f_refname);
                }
                continue;
            }
            return this.getModelitem(foreignKey.getName());
        }
        throw new ContextedRuntimeException("At least one of the modelitem/@name in the model must match refname.").addContextValue("refname", (Object)refname);
    }

    public boolean isOptimisticLock() {
        return StringUtils.isNotBlank((CharSequence)this.getOptimisticLockItem());
    }

    public String getOptimisticLockItem() {
        return this.model.getOptimisticLock();
    }

    public String sessionFactoryBeanId() {
        Database subdatabase = ModelUtils.getSubDatabase(this.model);
        if (subdatabase == null) {
            return DEFALUT_SESSION_FACTORY_BEAN_ID;
        }
        return subdatabase.getSessionFactory();
    }
}

