/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.component.appschema;

import java.util.ArrayList;
import java.util.Arrays;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelitemUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Buttonfield;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.model.ModelGeneratorFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class ModelUtils {
    protected ModelUtils() {
    }

    public static Modelitem[] getModelitems(Model model) {
        Project project = ModelUtils.getProject(model);
        return ModelUtils.getModelitems(model, project);
    }

    public static Modelitem[] getModelitems(Model model, Project project) {
        if (model == null) {
            return new Modelitem[0];
        }
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (IModelChoice imc : model.getContent()) {
            if (!(imc instanceof Modelitem)) continue;
            list.addAll(Arrays.asList(ModelitemUtils.getModelitem(model, (Modelitem)imc, project)));
        }
        return list.toArray(new Modelitem[list.size()]);
    }

    public static Buttonfield[] getButtonfields(Model model) {
        if (model == null) {
            return new Buttonfield[0];
        }
        ArrayList<Buttonfield> list = new ArrayList<Buttonfield>();
        for (IModelChoice imc : model.getContent()) {
            if (!(imc instanceof Buttonfield)) continue;
            list.add((Buttonfield)imc);
        }
        return list.toArray(new Buttonfield[list.size()]);
    }

    public static Project getProject(Model model) {
        if (model == null) {
            return null;
        }
        return (Project)model.rGetParentRNode();
    }

    public static String getClassName(Model model) {
        if (!model.getUseRelax()) {
            return AppSchemaUtil.getClassname(model);
        }
        return ModelGeneratorFactory.create(ModelUtils.getProject(model), model).getClassname();
    }

    public static Database getSubDatabase(Model model) {
        if (StringUtils.isBlank((CharSequence)model.getSubdatabase())) {
            return null;
        }
        for (Database database : AppSchemaUtil.getSubdatabases(ModelUtils.getProject(model).getEnvironment())) {
            if (!model.getSubdatabase().equals(database.getName())) continue;
            return database;
        }
        throw new ContextedRuntimeException("At least one of the subdatabase/database/@name in the model must match model/@subdatabase.").addContextValue("model/@id", (Object)model.getId()).addContextValue("model/@subdatabase", (Object)model.getSubdatabase());
    }

    public static String getSubdatabaseIdx(Model smodel) {
        if (smodel == null) {
            return "";
        }
        String subdatabase = smodel.getSubdatabase();
        if (StringUtils.isBlank((CharSequence)subdatabase)) {
            return "";
        }
        return StringUtils.removeStart((String)subdatabase, (String)"jdbc/jfc");
    }
}

