/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import jp.jasminesoft.jfc.appgen.component.CalendarViewShowlistAction;
import jp.jasminesoft.jfc.appgen.component.DeleteAction;
import jp.jasminesoft.jfc.appgen.component.PresentationModelitem;
import jp.jasminesoft.jfc.appgen.component.ShowAction;
import jp.jasminesoft.jfc.appgen.component.ShowlistAction;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.SubDatabase;
import jp.jasminesoft.jfc.appgen.component.UpdateAction;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.appgen.generator.VelocityBasedJavaGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class StoreModelBasedGenerator
extends VelocityBasedJavaGenerator {
    protected final StoreModel storeModel;

    public StoreModelBasedGenerator(Project project, Model storeModel) {
        super(project);
        this.storeModel = new StoreModel(storeModel);
    }

    @Override
    protected void initContext() {
        super.initContext();
        this.context.put("model", this.storeModel);
        this.addActions(this.context);
        this.addCalendarViewAction(this.context);
        this.addStrutsclassgenShowlistActions(this.context);
        this.subdatabase(this.context);
        this.addPresentationModelitems(this.context);
    }

    protected void subdatabase(Map<String, Object> context) {
        Database subdatabase = ModelUtils.getSubDatabase(this.storeModel.getModel());
        if (subdatabase != null) {
            context.put("Jdbcjfc", new SubDatabase(subdatabase).jdbcjfc());
        }
    }

    protected void addActions(Map<String, Object> context) {
        Action deleteAction;
        Action updateAction;
        Action showAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.storeModel.getId(), "show");
        if (showAction != null) {
            context.put("showAction", new ShowAction(showAction));
        }
        if ((updateAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.storeModel.getId(), "update")) != null) {
            context.put("updateAction", new UpdateAction(updateAction));
        }
        if ((deleteAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.storeModel.getId(), "delete")) != null) {
            context.put("deleteAction", new DeleteAction(deleteAction));
        }
        for (Action showlistAction : AppSchemaUtil.getActionsByModelIdAndType(this.project, this.storeModel.getId(), "showList")) {
            if (!showlistAction.getStrutsclassgen()) continue;
            context.put("showListAction", new ShowlistAction(showlistAction));
            break;
        }
    }

    protected void addCalendarViewAction(Map<String, Object> context) {
        Action action = AppSchemaUtil.getActionByModelIdAndTypeAndView(this.project, this.storeModel.getId(), "showList", "calendar");
        if (action == null) {
            return;
        }
        context.put("calendarViewAction", new CalendarViewShowlistAction(action));
    }

    protected void addStrutsclassgenShowlistActions(Map<String, Object> context) {
        if (!this.storeModel.getModel().getTextsearch()) {
            return;
        }
        ArrayList<ShowlistAction> actions = new ArrayList<ShowlistAction>();
        for (Action showlistAction : AppSchemaUtil.getActionsByModelIdAndType(this.project, this.storeModel.getId(), "showList")) {
            if (!showlistAction.getStrutsclassgen()) continue;
            actions.add(new ShowlistAction(showlistAction));
        }
        if (actions.size() == 0) {
            return;
        }
        context.put("strutsclassgenShowlistActions", actions);
    }

    protected void addPresentationModelitems(Map<String, Object> context) {
        Model presentationModel = AppSchemaUtil.getPresentationModel(this.project, this.storeModel.getModel());
        if (presentationModel == null) {
            context.put("presentationItems", new PresentationModelitem[0]);
            return;
        }
        context.put("charTypeModelitems", Arrays.stream(presentationModel.getContent()).filter(item -> item instanceof Modelitem).map(item -> new PresentationModelitem(presentationModel, (Modelitem)item)).filter(item -> item.getChartypes().size() != 0).toArray(PresentationModelitem[]::new));
    }
}

