/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.generator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.appgen.generator.AppschemaBasedGenerator;
import jp.jasminesoft.jfc.core.support.velocity.VelocityTemplateUtils;
import jp.jasminesoft.jfc.core.support.velocity.VelocityUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VelocityBasedGenerator
extends AppschemaBasedGenerator {
    private static final Logger logger = LogManager.getLogger(VelocityBasedGenerator.class);
    protected String templatePath;
    protected Map<String, Object> context = null;
    protected static final String VELOCITY_TEMPLATE_FILE_EXTENSION = "vm";
    private String templateBaseDir = "vm/";
    private String templateDir;

    public VelocityBasedGenerator(Project project) {
        this(project, "");
    }

    public VelocityBasedGenerator(Project project, String templateDir) {
        super(project);
        this.setTemplateDir(templateDir);
    }

    protected void initContext() {
        this.context = new HashMap<String, Object>();
        this.context.put("project", this.project);
        this.context.put("dollar", "$");
        this.context.put("Utils", new VelocityTemplateUtils());
    }

    protected void setTemplateDir(String templateDir) {
        if (StringUtils.isBlank((String)templateDir)) {
            templateDir = "";
        } else if (!(templateDir = templateDir.replace('\\', '/')).endsWith(String.valueOf('/'))) {
            templateDir = templateDir + '/';
        }
        this.templateDir = templateDir;
    }

    protected String getTemplateDir() {
        return this.templateDir;
    }

    public void generate(String path) throws IOException {
        this.templatePath = path;
        if (this.context == null) {
            this.initContext();
        }
        this.context.put("thisFilename", StringUtils.removeEnd((String)StringUtils.substringAfterLast((String)this.getTemplatePath(), (String)"/"), (String)".vm"));
        this.context.put("thisFiledir", StringUtils.substringBeforeLast((String)this.getTemplatePath(), (String)"/"));
        this.generate();
    }

    public void addContext(Map<String, Object> map) {
        if (this.context == null) {
            this.initContext();
        }
        this.context.putAll(map);
    }

    @Override
    protected String getContent() {
        String path = this.templateBaseDir + this.getTemplateDir() + this.getTemplatePath();
        return VelocityUtils.merge((String)path, this.context);
    }

    protected String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    protected String getFilename() {
        String filename = this.getTemplateDir() + this.getTemplatePath();
        filename = VelocityUtils.evaluate((String)filename, this.context);
        filename = StringUtils.removeEnd((String)filename, (String)".vm");
        return filename;
    }
}

