/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.support.hibernate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import jp.jasminesoft.jfc.core.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public class DatabaseSchemaExport {
    private static final Logger logger = LogManager.getLogger(DatabaseSchemaExport.class);
    private ServiceRegistry serviceRegistry = null;
    private String replaceHibernatePropertiesFile;

    public void export(String workdir, String wagbyappWebInf, String mappingFile) {
        if (StringUtils.isBlank((String)mappingFile)) {
            return;
        }
        String modelid = StringUtils.removeEnd((String)new File(mappingFile).getName(), (String)".hbm.xml");
        this.export(workdir, wagbyappWebInf, mappingFile, modelid, ExportType.CREATE);
        this.export(workdir, wagbyappWebInf, mappingFile, modelid, ExportType.DROP);
    }

    public void export(String workdir, String wagbyappWebInf, String mappingFile, String modelid, ExportType exportType) {
        String outputdir = workdir + "/dbschema/" + exportType.toString().toLowerCase() + "ddl/";
        new File(outputdir).mkdirs();
        String outputFilePath = outputdir + modelid + ".ddl";
        this.prepare(outputFilePath);
        String delimiter = ";";
        try {
            if (this.serviceRegistry == null) {
                this.serviceRegistry = this.createServiceRegistry(workdir);
            }
            MetadataImplementor metadata = this.createMetadata(mappingFile);
            SchemaExport schemaExport = new SchemaExport();
            schemaExport.setHaltOnError(false);
            schemaExport.setOutputFile(outputFilePath);
            schemaExport.setDelimiter(delimiter);
            schemaExport.setFormat(true);
            schemaExport.setImportFiles("/import.sql");
            schemaExport.execute(EnumSet.of(TargetType.SCRIPT), exportType.action(), (Metadata)metadata, this.serviceRegistry);
            schemaExport = null;
        }
        catch (Throwable e) {
            logger.error("error in generate ddl " + outputFilePath + " from " + mappingFile, e);
            throw new IllegalStateException(e);
        }
    }

    protected void prepare(String outputFilePath) {
        File outputFile = new File(outputFilePath);
        if (!outputFile.exists()) {
            return;
        }
        outputFile.delete();
    }

    protected MetadataImplementor createMetadata(String mappingFile) {
        MetadataSources metadataSources = new MetadataSources(this.serviceRegistry);
        metadataSources.addFile(mappingFile);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        return (MetadataImplementor)metadataBuilder.build();
    }

    protected StandardServiceRegistry createServiceRegistry(String workdir) throws IOException {
        String propertiesFile = this.replaceHibernatePropertiesFile != null ? this.replaceHibernatePropertiesFile : workdir + "/dbschema/properties/hibernate.properties";
        Properties properties = new Properties();
        try (FileInputStream istream = new FileInputStream(propertiesFile);){
            properties.load(istream);
        }
        BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().build();
        StandardServiceRegistryBuilder serviceRegistryBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry);
        serviceRegistryBuilder.applySettings((Map)properties);
        return serviceRegistryBuilder.build();
    }

    public void destroy() {
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
    }

    public static void main(String[] arg) {
        String devhome = System.getProperty("devhome");
        if (devhome == null) {
            devhome = "../..";
        }
        String work = devhome + "/wagbydesigner/webapps/wagbydesigner/WEB-INF/env/work";
        String wagbyappWebInf = devhome + "/wagbyapp/webapps/wagby/WEB-INF";
        String mappingFile = System.getProperty("mappingFile");
        if (StringUtils.isBlank((String)mappingFile)) {
            String modelid = System.getProperty("modelid");
            if (StringUtils.isBlank((String)modelid)) {
                modelid = "juser";
            }
            mappingFile = work + "/srcgen/webpage/WEB-INF/classes/" + modelid + ".hbm.xml";
        }
        DatabaseSchemaExport databaseSchemaExport = new DatabaseSchemaExport();
        String hibernatePropertiesFile = System.getProperty("hibernatePropertiesFile");
        if (StringUtils.isNotBlank((String)hibernatePropertiesFile)) {
            databaseSchemaExport.replaceHibernatePropertiesFile = hibernatePropertiesFile;
        }
        databaseSchemaExport.export(work, wagbyappWebInf, mappingFile);
        databaseSchemaExport.destroy();
    }

    public static enum ExportType {
        CREATE,
        DROP;


        public SchemaExport.Action action() {
            if (this == CREATE) {
                return SchemaExport.Action.CREATE;
            }
            if (this == DROP) {
                return SchemaExport.Action.DROP;
            }
            return null;
        }
    }
}

