/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.appgen.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.jasminesoft.jfc.core.util.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Native2AsciiProcessBuilder {
    private static final Logger logger = LogManager.getLogger(Native2AsciiProcessBuilder.class);

    public void convert(File resource, File toDir) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.native2ascii());
        command.add("-encoding");
        command.add("UTF8");
        command.add(resource.getAbsolutePath());
        String toFile = StringUtils.removeEnd((String)resource.getName(), (String)".UTF8");
        command.add(new File(toDir, toFile).getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            int ret = process.waitFor();
            logger.debug(IOUtils.toString((InputStream)process.getInputStream()));
            logger.info(IOUtils.toString((InputStream)process.getErrorStream()));
            ret = process.waitFor();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private String native2ascii() {
        File native2ascii = new File(System.getProperty("java.home") + "/bin/native2ascii");
        if (native2ascii.exists()) {
            return native2ascii.getAbsolutePath();
        }
        return new File(System.getProperty("java.home") + "/../bin/native2ascii").getAbsolutePath();
    }
}

