/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.jasminesoft.jfc.gen.AbstractExpressionGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDBExpressionGenerator
extends AbstractExpressionGenerator {
    private static Logger logger = LogManager.getLogger(AbstractDBExpressionGenerator.class);

    @Override
    public void gCreateExpressionMethod_main(StringBuilder sb) {
        super.gCreateExpressionMethod_main(sb);
        sb.append(CR);
        if (this.isUseOutputSortStatementMethod() && this.sort != null) {
            sb.append("        ");
            sb.append("String[] sort_key = (String[])map.get(\"");
            sb.append(ProcessBeanGenerator.SortKeyParamName);
            sb.append("\");");
            sb.append(CR);
            sb.append("        ");
            sb.append("outputSortStatement(sb");
            if (this.isEnableQuote()) {
                sb.append(", quoteId");
            }
            sb.append(", sort_key);");
            sb.append(CR);
        }
    }

    @Override
    public void gOutputWhereMainMethod_finish(StringBuilder sb) {
        sb.append("        ");
        sb.append("return isfirstexpression;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    protected void gOutputWhereEndMethod(StringBuilder sb) {
        String[] param = this.isEnableQuote() ? new String[]{"isfirstexpression", "sb", "quoteWhere"} : new String[]{"isfirstexpression", "sb"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql.outputwhereend"), param, null));
        sb.append("    ");
        sb.append("protected void outputWhereEnd(");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression, StringBuilder sb");
        if (this.isEnableQuote()) {
            sb.append(", String quoteWhere");
        }
        sb.append(")");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (isfirstexpression == false) {");
        sb.append(CR);
        if (this.isEnableQuote()) {
            sb.append("            ");
            sb.append("sb.append(quoteWhere);");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    public void gOtherMethod(StringBuilder sb) {
        super.gOtherMethod(sb);
        sb.append(this.gOutputWhereConjuctionMethod());
        if (this.sort != null) {
            sb.append(this.gOutputSortStatementMethod());
        }
        if (AppSchemaUtil.isFlowstatusSearchDefined(this.getAction())) {
            this.gFlowstatusUtilMethod(sb);
        }
    }

    protected void gFlowstatusUtilMethod(StringBuilder sb) {
        Model smodel = this.getStoreModel();
        String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        sb.append(CR);
        sb.append("    ").append("/**").append(CR);
        sb.append("    ").append(" * ").append(this.rman.getValue("pbean.comment.flowstatus.method_explanation")).append(CR);
        sb.append("    ").append(" *").append(CR);
        sb.append("    ").append(" * @param flowStatus").append(CR);
        sb.append("    ").append(" * @return String").append(CR);
        sb.append("    ").append(" */").append(CR);
        sb.append("    ").append("public String getFlowstatusSearchCondition(int flowStatus) {").append(CR);
        sb.append("        ").append("// ").append(this.rman.getValue("pbean.comment.flowstatus.start")).append(CR);
        sb.append("        ").append("if (flowStatus == 1) {").append(CR);
        sb.append("            ").append("return \" ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ = '0' \";").append(CR);
        sb.append("        ").append("} else if (flowStatus == 2) {").append(CR);
        sb.append("            ").append("// ").append(this.rman.getValue("pbean.comment.flowstatus.application_admit")).append(CR);
        sb.append("            ").append("return \" ( ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ = '1' AND ").append(id_alias).append(".jfcWorkflowCurrentNode_ = '2' ) \";").append(CR);
        sb.append("        ").append("} else if (flowStatus == 3) {").append(CR);
        sb.append("            ").append("// ").append(this.rman.getValue("pbean.comment.flowstatus.application_admit")).append(CR);
        sb.append("            ").append("return \" ( ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ <> '0' AND ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ <> '1' AND ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ IS NOT NULL AND ").append(id_alias).append(".jfcWorkflowCurrentNode_ IS NOT NULL ) \";").append(CR);
        sb.append("        ").append("} else if (flowStatus == 4) {").append(CR);
        sb.append("            ").append("// ").append(this.rman.getValue("pbean.comment.flowstatus.end")).append(CR);
        sb.append("            ").append("return \" ( ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ IS NOT NULL AND ").append(id_alias).append(".jfcWorkflowCurrentNode_ IS NULL ) \";").append(CR);
        sb.append("        ").append("} else if (flowStatus == 5) {").append(CR);
        sb.append("            ").append("// ").append(this.rman.getValue("pbean.comment.flowstatus.reject")).append(CR);
        sb.append("            ").append("return \" ( ").append(id_alias).append(".jfcWorkflowProcessedLayerId_ IS NULL AND ").append(id_alias).append(".jfcWorkflowCurrentNode_ IS NULL ) \";").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("        ").append("return \"\";").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append(CR);
    }

    @Override
    protected String callOutputWhereEndMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append("outputWhereEnd(isfirstexpression, sb");
        if (this.isEnableQuote()) {
            sb.append(", quoteWhere");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String gAddCondition(Condition condition, String name, String prefix, String type, String cond, String value, boolean isMultipleFlag, boolean isStoreref, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        Relation rel_citem;
        Modelitem last_item;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (prefix == null) {
            prefix = "";
        }
        String type0 = null;
        type0 = JavaSourceGenerator.isBasicType(type) ? JavaSourceGenerator.b2wc(type) : JavaSourceGenerator.getProperType(type);
        String cname = null;
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String keyname = cname;
        Model cmodel = this.getConditionModel();
        Modelitem citem = AppSchemaUtil.getModelitem(cname, cmodel);
        Model smodel = this.getStoreModel();
        Modelitem s_mitem = AppSchemaUtil.getModelitem(name, smodel);
        Relation _relation = AppSchemaUtil.getRelationTypeIsRef(s_mitem);
        if (_relation != null && (last_item = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), s_mitem)).getTransient() && StringUtils.isBlank((CharSequence)last_item.getFormula())) {
            Object[] o = new Object[]{smodel.getId(), name, last_item.getName()};
            logger.error(this.rman.getValue("modeldef.relation.transient", o));
        }
        if ((rel_citem = AppSchemaUtil.getRelationTypeExceptRef(citem)) != null) {
            Model __rmodel;
            PrimaryKey[] pkeys;
            if (!(rel_citem.getRoleid() != null && rel_citem.getRolecontent() != null && rel_citem.getRoleid().equals(rel_citem.getRolecontent()) || (pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(__rmodel = (Model)rel_citem.getIdrefAsIRNode(), this.project)) == null || pkeys.length <= 1)) {
                if (indexOfCompositeKey <= pkeys.length) {
                    keyname = cname + "_" + pkeys[indexOfCompositeKey].getName();
                } else {
                    logger.error("Internal error, invalid indexOfCompositeKey value," + indexOfCompositeKey + ",__rmodel=" + __rmodel.getId());
                }
            }
        } else {
            Model __rmodel;
            PrimaryKey[] pkeys;
            Modelitem s_citem = AppSchemaUtil.getModelitem(cname, smodel);
            Relation rel_s_citem = AppSchemaUtil.getRelationTypeExceptRef(s_citem);
            if (rel_s_citem != null && rel_s_citem != null && (pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(__rmodel = (Model)rel_s_citem.getIdrefAsIRNode(), this.project)) != null && pkeys.length > 1) {
                if (indexOfCompositeKey <= pkeys.length) {
                    keyname = cname + "_" + pkeys[indexOfCompositeKey].getName();
                } else {
                    logger.error("Internal error, invalid indexOfCompositeKey value," + indexOfCompositeKey + ",__rmodel=" + __rmodel.getId());
                }
            }
        }
        sb.append("        ");
        sb.append("// " + keyname + prefix + " : " + type0);
        sb.append(CR);
        sb.append("        ");
        sb.append(type0);
        sb.append(" ");
        sb.append("_" + keyname + prefix);
        sb.append(" = ");
        sb.append(CR);
        sb.append("            ");
        if (type0.equals("java.sql.Timestamp")) {
            sb.append("jp.jasminesoft.util.DateTimeUtil.getTimestamp(");
            sb.append("map.get(\"");
            sb.append(StringUtil.convertJavaString((String)(this.getParameterMapKey(condition, keyname) + prefix)));
            sb.append("\"), ");
            if (cond.equals("<=") || cond.equals("<")) {
                sb.append("23, 59, 59, 999");
            } else {
                sb.append("0, 0, 0, 0");
            }
            sb.append(");");
        } else {
            sb.append("(");
            sb.append(type0);
            sb.append(")map.get(\"");
            sb.append(StringUtil.convertJavaString((String)(this.getParameterMapKey(condition, keyname) + prefix)));
            sb.append("\");");
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + keyname + prefix + " != null");
        if ("String".equals(type0)) {
            sb.append(" &&");
            sb.append("_" + keyname + prefix + ".length() > 0");
        }
        sb.append(") {");
        sb.append(CR);
        String basetab = "";
        sb.append(this.setIsfirstexpression("            " + basetab, condition.getOperator(), conditiongroup_nestlevel));
        if (!isMultipleFlag) {
            sb.append("            " + basetab);
            sb.append("if (_noselectionSet.contains(\"" + keyname + prefix + "\")");
            if (AppSchemaUtil.isForeignKey(keyname, smodel)) {
                sb.append(" || _noselectionSet.contains(\"" + keyname + prefix + "#allowNullFkey\")");
            }
            sb.append(") {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("sb.append(\"( \");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        }
        if (isChildFlag || isMultipleFlag) {
            sb.append(this.gAddCondition_child(condition, basetab, name, keyname, prefix, type, cond, isMultipleFlag, isStoreref, conditiongroup_nestlevel, indexOfCompositeKey));
        } else {
            sb.append(this.gAddCondition_item(condition, basetab, name, keyname, prefix, type, cond, value, isStoreref, conditiongroup_nestlevel, indexOfCompositeKey));
        }
        if (!isMultipleFlag) {
            String columnname = this.getProperColumnName(name, indexOfCompositeKey);
            Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
            boolean isStoreThismodel = true;
            if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
                isStoreThismodel = false;
            }
            sb.append("            " + basetab);
            sb.append("if (_noselectionSet.contains(\"" + keyname + prefix + "\")");
            if (AppSchemaUtil.isForeignKey(keyname, smodel)) {
                sb.append(" || _noselectionSet.contains(\"" + keyname + prefix + "#allowNullFkey\")");
            }
            sb.append(") {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("                " + basetab, "OR", 0));
            if (isChildFlag || isMultipleFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, "                " + basetab, name, "", type, cond, isMultipleFlag, indexOfCompositeKey));
            }
            sb.append(this.outputQuoteIdInWhere("                " + basetab));
            sb.append("                " + basetab);
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("                " + basetab));
            sb.append("                " + basetab);
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isChildFlag || isMultipleFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, "                " + basetab, name, "", type, cond, isMultipleFlag));
            }
            sb.append("                " + basetab);
            sb.append("sb.append(\") \");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("} else if (_noselectionSet.contains(\"" + keyname + prefix + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            " + basetab, condition.getOperator(), conditiongroup_nestlevel));
            if (isChildFlag || isMultipleFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, "            " + basetab, name, "", type, cond, isMultipleFlag, indexOfCompositeKey));
            }
            sb.append(this.outputQuoteIdInWhere("            " + basetab));
            sb.append("            " + basetab);
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            " + basetab));
            sb.append("            " + basetab);
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isChildFlag || isMultipleFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, "            " + basetab, name, "", type, cond, isMultipleFlag));
            }
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAddCondition_item(Condition condition, String basetab, String name, String keyname, String prefix, String type, String cond, String value, boolean isStoreref, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        boolean isChildFlag;
        String cname;
        if (prefix == null) {
            prefix = "";
        }
        String type0 = JavaSourceGenerator.isBasicType(type) ? JavaSourceGenerator.b2wc(type) : JavaSourceGenerator.getProperType(type);
        boolean isANDORSearch = condition.getUseAndOrSearch();
        if (AppSchemaUtil.hasChildPart(name)) {
            cname = AppSchemaUtil.getChildPart(name);
            isChildFlag = true;
        } else {
            cname = name;
            isChildFlag = false;
        }
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        boolean isMultiple = smitem != null ? smitem.getMultiple() : false;
        StringBuilder sb = new StringBuilder();
        if (!isStoreThismodel || isChildFlag || isMultiple) {
            sb.append(this.gSubQueryBegin(condition, "            " + basetab, name, "", type, cond, false, indexOfCompositeKey));
        }
        sb.append(this.outputQuoteIdInWhere("            " + basetab));
        String mtab = "";
        if ("String".equals(type0) && isANDORSearch) {
            sb.append("            " + basetab);
            sb.append("String cnj = \"AND\";");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("if (");
            sb.append("_" + keyname + prefix);
            sb.append(".startsWith(\"OR \")) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("cnj = \"OR\";");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("_" + keyname + prefix);
            sb.append(" = ");
            sb.append("_" + keyname + prefix);
            sb.append(".substring(\"OR \".length());");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("String[] tokens = DbProcessBeanUtil.splitBySpace(");
            sb.append("_" + keyname + prefix);
            sb.append(");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("for (int i=0; i<tokens.length; i++) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("if (i == 0) {");
            sb.append(CR);
            sb.append("                    " + basetab);
            sb.append("sb.append(\" ( \");");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("                    ", "cnj", conditiongroup_nestlevel));
            sb.append("                " + basetab);
            sb.append("}");
            sb.append(CR);
            mtab = "    ";
        }
        boolean useLikeOperatorAtRuntime = false;
        String matchType = condition.getMatchtype();
        if ("String".equals(type0) && "LIKE".equals(cond) && "runtime".equals(matchType)) {
            String varname = null;
            varname = isANDORSearch ? "tokens[i]" : (value.equals(cname + prefix) ? "_" + value : value);
            sb.append("            " + basetab + mtab);
            sb.append("StringBuilder var = new StringBuilder();").append(CR);
            sb.append("            " + basetab + mtab);
            sb.append("int _len = ").append(varname).append(".length();").append(CR);
            sb.append("            " + basetab + mtab);
            sb.append("for (int j=0; j<_len; j++) {").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("char c = ").append(varname).append(".charAt(j);").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("if (c == '\\\\' && j+1 < _len) {").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("if (").append(varname).append(".charAt(j+1) == '*') {").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("var.append('*');").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("j++;").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("continue;").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("} else if (").append(varname).append(".charAt(j+1) == '?') {").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("var.append('?');").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("j++;").append(CR);
            sb.append("                        " + basetab + mtab);
            sb.append("continue;").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("}").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("}").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("if (c == '*') {").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("var.append('%');").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("} else if (c == '?') {").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("var.append('_');").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("} else {").append(CR);
            sb.append("                    " + basetab + mtab);
            sb.append("var.append(SQLUtilities.replaceLikeSpecialChar(c, \"\\\\\"));").append(CR);
            sb.append("                " + basetab + mtab);
            sb.append("}").append(CR);
            sb.append("            " + basetab + mtab);
            sb.append("}").append(CR);
            useLikeOperatorAtRuntime = true;
        }
        sb.append("            " + basetab + mtab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("            " + basetab + mtab));
        sb.append("            " + basetab + mtab);
        sb.append("sb.append(\" ");
        sb.append(StringUtil.convertJavaString((String)cond));
        sb.append(" ");
        if ("String".equals(type0)) {
            if ("LIKE".equals(cond)) {
                Environment env = this.project.getEnvironment();
                String escapestr = DbTypeManager.getSearchStringEscapeInLike(smodel, env);
                if (value.equals(cname + prefix)) {
                    value = "_" + value;
                }
                sb.append("'");
                if ("part".equals(matchType) || "post".equals(matchType)) {
                    sb.append("%");
                }
                sb.append("\");");
                sb.append(CR);
                sb.append("            " + basetab + mtab);
                sb.append("sb.append(");
                if (useLikeOperatorAtRuntime) {
                    sb.append("var");
                } else {
                    sb.append("SQLUtilities.replaceLikeSpecialChar(");
                    if (isANDORSearch) {
                        sb.append("tokens[i]");
                    } else {
                        sb.append(value);
                    }
                    sb.append(", \"");
                    sb.append(escapestr);
                    sb.append("\")");
                }
                sb.append(");");
                sb.append(CR);
                sb.append("            " + basetab + mtab);
                sb.append("sb.append(\"");
                if ("part".equals(matchType) || "pre".equals(matchType)) {
                    sb.append("%");
                }
                sb.append("' ESCAPE '" + escapestr + "' \");");
            } else {
                sb.append("'\");");
                sb.append(CR);
                sb.append("            " + basetab + mtab);
                sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
                if (isANDORSearch) {
                    sb.append("tokens[i]");
                } else {
                    sb.append("_" + keyname + prefix);
                }
                sb.append("));");
                sb.append(CR);
                sb.append("            " + basetab + mtab);
                sb.append("sb.append(\"' \");");
            }
        } else if (JavaSourceGenerator.isWrapperClass(type0)) {
            sb.append("\");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(");
            sb.append("_" + keyname + prefix);
            sb.append(");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(\" \");");
        } else {
            sb.append("'\");");
            sb.append(CR);
            sb.append(this.outputDateQueryInAddCondition("            " + basetab, "_" + keyname + prefix, type));
            sb.append("            " + basetab);
            sb.append("sb.append(\"' \");");
        }
        sb.append(CR);
        if ("String".equals(type0) && isANDORSearch) {
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(\" ) \");");
            sb.append(CR);
        }
        if (!isStoreThismodel || isChildFlag || isMultiple) {
            sb.append(this.gSubQueryEnd(condition, "            " + basetab, name, "", type, cond, false));
        }
        return sb.toString();
    }

    protected String outputQuoteId(String tab) {
        if (!this.isEnableQuote()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("sb.append(quoteId);");
        sb.append(CR);
        return sb.toString();
    }

    protected String outputQuoteIdInWhere(String tab) {
        if (!this.isEnableQuote()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("sb.append(quoteIdInWhere);");
        sb.append(CR);
        return sb.toString();
    }

    protected String outputDateQueryInAddCondition(String basetab, String variablename, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("sb.append(");
        sb.append(this.gTimeFormatForNoneSupportTimeDataTypeBegin(type));
        sb.append(variablename);
        sb.append(this.gTimeFormatForNoneSupportTimeDataTypeEnd(type));
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    protected String outputDateQueryInAddCondition_implicit(String basetab, String value, String condition_name, String type) {
        if (value != null && value.length() > 0) {
            Environment env = this.project.getEnvironment();
            String[] input_formats = null;
            String output_format = DbTypeManager.getSimpleDateFormatString(env, type);
            if ("date".equalsIgnoreCase(type)) {
                input_formats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd"};
            } else if ("time".equalsIgnoreCase(type)) {
                input_formats = new String[]{"HH:mm:ss", "HHmmss", "HH:mm", "HHmm"};
                if (!DbTypeManager.isSupportTimeDataType(env)) {
                    output_format = DbTypeManager.getSimpleDateFormatForNoneSupportTimeDataType(env);
                }
            } else if ("dateTime".equalsIgnoreCase(type)) {
                input_formats = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HHmmss", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HHmmss", "yyyyMMdd HH:mm:ss", "yyyyMMdd HHmmss"};
            }
            Date _dateValue = DateTimeUtil.getDateWithFormat((String)value, input_formats);
            if (_dateValue == null) {
                if (value.indexOf("(") < 0) {
                    String actionid = this.getAction().getId();
                    String input_format = "";
                    for (String i_fmt : input_formats) {
                        input_format = input_format + "\"" + i_fmt + "\" ";
                    }
                    Object[] o = new Object[]{actionid, condition_name, value, input_format};
                    logger.error(this.rman.getValue("pbean.errmsg.implicit.date.format", o));
                }
            } else {
                SimpleDateFormat format = new SimpleDateFormat(output_format);
                value = format.format(_dateValue);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)value));
        sb.append("\");");
        sb.append(CR);
        return sb.toString();
    }

    protected String gTimeFormatForNoneSupportTimeDataTypeBegin(String type) {
        StringBuilder sb = new StringBuilder();
        if ("time".equalsIgnoreCase(type) && !DbTypeManager.isSupportTimeDataType(this.project.getEnvironment())) {
            sb.append("DateTimeUtil.getStringWithFormat(");
        }
        return sb.toString();
    }

    protected String gTimeFormatForNoneSupportTimeDataTypeEnd(String type) {
        StringBuilder sb = new StringBuilder();
        if ("time".equalsIgnoreCase(type) && !DbTypeManager.isSupportTimeDataType(this.project.getEnvironment())) {
            sb.append(", \"");
            sb.append(DbTypeManager.getSimpleDateFormatForNoneSupportTimeDataType(this.project.getEnvironment()));
            sb.append("\")");
        }
        return sb.toString();
    }

    @Override
    protected String gAddCondition_implicit(Condition condition, String name, String type, String cond, String value, boolean isMultipleFlag, int conditiongroup_nestlevel, boolean isCheckbox, int indexOfCompositeKey) {
        String cname;
        boolean isChildFlag;
        String actionid;
        StringBuilder sb = new StringBuilder();
        String string = actionid = this.getAction() != null ? this.getAction().getId() : "";
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        if ("storeref".equals(type)) {
            type = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), smitem, "roleid", false);
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.implicit", cname));
        sb.append(CR);
        if (isMultipleFlag && "NULL".equalsIgnoreCase(value) && "=".equals(cond)) {
            Object[] o = new Object[]{actionid, condition.getName()};
            logger.error(this.rman.getValue("pbean.errmsg.implicit.multi.isnull", o));
            sb.append("        ");
            sb.append("// ");
            sb.append(this.rman.getValue("pbean.errmsg.implicit.multi.isnull", o));
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        String except = condition.getExcept();
        if (except != null && except.length() > 0) {
            Object[] o = new Object[]{actionid, condition.getName()};
            logger.error(this.rman.getValue("pbean.errmsg.implicit.except", o));
        }
        String basetab = "";
        boolean isExcept = false;
        String permname = condition.getExceptPermname();
        String permaction = condition.getExceptPermaction();
        if (permname != null && permname.length() > 0 || permaction != null && permaction.length() > 0) {
            if (permname == null || permname.length() == 0 || permaction == null || permaction.length() == 0) {
                Object[] o = new Object[]{actionid, condition.getName(), permname, permaction};
                logger.error(this.rman.getValue("pbean.errmsg.implicit.exceptPermAttributes", o));
            } else {
                sb.append("        ");
                sb.append("if (!isValidPermission(new JFCAppPermission(\"");
                sb.append(permname);
                sb.append("\", \"");
                sb.append(permaction);
                sb.append("\"))) {");
                sb.append(CR);
                basetab = "    ";
                isExcept = true;
            }
        } else {
            sb.append("        ");
            sb.append("if (p.user != null) {");
            sb.append(CR);
            basetab = "    ";
            isExcept = true;
        }
        String _function_varname = null;
        if ("function".equals(type) && value.startsWith("SEARCH_PRINCIPAL(") && value.endsWith(")")) {
            _function_varname = "_target_" + name;
            String content = value.substring("SEARCH_PRINCIPAL(".length(), value.length() - ")".length());
            sb.append("        " + basetab);
            sb.append("String ");
            sb.append(_function_varname);
            sb.append(" = ");
            sb.append("JFCUtils.getFirstJuserPrincipalNameInCandidate(p.user,");
            String[] candidates = content.split(",");
            for (int i = 0; i < candidates.length; ++i) {
                String candidate = candidates[i];
                sb.append(" \"");
                sb.append(StringUtil.convertJavaString((String)candidate));
                sb.append("\"");
                if (i >= candidates.length - 1) continue;
                sb.append(",");
            }
            sb.append(");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("if (");
            sb.append(_function_varname);
            sb.append(" != null) {");
            sb.append(CR);
            basetab = basetab + "    ";
        }
        String _gidVariablename = "_gid_" + cname;
        if ("jgroupid".equals(type)) {
            String getGroupId = "getGroupId";
            if ("group".equals(smitem.getGroupDataType())) {
                getGroupId = "getSubGroupIds";
            }
            sb.append("        " + basetab);
            sb.append("if (p.user." + getGroupId + "() != null && ");
            sb.append("p.user." + getGroupId + "().length > 0 ) {");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("int[] " + _gidVariablename + " = ");
            sb.append("p.user." + getGroupId + "();");
            sb.append(CR);
            basetab = basetab + "    ";
        }
        boolean isUseValueVariable = false;
        String c_value = null;
        if (JavaSourceGenerator.isUseExpression(value) && (c_value = HelperGenerator_calc_parser.convertFunctionNames(value)) != null) {
            String ctype = null;
            String smitem_type = smitem.getType();
            if ("storeref".equals(smitem_type)) {
                smitem_type = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), smitem, "roleid");
            }
            ctype = "javacode".equals(type) ? (JavaSourceGenerator.isStringType(smitem_type) ? "String" : "Object") : (JavaSourceGenerator.isBasicType(smitem_type) ? JavaSourceGenerator.b2wc(smitem_type) : JavaSourceGenerator.getProperType(smitem_type));
            sb.append("        " + basetab);
            sb.append(ctype).append(" _value = ");
            sb.append(c_value);
            sb.append(";").append(CR);
            sb.append("        " + basetab);
            if (JavaSourceGenerator.isStringType(ctype)) {
                sb.append("if (StringUtils.isNotBlank(_value)) {");
            } else {
                sb.append("if (_value != null) {");
            }
            sb.append(CR);
            basetab = basetab + "    ";
            isUseValueVariable = true;
            if ("javacode".equals(type) && c_value != null && JavaSourceGenerator.isStringType(smitem_type)) {
                type = "string";
                c_value = "_value";
            }
        }
        sb.append(this.setIsfirstexpression("        " + basetab, condition.getOperator(), conditiongroup_nestlevel));
        if (isChildFlag || isMultipleFlag || isCheckbox || !isStoreThismodel) {
            sb.append(this.gSubQueryBegin(condition, "        " + basetab, name, "", type, cond, isMultipleFlag, indexOfCompositeKey));
        }
        sb.append(this.outputQuoteIdInWhere("        " + basetab));
        sb.append("        " + basetab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("        " + basetab));
        if ("NULL".equalsIgnoreCase(value)) {
            if ("=".equals(cond)) {
                cond = "IS";
            } else if ("!=".equals(cond)) {
                cond = "IS NOT";
            }
        } else if ("jgroupid".equals(type)) {
            cond = "IN";
        }
        sb.append("        " + basetab);
        sb.append("sb.append(\" ");
        sb.append(StringUtil.convertJavaString((String)cond));
        sb.append(" ");
        if ("NULL".equalsIgnoreCase(value)) {
            sb.append(StringUtil.convertJavaString((String)value.toUpperCase()));
            sb.append(" \");");
        } else if ("string".equalsIgnoreCase(type)) {
            if ("LIKE".equals(cond)) {
                String matchType = condition.getMatchtype();
                Environment env = this.project.getEnvironment();
                String escapestr = DbTypeManager.getSearchStringEscapeInLike(smodel, env);
                sb.append("'");
                if ("part".equals(matchType) || "post".equals(matchType)) {
                    sb.append("%");
                }
                sb.append("\");");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(SQLUtilities.replaceLikeSpecialChar(");
                if (c_value == null) {
                    sb.append("\"" + value + "\"");
                } else {
                    sb.append(c_value);
                }
                sb.append(", \"");
                sb.append(escapestr);
                sb.append("\"));");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(\"");
                if ("part".equals(matchType) || "pre".equals(matchType)) {
                    sb.append("%");
                }
                sb.append("' ESCAPE '" + escapestr + "' \");");
            } else {
                sb.append("'\");");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
                if (c_value == null) {
                    sb.append("\"" + value + "\"");
                } else {
                    sb.append(c_value);
                }
                sb.append("));");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(\"' \");");
            }
        } else if ("username".equals(type)) {
            sb.append("'\");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(");
            sb.append("p.user.getUsername()");
            sb.append(");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(\"' \");");
        } else if ("jgroupid".equals(type)) {
            sb.append("(\");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("for (int i=0; i<" + _gidVariablename + ".length; i++) {");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("sb.append(" + _gidVariablename + "[i]);");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("if (i != " + _gidVariablename + ".length-1) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("sb.append(\", \");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(\") \");");
        } else if ("javacode".equals(type)) {
            String stype;
            boolean useSingleQuote = false;
            if (smitem != null && (JavaSourceGenerator.isStringType(stype = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), smitem)) || JavaSourceGenerator.isDateOrTimeType(stype))) {
                sb.append("'");
                useSingleQuote = true;
            }
            sb.append("\");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(");
            if (c_value != null) {
                sb.append("_value");
            } else {
                sb.append(value);
            }
            sb.append(");");
            sb.append(CR);
            if (useSingleQuote) {
                sb.append("        " + basetab);
                sb.append("sb.append(\"' \");");
                sb.append(CR);
            }
        } else if (value.startsWith("now") && ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || "dateTime".equalsIgnoreCase(type))) {
            Date d = null;
            d = "time".equalsIgnoreCase(type) ? DateTimeUtil.getTimeWithNowFormat((String)value) : DateTimeUtil.getDateWithNowFormat((String)value);
            if (d == null) {
                Object[] o = new Object[]{actionid, cname, value};
                logger.error(this.rman.getValue("pbean.errmsg.implicit.date.nowformat", o));
            }
            sb.append("'\");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(");
            sb.append(this.gTimeFormatForNoneSupportTimeDataTypeBegin(type));
            sb.append(JavaSourceGenerator.getSQLObjectMethodname(type));
            sb.append("(");
            if ("time".equalsIgnoreCase(type)) {
                sb.append("DateTimeUtil.getTimeWithNowFormat(\"");
                sb.append(value);
                sb.append("\")");
            } else {
                sb.append("DateTimeUtil.getDateWithNowFormat(\"");
                sb.append(value);
                sb.append("\")");
            }
            sb.append(")");
            sb.append(this.gTimeFormatForNoneSupportTimeDataTypeEnd(type));
            sb.append(");");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("sb.append(\"' \");");
            sb.append(CR);
        } else if ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || "dateTime".equalsIgnoreCase(type)) {
            sb.append("'\");");
            sb.append(CR);
            sb.append(this.outputDateQueryInAddCondition_implicit("        " + basetab, value, cname, type));
            sb.append("        " + basetab);
            sb.append("sb.append(\"' \");");
        } else if ("function".equalsIgnoreCase(type)) {
            if (value.startsWith("SEARCH_PRINCIPAL(") && value.endsWith(")")) {
                sb.append("'\");");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
                sb.append(_function_varname);
                sb.append("));");
                sb.append(CR);
                sb.append("        " + basetab);
                sb.append("sb.append(\"' \");");
            }
        } else if (c_value == null) {
            sb.append(StringUtil.convertJavaString((String)value));
            sb.append(" \");");
        } else {
            sb.append("\" + ");
            sb.append(c_value);
            sb.append(");");
        }
        if (isUseValueVariable) {
            if (!"javacode".equals(type)) {
                sb.append(CR);
            }
            sb.append("        " + basetab.substring(0, basetab.length() - 4));
            sb.append("}");
        }
        sb.append(CR);
        if (isChildFlag || isMultipleFlag || isCheckbox || !isStoreThismodel) {
            sb.append(this.gSubQueryEnd(condition, "        " + basetab, name, "", type, cond, isMultipleFlag));
        }
        if ("jgroupid".equals(type)) {
            basetab = basetab.substring("    ".length());
            sb.append("        " + basetab);
            sb.append("}");
            sb.append(CR);
        }
        if ("function".equalsIgnoreCase(type)) {
            basetab = basetab.substring(0, Math.min(0, basetab.length() - "    ".length()));
            sb.append("        " + basetab);
            sb.append("}");
            sb.append(CR);
        }
        if (isExcept) {
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(CR);
        return sb.toString();
    }

    protected String gOutputWhereConjuctionMethod() {
        StringBuilder sb = new StringBuilder();
        String[] param = this.isEnableQuote() ? new String[]{"isfirstexpression", "sb", "quoteWhere"} : new String[]{"isfirstexpression", "sb"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql.outputwhereconjuction"), param, "boolean"));
        sb.append("    ");
        sb.append("protected boolean outputWhereConjuction(");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression, StringBuilder sb");
        if (this.isEnableQuote()) {
            sb.append(", String quoteWhere");
        }
        sb.append(")");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("return outputWhereConjuction(isfirstexpression, sb, ");
        if (this.isEnableQuote()) {
            sb.append("quoteWhere, ");
        }
        sb.append("\"AND\");");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("protected boolean outputWhereConjuction(");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression, StringBuilder sb, ");
        if (this.isEnableQuote()) {
            sb.append("String quoteWhere, ");
        }
        sb.append(CR);
        sb.append("            ");
        sb.append("String constr)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (isfirstexpression) {");
        sb.append(CR);
        if (this.isUseWhereInOutputWhereConjuctionMethod()) {
            sb.append("            ");
            sb.append("sb.append(\" WHERE \");");
            sb.append(CR);
        }
        if (this.isEnableQuote()) {
            sb.append("            ");
            sb.append("sb.append(quoteWhere);");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("isfirstexpression = false;");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("            ");
        sb.append("sb.append(constr);");
        sb.append(CR);
        sb.append("            ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return isfirstexpression;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gOutputSortStatementMethod() {
        Sortkey[] keys;
        StringBuilder sb = new StringBuilder();
        String[] param = this.isEnableQuote() ? new String[]{"sb", "quoteId", "sort_key"} : new String[]{"sb", "sort_key"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.sql.outputsortstatement"), param, null));
        sb.append("    ");
        sb.append("protected void outputSortStatement(");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder sb");
        if (this.isEnableQuote()) {
            sb.append(", String quoteId");
        }
        sb.append(", String[] sort_key)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (sort_key == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return;");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("int sortcnt = 0;");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean descFlag = false;");
        sb.append(CR);
        sb.append("        ");
        sb.append("int length = sort_key.length;");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (int i=0; i<length; i++) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("String s = sort_key[i];");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (s.endsWith(\":DESC\")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("s = s.substring(0, s.length() - \":DESC\".length());");
        sb.append(CR);
        sb.append("                ");
        sb.append("descFlag = true;");
        sb.append(CR);
        sb.append("            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                ");
        sb.append("descFlag = false;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("            ");
        sb.append("String columnName;");
        sb.append(CR);
        boolean isOutputColumnIf = false;
        if (this.sort != null && (keys = this.sort.getSortkey()) != null) {
            String cnt = null;
            int length = keys.length;
            for (int j = 0; j < length; ++j) {
                cnt = keys[j].getContent();
                if (!this.isOutputSortColumn(keys[j])) continue;
                sb.append("            ");
                if (isOutputColumnIf) {
                    sb.append("} else ");
                }
                sb.append("if (s.equals(\"");
                sb.append(StringUtil.convertJavaString((String)cnt));
                sb.append("\")) {");
                sb.append(CR);
                sb.append("                ");
                sb.append("columnName = \"");
                String s = this.getProperColumnName(cnt);
                sb.append(StringUtil.convertJavaString((String)s));
                sb.append("\";");
                sb.append(CR);
                isOutputColumnIf = true;
            }
            if (isOutputColumnIf) {
                sb.append("            ");
                sb.append("} else {");
                sb.append(CR);
                sb.append("                ");
                sb.append("continue;");
                sb.append(CR);
                sb.append("            ");
                sb.append("}");
                sb.append(CR);
            }
        }
        if (!isOutputColumnIf) {
            sb.append("            ");
            sb.append("// nothing sort column");
            sb.append(CR);
            sb.append("            ");
            sb.append("if (true) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("continue;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append("            ");
        sb.append("if (sortcnt == 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\"ORDER BY \");");
        sb.append(CR);
        sb.append("            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\", \");");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("sortcnt++;");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.outputQuoteId("            "));
        sb.append("            ");
        sb.append("sb.append(columnName);");
        sb.append(CR);
        sb.append(this.outputQuoteId("            "));
        sb.append("            ");
        sb.append("if (descFlag)");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\" DESC\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected boolean isUseWhereInOutputWhereConjuctionMethod() {
        return true;
    }

    protected boolean isUseOutputSortStatementMethod() {
        return true;
    }

    protected abstract String gSubQueryBegin(Condition var1, String var2, String var3, String var4, String var5, String var6, boolean var7, int var8);

    protected abstract String gSubQueryEnd(Condition var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    protected abstract String gAddCondition_child(Condition var1, String var2, String var3, String var4, String var5, String var6, String var7, boolean var8, boolean var9, int var10, int var11);

    public abstract String getProperColumnName(String var1);

    public abstract String getProperColumnName(String var1, int var2);

    protected abstract boolean isOutputSortColumn(Sortkey var1);
}

