/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AnormType;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Anormlib;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnormManagerGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Anormlib anormlib;
    protected String proxyClassname;
    protected AnormType anormType;
    public static final String OPTION_ADDRESSMATCH = "addressmatch";
    protected Logger logger = LogManager.getLogger((String)AnormManagerGenerator.class.getName());

    public static AnormType getAnormType(Project project) {
        Environment env = project.getEnvironment();
        Anormlib anormlib = AppSchemaUtil.getAnormlib(env);
        return AnormManagerGenerator.getAnormType(anormlib);
    }

    public static AnormType getAnormType(Anormlib anormlib) {
        AnormType anormType = null;
        if (anormlib != null) {
            if ("json".equals(anormlib.getType())) {
                anormType = AnormType.JSONv1;
            } else if ("rmi".equals(anormlib.getType())) {
                anormType = AnormType.R5;
            } else if ("horb".equals(anormlib.getType())) {
                anormType = AnormType.R4;
            }
        }
        if (anormType == null) {
            anormType = null;
        }
        return anormType;
    }

    public static String getAnormServerProxyClassname(Project project) {
        Environment env = project.getEnvironment();
        Anormlib anormlib = AppSchemaUtil.getAnormlib(env);
        return AnormManagerGenerator.getAnormServerProxyClassname(anormlib);
    }

    public static String getAnormServerProxyClassname(Anormlib anormlib) {
        String ret = null;
        AnormType anormType_ = AnormManagerGenerator.getAnormType(anormlib);
        if (anormlib != null) {
            if (anormType_ == AnormType.JSONv1) {
                return "AnormJsonClient";
            }
            HashSet<String> options = new HashSet<String>();
            String op = anormlib.getOption();
            if (op != null && op.length() > 0) {
                StringTokenizer st = new StringTokenizer(op, " ,");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    options.add(token);
                }
            }
            if (options != null && options.contains(OPTION_ADDRESSMATCH)) {
                if (anormType_ == AnormType.R5) {
                    ret = "AnormServer";
                } else if (anormType_ == AnormType.R4) {
                    ret = "LLAnormServer_Proxy";
                }
            }
        }
        if (anormType_ != null && anormType_ == AnormType.R5) {
            ret = "AnormServer";
        } else if (anormType_ != null && anormType_ == AnormType.R4) {
            ret = "AnormServer_Proxy";
        }
        return ret;
    }

    public static String getAnormServerProxyClassnameWithPackage(Project project) {
        Environment env = project.getEnvironment();
        Anormlib anormlib = AppSchemaUtil.getAnormlib(env);
        return AnormManagerGenerator.getAnormServerProxyClassnameWithPackage(anormlib);
    }

    public static String getAnormServerProxyClassnameWithPackage(Anormlib anormlib) {
        String className = AnormManagerGenerator.getAnormServerProxyClassname(anormlib);
        AnormType anormType_ = AnormManagerGenerator.getAnormType(anormlib);
        if (anormType_ != null && anormType_ == AnormType.JSONv1) {
            return "jp.jasminesoft.jfc.app.AnormJsonClient";
        }
        if (anormType_ != null && anormType_ == AnormType.R5) {
            return "jp.jasminesoft.anorm.rmi." + className;
        }
        if (anormType_ != null && anormType_ == AnormType.R4) {
            return "jp.jasminesoft.anorm.horb." + className;
        }
        return null;
    }

    public AnormManagerGenerator(Project project, Anormlib anormlib) {
        super(project);
        this.anormlib = anormlib;
        this.anormType = AnormManagerGenerator.getAnormType(anormlib);
        this.proxyClassname = AnormManagerGenerator.getAnormServerProxyClassname(anormlib);
    }

    @Override
    public String process0() {
        if (this.anormType == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gLoggerReady(this.getClassname()));
        sb.append(this.gContent());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class NormalizeServerManager");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return rman.getValue("anormman.comment.explanation");
    }

    @Override
    public String getClassname() {
        return "NormalizeServerManager";
    }

    @Override
    public String getSubpackageName() {
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.getSubpackageName();
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("jp.jasminesoft.jfc.service.JfcConfig");
        importList.add("jp.jasminesoft.jfc.ActionParameter");
        if (this.anormType != null && this.anormType == AnormType.JSONv1) {
            importList.add("jp.jasminesoft.jfc.app.AnormJsonClient");
        } else if (this.anormType != null && this.anormType == AnormType.R5) {
            importList.add("java.rmi.Naming");
            importList.add("jp.jasminesoft.anorm.rmi." + this.proxyClassname);
        } else if (this.anormType != null && this.anormType == AnormType.R4) {
            importList.add("jp.jasminesoft.anorm.horb." + this.proxyClassname);
            importList.add("jp.jasminesoft.anorm.NormalizeException");
            importList.add("horb.orb.*");
        }
        importList.add("org.apache.logging.log4j.Logger");
        importList.add("org.apache.logging.log4j.LogManager");
        return importList.toArray(new String[0]);
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gVariable());
        sb.append(this.gGetInstanceMethod());
        return sb.toString();
    }

    protected String gVariable() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private static ");
        sb.append(this.proxyClassname);
        sb.append(" __jfc_proxy = null;");
        sb.append(CR);
        sb.append(CR);
        if (this.anormType == null || this.anormType != AnormType.JSONv1) {
            sb.append("    ");
            sb.append("public static int RETRYCOUNT = 5;");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gGetInstanceMethod() {
        if (this.anormType == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), null, this.proxyClassname));
        sb.append("    ");
        sb.append("public synchronized static ");
        sb.append(this.proxyClassname);
        sb.append(" getInstance(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return getInstance(p.appctx.getBean(JfcConfig.class));");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), null, this.proxyClassname));
        sb.append("    ");
        sb.append("public synchronized static ");
        sb.append(this.proxyClassname);
        sb.append(" getInstance(JfcConfig jfcConfig) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (__jfc_proxy == null) {");
        sb.append(CR);
        sb.append("            ");
        if (this.anormType == AnormType.R5 || this.anormType == AnormType.JSONv1) {
            sb.append("String _url = jfcConfig.getAnormUrl();");
        } else if (this.anormType == AnormType.R4) {
            sb.append("String _url = jfcConfig.getAnormHorbUrl();");
        }
        sb.append(CR);
        if (this.anormType != null && this.anormType == AnormType.JSONv1) {
            sb.append("            ");
            sb.append("__jfc_proxy = AnormJsonClient.getInstance();").append(CR);
            sb.append("            ");
            sb.append("__jfc_proxy.setAnormServerUrl(_url);").append(CR);
        } else {
            sb.append("            ");
            sb.append("for (int i=0; i<RETRYCOUNT; i++) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("try {");
            sb.append(CR);
            sb.append("                    ");
            if (this.anormType == AnormType.R5) {
                sb.append("__jfc_proxy = (");
                sb.append(this.proxyClassname);
                sb.append(")Naming.lookup(_url);");
            } else if (this.anormType == AnormType.R4) {
                sb.append("__jfc_proxy = new ");
                sb.append(this.proxyClassname);
                sb.append("(_url);");
            }
            sb.append(CR);
            sb.append("                ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("logger.warn(e.getMessage()+\" \"+_url);");
            sb.append(CR);
            sb.append("                    ");
            sb.append("__jfc_proxy = null;");
            sb.append(CR);
            sb.append("                ");
            sb.append("}");
            sb.append(CR);
            sb.append("                ");
            sb.append("if (__jfc_proxy != null)");
            sb.append(CR);
            sb.append("                    ");
            sb.append("break;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return __jfc_proxy;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(CommentGenerator.gComment(rman.getValue("anormman.comment.reset"), null, null));
        sb.append("    ");
        sb.append("public synchronized static void reset() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("__jfc_proxy = null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        String[] params = new String[]{"address", "partName"};
        sb.append(CommentGenerator.gComment(rman.getValue("anormman.comment.getresult"), params, "String"));
        sb.append("    ");
        sb.append("public synchronized static String getAnormResult(String adrs, String partName) {");
        sb.append(CR);
        AnormType anormType = AnormManagerGenerator.getAnormType(this.project);
        if (anormType == AnormType.R5 || anormType == AnormType.JSONv1) {
            sb.append("        ");
            sb.append("String ret = \"\";");
            sb.append(CR);
            sb.append("        ");
            sb.append("if (__jfc_proxy != null) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("try {");
            sb.append(CR);
            sb.append("                ");
            sb.append("ret = __jfc_proxy.getResultByString(adrs, partName);");
            sb.append(CR);
            sb.append("            ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        } else if (anormType == AnormType.R4) {
            sb.append("        ");
            sb.append("String ret = \"" + rman.getValue("anormman.comment.getresult.unsupported_r4") + "\";");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("return ret;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

