/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Initloader;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class ApplicationPropertiesGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    public static final String FILENAME = "wagbyapp.properties";

    public ApplicationPropertiesGenerator(Project project) {
        super(project);
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties";
    }

    public String getFilename() {
        return FILENAME;
    }

    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            content = this.getGeneratorClassName() + content;
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append("#").append(CR);
        sb.append("# configuration for wagby application.").append(CR);
        sb.append("#").append(CR);
        sb.append(CR);
        sb.append("# InitLoader").append(CR);
        Environment env = this.project.getEnvironment();
        Initloader initloader = AppSchemaUtil.getInitloader(env);
        String basePath = null;
        String configPath = null;
        String initdataPath = null;
        String importParentPath = null;
        String exportParentPath = null;
        String exportDirectoryPrefix = null;
        if (initloader != null) {
            basePath = initloader.getBasePath();
            if (basePath.length() > 0 && !basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            configPath = basePath + initloader.getConfigPath();
            initdataPath = "../webapps/" + AppSchemaUtil.getWebappName(this.project) + "/WEB-INF/" + AppSchemaUtil.getInitLoaderBasePathLastName(this.project.getEnvironment());
            importParentPath = initloader.getImportParentPath();
            if (importParentPath == null || importParentPath.length() == 0) {
                importParentPath = basePath;
            }
            if ((exportParentPath = initloader.getExportParentPath()) == null || exportParentPath.length() == 0) {
                exportParentPath = basePath;
            }
            exportDirectoryPrefix = initloader.getExportDirectoryPrefix();
        } else {
            basePath = ".." + File.separator + "command" + File.separator;
            configPath = basePath + "conf" + File.separator + "initdb.xml";
            initdataPath = basePath;
            importParentPath = basePath;
            exportParentPath = basePath;
            exportDirectoryPrefix = "data_";
        }
        sb.append("basePath=").append(basePath).append(CR);
        sb.append("configPath=").append(configPath).append(CR);
        sb.append("initdataPath=").append(initdataPath).append(CR);
        sb.append("importParentPath=").append(importParentPath).append(CR);
        sb.append("exportParentPath=").append(exportParentPath).append(CR);
        sb.append("exportDirectoryPrefix=").append(exportDirectoryPrefix).append(CR);
        return sb.toString();
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "# genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }
}

