/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseXslGenerator
extends SourceGenerator {
    private static final Logger logger = LogManager.getLogger(BaseXslGenerator.class);
    private String Srcdir;

    public BaseXslGenerator(Project project, String srcdir) {
        super(project);
        this.Srcdir = srcdir;
    }

    @Override
    public String getFileSuffix() {
        return "";
    }

    @Override
    public void process() {
        try {
            DOMSource inputsrc = new DOMSource(this.project.makeDocument());
            TransformerFactory factory = TransformerFactory.newInstance();
            this.process(inputsrc, factory, null);
        }
        catch (Exception e) {
            logger.error("failed process", (Throwable)e);
        }
    }

    private void process(Source inputsrc, TransformerFactory factory, String srcfile) throws Exception {
        File parent = srcfile == null ? new File(this.Srcdir) : new File(this.Srcdir, srcfile);
        if (!parent.isDirectory()) {
            logger.warn("nothing directory " + parent);
            return;
        }
        File[] files = parent.listFiles();
        if (files == null) {
            logger.warn("failed list files " + parent);
            return;
        }
        for (File file : files) {
            String shortfilename = file.getName();
            String filename = srcfile == null ? shortfilename : new File(srcfile, shortfilename).toString();
            if (file.isDirectory()) {
                this.process(inputsrc, factory, filename);
                continue;
            }
            if (!shortfilename.toLowerCase().endsWith(".xsl")) continue;
            StreamSource xslsrc = new StreamSource(file);
            Transformer transformer = factory.newTransformer(xslsrc);
            transformer.setOutputProperty("encoding", this.getEncoding());
            StringWriter writer = new StringWriter();
            StreamResult destresult = new StreamResult(writer);
            transformer.transform(inputsrc, destresult);
            String outputfilename = filename.substring(0, filename.length() - 4);
            this.createSource(writer.toString() + this.getGeneratorClassName(), outputfilename, "", false);
        }
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }
}

