/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang.StringUtils;

public class BrowserTypePropertiesGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    public static final String FILENAME = "browsertype.properties";

    public BrowserTypePropertiesGenerator(Project project) {
        super(project);
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties";
    }

    public String getFilename() {
        return FILENAME;
    }

    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            content = this.getGeneratorClassName() + content;
            this.createSource(content, filename, subpackagename, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process0() {
        String srcfilename = "template" + File.separator + FILENAME;
        File srcfile = new File(srcfilename);
        if (!srcfile.exists() || !srcfile.canRead()) {
            this.logger.error("File " + srcfilename + " is not found. Skip to generate " + FILENAME);
            return null;
        }
        boolean isMobile = false;
        for (IProjectChoice ipc : this.project.getContent()) {
            Presentation presentation;
            if (!(ipc instanceof Presentation) || !StringUtils.isNotBlank((String)(presentation = (Presentation)ipc).getMobile())) continue;
            isMobile = true;
            break;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcfilename), "UTF-8"));
            String line = null;
            String appleWebKitKeyNo = null;
            while ((line = in.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) != '#') {
                    int ptr;
                    if (line.indexOf("AppleWebKit") > 0 && appleWebKitKeyNo == null && (ptr = line.indexOf(".key=")) > 0) {
                        appleWebKitKeyNo = line.substring(0, ptr);
                    }
                    if (appleWebKitKeyNo != null) {
                        if (line.startsWith(appleWebKitKeyNo)) {
                            if (!isMobile) {
                                line = "#" + line;
                            }
                        } else {
                            appleWebKitKeyNo = null;
                        }
                    }
                }
                sb.append(line).append(CR);
            }
        }
        catch (IOException e) {
            this.logger.error("Unexpected I/O Error in read file " + srcfilename + ", " + e.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "# genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }
}

