/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;

public class BuildShGenerator
extends SourceGenerator {
    public static final String REDIRECTOR_csh = ">>& ";
    public static final String REDIRECTOR_sh = "2>&1 >> ";
    public String REDIRECTOR;
    protected ResourceManager rman;
    protected Map nameMap;

    public BuildShGenerator(Project project, Map nameMap) {
        super(project);
        this.nameMap = nameMap;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.REDIRECTOR = REDIRECTOR_sh;
    }

    @Override
    public String getFileSuffix() {
        return ".sh";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = "build-" + this.project.getName();
        if (content != null) {
            content = content + this.getGeneratorClassName();
            this.createSource(content, filename, "", false);
        }
    }

    public String process0() {
        StringBuilder sb = new StringBuilder();
        String logname = "build-" + this.project.getName() + ".log";
        sb.append("#!/bin/sh");
        sb.append(CR);
        sb.append("rm ");
        sb.append(logname);
        sb.append(CR);
        sb.append("date > ");
        sb.append(logname);
        sb.append(CR);
        sb.append("ant clean_all ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append("ant srcgen ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append("cp work/srcgen/build.xml . ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append("ant relaxer_ready ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append(this.createAllTarget("store", logname));
        sb.append(this.createAllTarget("presentation", logname));
        sb.append(this.createAllTarget("list", logname));
        sb.append(this.createAllTarget("condition", logname));
        sb.append(this.createAllTarget("master", logname));
        sb.append(this.createAllTarget("dtd", logname));
        sb.append("ant all  ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append("ant rel ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        sb.append("date ");
        sb.append(this.REDIRECTOR);
        sb.append(logname);
        sb.append(CR);
        return sb.toString();
    }

    private String createAllTarget(String key, String logname) {
        List list = (List)this.nameMap.get(key);
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        if (size < 20) {
            sb.append("ant relaxer_");
            sb.append(key);
            sb.append(" ");
            sb.append(this.REDIRECTOR);
            sb.append(logname);
            sb.append(CR);
            return sb.toString();
        }
        int postfix = 1;
        for (int i = 0; i < size; i += 20) {
            sb.append("ant relaxer_");
            sb.append(key);
            sb.append(postfix++);
            sb.append(" ");
            sb.append(this.REDIRECTOR);
            sb.append(logname);
            sb.append(CR);
        }
        return sb.toString();
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "# genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }
}

