/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.MasterBeanGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_update_base;
import jp.jasminesoft.jfc.gen.StorerefModelManager;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class CacheManagerGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    private static final int Static = 1;
    private static final int Session = 2;
    private static int InstanceMode = 1;
    public static final String PUBLIC_METHOD_SUFFIX = "_remote";
    public static final String PRIVATE_METHOD_SUFFIX = "_local";
    protected String[] defaultImportStatement = new String[]{"java.io.Serializable", "java.util.*", "javax.servlet.http.HttpSession", "jp.jasminesoft.jfc.ActionParameter", "jp.jasminesoft.jfc.ActionParameter", "jp.jasminesoft.jfc.JFCUtils", "jp.jasminesoft.jfc.PrimaryKeyUtils", "jp.jasminesoft.jfc.controller.BaseController", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "java.text.SimpleDateFormat", "net.sf.ehcache.*", "jp.jasminesoft.jfc.app.*"};
    private Map<String, Model> modelMap = new TreeMap<String, Model>();
    private Map<String, Model> masterModelMap = new TreeMap<String, Model>();
    private boolean isCluster = false;

    public CacheManagerGenerator(Project project) {
        super(project);
        IProjectChoice[] ipc;
        if (JFCAppGenerator.getIsCluster() && AppSchemaUtil.isCluster(project)) {
            this.isCluster = true;
        }
        IProjectChoice[] iProjectChoiceArray = ipc = project != null ? project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                if (!(ipc[i] instanceof Model)) continue;
                Model model = (Model)ipc[i];
                if (AppSchemaUtil.isStoreModel(model) && model.getCache()) {
                    this.modelMap.put(model.getId(), model);
                } else if ("master".equals(model.getType())) {
                    this.masterModelMap.put(model.getId(), model);
                }
                if ("master".equals(model.getType()) || !StringUtils.isNotBlank((String)model.getMasterclassname())) continue;
                this.masterModelMap.put(model.getId(), model);
            }
        }
    }

    @Override
    public String getClassname() {
        return "CacheManager";
    }

    public String getClassExplanation() {
        return rman.getValue("cacheman.comment.class");
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends CacheManagerBase");
        sb.append(this.gImplementsStatement());
        sb.append(CR);
        return sb.toString();
    }

    public String gImplementsStatement() {
        String clusterInterfaceName;
        ArrayList<String> implementsList = new ArrayList<String>();
        if (this.isCluster && StringUtils.isNotBlank((String)(clusterInterfaceName = this.getClusterInterfaceName()))) {
            implementsList.add(clusterInterfaceName);
        }
        if (InstanceMode == 2) {
            implementsList.add("Serializable");
        }
        if (implementsList.isEmpty()) {
            return "";
        }
        boolean isnotfirst = false;
        StringBuilder sb = new StringBuilder(" implements ");
        for (String intname : implementsList) {
            if (isnotfirst) {
                sb.append(", ");
                isnotfirst = true;
            }
            sb.append(intname);
        }
        return sb.toString();
    }

    protected String getClusterInterfaceName() {
        return "";
    }

    @Override
    public String[] getDefaultImport() {
        if (this.isCluster) {
            String[] clusterImportStatement = new String[]{"java.lang.management.*", "javax.management.*", "javax.management.remote.*", "jp.jasminesoft.jfc.ClusterManager", "jp.jasminesoft.jfc.ClusterManagerFactory", "jp.jasminesoft.jfc.MBeanServerConnectionFactoryBeanWrapper"};
            String[] _defaultImportStatement = new String[this.defaultImportStatement.length + clusterImportStatement.length];
            System.arraycopy(this.defaultImportStatement, 0, _defaultImportStatement, 0, this.defaultImportStatement.length);
            System.arraycopy(clusterImportStatement, 0, _defaultImportStatement, this.defaultImportStatement.length, clusterImportStatement.length);
            this.defaultImportStatement = _defaultImportStatement;
        }
        return this.defaultImportStatement;
    }

    @Override
    public String getSubpackageName() {
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.getSubpackageName();
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(this.gModelImport());
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    public String gModelImport() {
        IProjectChoice[] ipc;
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] iProjectChoiceArray = ipc = this.project != null ? this.project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model;
                if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isStoreModel(model = (Model)ipc[i])) continue;
                sb.append("import ");
                sb.append(AppSchemaUtil.getPackagename(model, this.project));
                sb.append(AppSchemaUtil.getClassname(model));
                sb.append(";");
                sb.append(CR);
            }
        }
        return sb.toString();
    }

    @Override
    public String process0() {
        IProjectChoice[] ipc;
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gLoggerReady(this.getClassname()));
        sb.append(this.gVariableDefinition1());
        sb.append(this.gVariableDefinition2());
        sb.append(this.gVariableDefinition3());
        sb.append(this.gStaticInitializer());
        sb.append(this.gConstructor());
        sb.append(this.gGetInstanceMethod());
        sb.append(this.gGetMaxCacheSizeMethod());
        sb.append(this.gGetDefaultSizeMethod());
        sb.append(this.gGetCacheManagerBaseMethodType());
        sb.append(this.gGetUpdateChoiceObjCacheManagerBaseMethodType());
        IProjectChoice[] iProjectChoiceArray = ipc = this.project != null ? this.project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model;
                if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isStoreModel(model = (Model)ipc[i])) continue;
                sb.append(this.gProcess(model));
            }
        }
        for (String id : this.masterModelMap.keySet()) {
            Model model = this.masterModelMap.get(id);
            sb.append(this.gProcess_clearMaster(model));
        }
        sb.append(this.gUpdateChoiceObj());
        sb.append(this.gEnd());
        return sb.toString();
    }

    protected String gVariableDefinition1() {
        StringBuilder sb = new StringBuilder();
        int default_size = this.modelMap.size() * 2;
        if (default_size < 16) {
            default_size = 16;
        }
        sb.append("    ");
        sb.append("private static final int DEFAULT_SIZE = ");
        sb.append(default_size);
        sb.append(";");
        sb.append(CR);
        sb.append("    ");
        sb.append("private static final int MAX_CACHE_SIZE = 1000;");
        sb.append(CR);
        return sb.toString();
    }

    protected String gVariableDefinition2() {
        StringBuilder sb = new StringBuilder();
        if (this.isCluster) {
            sb.append("    ");
            sb.append("public static ObjectName OBJECTNAME = null;");
            sb.append(CR);
        }
        if (InstanceMode == 1) {
            sb.append("    ");
            sb.append("private static final CacheManager _instance = new CacheManager();");
            sb.append(CR);
        }
        sb.append(CR);
        return sb.toString();
    }

    protected String gVariableDefinition3() {
        StringBuilder sb = new StringBuilder();
        this.gVariableDefinition3system(sb);
        this.gVariableDefinition3nonsystem1(sb);
        this.gVariableDefinition3nonsystem2(sb);
        return sb.toString();
    }

    protected String gVariableDefinition3nonsystem1(StringBuilder sb) {
        return this.gVariableDefinition3nonsystem(sb, 0);
    }

    protected String gVariableDefinition3nonsystem2(StringBuilder sb) {
        return this.gVariableDefinition3nonsystem(sb, 1);
    }

    protected String gVariableDefinition3nonsystem(StringBuilder sb) {
        return "";
    }

    protected String gVariableDefinition3nonsystem(StringBuilder sb, int mvalue) {
        IProjectChoice[] ipc;
        int count = 0;
        StorerefModelManager srefman = StorerefModelManager.getInstance();
        IProjectChoice[] iProjectChoiceArray = ipc = this.project != null ? this.project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model;
                if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isStoreModel(model = (Model)ipc[i]) || JFCUtils.isSystemModel((String)model.getId())) continue;
                String mainmodelref = model.getMainmodelidref();
                if (!srefman.contains(model.getId()) && (!StringUtils.isNotBlank((String)mainmodelref) || !srefman.contains(mainmodelref))) continue;
                if (count % 2 == mvalue) {
                    String s = this.gProcess_clear_actionType_variable(model);
                    sb.append(s);
                }
                ++count;
            }
        }
        return sb.toString();
    }

    protected String gVariableDefinition3system(StringBuilder sb) {
        IProjectChoice[] ipc;
        StorerefModelManager srefman = StorerefModelManager.getInstance();
        IProjectChoice[] iProjectChoiceArray = ipc = this.project != null ? this.project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model;
                if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isStoreModel(model = (Model)ipc[i]) || !JFCUtils.isSystemModel((String)model.getId())) continue;
                String mainmodelref = model.getMainmodelidref();
                if (!srefman.contains(model.getId()) && (!StringUtils.isNotBlank((String)mainmodelref) || !srefman.contains(mainmodelref))) continue;
                String s = this.gProcess_clear_actionType_variable(model);
                sb.append(s);
            }
        }
        sb.append("    ");
        sb.append("protected static final Set<String> cachekeySetThreadLocal;");
        sb.append(CR);
        sb.append("    ");
        sb.append("protected static final Set<String> updateChoiceObjKeySetThreadLocal;");
        sb.append(CR);
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        ArrayList<Model> threadLocalCacheModel = new ArrayList<Model>();
        Iterator<Map.Entry<String, Model>> it = this.modelMap.entrySet().iterator();
        while (it.hasNext()) {
            Model model = it.next().getValue();
            if (!model.getCache() || !model.getCacheMethod().equals("ThreadLocal")) continue;
            threadLocalCacheModel.add(model);
        }
        if (threadLocalCacheModel.size() == 0) {
            sb.append("        ");
            sb.append("cachekeySetThreadLocal = Collections.emptySet();");
            sb.append(CR);
            sb.append("        ");
            sb.append("updateChoiceObjKeySetThreadLocal = Collections.emptySet();");
            sb.append(CR);
        } else {
            StringBuilder sb_cachekey = new StringBuilder();
            sb_cachekey.append("        ");
            sb_cachekey.append("cachekeySetThreadLocal = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(new String[] {");
            sb_cachekey.append(CR);
            StringBuilder sb_updateChoiceObjKey = new StringBuilder();
            sb_updateChoiceObjKey.append("        ");
            sb_updateChoiceObjKey.append("Set<String> _updateChoiceObjKeySetThreadLocal = new HashSet<String>();");
            sb_updateChoiceObjKey.append(CR);
            for (Model model : threadLocalCacheModel) {
                sb_cachekey.append("            ");
                sb_cachekey.append("\"" + this.createCachekey(model, this.project) + "\",");
                sb_cachekey.append(CR);
                String mainmodelref = model.getMainmodelidref();
                if (!srefman.contains(model.getId()) && (!StringUtils.isNotBlank((String)mainmodelref) || !srefman.contains(mainmodelref))) continue;
                sb_updateChoiceObjKey.append("        ");
                sb_updateChoiceObjKey.append("_updateChoiceObjKeySetThreadLocal.addAll(Arrays.asList(ClearUpdateChoiceObjKeyName_" + model.getId() + "));");
                sb_updateChoiceObjKey.append(CR);
            }
            sb_cachekey.append("        ");
            sb_cachekey.append("})));");
            sb_cachekey.append(CR);
            sb_updateChoiceObjKey.append("        ");
            sb_updateChoiceObjKey.append("updateChoiceObjKeySetThreadLocal = Collections.unmodifiableSet(_updateChoiceObjKeySetThreadLocal);");
            sb_updateChoiceObjKey.append(CR);
            sb.append((CharSequence)sb_cachekey);
            sb.append((CharSequence)sb_updateChoiceObjKey);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gStaticInitializer() {
        if (!this.isCluster) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append("            ");
        sb.append("MBeanServer server = ManagementFactory.getPlatformMBeanServer();");
        sb.append(CR);
        sb.append("            ");
        sb.append("ObjectName objname");
        sb.append(CR);
        sb.append("                ");
        sb.append("= new ObjectName(OBJECTNAME_STR);");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (!server.isRegistered(objname)) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("server.registerMBean(_instance, objname);");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (NotCompliantMBeanException ncmbe) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("logger.error(ncmbe.getMessage());");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("logger.error(e);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gConstructor() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("private ");
        sb.append(this.getClassname());
        sb.append("() {");
        sb.append(CR);
        if (this.isCluster) {
            sb.append("        ");
            sb.append("try {");
            sb.append(CR);
            sb.append("            ");
            sb.append("OBJECTNAME = new ObjectName(OBJECTNAME_STR);");
            sb.append(CR);
            sb.append("        ");
            sb.append("} catch (MalformedObjectNameException mone) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("logger.error(\"invalid ObjectName.\", mone);");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetInstanceMethod() {
        if (InstanceMode == 1) {
            return this.gGetInstanceMethod_static();
        }
        if (InstanceMode == 2) {
            return this.gGetInstanceMethod_session();
        }
        logger.error("InstanceMode is ignore value");
        return "";
    }

    protected String gGetMaxCacheSizeMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public int getMaxCacheSize() {").append(CR);
        sb.append("        ");
        sb.append("return MAX_CACHE_SIZE;").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gGetDefaultSizeMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public int getDefaultSize() {").append(CR);
        sb.append("        ");
        sb.append("return DEFAULT_SIZE;").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gGetCacheManagerBaseMethodType() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("@Override").append(CR);
        sb.append("    ");
        sb.append("protected CacheManagerBaseMethodType getCacheManagerBaseMethodType(String cachekey) {").append(CR);
        sb.append("        ");
        sb.append("if (cachekeySetThreadLocal.contains(cachekey)) {").append(CR);
        sb.append("            ");
        sb.append("return CacheManagerBaseMethodType.THREAD_LOCAL;").append(CR);
        sb.append("        ");
        sb.append("}").append(CR);
        sb.append("        ");
        sb.append("return CacheManagerBaseMethodType.EH_CACHE;").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gGetUpdateChoiceObjCacheManagerBaseMethodType() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("@Override").append(CR);
        sb.append("    ");
        sb.append("protected CacheManagerBaseMethodType getUpdateChoiceObjCacheManagerBaseMethodType(String updateChoiceObjKey) {").append(CR);
        sb.append("        ");
        sb.append("if (updateChoiceObjKeySetThreadLocal.contains(updateChoiceObjKey)) {").append(CR);
        sb.append("            ");
        sb.append("return CacheManagerBaseMethodType.THREAD_LOCAL;").append(CR);
        sb.append("        ");
        sb.append("}").append(CR);
        sb.append("        ");
        sb.append("return CacheManagerBaseMethodType.EH_CACHE;").append(CR);
        sb.append("    ");
        sb.append("}").append(CR).append(CR);
        return sb.toString();
    }

    protected String gGetInstanceMethod_static() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), null, null));
        sb.append("    ");
        sb.append("public static ");
        sb.append(this.getClassname());
        sb.append(" getInstance() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return _instance;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        String[] params = new String[]{"p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), params, null));
        sb.append("    ");
        sb.append(CR);
        sb.append("    ");
        sb.append("public static ");
        sb.append(this.getClassname());
        sb.append(" getInstance(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return getInstance();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetInstanceMethod_session() {
        StringBuilder sb = new StringBuilder();
        String[] params = new String[]{"p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.getinstance"), params, null));
        sb.append("    ");
        sb.append("public static ");
        sb.append(this.getClassname());
        sb.append(" getInstance(ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("CacheManager _instance = null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (p == null || p.request == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return _instance;");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("HttpSession session = p.request.getSession();");
        sb.append(CR);
        sb.append("        ");
        sb.append("synchronized (session) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("_instance = (CacheManager)session.getAttribute(BaseController.CacheManagerSessionName);");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (_instance == null) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("_instance = new CacheManager();");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("session.setAttribute(BaseController.CacheManagerSessionName, _instance);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return _instance;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gProcess_get_make_key(model));
        sb.append(this.gProcess_get_make_key2(model));
        if (this.modelMap.containsKey(model.getId())) {
            sb.append(this.gProcess_get(model));
            sb.append(this.gProcess_put(model));
        }
        sb.append(this.gProcess_remove_pattern1(model));
        sb.append(this.gProcess_remove_pattern2(model));
        sb.append(this.gProcess_clear_actionType(model));
        sb.append(this.gProcess_clear(model));
        return sb.toString();
    }

    protected String gProcess_get_make_key(Model model) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String[] params = new String[]{id};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.makekey"), params, null));
        sb.append("    ");
        sb.append("public final String get");
        sb.append(classname);
        sb.append("Key(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (");
        sb.append(id);
        sb.append(" == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return \"\";");
        sb.append(CR);
        sb.append(CR);
        if (!StringUtils.isNotBlank((String)model.getPackage()) || !model.getPackage().startsWith("jp.jasminesoft.jfc.app")) {
            sb.append("        ");
            sb.append("return ");
            sb.append(AppSchemaUtil.getPackagename_app(model, this.project));
            sb.append(AppSchemaUtil.getHelperClassname(model));
            sb.append(".getPrimaryKeyAsString(").append(id).append(");");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(model);
        String name = null;
        String type = null;
        HashMap<String, Boolean> formatControlMap = new HashMap<String, Boolean>();
        boolean isFirstOutput = true;
        for (int i = 0; i < pkeys.length; ++i) {
            if (AppSchemaUtil.isGenerationPrimaryKey(pkeys[i], model)) continue;
            name = pkeys[i].getName();
            Modelitem mitem = AppSchemaUtil.getModelitem(name, model);
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
            if (relation != null) {
                String[][] _params;
                Model rmodel = (Model)relation.getIdrefAsIRNode();
                if (rmodel == null) {
                    rmodel = AppSchemaUtil.getModel(this.project, relation.getIdref());
                }
                if ((_params = AppSchemaUtil.getAllCompositeKeyNameAndTypeAsStringArray(this.project, rmodel)) == null || _params.length <= 0) continue;
                for (int j = 0; j < _params.length; ++j) {
                    String _name = null;
                    _name = _params.length == 1 ? name : name + "_" + _params[j][0];
                    String _type = _params[j][1];
                    this.gProcess_get_make_key_body(id, _name, _type, isFirstOutput, formatControlMap, sb);
                    isFirstOutput = false;
                }
                continue;
            }
            type = AppSchemaUtil.getPkeyType(model, name, pkeys[i].getType(), this.project);
            this.gProcess_get_make_key_body(id, name, type, isFirstOutput, formatControlMap, sb);
            isFirstOutput = false;
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("return _key.toString();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gProcess_get_make_key_body(String id, String name, String type, boolean isFirstOutput, Map<String, Boolean> formatControlMap, StringBuilder sb) {
        Boolean isDateFormatOutput = formatControlMap.get("isDateFormatOutput");
        Boolean isTimeFormatOutput = formatControlMap.get("isTimeFormatOutput");
        Boolean isDateTimeFormatOutput = formatControlMap.get("isDateTimeFormatOutput");
        if ("date".equals(type) && isDateFormatOutput == null) {
            sb.append("        ");
            sb.append(ControllerGenerator2.getFixedLocaleSimpleDateFormatDefinition(this.project, type));
            sb.append(CR);
            formatControlMap.put("isDateFormatOutput", Boolean.TRUE);
        } else if ("time".equals(type) && isTimeFormatOutput == null) {
            sb.append("        ");
            sb.append(ControllerGenerator2.getFixedLocaleSimpleDateFormatDefinition(this.project, type));
            sb.append(CR);
            formatControlMap.put("isTimeFormatOutput", Boolean.TRUE);
        } else if ("dateTime".equals(type) && isDateTimeFormatOutput == null) {
            sb.append("        ");
            sb.append(ControllerGenerator2.getFixedLocaleSimpleDateFormatDefinition(this.project, type));
            sb.append(CR);
            formatControlMap.put("isDateTimeFormatOutput", Boolean.TRUE);
        }
        if (isFirstOutput) {
            sb.append("        ");
            sb.append("StringBuilder _key = new StringBuilder();");
            sb.append(CR);
        } else {
            sb.append("        ");
            sb.append("_key.append(PrimaryKeyUtils.PKEY_SEPARATOR());");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("_key.append(");
        if (JavaSourceGenerator.isBasicType(type)) {
            sb.append(JavaSourceGenerator.getB2wc_method(type));
            sb.append("(");
            sb.append(id + CacheManagerGenerator.getterFullMethod(name));
            sb.append("));");
        } else if ("date".equals(type)) {
            sb.append("fmt_d.format(");
            sb.append(id + CacheManagerGenerator.getterFullMethod(name));
            sb.append("));");
        } else if ("time".equals(type)) {
            sb.append("fmt_t.format(");
            sb.append(id + CacheManagerGenerator.getterFullMethod(name));
            sb.append("));");
        } else if ("dateTime".equals(type)) {
            sb.append("fmt_dt.format(");
            sb.append(id + CacheManagerGenerator.getterFullMethod(name));
            sb.append("));");
        } else {
            sb.append("(String)");
            sb.append(id + CacheManagerGenerator.getterFullMethod(name));
            sb.append(");");
        }
        sb.append(CR);
    }

    protected String gProcess_get_make_key2(Model model) {
        int i;
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        String[] params = new String[]{id};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.makekey"), params, null));
        sb.append("    ");
        sb.append("public final String get");
        sb.append(classname);
        sb.append("Key(");
        String name = null;
        int count = 0;
        for (i = 0; i < pkeys.length; ++i) {
            if (AppSchemaUtil.isGenerationPrimaryKey(pkeys[i], model)) continue;
            if (count > 0) {
                sb.append(", ");
            }
            name = AppSchemaUtil.createFullPrimaryKeyName(pkeys[i]);
            sb.append("String");
            sb.append(" ");
            sb.append(name);
            ++count;
        }
        sb.append(") {");
        sb.append(CR);
        if (pkeys.length == 1) {
            sb.append("        ");
            sb.append("return ");
            sb.append(name);
            sb.append(";");
            sb.append(CR);
        } else {
            for (i = 0; i < pkeys.length; ++i) {
                if (AppSchemaUtil.isGenerationPrimaryKey(pkeys[i], model)) continue;
                name = AppSchemaUtil.createFullPrimaryKeyName(pkeys[i]);
                if (i == 0) {
                    sb.append("        ");
                    sb.append("StringBuilder _key = new StringBuilder();");
                    sb.append(CR);
                } else {
                    sb.append("        ");
                    sb.append("_key.append(PrimaryKeyUtils.PKEY_SEPARATOR());");
                    sb.append(CR);
                }
                sb.append("        ");
                sb.append("_key.append(");
                sb.append(name);
                sb.append(");");
                sb.append(CR);
            }
            sb.append("        ");
            sb.append("return _key.toString();");
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_get(Model model) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        if (pkeys == null) {
            return "";
        }
        String[] params = new String[]{"key"};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.get"), params, classname));
        sb.append("    ");
        sb.append("public ");
        sb.append(classname);
        sb.append(" get");
        sb.append(classname);
        sb.append("(String key) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return get(key, ").append(classname).append(".class, ");
        sb.append("\"");
        sb.append(this.createCachekey(model, this.project));
        sb.append("\");").append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_put(Model model) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        String id = model.getId();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        if (pkeys == null) {
            return "";
        }
        String[] params = new String[]{"key"};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.put"), params, classname));
        sb.append("    ");
        sb.append("public void put");
        sb.append(classname);
        sb.append("(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("put(").append(id).append(", ").append(classname).append(".class, \"");
        sb.append(this.createCachekey(model, this.project));
        sb.append("\", ");
        sb.append("get");
        sb.append(classname);
        sb.append("Key(");
        sb.append(id);
        sb.append(")");
        sb.append(");").append(CR);
        LinkedHashSet<Model> targetModelSet = new LinkedHashSet<Model>();
        if (model.getCache()) {
            targetModelSet.add(model);
        }
        if (StringUtils.isNotBlank((String)model.getMainmodelidref())) {
            targetModelSet.add((Model)model.getMainmodelidrefAsIRNode());
            ProcessBeanGenerator.addSubModelWithSameParent(model.getMainmodelidref(), model, targetModelSet, this.project);
        }
        ProcessBeanGenerator.addSubModelWithSameParent(model.getId(), model, targetModelSet, this.project);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_remove_pattern1(Model model) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String[] params = new String[]{"key"};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
        sb.append("    ");
        sb.append("public void remove");
        sb.append(classname);
        sb.append("(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("remove");
        sb.append(classname);
        sb.append("(");
        sb.append("get");
        sb.append(classname);
        sb.append("Key(");
        sb.append(id);
        sb.append(")");
        sb.append(");");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_remove_pattern2(Model model) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        String[] params = new String[]{"key"};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
        sb.append("    ");
        sb.append("public void remove");
        sb.append(classname);
        sb.append("(String key) {");
        sb.append(CR);
        LinkedHashSet<Model> targetModelSet = new LinkedHashSet<Model>();
        if (model.getCache()) {
            targetModelSet.add(model);
        }
        if (StringUtils.isNotBlank((String)model.getMainmodelidref())) {
            targetModelSet.add((Model)model.getMainmodelidrefAsIRNode());
            ProcessBeanGenerator.addSubModelWithSameParent(model.getMainmodelidref(), model, targetModelSet, this.project);
        }
        ProcessBeanGenerator.addSubModelWithSameParent(model.getId(), model, targetModelSet, this.project);
        for (Model rmodel : targetModelSet) {
            if (!rmodel.getCache()) continue;
            String rid = rmodel.getId();
            sb.append("        ");
            sb.append("remove(key, ");
            sb.append("\"");
            sb.append(this.createCachekey(rmodel, this.project));
            sb.append("\"");
            sb.append(");").append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (this.isCluster) {
            sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
            sb.append("    ");
            sb.append("public void remove");
            sb.append(classname);
            sb.append(PUBLIC_METHOD_SUFFIX);
            sb.append("(String key, String machinename) {");
            sb.append(CR);
            sb.append(CacheManagerGenerator.gClusterActiveCheckCode("        "));
            sb.append("        ");
            sb.append("remove" + classname + "(key);");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gProcess_clear(Model model) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.clear"), null, null));
        sb.append("    ");
        sb.append("public void clear");
        sb.append(classname);
        sb.append("() {");
        sb.append(CR);
        if (model.getCache()) {
            sb.append("        ");
            sb.append("clear(").append("\"");
            sb.append(this.createCachekey(model, this.project));
            sb.append("\");").append(CR);
        }
        sb.append("        ");
        sb.append("clear");
        sb.append(classname);
        sb.append("_");
        sb.append((Object)ActionType.update);
        if (this.isCluster) {
            sb.append(PRIVATE_METHOD_SUFFIX);
        }
        sb.append("((String) null);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (this.isCluster) {
            sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.clear"), null, null));
            sb.append("    ");
            sb.append("public void clear");
            sb.append(classname);
            sb.append(PUBLIC_METHOD_SUFFIX);
            sb.append("(String machinename) {");
            sb.append(CR);
            sb.append(CacheManagerGenerator.gClusterActiveCheckCode("        "));
            sb.append("        ");
            sb.append("clear" + classname + "();");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gProcess_clear_actionType(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gProcess_clear_actionType_model(model, ActionType.insert));
        sb.append(this.gProcess_clear_actionType_model(model, ActionType.update));
        sb.append(this.gProcess_clear_actionType_model(model, ActionType.delete));
        sb.append(this.gProcess_clear_actionType_key(model, ActionType.insert));
        sb.append(this.gProcess_clear_actionType_key(model, ActionType.update));
        sb.append(this.gProcess_clear_actionType_key(model, ActionType.delete));
        return sb.toString();
    }

    protected String gProcess_clear_actionType_variable(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected final static String[] ClearUpdateChoiceObjKeyName_" + model.getId());
        List<String> list = ProcessBeanGenerator.getKeyCacheManagerClearUpdateChoiceObj(model, this.project);
        if (list.size() == 0) {
            sb.append(" = {};");
            sb.append(CR);
            return sb.toString();
        }
        sb.append(" = {");
        sb.append(CR);
        for (String s : list) {
            sb.append("        ");
            sb.append(s);
            sb.append(",");
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_clear_actionType_model(Model model, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String[] params = new String[]{classname};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
        sb.append("    ");
        sb.append("public void clear");
        sb.append(classname);
        sb.append("_");
        sb.append((Object)actionType);
        sb.append("(");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("clear");
        sb.append(classname);
        sb.append("_");
        sb.append((Object)actionType);
        sb.append("(");
        sb.append("get");
        sb.append(classname);
        sb.append("Key(");
        sb.append(id);
        sb.append(")");
        sb.append(");");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_clear_actionType_key(Model model, ActionType actionType) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        String[] params = new String[]{classname};
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
        sb.append("    ");
        sb.append("public");
        sb.append(this.gSynchronizedModifier());
        sb.append(" void clear");
        sb.append(classname);
        sb.append("_");
        sb.append((Object)actionType);
        sb.append("(String key) {");
        sb.append(CR);
        String clear_code = this.gProcess_clear_actionType_key_content(model, actionType, "", "        ");
        if (this.isCluster) {
            String cacheClearMethod = "clear" + classname + "_" + (Object)((Object)actionType) + PRIVATE_METHOD_SUFFIX + "(key)";
            if (StringUtils.isNotBlank((String)clear_code)) {
                sb.append(CacheManagerGenerator.gClusterCacheCearCode("clear" + classname + "_" + (Object)((Object)actionType) + PUBLIC_METHOD_SUFFIX + "(key, machinename)", "        "));
            }
            sb.append("        ");
            sb.append(cacheClearMethod);
            sb.append(";");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
            sb.append("    ");
            sb.append("public void clear");
            sb.append(classname);
            sb.append("_");
            sb.append((Object)actionType);
            sb.append(PUBLIC_METHOD_SUFFIX);
            sb.append("(String key, String machinename) {");
            sb.append(CR);
            sb.append(CacheManagerGenerator.gClusterActiveCheckCode("        "));
            sb.append("        ");
            sb.append(cacheClearMethod);
            sb.append(";");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.remove"), params, null));
            sb.append("    ");
            sb.append("public void clear");
            sb.append(classname);
            sb.append("_");
            sb.append((Object)actionType);
            sb.append(PRIVATE_METHOD_SUFFIX);
            sb.append("(String key) {");
            sb.append(CR);
        }
        sb.append(clear_code);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gProcess_clear_actionType_key_content(Model model, ActionType actionType, String instance, String basetab) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getClassname(model);
        int storage = AppSchemaUtil.getStorageType(model.getStorage());
        StorerefModelManager srefman = StorerefModelManager.getInstance();
        Map<String, Set<Modelitem>> copyMap = AppSchemaUtil.createRefTargetItemWithRelatedItemMapWithStoreRefmodel(model, this.project);
        if (storage == 5 && (actionType == ActionType.update || actionType == ActionType.delete)) {
            sb.append(basetab);
            sb.append(instance);
            sb.append("remove");
            sb.append(classname);
            sb.append("(key");
            sb.append(");");
            sb.append(CR);
        }
        String mainmodelref = model.getMainmodelidref();
        if (srefman.contains(model.getId()) || StringUtils.isNotBlank((String)mainmodelref) && srefman.contains(mainmodelref)) {
            sb.append(basetab);
            sb.append("for (String s : ClearUpdateChoiceObjKeyName_" + model.getId() + ") {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append(instance);
            sb.append("clearUpdateChoiceObj(s);");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
        }
        if (ProcessBeanGenerator_update_base.isClearCache_updateRelatedItem(model, copyMap, this.project) && (actionType == ActionType.insert || actionType == ActionType.update)) {
            sb.append(ProcessBeanGenerator_update_base.gRunMethodCode_updateRelatedItem_ClearCache(model, copyMap, instance, this.project, "        "));
        }
        sb.append(this.gClearGroupNodes(model, actionType, basetab));
        sb.append(this.gClearJCategory(model, actionType, basetab));
        return sb.toString();
    }

    protected Object gClearGroupNodes(Model model, ActionType actionType, String basetab) {
        String code = basetab + "clearGroupNodes();" + CR;
        if ("jgroup".equals(model.getId()) && (actionType == ActionType.update || actionType == ActionType.delete)) {
            return code;
        }
        if ("jfcgroupnode".equals(model.getId())) {
            return code;
        }
        return "";
    }

    protected Object gClearJCategory(Model model, ActionType actionType, String basetab) {
        String code = basetab + "clearPrincipalCategory();" + CR;
        if ("jcategory".equals(model.getId()) && (actionType == ActionType.update || actionType == ActionType.delete)) {
            return code;
        }
        return "";
    }

    protected String gUpdateChoiceObj() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gUpdateChoiceObj_clearAll());
        return sb.toString();
    }

    protected String gProcess_clearMaster(Model model) {
        if (AppSchemaUtil.getStorageType(model.getStorage()) == 3) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = MasterBeanGenerator.getMasterClassname(model);
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.clear"), null, null));
        sb.append("    ");
        sb.append("public void clear");
        sb.append(classname);
        sb.append("() {");
        sb.append(CR);
        sb.append("        ");
        if (!"master".equals(model.getType()) && StringUtils.isNotBlank((String)model.getMasterclassname())) {
            sb.append(model.getMasterclassname());
        } else {
            sb.append(this.project.getPackage());
            sb.append(".app.");
            sb.append(id);
            sb.append(".");
            sb.append(classname);
        }
        sb.append(".clear();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (this.isCluster) {
            sb.append("    ");
            sb.append("public void clear");
            sb.append(classname);
            sb.append(PUBLIC_METHOD_SUFFIX);
            sb.append("(String machinename) {");
            sb.append(CR);
            sb.append(CacheManagerGenerator.gClusterActiveCheckCode("        "));
            sb.append("        ");
            sb.append("clear");
            sb.append(classname);
            sb.append("();");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gUpdateChoiceObj_clearAll() {
        IProjectChoice[] ipc;
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.clearAll"), null, null));
        sb.append("    ");
        sb.append("public void clearAll() {");
        sb.append(CR);
        sb.append("        ").append("super.clearAll();").append(CR);
        IProjectChoice[] iProjectChoiceArray = ipc = this.project != null ? this.project.getContent() : null;
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Model model;
                if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isStoreModel(model = (Model)ipc[i])) continue;
                sb.append("        ");
                sb.append("clear");
                sb.append(AppSchemaUtil.getClassname(model));
                sb.append("();");
                sb.append(CR);
            }
        }
        for (String id : this.masterModelMap.keySet()) {
            Model mmodel = this.masterModelMap.get(id);
            if (AppSchemaUtil.getStorageType(mmodel.getStorage()) == 3) continue;
            String mclassname = MasterBeanGenerator.getMasterClassname(mmodel);
            sb.append("        ");
            sb.append("clear");
            sb.append(mclassname);
            sb.append("();");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("clearAllUpdateChoiceObj();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (this.isCluster) {
            sb.append(CommentGenerator.gComment(rman.getValue("cacheman.comment.clearAll"), null, null));
            sb.append("    ");
            sb.append("public void clearAll");
            sb.append(PUBLIC_METHOD_SUFFIX);
            sb.append("(String machinename) {");
            sb.append(CR);
            sb.append(CacheManagerGenerator.gClusterActiveCheckCode("        "));
            sb.append("        ");
            sb.append("clearAll();");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected static String gClusterCacheCearCode(String cacheClearMethod, String basetab) {
        if (StringUtils.isBlank((String)cacheClearMethod)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("ClusterManager clusterman = ClusterManagerFactory.getClusterManager();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("String machinename = clusterman.getThisMachinename();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("MBeanServerConnectionFactoryBeanWrapper[] beans");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("= clusterman.getMBeanServerConnectionFactoryBeanWrapperList();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("for (MBeanServerConnectionFactoryBeanWrapper bean : beans) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("MBeanServerConnection mbsc = bean.getMBeanServerConnection(CacheManager.OBJECTNAME);");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (mbsc == null) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("continue;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("CacheManagerMBean cman_mbean");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("= (CacheManagerMBean)MBeanServerInvocationHandler.newProxyInstance(");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("mbsc,");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("CacheManager.OBJECTNAME,");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("CacheManagerMBean.class, false);");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("cman_mbean.");
        sb.append(cacheClearMethod);
        sb.append(";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gSynchronizedModifier() {
        return "";
    }

    protected static String gClusterActiveCheckCode(String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("ClusterManager clusterman = ClusterManagerFactory.getClusterManager();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("clusterman.checkActive(machinename);");
        sb.append(CR);
        return sb.toString();
    }

    private String createCachekey(Model model, Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append(AppSchemaUtil.getPackagename(model, project));
        sb.append(AppSchemaUtil.getClassname(model));
        return sb.toString();
    }

    public static void reset() {
        InstanceMode = 1;
    }

    protected static enum ActionType {
        insert,
        update,
        delete;

    }
}

