/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.jasminesoft.jfc.tools.appid.ApplicationIDUtil;
import jp.jasminesoft.util.ExtensionFilenameFilter;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CheckLicense {
    private static final boolean debug = false;
    private static final String baseDirectory = ".." + File.separator + "xls-model";
    private static final String CR = System.getProperty("line.separator");
    private static String devMachineId;
    private static ResourceManager rman;
    protected static String devhomePath;

    public static String process() {
        String ret = CheckLicense.a();
        if (ret != null) {
            return ret;
        }
        return CheckLicense.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a() {
        String key = null;
        InputStream is = null;
        try {
            String key0;
            File f = new File(".." + File.separator + "wagby-licensekey.xml");
            if (!f.exists()) {
                f = new File(devhomePath + "/wagby-licensekey.xml");
            }
            if (!f.exists()) {
                String string = rman.getValue("checklicense.notfound");
                return string;
            }
            if (!f.canRead()) {
                String string = rman.getValue("checklicense.cannotread");
                return string;
            }
            is = new FileInputStream(f);
            if (is == null) return null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            Element elem = doc.getDocumentElement();
            Node node = elem.getFirstChild();
            StringBuffer buf = new StringBuffer();
            while (node instanceof Text) {
                buf.append(node.getNodeValue());
                if ((node = node.getNextSibling()) != null) continue;
            }
            key = buf.toString();
            int VersionLen = 2;
            byte[] ba1 = CheckLicense.StringToByteArray(key.substring(2));
            if (ba1.length < 2) {
                String string = rman.getValue("checklicense.invalid");
                return string;
            }
            byte[] ba2 = new byte[ba1.length - 2];
            byte randombyte = ba1[0];
            byte checkbyte = 0;
            for (int i = 2; i < ba1.length; ++i) {
                byte b;
                checkbyte = (byte)(checkbyte + ba1[i]);
                ba2[i - 2] = b = (byte)(ba1[i] - randombyte);
            }
            if (ba1[1] != checkbyte) {
                String i = rman.getValue("checklicense.invalid");
                return i;
            }
            if (key != null && key.length() > 2 && (key.charAt(0) == '0' && key.charAt(1) == '2' || key.charAt(0) == '0' && key.charAt(1) == '1' || key.charAt(0) == '0' && key.charAt(1) == '0')) {
                String i = null;
                return i;
            }
            try {
                key0 = new String(ba2, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                String string = rman.getValue("checklicense.invalid");
                if (is == null) return string;
                try {
                    is.close();
                    return string;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
            String[] v = key0.split(Pattern.quote("+"), -1);
            devMachineId = v[27];
            if (StringUtils.isBlank((String)devMachineId)) {
                String string = null;
                return string;
            }
            boolean isMatch = false;
            try {
                Enumeration<NetworkInterface> nic = NetworkInterface.getNetworkInterfaces();
                while (nic.hasMoreElements()) {
                    NetworkInterface n = nic.nextElement();
                    String macaddress = ApplicationIDUtil.Byte2HexStr((byte[])n.getHardwareAddress(), (boolean)false);
                    if (macaddress == null || macaddress.length() != 12 || !devMachineId.equals(macaddress)) continue;
                    isMatch = true;
                    break;
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            if (isMatch) return null;
            String string = rman.getValue("checklicense.wrongmachine");
            return string;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String b() {
        String[] filenames;
        StringBuilder sb = new StringBuilder();
        File xlsModelDirectory = new File(baseDirectory);
        String[] exts = new String[]{".xls"};
        ExtensionFilenameFilter filter = new ExtensionFilenameFilter(exts, false, false);
        for (String filename : filenames = xlsModelDirectory.list((FilenameFilter)filter)) {
            if ("base.xls".equals(filename) || "common-jgroup.xls".equals(filename) || "common-jnews.xls".equals(filename) || "common-juser.xls".equals(filename) || CheckLicense.c(new File(baseDirectory + File.separator + filename))) continue;
            sb.append(filename).append(CR);
        }
        String ret = sb.toString();
        if (ret.length() > 0) {
            ret = devMachineId == null || devMachineId.length() == 0 ? rman.getValue("checklicense.unlimited") + CR + ret : rman.getValue("checklicense.mismatch") + CR + ret;
        }
        if (ret.endsWith(",")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean c(File file) {
        FileInputStream reader = null;
        try {
            String s;
            HSSFRow currentRow;
            HSSFCell aCell;
            HSSFRichTextString rstring;
            reader = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)reader);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            HSSFSheet sheet = workbook.getSheet("+repositorydef");
            int ptr = 0;
            while ((rstring = (aCell = (currentRow = sheet.getRow(ptr)).getCell(25)).getRichStringCellValue()) != null && (s = rstring.getString()) != null && s.length() != 0) {
                if (StringUtils.isNotBlank((String)devMachineId) && s.equals(devMachineId)) {
                    boolean bl = true;
                    return bl;
                }
                if (StringUtils.isBlank((String)devMachineId) && StringUtils.isNotBlank((String)s)) {
                    boolean bl = false;
                    return bl;
                }
                if (++ptr <= 1024) continue;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (!StringUtils.isNotBlank((String)devMachineId)) return true;
        return false;
    }

    private static byte[] StringToByteArray(String s) {
        int slen = s.length();
        int balen = slen * 6 / 8;
        byte[] ba = new byte[balen];
        for (int cnt = 0; cnt < balen; ++cnt) {
            int charcnt = cnt * 8 / 6;
            int b1 = CheckLicense.CharacterToBit6(s.charAt(charcnt));
            int shift1 = 8 * (cnt + 1) - 6 * (charcnt + 1);
            if (shift1 == 0) {
                ba[cnt] = (byte)(b1 & 0xFF);
                continue;
            }
            if (shift1 <= 0) {
                ba[cnt] = (byte)(b1 >> -shift1 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(b1 << shift1 & 0xFF);
            int b2 = CheckLicense.CharacterToBit6(s.charAt(charcnt + 1));
            int shift2 = 8 * (cnt + 1) - 6 * (charcnt + 2);
            if (shift2 == 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 & 0xFF);
                continue;
            }
            if (shift2 <= 0) {
                ba[cnt] = (byte)(ba[cnt] | b2 >> -shift2 & 0xFF);
                continue;
            }
            ba[cnt] = (byte)(ba[cnt] | b2 << shift2 & 0xFF);
            int b3 = CheckLicense.CharacterToBit6(s.charAt(charcnt + 2));
            int shift3 = 8 * (cnt + 1) - 6 * (charcnt + 3);
            ba[cnt] = shift3 == 0 ? (byte)(ba[cnt] | b3 & 0xFF) : (shift3 <= 0 ? (byte)(ba[cnt] | b3 >> -shift3 & 0xFF) : (byte)(ba[cnt] | b3 << shift3 & 0xFF));
        }
        return ba;
    }

    private static int CharacterToBit6(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65 + 36;
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '-') {
            return 63;
        }
        return -1;
    }

    static {
        rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        devhomePath = "../../";
    }
}

