/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.ISourceVariable;

public class ClassnameManager
implements ISourceVariable {
    String packagename = null;
    ArrayList addfullclassnameList = new ArrayList();
    ArrayList addallpackagenameList = new ArrayList();
    ArrayList addsubclassnameList = new ArrayList();
    boolean isLockedUpdate = false;

    public ClassnameManager() {
    }

    public ClassnameManager(String packagename, String[] fullclassnames) {
        this();
        this.setPackagename(packagename);
        this.addClassnames(fullclassnames);
    }

    public void setPackagename(String packagename) {
        if (this.isLockedUpdate) {
            throw new IllegalStateException("locked update");
        }
        this.packagename = packagename;
    }

    public String getPackagename() {
        return this.packagename;
    }

    public void addClassname(String fullclassname) {
        if (this.isLockedUpdate) {
            throw new IllegalStateException("locked update");
        }
        if (this.addfullclassnameList.contains(fullclassname)) {
            return;
        }
        String thispackagename = this.getPackagename(fullclassname);
        if (this.packagename.equals("java.lang")) {
            return;
        }
        String subclassname = this.getSubclassname(fullclassname);
        if (subclassname.equals("*")) {
            if (this.addallpackagenameList.contains(subclassname)) {
                return;
            }
            this.addallpackagenameList.add(thispackagename);
        } else {
            if (this.addsubclassnameList.contains(subclassname)) {
                return;
            }
            this.addsubclassnameList.add(subclassname);
        }
        this.addfullclassnameList.add(fullclassname);
    }

    public void clearClassname() {
        if (this.isLockedUpdate) {
            throw new IllegalStateException("locked update");
        }
        this.addfullclassnameList.clear();
        this.addallpackagenameList.clear();
        this.addsubclassnameList.clear();
    }

    public void addClassnames(String[] fullclassnames) {
        if (this.isLockedUpdate) {
            throw new IllegalStateException("locked update");
        }
        for (int i = 0; i < fullclassnames.length; ++i) {
            this.addClassname(fullclassnames[i]);
        }
    }

    public void setClassnames(String[] fullclassnames) {
        if (this.isLockedUpdate) {
            throw new IllegalStateException("locked update");
        }
        this.clearClassname();
        this.addClassnames(fullclassnames);
    }

    public String outputPackageAndImportCode() {
        this.isLockedUpdate = true;
        StringBuilder sb = new StringBuilder();
        if (this.isHavePackagename()) {
            this.appendPackageCode(sb);
            sb.append(CR);
        }
        this.appendImportCode(sb);
        return sb.toString();
    }

    public String outputImportCode() {
        this.isLockedUpdate = true;
        StringBuilder sb = new StringBuilder();
        this.appendImportCode(sb);
        return sb.toString();
    }

    private void appendPackageCode(StringBuilder sb) {
        sb.append("package ");
        sb.append(this.packagename);
        sb.append(";");
        sb.append(CR);
    }

    private void appendImportCode(StringBuilder sb) {
        for (String fullclassname : this.addfullclassnameList) {
            sb.append("import ");
            sb.append(fullclassname);
            sb.append(";");
            sb.append(CR);
        }
    }

    public String outputClassname(String classname) {
        String subclassname;
        String thispackagename;
        String fullclassname;
        if (this.isFullclassname(classname) || !this.isHavePackagename()) {
            fullclassname = classname;
            thispackagename = this.getPackagename(classname);
            subclassname = this.getSubclassname(classname);
        } else {
            fullclassname = this.packagename + "." + classname;
            thispackagename = this.packagename;
            subclassname = classname;
        }
        if (this.addfullclassnameList.contains(fullclassname)) {
            return subclassname;
        }
        if (this.addallpackagenameList.contains(thispackagename)) {
            return subclassname;
        }
        if ("java.lang".equals(thispackagename)) {
            return subclassname;
        }
        return classname;
    }

    private boolean isHavePackagename() {
        return this.packagename != null && !this.packagename.equals("");
    }

    private boolean isFullclassname(String classname) {
        int lastdotindex = classname.lastIndexOf(46);
        if (lastdotindex >= 0) {
            if (lastdotindex == classname.length()) {
                throw new IllegalStateException("illegal classname. classname \"" + classname + "\"last char is dot.");
            }
            return true;
        }
        return false;
    }

    private String getSubclassname(String fullclassname) {
        String subclassname;
        int lastdotindex = fullclassname.lastIndexOf(46);
        if (lastdotindex >= 0) {
            if (lastdotindex == fullclassname.length()) {
                throw new IllegalStateException("illegal classname. classname \"" + fullclassname + "\" last char is dot.");
            }
            subclassname = fullclassname.substring(lastdotindex + 1);
        } else {
            subclassname = fullclassname;
        }
        return subclassname;
    }

    private String getPackagename(String fullclassname) {
        int lastdotindex = fullclassname.lastIndexOf(46);
        String packagename = lastdotindex >= 0 ? fullclassname.substring(0, lastdotindex) : "";
        return packagename;
    }
}

