/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;

public abstract class ConfigGenerator
extends SourceGenerator {
    protected String tmplatefilename;
    protected ResourceManager rman;
    protected String packagedir;
    protected String packagename;

    public ConfigGenerator(Project project) {
        this(null, project);
    }

    public ConfigGenerator(String tmplatefilename, Project project) {
        super(project);
        this.tmplatefilename = tmplatefilename;
        this.packagedir = JavaSourceGenerator.convPackage2FilePath(project.getPackage());
        this.packagename = project.getPackage();
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public String getTmplateFilename() {
        return this.tmplatefilename;
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            content = content + this.getGeneratorClassName();
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public abstract String getFilename();

    public abstract String getSubpackageName();

    public abstract String process0();

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }
}

