/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;

public abstract class ControlUtilGenerator
extends TablenameGenerator {
    protected String[] defaultImportStatement = new String[]{"java.util.*", "jp.jasminesoft.jfc.*", "org.springframework.context.ApplicationContext", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "javax.servlet.http.HttpServletRequest", "java.sql.Connection"};

    public ControlUtilGenerator(Project project) {
        super(project);
    }

    public String getBaseClassname() {
        return this.getClassname().substring(0, this.getClassname().length() - "Impl".length());
    }

    public String gVariable() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private final static Logger logger = LogManager.getLogger(").append(this.getClassname()).append(".class);");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends ").append(this.getBaseClassname());
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            importList.add(this.defaultImportStatement[i]);
        }
        return importList.toArray(new String[0]);
    }

    public abstract String getProcessAsMapMethodCommentKey();

    public abstract String getProcessAsMapMethodReturnCommentKey();

    public abstract String getProcessAsMapMethodReturnType();

    public abstract String getProcessAsMapMethodName();

    public String getHelperType() {
        return "Helper";
    }

    public String gProcessAsMapMethod() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipcs = this.project.getContent();
        if (ipcs == null || ipcs.length == 0) {
            return sb.toString();
        }
        sb.append("    ");
        sb.append("protected final static String[][] PHelperBeanNames = {");
        boolean isfirst = true;
        for (IProjectChoice ipc : ipcs) {
            Model pmodel;
            String type;
            if (!(ipc instanceof Model) || !"presentation".equals(type = (pmodel = (Model)ipc).getType())) continue;
            String phelperclassname = AppSchemaUtil.getHelperClassname(pmodel, this.getHelperType());
            AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project, this.getHelperType());
            if (!isfirst) {
                sb.append(",");
            } else {
                isfirst = false;
            }
            sb.append(CR);
            sb.append("        ");
            sb.append("{\"");
            sb.append(pmodel.getId());
            sb.append("\", \"");
            sb.append(phelperclassname);
            sb.append("\"}");
        }
        sb.append(CR);
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append("    ");
        sb.append("protected final static Map<String, String> PHelperBeanNameMap;");
        sb.append(CR);
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        sb.append("        ");
        sb.append("PHelperBeanNameMap = new HashMap<String, String>();");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (String[] beanname : PHelperBeanNames) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("PHelperBeanNameMap.put(beanname[0], beanname[1]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("@Override").append(CR);
        sb.append("    ");
        sb.append("protected Map<String, String> getPHelperBeanNameMap() {").append(CR);
        sb.append("        ");
        sb.append("return PHelperBeanNameMap;").append(CR);
        sb.append("    ");
        sb.append("}").append(CR);
        sb.append(CR);
        return sb.toString();
    }

    public abstract String getProcessAsContentMethodCommentKey();

    public abstract String getProcessAsContentMethodReturnCommentKey();

    public abstract String getProcessAsContentMethodReturnType();

    public abstract String getProcessAsContentMethodName();

    public abstract String getProcessAsContentDefaultReturnValue();

    public abstract String getProcessAsContentDefineReturnVariable();

    public abstract String getProcessAsContentReturnValueName();

    public String getModelitemParameterComment() {
        return "modelitemname " + rman.getValue("ControlUtilGenerator.param.modelitemname");
    }

    public String getModelitemVariableName() {
        return "modelitemname";
    }

    public String gProcessAsContentMethod() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipcs = this.project.getContent();
        if (ipcs == null || ipcs.length == 0) {
            return sb.toString();
        }
        sb = null;
        return "";
    }

    protected abstract boolean skipModel(Model var1);

    private void gProcessAsContentMethod_store(StringBuilder sb, Model pmodel, Model smodel) {
        String _classname = AppSchemaUtil.getClassname(smodel);
        String _packagename = AppSchemaUtil.getPackagename(smodel, this.project);
        String phelper = AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project, this.getHelperType());
        String[] msg_param = new String[]{"p ActionParameter", "user " + rman.getValue("ControlUtilGenerator.param.user"), "obj " + rman.getValue("ControlUtilGenerator.param.obj"), this.getModelitemParameterComment()};
        sb.append(CommentGenerator.gComment(rman.getValue(this.getProcessAsContentMethodCommentKey()), msg_param, rman.getValue(this.getProcessAsContentMethodReturnCommentKey())));
        sb.append("    ");
        sb.append("protected ").append(this.getProcessAsContentMethodReturnType()).append(" ").append(this.getProcessAsContentMethodName()).append("_" + pmodel.getId() + "(");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p, User user, Object obj, String ").append(this.getModelitemVariableName()).append(")");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        String tab = "        ";
        sb.append("        ");
        sb.append("if (obj == null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return ").append(phelper).append(".");
        sb.append(this.getProcessAsContentMethodName()).append("(user, ").append(this.getModelitemVariableName()).append(", p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (obj instanceof ");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(") {");
        sb.append(CR);
        sb.append("            ");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(" _item =");
        sb.append(CR);
        sb.append("                ");
        sb.append("(");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(")obj;");
        sb.append(CR);
        sb.append("            ");
        sb.append("return ").append(phelper).append(".");
        sb.append(this.getProcessAsContentMethodName()).append("(user, _item, ").append(this.getModelitemVariableName()).append(", p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gProcessAsContentMethod_list(StringBuilder sb, Model pmodel, Model ssmodel) {
        boolean isTextSearchMode = AppSchemaUtil.hasTextSearchModelitem(ssmodel);
        String _classname = "Item";
        String _packagename = AppSchemaUtil.getPackagename(pmodel, this.project);
        String _smodel_classname = AppSchemaUtil.getClassname(ssmodel);
        String _smodel_packagename = AppSchemaUtil.getPackagename(ssmodel, this.project);
        String phelper = AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project, this.getHelperType());
        String[] msg_param = new String[]{"p ActionParameter", "user " + rman.getValue("ControlUtilGenerator.param.user"), "obj " + rman.getValue("ControlUtilGenerator.param.obj"), this.getModelitemParameterComment()};
        sb.append(CommentGenerator.gComment(rman.getValue(this.getProcessAsContentMethodCommentKey()), msg_param, rman.getValue(this.getProcessAsContentMethodReturnCommentKey())));
        sb.append("    ");
        sb.append("protected ").append(this.getProcessAsContentMethodReturnType()).append(" ").append(this.getProcessAsContentMethodName()).append("_" + pmodel.getId() + "(");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p, User user, Object obj, String ").append(this.getModelitemVariableName()).append(")");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        String tab = "        ";
        sb.append("        ");
        sb.append("if (p.user == null && user != null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("p.user = user;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("if (obj == null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return ").append(phelper).append(".");
        sb.append(this.getProcessAsContentMethodName()).append("(user, ").append(this.getModelitemVariableName()).append(", p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (obj instanceof ");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(") {");
        sb.append(CR);
        sb.append("            ");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(" _item =");
        sb.append(CR);
        sb.append("                ");
        sb.append("(");
        sb.append(_packagename);
        sb.append(_classname);
        sb.append(")obj;");
        sb.append(CR);
        sb.append("            ");
        sb.append("return ").append(phelper).append(".");
        sb.append(this.getProcessAsContentMethodName()).append("(user, _item, ").append(this.getModelitemVariableName()).append(", p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (obj instanceof ");
        sb.append(_smodel_packagename);
        sb.append(_smodel_classname);
        sb.append(") {");
        sb.append(CR);
        sb.append("            ");
        sb.append(_smodel_packagename);
        sb.append(_smodel_classname);
        sb.append(" _item =");
        sb.append(CR);
        sb.append("                ");
        sb.append("(");
        sb.append(_smodel_packagename);
        sb.append(_smodel_classname);
        sb.append(")obj;");
        sb.append(CR);
        sb.append("            ");
        sb.append("return ").append(phelper).append(".");
        sb.append(this.getProcessAsContentMethodName()).append("(user, _item, ").append(this.getModelitemVariableName()).append(", p);");
        sb.append(CR);
        if (isTextSearchMode && !pmodel.getUpdatelist()) {
            PrimaryKey[] pkeys;
            StringBuilder sb0 = new StringBuilder();
            for (PrimaryKey pkey : pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(ssmodel, this.project)) {
                Relation relation;
                if (pkey.getBranch()) continue;
                String pkey_name = pkey.getName();
                Modelitem sitem = AppSchemaUtil.getModelitem(pkey_name, ssmodel);
                if (sitem != null && (relation = AppSchemaUtil.getRelationTypeExceptRef(sitem)) != null) {
                    String sitem_id = sitem.getName();
                    String sitem_classname = AppSchemaUtil.getModelitemClassname(sitem);
                    sb.append("            ");
                    sb0.append(_packagename);
                    sb0.append(sitem_classname);
                    sb0.append(" ");
                    sb0.append("__" + sitem_id);
                    sb0.append(" = new ");
                    sb0.append(_packagename);
                    sb0.append(sitem_classname);
                    sb0.append("();");
                    sb0.append(CR);
                    sb.append("            ");
                    sb0.append("__" + sitem_id);
                    sb0.append(".setIdByString(");
                    sb0.append("contentMap.get(\"");
                    sb0.append(sitem_id);
                    sb0.append("\"));");
                    sb0.append(CR);
                    sb.append("            ");
                    sb0.append("__" + sitem_id);
                    sb0.append(".setChoose(true);");
                    sb0.append(CR);
                    sb.append("            ");
                    sb0.append("_item.");
                    sb0.append(JavaSourceGenerator.setterMethod(pkey_name));
                    sb0.append("(");
                    sb0.append("__" + sitem_id);
                    sb0.append(");");
                    sb0.append(CR);
                    continue;
                }
                sb.append("            ");
                sb0.append("_item.");
                sb0.append(JavaSourceGenerator.setterMethod(pkey_name));
                sb0.append("(");
                sb0.append("contentMap.get(\"");
                sb0.append(pkey_name);
                sb0.append("\"));");
                sb0.append(CR);
            }
            if (sb0.length() > 0) {
                sb.append("        ");
                sb.append("} else if (obj instanceof Map) {");
                sb.append(CR);
                sb.append("            ");
                sb.append(_packagename);
                sb.append(_classname);
                sb.append(" ");
                sb.append("_item =");
                sb.append(CR);
                sb.append("                ");
                sb.append("new ");
                sb.append(_packagename);
                sb.append(_classname);
                sb.append("();");
                sb.append(CR);
                sb.append("            ");
                sb.append("Map<String, String> contentMap = (Map<String, String>)obj;");
                sb.append(CR);
                sb.append(sb0.toString());
                sb.append("            ");
                sb.append("return ").append(phelper).append(".");
                sb.append(this.getProcessAsContentMethodName()).append("(user, _item, ").append(this.getModelitemVariableName()).append(", p);");
                sb.append(CR);
            }
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }
}

