/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.IActionParameter;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGenerateControllerBean;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;

public abstract class ControllerGeneratorBase
extends JavaSourceGenerator
implements IGeneratorFactory,
IActionParameter,
IGenerateControllerBean {
    public static final String SUB_PACKAGE_NAME = "controller";
    protected String templateDir = "template/javasrc/controller/";

    public ControllerGeneratorBase(Project project) {
        super(project);
    }

    protected String getTemplateFilePath() {
        return this.templateDir + this.getTemplateFile();
    }

    protected abstract String getTemplateFile();

    @Override
    public String process0() {
        if (!this.isGenerate()) {
            return null;
        }
        Map<String, Object> map = this.createParameterMap();
        return VelocityUtils.mergeContent((String)this.getTemplateFilePath(), map);
    }

    public boolean isGenerate() {
        return true;
    }

    public static Map<String, Object> createParameterMap(Project project, Model smodel) {
        String pkeyclassname;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("author", project.getAuthor());
        map.put("project", project);
        if (smodel != null) {
            map.put("entityPackageName", AppSchemaUtil.getPackagename(smodel, project));
            map.put("entityClassName", AppSchemaUtil.getClassname(smodel));
            map.put("modelName", smodel.getId());
            map.put("smodel", smodel);
            map.put("modelMetaName", StoreModelUtils.metaName((String)smodel.getId()));
            map.put("helperClassName", AppSchemaUtil.getHelperClassBeanName4Dicon(smodel, project));
        }
        if (smodel == null || smodel.getType() == null) {
            pkeyclassname = "Object";
        } else {
            StoreModel storeModel = new StoreModel(smodel);
            pkeyclassname = storeModel.getPrimarykey().getClassName();
        }
        map.put("pkeyclassname", pkeyclassname);
        return map;
    }

    public Map<String, Object> createParameterMap() {
        Model smodel = this.getStoreModel();
        Map<String, Object> map = ControllerGeneratorBase.createParameterMap(this.project, smodel);
        map.put("packageName", this.getPackage());
        map.put("className", this.getClassname());
        map.put("subdatabaseIdx", ModelUtils.getSubdatabaseIdx(smodel));
        return map;
    }

    @Override
    public abstract String getClassname();

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    protected abstract Model getStoreModel();

    protected void putPRIMARYKEYS(Map<String, Object> map) {
        Model smodel = this.getStoreModel();
        map.put("PRIMARYKEYS", AppSchemaUtil.getPrimaryKey(smodel));
        map.put("PRIMARYKEYTYPES", this.getPrimaryKeyTypes());
        map.put("codePRIMARYKEYS", this.generateCodePRIMARYKEYS());
    }

    protected String[] getPrimaryKeyTypes() {
        Model smodel = this.getStoreModel();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(smodel);
        String[] sa = new String[pkeys.length];
        for (int i = 0; i < pkeys.length; ++i) {
            String name = pkeys[i].getName();
            Modelitem mitem = AppSchemaUtil.getModelitem(name, smodel);
            sa[i] = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), mitem, "roleid");
        }
        return sa;
    }

    protected String generateCodePRIMARYKEYS() {
        Model smodel = this.getStoreModel();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(smodel);
        String[] sa = new String[pkeys.length];
        for (int i = 0; i < pkeys.length; ++i) {
            sa[i] = pkeys[i].getName();
        }
        return ControllerGeneratorBase.outputStringArrayCode(sa);
    }

    protected String generateCodeMULTIPLE_MODELITEM_NAME() {
        Modelitem[] mitems;
        ArrayList<String> list = new ArrayList<String>();
        Model smodel = this.getStoreModel();
        for (Modelitem mitem : mitems = AppSchemaUtil.getModelitem(smodel)) {
            if (!mitem.getMultiple() || mitem.getHasChild()) continue;
            list.add(mitem.getName());
        }
        String[] sa = list.toArray(new String[list.size()]);
        return ControllerGeneratorBase.outputStringArrayCode(sa);
    }

    protected String generateCodeCONTAINER_META() {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, List<Modelitem>> containerNameMap = this.createContainerNameMap();
        for (Map.Entry<String, List<Modelitem>> e : containerNameMap.entrySet()) {
            list.add(this.generateCodeCONTAINER_META1(e.getKey(), e.getValue()));
        }
        String[] sa = list.toArray(new String[list.size()]);
        return ControllerGeneratorBase.outputArrayCode(sa);
    }

    private String generateCodeCONTAINER_META1(String containerName, List<Modelitem> list) {
        String sortkey = this.getContainerSortKey(list);
        String cidmitemname = this.getContainerIdModelitem(containerName, list);
        return "new ContainerMeta(\"" + containerName + "\", \"" + cidmitemname + "\", \"" + sortkey + "\")";
    }

    private String getContainerSortKey(List<Modelitem> list) {
        StringBuilder sb0 = new StringBuilder();
        for (int k = 0; k < list.size(); ++k) {
            Modelitem _item = list.get(k);
            if (k == 0) continue;
            String _name = _item.getName();
            sb0.append(AppSchemaUtil.getChildPart(_name));
            if (k >= list.size() - 1) continue;
            sb0.append(" ");
        }
        return sb0.toString();
    }

    private String getContainerIdModelitem(String containerName, List<Modelitem> mitems) {
        for (Modelitem _item : mitems) {
            if (!AppSchemaUtil.getParentPart(_item.getName()).equals(containerName) || !_item.getAutokey()) continue;
            return AppSchemaUtil.getChildPart(_item.getName());
        }
        return null;
    }

    private Map<String, List<Modelitem>> createContainerNameMap() {
        Model smodel = this.getStoreModel();
        IModelChoice[] imc = smodel.getContent();
        LinkedHashMap<String, List<Modelitem>> containerNameMap = new LinkedHashMap<String, List<Modelitem>>();
        if (imc == null) {
            return containerNameMap;
        }
        String key = null;
        ArrayList<Modelitem> list = null;
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Modelitem)) continue;
            Modelitem _item = (Modelitem)imc[i];
            if (_item.getMultiple() && _item.getHasChild()) {
                list = new ArrayList<Modelitem>();
                list.add(_item);
                key = _item.getName();
                containerNameMap.put(key, list);
            }
            if (key == null || !_item.getName().startsWith(key + "/")) continue;
            list.add(_item);
        }
        return containerNameMap;
    }

    protected static String outputStringArrayCode(String[] sa) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sa.length; ++i) {
            String s = sa[i];
            sb.append("        \"");
            sb.append(s);
            sb.append("\"");
            if (i >= sa.length - 1) continue;
            sb.append(",\n");
        }
        return sb.toString();
    }

    protected static String outputArrayCode(String[] sa) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sa.length; ++i) {
            String s = sa[i];
            sb.append("        ");
            sb.append(s);
            if (i >= sa.length - 1) continue;
            sb.append(",\n");
        }
        return sb.toString();
    }

    protected void putScreenMessageListenerClassname(Map<String, Object> map, String[] classnames) {
        map.put("SCREEN_MESSAGE_LISTENER_CLASSNAME", classnames);
    }

    @Override
    public abstract String generateControllerBean(String var1);

    public static boolean isCustomize(String beanClass) {
        StringBuilder _path = new StringBuilder();
        _path.append(ControllerGeneratorBase.getCustomizeClassname(beanClass, File.separator));
        _path.append(".java");
        return ControllerGeneratorBase.existsCustomizeFile(_path.toString());
    }

    public static String getCustomizeClassname(String beanClass, String sep) {
        String _packagename = StringUtil.getPackageName((String)beanClass);
        String _classname = StringUtil.getClassName((String)beanClass);
        StringBuilder sb0 = new StringBuilder();
        if (!sep.equals(".")) {
            sb0.append(StringUtil.replaceAll((String)_packagename, (String)".", (String)sep));
        } else {
            sb0.append(_packagename);
        }
        sb0.append(sep);
        sb0.append("My");
        sb0.append(_classname);
        return sb0.toString();
    }

    public static boolean existsCustomizeFile(String filename) {
        String[] basedirs;
        for (String basedir : basedirs = rman.getValueStrArray("CustomizeJavaSourceBasedirs")) {
            File file = new File(basedir, filename.toString());
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }
}

