/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ControllerGenerator;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_copy;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_delete;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_download;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_empty;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_free;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_insert;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_myclass;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_show;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_showList;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_showListByCalendarView;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_showTotal;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_update;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_updateList;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_uploadUpdate;
import jp.jasminesoft.jfc.gen.ControllerGenerator_childShowControllerDataitem;
import jp.jasminesoft.jfc.gen.ControllerGenerator_copy;
import jp.jasminesoft.jfc.gen.ControllerGenerator_delete;
import jp.jasminesoft.jfc.gen.ControllerGenerator_download;
import jp.jasminesoft.jfc.gen.ControllerGenerator_free;
import jp.jasminesoft.jfc.gen.ControllerGenerator_initLoader;
import jp.jasminesoft.jfc.gen.ControllerGenerator_insert;
import jp.jasminesoft.jfc.gen.ControllerGenerator_myclass;
import jp.jasminesoft.jfc.gen.ControllerGenerator_reactAdminRest;
import jp.jasminesoft.jfc.gen.ControllerGenerator_show;
import jp.jasminesoft.jfc.gen.ControllerGenerator_showList;
import jp.jasminesoft.jfc.gen.ControllerGenerator_showListByCalendarView;
import jp.jasminesoft.jfc.gen.ControllerGenerator_showTotal;
import jp.jasminesoft.jfc.gen.ControllerGenerator_update;
import jp.jasminesoft.jfc.gen.ControllerGenerator_updateList;
import jp.jasminesoft.jfc.gen.ControllerGenerator_uploadUpdate;
import jp.jasminesoft.jfc.gen.IGenerateControllerBean;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SourceWriter;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ControllerGeneratorFactory.class.getName());
    protected static ResourceManager rman;
    private static final String customizeFolder = "../customize/webpage/WEB-INF/src/";
    private static CompatibilityManager compatibilityManager;

    public static JavaSourceGenerator[] create(Project project, Action action) {
        IGenerateControllerBean[] igcb;
        HashSet<JavaSourceGenerator> sgenSet = new HashSet<JavaSourceGenerator>();
        for (IGenerateControllerBean i : igcb = ControllerGeneratorFactory.createGenerateControllerBean(project, action)) {
            if (!(i instanceof JavaSourceGenerator)) continue;
            sgenSet.add((JavaSourceGenerator)((Object)i));
        }
        return sgenSet.toArray(new JavaSourceGenerator[0]);
    }

    public static IGenerateControllerBean[] createGenerateControllerBean(Project project, Action action) {
        ControllerGenerator2 congen;
        JavaSourceGenerator congen2;
        ArrayList<IGenerateControllerBean> sgenSet = new ArrayList<IGenerateControllerBean>();
        String type = action.getType();
        if (type == null) {
            logger.warn(rman.getValue("value.null.action.type", action.getId()));
            logger.warn(rman.getValue("struts.comment.skip"));
            return null;
        }
        Model smodel = (Model)action.getIdrefAsIRNode();
        if ("show".equals(type)) {
            congen2 = new ControllerGenerator2_show(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_show(project, action, Collections.emptyList()));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("showList".equals(type)) {
            String view = action.getView();
            if (action.getUpdatelist()) {
                congen = new ControllerGenerator2_updateList(project, action);
                congen.setControllerGenerator(new ControllerGenerator_updateList(project, action));
                sgenSet.add(congen);
            } else if ("calendar".equals(view)) {
                congen = new ControllerGenerator2_showListByCalendarView(project, action);
                congen.setControllerGenerator(new ControllerGenerator_showListByCalendarView(project, action));
                sgenSet.add(congen);
            } else if (!"map".equals(view)) {
                if ("total".equals(view)) {
                    congen = new ControllerGenerator2_showTotal(project, action);
                    congen.setControllerGenerator(new ControllerGenerator_showTotal(project, action));
                    sgenSet.add(congen);
                } else {
                    congen = new ControllerGenerator2_showList(project, action);
                    congen.setControllerGenerator(new ControllerGenerator_showList(project, action));
                    sgenSet.add(congen);
                }
            }
        } else if ("insert".equals(type)) {
            congen2 = new ControllerGenerator2_insert(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_insert(project, action));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("update".equals(type)) {
            congen2 = new ControllerGenerator2_update(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_update(project, action));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("delete".equals(type)) {
            if (smodel.getLogicalDelete()) {
                congen2 = new ControllerGenerator2_delete(project, action);
                congen2.setControllerGenerator(new ControllerGenerator_delete(project, action, ControllerGenerator_delete.Type.LOGICAL));
                sgenSet.add((IGenerateControllerBean)((Object)congen2));
                congen2 = new ControllerGenerator2_delete(project, action);
                congen2.setControllerGenerator(new ControllerGenerator_delete(project, action, ControllerGenerator_delete.Type.PHYSICAL));
                sgenSet.add((IGenerateControllerBean)((Object)congen2));
            } else {
                congen2 = new ControllerGenerator2_delete(project, action);
                congen2.setControllerGenerator(new ControllerGenerator_delete(project, action, ControllerGenerator_delete.Type.NORMAL));
                sgenSet.add((IGenerateControllerBean)((Object)congen2));
            }
        } else if ("copy".equals(type)) {
            congen2 = new ControllerGenerator2_copy(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_copy(project, action));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("showList-master".equals(type)) {
            if (smodel != null && !"static".equals(smodel.getStorage())) {
                // empty if block
            }
        } else if ("download".equals(type)) {
            congen2 = new ControllerGenerator2_download(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_download(project, action));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("free".equals(type)) {
            congen2 = new ControllerGenerator2_free(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_free(project, action, ((ControllerGenerator2_free)congen2).getSuperClassname()));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("empty".equals(type)) {
            final String strutsclasstype = action.getStrutsclasstype();
            if (strutsclasstype != null && strutsclasstype.startsWith("jp.jasminesoft.jfc.")) {
                final Action faction = action;
                IGenerateControllerBean icb = new IGenerateControllerBean(){

                    @Override
                    public String generateControllerBean(String tab) {
                        ControllerGenerator.ActionNode actionnode = new ControllerGenerator.ActionNode();
                        actionnode.setBeanid(faction.getId() + "Controller");
                        actionnode.setBeanclass(strutsclasstype);
                        return actionnode.toString(tab);
                    }
                };
                sgenSet.add(icb);
            } else {
                congen = new ControllerGenerator2_empty(project, action);
                congen.setControllerGenerator(new ControllerGenerator_free(project, action, ((ControllerGenerator2_empty)congen).getSuperClassname()));
                sgenSet.add(congen);
            }
        } else if ("uploadUpdate".equals(type)) {
            congen2 = new ControllerGenerator2_uploadUpdate(project, action);
            congen2.setControllerGenerator(new ControllerGenerator_uploadUpdate(project, action));
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        } else if ("reserved".equals(type) && "initLoader".equals(action.getId())) {
            congen2 = new ControllerGenerator_initLoader(project, action);
            sgenSet.add((IGenerateControllerBean)((Object)congen2));
        }
        sgenSet.addAll(ControllerGeneratorFactory.gOutputDataWithPlace(project, action));
        String myclass = action.getStrutsclasstype();
        if (myclass != null && myclass.length() > 0 && !myclass.startsWith("jp.jasminesoft.jfc.controller.")) {
            if (myclass.endsWith("Action")) {
                myclass = myclass.substring(0, myclass.length() - "Action".length()) + "Controller";
            }
            ControllerGeneratorFactory.addMyClassControllerGenerator(project, action, sgenSet, myclass, null);
            if ("delete".equals(type) && smodel.getLogicalDelete()) {
                String superclassname = "PhysicalDelete" + SourceGenerator.capFirst(smodel.getId()) + "Controller";
                myclass = "My" + superclassname;
                ControllerGeneratorFactory.addMyClassControllerGenerator(project, action, sgenSet, myclass, superclassname);
            }
        }
        return sgenSet.toArray(new IGenerateControllerBean[0]);
    }

    private static void addMyClassControllerGenerator(Project project, Action action, ArrayList<IGenerateControllerBean> sgenSet, String myclass, String superclassname) {
        StringBuilder path = new StringBuilder(customizeFolder);
        path.append(JavaSourceGenerator.convPackage2FilePath(project.getPackage()));
        path.append("/");
        path.append("controller");
        path.append("/");
        path.append(action.getIdref());
        path.append("/");
        path.append(myclass).append(".java");
        File file = new File(SourceWriter.normalizeFilepath(path.toString()));
        if (!file.exists()) {
            ControllerGenerator2_myclass congen = new ControllerGenerator2_myclass(project, action);
            if (superclassname == null) {
                superclassname = congen.getSuperClassname();
            }
            congen.setControllerGenerator(new ControllerGenerator_myclass(project, action, myclass, superclassname));
            sgenSet.add(congen);
        }
    }

    protected static Set<ControllerGenerator> gOutputDataWithPlace(Project project, Action action) {
        HashSet<ControllerGenerator> sgenSet = new HashSet<ControllerGenerator>();
        Datalist datalist = AppSchemaUtil.getDatalist(action);
        if (datalist == null) {
            return sgenSet;
        }
        Dataitem[] dataitems = datalist.getDataitem();
        if (dataitems == null) {
            return sgenSet;
        }
        for (int i = 0; i < dataitems.length; ++i) {
            Dataitem dataitem;
            String dataitemtype;
            if (i == 0 || "updateList".equals(dataitemtype = (dataitem = dataitems[i]).getType()) || "list".equals(dataitemtype)) continue;
            if ("array2list".equals(dataitemtype)) {
                sgenSet.add(new ControllerGenerator_childShowControllerDataitem(project, action, dataitem));
                continue;
            }
            if (!"reverse".equals(dataitemtype)) continue;
        }
        return sgenSet;
    }

    protected static List<Dataitem> getDataitem(Dataitem[] dataitems, String dataitemtype) {
        ArrayList<Dataitem> list = new ArrayList<Dataitem>();
        if (dataitems == null) {
            return list;
        }
        for (Dataitem dataitem : dataitems) {
            if (!dataitemtype.equals(dataitem.getType())) continue;
            list.add(dataitem);
        }
        return list;
    }

    public static JavaSourceGenerator[] createForStoreModel(Project project, Model smodel) {
        IGenerateControllerBean[] igcb;
        HashSet<JavaSourceGenerator> sgenSet = new HashSet<JavaSourceGenerator>();
        for (IGenerateControllerBean i : igcb = ControllerGeneratorFactory.createGenerateControllerBeanForStoreModel(project, smodel)) {
            if (!(i instanceof JavaSourceGenerator)) continue;
            sgenSet.add((JavaSourceGenerator)((Object)i));
        }
        return sgenSet.toArray(new JavaSourceGenerator[0]);
    }

    public static IGenerateControllerBean[] createGenerateControllerBeanForStoreModel(Project project, Model smodel) {
        ArrayList<ControllerGenerator_reactAdminRest> sgenSet = new ArrayList<ControllerGenerator_reactAdminRest>();
        if (compatibilityManager.getBooleanValue("jp.jasminesoft.jfc.gen.ControllerGenerator_RestV3") && smodel.getRestV3()) {
            sgenSet.add(new ControllerGenerator_reactAdminRest(project, smodel));
        }
        return sgenSet.toArray(new IGenerateControllerBean[0]);
    }

    static {
        compatibilityManager = CompatibilityManager.getInstance();
    }
}

