/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Activemq;
import jp.jasminesoft.jfc.gen.appschema.Cacheinfo;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import org.apache.commons.lang3.StringUtils;

public class EhcacheXmlGenerator
extends ConfigGenerator {
    public EhcacheXmlGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "ehcache";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        String maxBytesLocalHeap = null;
        Environment env = this.project.getEnvironment();
        Cacheinfo cinfo = null;
        IEnvironmentChoice[] iec = env.getContent();
        if (iec != null) {
            for (int i = 0; i < iec.length; ++i) {
                if (!(iec[i] instanceof Cacheinfo)) continue;
                cinfo = (Cacheinfo)iec[i];
                maxBytesLocalHeap = cinfo.getMaxBytesLocalHeap();
                break;
            }
        }
        if (StringUtils.isBlank(maxBytesLocalHeap)) {
            maxBytesLocalHeap = "100";
        }
        tplman.addContent("maxBytesLocalHeap", maxBytesLocalHeap + "M");
        tplman.addContent("cacheEventListenerFactory", this.createCacheEventListenerFactory());
        tplman.addContent("cacheManagerPeerProviderFactory", this.createCacheManagerPeerProviderFactory());
        return tplman.getResult();
    }

    protected boolean isEhcacheJMSReplication() {
        return AppSchemaUtil.getActivemq(this.project.getEnvironment()) != null;
    }

    protected String createCacheEventListenerFactory() {
        if (!this.isEhcacheJMSReplication()) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(CR + "    ");
        sb.append("<cacheEventListenerFactory").append(CR + "    ");
        sb.append("  class=\"net.sf.ehcache.distribution.jms.JMSCacheReplicatorFactory\"").append(CR + "    ");
        sb.append("  properties=\"replicateAsynchronously=false,").append(CR + "    ");
        sb.append("              replicatePuts=false,").append(CR + "    ");
        sb.append("              replicateUpdates=true,").append(CR + "    ");
        sb.append("              replicateUpdatesViaCopy=false,").append(CR + "    ");
        sb.append("              replicateRemovals=true\"").append(CR + "    ");
        sb.append("              propertySeparator=\",\"/>");
        return sb.toString();
    }

    protected String createCacheManagerPeerProviderFactory() {
        Activemq activemq = AppSchemaUtil.getActivemq(this.project.getEnvironment());
        if (activemq == null) {
            return "";
        }
        String SEP = ";";
        StringBuilder sb = new StringBuilder().append(CR + "  ");
        sb.append("<cacheManagerPeerProviderFactory").append(CR + "  ");
        sb.append("  class=\"jp.jasminesoft.jfc.core.support.ehcache.JMSCacheManagerPeerProviderFactory\"").append(CR + "  ");
        sb.append("  properties=\"initialContextFactoryName=jp.jasminesoft.jfc.core.support.ehcache.EhCacheActiveMQInitialContextFactory").append(";").append(CR + "  ");
        sb.append("              providerURL=").append(activemq.getProviderURL()).append(";").append(CR + "  ");
        sb.append("              userName=").append(activemq.getUserName()).append(";").append(CR + "  ");
        sb.append("              password=").append(activemq.getPassword()).append(";").append(CR + "  ");
        sb.append("              replicationTopicConnectionFactoryBindingName=topicConnectionFactory").append(";").append(CR + "  ");
        sb.append("              getQueueConnectionFactoryBindingName=queueConnectionFactory").append(";").append(CR + "  ");
        sb.append("              replicationTopicBindingName=ehcache").append(";").append(CR + "  ");
        sb.append("              getQueueBindingName=ehcacheGetQueue\"").append(CR + "  ");
        sb.append("  propertySeparator=\"").append(";").append("\"/>");
        return sb.toString();
    }
}

