/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.gen.AbstractDBExpressionGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpressionGenerator_Hibernate
extends AbstractDBExpressionGenerator {
    private static Logger logger = LogManager.getLogger(ExpressionGenerator_Hibernate.class);
    private DbTypeManager.SubqueryHeaderType subqueryHeaderType;
    private int expressionHeaderType = 1;
    public static final int ShowList = 1;
    public static final int GetCount = 2;
    public static final int AggregateFunction = 3;
    public static final int AggregateUpdateListGetMaxFunction = 4;
    public static final int AggregateUpdateListGetMinFunction = 5;
    private String expressionHeader = null;

    public ExpressionGenerator_Hibernate(Project project) {
        Environment env = project.getEnvironment();
        this.subqueryHeaderType = DbTypeManager.getSubqueryHeaderType(env);
    }

    @Override
    public String getProperColumnName(String name) {
        return this.getProperColumnName(name, 0);
    }

    @Override
    public String getProperColumnName(String name, int indexOfCompositeKey) {
        Model smodel = this.getStoreModel();
        return ExpressionGenerator_Hibernate.getProperColumnName(name, smodel, indexOfCompositeKey, this.project);
    }

    public static String getProperColumnName(String name, Model smodel, int indexOfCompositeKey, Project project) {
        Modelitem smitem = ExpressionGenerator_Hibernate.getModelitemConsideringCompositeKey(name, smodel, project);
        if (smitem == null || AppSchemaUtil.isStoreThismodel(smitem)) {
            return ExpressionGenerator_Hibernate.getProperColumnName0(name, smodel, indexOfCompositeKey, project);
        }
        return ExpressionGenerator_Hibernate.getProperColumnName_refmodel(smitem, smodel, indexOfCompositeKey, project);
    }

    private static String getProperColumnName_refmodel(Modelitem smitem, Model smodel, int indexOfCompositeKey, Project project) {
        boolean isCheckRelation;
        Relation smitem_relation;
        ArrayList<SubQueryFromData> fromdatalist = new ArrayList<SubQueryFromData>();
        String name = smitem.getName();
        if (AppSchemaUtil.hasChildPart(name)) {
            String pname = AppSchemaUtil.getParentPart(name);
            String pname_alias = AppSchemaUtil.createHqlAliasName(pname);
            SubQueryFromData contfromdata = SubQueryFromDataImpl.createForCode(null, pname_alias);
            fromdatalist.add(contfromdata);
        }
        boolean isThisModel = false;
        String smitem_relation_name = null;
        Model smitem_refmodel = null;
        while ((smitem_relation = AppSchemaUtil.getRelationTypeIsRef(smitem)) != null) {
            smitem_relation_name = smitem_relation.getName();
            smitem_refmodel = (Model)smitem_relation.getIdrefAsIRNode();
            smitem = AppSchemaUtil.getModelitem(smitem_relation_name, smitem_refmodel);
            String refmodel_id_alias = AppSchemaUtil.createHqlAliasName(smitem_refmodel.getId());
            refmodel_id_alias = ExpressionGenerator_Hibernate.findHqlAliasName(refmodel_id_alias, smodel, fromdatalist);
            SubQueryFromData fromdata = SubQueryFromDataImpl.createForClassname(null, refmodel_id_alias);
            fromdatalist.add(fromdata);
            isThisModel = AppSchemaUtil.isStoreThismodel(smitem);
            if (!isThisModel) continue;
            break;
        }
        if (smitem_relation_name == null || smitem_refmodel == null) {
            logger.error("[Internal Error] unknown relation[@type=ref] modelitem name:" + name + " model_id:" + smodel.getId());
            return null;
        }
        if (isThisModel) {
            isCheckRelation = AppSchemaUtil.isCheckRelation(smitem);
        } else {
            Relation smitem_name_mitem_relation;
            isCheckRelation = false;
            if (("storeref".equals(smitem.getType()) || "masterref".equals(smitem.getType())) && (smitem_name_mitem_relation = AppSchemaUtil.getRelationTypeExceptRef(smitem)) != null && "check".equals(smitem_name_mitem_relation.getType())) {
                isCheckRelation = true;
            }
        }
        if (isCheckRelation || smitem.getMultiple()) {
            String innerjoinalias = AppSchemaUtil.getHibernatePropertyName(smitem_refmodel, smitem, indexOfCompositeKey);
            innerjoinalias = ExpressionGenerator_Hibernate.findHqlAliasName(innerjoinalias, smodel, fromdatalist);
            SubQueryFromData innerjoindata = SubQueryInnerJoinDataImpl.createForClassname(null, innerjoinalias);
            fromdatalist.add(innerjoindata);
            return innerjoinalias;
        }
        String id_alias = fromdatalist.get(fromdatalist.size() - 1).getAlias();
        StringBuilder columnname = new StringBuilder();
        columnname.append(id_alias);
        columnname.append(".");
        columnname.append(AppSchemaUtil.getHibernatePropertyName(name, smodel, smitem, null, indexOfCompositeKey, project));
        return columnname.toString();
    }

    private static String getProperColumnName0(String name, Model smodel, int indexOfCompositeKey, Project project) {
        Modelitem smitem = ExpressionGenerator_Hibernate.getModelitemConsideringCompositeKey(name, smodel, project);
        if (smitem == null) {
            Object[] o = new Object[]{smodel.getId(), name};
            ResourceManager _rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
            logger.error(_rman.getValue("modelitem.notfound", o));
            throw new IllegalArgumentException(name);
        }
        boolean isMultipleFlag = ExpressionGenerator_Hibernate.isMultipleFlag(smitem);
        boolean isCheckRelation = AppSchemaUtil.isCheckRelation(smitem);
        StringBuilder columnname = new StringBuilder();
        if (isMultipleFlag || isCheckRelation) {
            columnname.append(AppSchemaUtil.getHibernatePropertyName(name, smodel, smitem, null, indexOfCompositeKey, project));
        } else if (AppSchemaUtil.hasChildPart(name)) {
            String pname = AppSchemaUtil.getParentPart(name);
            String pname_alias = AppSchemaUtil.createHqlAliasName(pname);
            columnname.append(pname_alias);
            columnname.append(".");
            columnname.append(AppSchemaUtil.getHibernatePropertyName(name, smodel, smitem, null, indexOfCompositeKey, project));
        } else {
            String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
            columnname.append(id_alias);
            columnname.append(".");
            columnname.append(AppSchemaUtil.getHibernatePropertyName(name, smodel, smitem, null, indexOfCompositeKey, project));
        }
        return columnname.toString();
    }

    @Override
    public void gCreateExpressionMethod_init(StringBuilder sb) {
        String expressionMethodname = "createExpression";
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param")};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.hibernate"), param, this.rman.getValue("pbean.comment.createexpression.hibernate.ret")));
        sb.append("    ");
        sb.append("protected String ");
        sb.append(expressionMethodname);
        sb.append("(Map map");
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            sb.append(", String db_key, Object map_value");
        }
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder sb = new StringBuilder();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.hibernate.begin"));
        sb.append(CR);
        sb.append(CR);
    }

    public void setExpressionHeaderType(int type) {
        this.expressionHeaderType = type;
    }

    public int getExpressionHeaderType() {
        return this.expressionHeaderType;
    }

    public void setExpressionHeader(String expressionHeader) {
        this.expressionHeader = expressionHeader;
    }

    public String getExpressionHeader() {
        return this.expressionHeader;
    }

    @Override
    protected void gOutputExpressionHeaderMethod(StringBuilder sb) {
        sb.append("    ");
        sb.append("protected void outputExpressionHeader(StringBuilder sb");
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            sb.append(", String db_key, Object map_value");
        }
        sb.append(") {");
        sb.append(CR);
        this.gExpressionHeader(sb, this.expressionHeaderType);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gExpressionHeader(StringBuilder sb, int expressionHeaderType) {
        int i;
        Model smodel = this.getStoreModel();
        String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        String classname = AppSchemaUtil.getClassname(smodel);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(smodel);
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            for (i = 0; i < pkeys.length; ++i) {
                String columnname = this.getProperColumnName(pkeys[i].getName());
                sb.append("        ");
                sb.append("final String db_pkey" + (i + 1) + " = \"");
                sb.append(StringUtil.convertJavaString((String)columnname));
                sb.append("\";");
                sb.append(CR);
            }
        }
        sb.append("        ");
        sb.append("sb.append(\"");
        if (expressionHeaderType == 2) {
            sb.append("select count(*)");
            sb.append(" from ");
            sb.append(classname);
            sb.append(" as ");
            sb.append(id_alias);
        } else if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            sb.append("select \"+");
            for (i = 0; i < pkeys.length; ++i) {
                sb.append("db_pkey" + (i + 1));
                sb.append("+\", \"+");
            }
            sb.append("db_key+\"");
            sb.append(" from ");
            sb.append(classname);
            sb.append(" as ");
            sb.append(id_alias);
        } else if (expressionHeaderType == 3) {
            if (this.getExpressionHeader() == null) {
                logger.error("[Internal Error] needs expressionHeader to generate Aggregate ProcessBean");
            }
            sb.append(this.getExpressionHeader());
        } else {
            if (expressionHeaderType != 1) {
                logger.warn("unknown expressionHeaderType " + expressionHeaderType + ". use ShowList");
            }
            sb.append("select ");
            sb.append(id_alias);
            sb.append(" from ");
            sb.append(classname);
            sb.append(" as ");
            sb.append(id_alias);
        }
        sb.append(" \");");
        sb.append(CR);
    }

    @Override
    protected String callOutputExpressionHeaderMethod() {
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            return "outputExpressionHeader(sb, db_key, map_value);";
        }
        return super.callOutputExpressionHeaderMethod();
    }

    @Override
    public void gOutputConditionMethod_init(StringBuilder sb) {
        String expressionMethodname = "outputCondition";
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param")};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.hibernate"), param, this.rman.getValue("pbean.comment.createexpression.hibernate.ret")));
        sb.append("    ");
        sb.append("protected void ");
        sb.append(expressionMethodname);
        sb.append("(StringBuilder sb, Map map");
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            sb.append(", String db_key, Object map_value");
        }
        sb.append(") {");
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.hibernate.begin"));
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression = true;");
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    protected void gOutputConditionMethod_main(StringBuilder sb) {
        if (this.getExpressionHeaderType() != 4 && this.getExpressionHeaderType() != 5) {
            super.gOutputConditionMethod_main(sb);
            return;
        }
        sb.append("        ");
        sb.append(this.callOutputWhereMainMethod("outputWhereMain", "sb", true));
        sb.append(CR);
        sb.append("        ");
        sb.append("{");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("            ", "AND", 0));
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        sb.append("sb.append(db_key);");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        sb.append("sb.append(\" IS NOT NULL \");");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (map_value != null) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("            ", "AND", 0));
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        sb.append("sb.append(db_key);");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        if (this.getExpressionHeaderType() == 4) {
            sb.append("sb.append(\" > ? \");");
        } else {
            sb.append("sb.append(\" < ? \");");
        }
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append(this.callOutputWhereEndMethod());
        sb.append(CR);
        sb.append("        ");
        sb.append("sb.append(\" ORDER BY \");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("        "));
        sb.append("        ");
        sb.append("sb.append(db_key);");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("        "));
        sb.append("        ");
        if (this.getExpressionHeaderType() == 4) {
            sb.append("sb.append(\" DESC \");");
        } else {
            sb.append("sb.append(\" \");");
        }
        sb.append(CR);
    }

    @Override
    public void gOutputWhereMainMethod_init(StringBuilder sb, String expressionMethodname) {
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param")};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.hibernate"), param, this.rman.getValue("pbean.comment.createexpression.hibernate.ret")));
        sb.append("    ");
        sb.append("protected boolean ");
        sb.append(expressionMethodname);
        sb.append("(");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isfirstexpression, StringBuilder sb, Map map)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.hibernate.begin"));
        sb.append(CR);
        sb.append(CR);
        sb.append(this.gPrepareNoselectionSet("        "));
        sb.append(CR);
    }

    @Override
    protected String gAddCondition_child(Condition condition, String basetab, String name, String keyname, String prefix, String type, String cond, boolean isMultipleFlag, boolean isStoreref, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        if (prefix == null) {
            prefix = "";
        }
        String cname = AppSchemaUtil.hasChildPart(name) ? AppSchemaUtil.getChildPart(name) : name;
        return this.gAddCondition_item(condition, basetab, name, keyname, prefix, type, cond, cname + prefix, isStoreref, conditiongroup_nestlevel, indexOfCompositeKey);
    }

    @Override
    protected String gAddCondition_master(Condition condition, String name, String cond, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        String basetab = "";
        sb.append(basetab + "        ");
        sb.append("Integer _" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append(basetab + "            ");
        }
        sb.append("(Integer)map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (_" + cname + " != null) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression(basetab + "            ", condition.getOperator(), conditiongroup_nestlevel));
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null) {
            sb.append("            " + basetab);
            sb.append("if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append("                " + basetab);
            sb.append("sb.append(\"( \");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
        }
        if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryBegin(condition, basetab + "            ", name, null, "int", condition.getCond(), false, 0));
        }
        sb.append(this.outputQuoteIdInWhere(basetab + "            "));
        sb.append(basetab + "            ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab + "            "));
        sb.append(basetab + "            ");
        sb.append("sb.append(\" ");
        sb.append(StringUtil.convertJavaString((String)cond));
        sb.append(" \");");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("sb.append(_" + cname + ".intValue());");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryEnd(condition, basetab + "            ", name, null, "int", condition.getCond(), false));
        }
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null) {
            sb.append("            " + basetab);
            sb.append("if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("                " + basetab, "OR", 0));
            if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, basetab + "                ", name, null, "int", condition.getCond(), false, 0));
            }
            sb.append(this.outputQuoteIdInWhere(basetab + "                "));
            sb.append(basetab + "                ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere(basetab + "                "));
            sb.append(basetab + "                ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, basetab + "                ", name, null, "int", condition.getCond(), false));
            }
            sb.append("                " + basetab);
            sb.append("sb.append(\") \");");
            sb.append(CR);
            sb.append("            " + basetab);
            sb.append("}");
            sb.append(CR);
            sb.append("        " + basetab);
            sb.append("} else if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression(basetab + "            ", condition.getOperator(), conditiongroup_nestlevel));
            if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, basetab + "            ", name, null, "int", condition.getCond(), false, 0));
            }
            sb.append(this.outputQuoteIdInWhere(basetab + "            "));
            sb.append(basetab + "            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere(basetab + "            "));
            sb.append(basetab + "            ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isChildFlag || isCheckboxFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, basetab + "            ", name, null, "int", condition.getCond(), false));
            }
        }
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_master_check(Condition condition, String name, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        sb.append("        ");
        sb.append("int[] _" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append("            ");
        }
        sb.append("(int[])map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + cname + " != null && ");
        sb.append("_" + cname + ".length > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("int count = 0;");
        sb.append(CR);
        sb.append("            ");
        sb.append("for (int i=0; i< ");
        sb.append("_" + cname + ".length; i++) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("int __" + cname + " = ");
        if (isChildFlag) {
            sb.append(CR);
            sb.append("                    ");
        }
        sb.append("_" + cname + "[i];");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (count == 0) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "AND", conditiongroup_nestlevel));
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryBegin(condition, "                    ", name, null, "int", condition.getCond(), false, 0));
        } else {
            sb.append("                    ");
            sb.append("sb.append(\"( \");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "OR", conditiongroup_nestlevel));
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\" = \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(__" + cname + ");");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("count++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null && !isCheckboxFlag) {
            sb.append("            ");
            sb.append("if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("                ", "OR", conditiongroup_nestlevel));
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("                ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("                ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("if (count > 0) {");
        sb.append(CR);
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryEnd(condition, "                ", name, null, "int", condition.getCond(), false));
        } else {
            sb.append("                ");
            sb.append("sb.append(\") \");");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null && !isCheckboxFlag) {
            sb.append("        ");
            sb.append("} else if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", "AND", conditiongroup_nestlevel));
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, "            ", name, null, "int", condition.getCond(), false, 0));
            }
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, "                ", name, null, "int", condition.getCond(), false));
            }
        }
        if (isEmptycaseZero) {
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.gEmptycaseZero("            ", columnname));
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_storeref_check(Condition condition, String name, String type, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        boolean isQuote = true;
        if (JavaSourceGenerator.isBasicType(type = JavaSourceGenerator.getProperType(type))) {
            isQuote = false;
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        sb.append("        ");
        sb.append(type);
        sb.append("[] _" + cname + " = (");
        sb.append(type);
        sb.append("[])map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + cname + " != null && ");
        sb.append("_" + cname + ".length > 0) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("int count = 0;");
        sb.append(CR);
        sb.append("            ");
        sb.append("for (int i=0; i< ");
        sb.append("_" + cname + ".length; i++) {");
        sb.append(CR);
        sb.append("                ");
        sb.append(type + " __" + cname + " = _" + cname + "[i];");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (count == 0) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "AND", conditiongroup_nestlevel));
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryBegin(condition, "                    ", name, null, type, condition.getCond(), false, indexOfCompositeKey));
        } else {
            sb.append("                    ");
            sb.append("sb.append(\"( \");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "OR", conditiongroup_nestlevel));
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("                "));
        sb.append("                ");
        sb.append("sb.append(\" = \");");
        sb.append(CR);
        if (isQuote) {
            sb.append("                ");
            sb.append("sb.append(\"'\");");
            sb.append(CR);
        }
        sb.append("                ");
        if (type.equals("String")) {
            sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
            sb.append("__" + cname);
            sb.append("));");
        } else {
            sb.append("sb.append(");
            sb.append("__" + cname);
            sb.append(");");
        }
        sb.append(CR);
        if (isQuote) {
            sb.append("                ");
            sb.append("sb.append(\"'\");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("count++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null && !isCheckboxFlag) {
            sb.append("            ");
            sb.append("if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("                ", "OR", conditiongroup_nestlevel));
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("                ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("                ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("if (count > 0) {");
        sb.append(CR);
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryEnd(condition, "                ", name, null, type, condition.getCond(), false));
        } else {
            sb.append("                ");
            sb.append("sb.append(\") \");");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null && !isCheckboxFlag) {
            sb.append("        ");
            sb.append("} else if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", "AND", conditiongroup_nestlevel));
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, "            ", name, null, type, condition.getCond(), false, indexOfCompositeKey));
            }
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, "            ", name, null, type, condition.getCond(), false));
            }
        }
        if (isEmptycaseZero) {
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.gEmptycaseZero("            ", columnname));
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_storeref_check_single(Condition condition, String name, String type, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel, int indexOfCompositeKey) {
        String cname;
        boolean isChildFlag;
        StringBuilder sb = new StringBuilder();
        if (AppSchemaUtil.hasChildPart(name)) {
            isChildFlag = true;
            cname = AppSchemaUtil.getChildPart(name);
        } else {
            isChildFlag = false;
            cname = name;
        }
        String columnname = this.getProperColumnName(name, indexOfCompositeKey);
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isStoreThismodel = true;
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            isStoreThismodel = false;
        }
        boolean isQuote = true;
        if (JavaSourceGenerator.isBasicType(type = JavaSourceGenerator.getProperType(type))) {
            isQuote = false;
        }
        if (JavaSourceGenerator.isBasicType(type)) {
            type = JavaSourceGenerator.b2wc(type);
        }
        sb.append("        ");
        sb.append("// ");
        sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
        sb.append(CR);
        sb.append("        ");
        sb.append(type);
        sb.append(" _" + cname + " = (");
        sb.append(type);
        sb.append(")map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
        sb.append("\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_" + cname + " != null) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("            ", "AND", conditiongroup_nestlevel));
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryBegin(condition, "            ", name, null, type, condition.getCond(), false, indexOfCompositeKey));
        }
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere("            "));
        sb.append("            ");
        sb.append("sb.append(\" = \");");
        sb.append(CR);
        if (isQuote) {
            sb.append("            ");
            sb.append("sb.append(\"'\");");
            sb.append(CR);
        }
        sb.append("            ");
        if (type.equals("String")) {
            sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
            sb.append("_" + cname);
            sb.append("));");
        } else {
            sb.append("sb.append(");
            sb.append("_" + cname);
            sb.append(");");
        }
        sb.append(CR);
        if (isQuote) {
            sb.append("            ");
            sb.append("sb.append(\"'\");");
            sb.append(CR);
        }
        sb.append("            ");
        sb.append("sb.append(\" \");");
        sb.append(CR);
        if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
            sb.append(this.gSubQueryEnd(condition, "            ", name, null, type, condition.getCond(), false));
        }
        if (AppSchemaUtil.getNoselection(item, this.cmodel, this.project) != null && !isCheckboxFlag) {
            sb.append("        ");
            sb.append("} else if (_noselectionSet.contains(\"" + cname + "\")) {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", "AND", conditiongroup_nestlevel));
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryBegin(condition, "            ", name, null, type, condition.getCond(), false, indexOfCompositeKey));
            }
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\"");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("            "));
            sb.append("            ");
            sb.append("sb.append(\" IS NULL \");");
            sb.append(CR);
            if (isCheckboxFlag || isChildFlag || !isStoreThismodel) {
                sb.append(this.gSubQueryEnd(condition, "            ", name, null, type, condition.getCond(), false));
            }
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_storeref_check_compositeKey(Condition condition, String name_o, PrimaryKey[] pkeys, String[] types, boolean isEmptycaseZero, boolean isCheckboxFlag, Modelitem item, int conditiongroup_nestlevel) {
        String cname;
        String name;
        String type;
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pkeys.length; ++i) {
            type = pkeys[i].getType();
            type = JavaSourceGenerator.getProperType(type);
            name = name_o + "_" + pkeys[i].getName();
            cname = AppSchemaUtil.hasChildPart(name) ? AppSchemaUtil.getChildPart(name) : name;
            if (i == 0) {
                sb.append("        ");
                sb.append("// ");
                sb.append(this.rman.getValue("pbean.comment.addcondition.master", cname));
                sb.append(CR);
            }
            sb.append("        ");
            sb.append(type);
            sb.append("[] _" + cname + " = (");
            sb.append(type);
            sb.append("[])map.get(\"");
            sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, cname)));
            sb.append("\");");
            sb.append(CR);
        }
        for (i = 0; i < pkeys.length; ++i) {
            type = pkeys[i].getType();
            type = JavaSourceGenerator.getProperType(type);
            name = name_o + "_" + pkeys[i].getName();
            cname = AppSchemaUtil.hasChildPart(name) ? AppSchemaUtil.getChildPart(name) : name;
            if (i == 0) {
                sb.append("        ");
                sb.append("if (_" + cname + " != null && ");
                sb.append("_" + cname + ".length > 0) {");
                sb.append(CR);
                sb.append("            ");
                sb.append("int count = 0;");
                sb.append(CR);
                sb.append("            ");
                sb.append("for (int i=0; i< ");
                sb.append("_" + cname + ".length; i++) {");
                sb.append(CR);
            }
            sb.append("                ");
            sb.append(type + " __" + cname + " = _" + cname + "[i];");
            sb.append(CR);
        }
        Model smodel = this.getStoreModel();
        PrimaryKey[] s_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        PrimaryKey pkey = s_pkeys[0];
        String mclassname = AppSchemaUtil.getClassname(smodel);
        String mid_alias = AppSchemaUtil.createHqlAliasName(mclassname);
        String classname = AppSchemaUtil.getModelitemClassname(item);
        String id_alias = AppSchemaUtil.createHqlAliasName(classname);
        sb.append("                ");
        sb.append("if (count == 0) {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "AND", conditiongroup_nestlevel));
        String pkey1 = mid_alias + "." + AppSchemaUtil.getHibernatePropertyName(smodel, pkey);
        String pkey2 = id_alias + "." + AppSchemaUtil.getHibernatePropertyName(smodel, pkey);
        String fromcode = AppSchemaUtil.getPackagename(smodel, this.project) + AppSchemaUtil.getModelitemClassname(item) + ".class.getName()";
        String fromalias = id_alias;
        SubQueryFromData fromdata = SubQueryFromDataImpl.createForCode(fromcode, fromalias);
        String sid_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        ArrayList<String> wherelist = new ArrayList<String>();
        this.generateSubQueryWhere_thismodel("                    ", smodel, sid_alias, fromalias, wherelist);
        List<SubQueryFromData> fromdatalist = Collections.nCopies(1, fromdata);
        this.outputSubqueryHeaderCode(sb, "                    ", pkey1, pkey2, fromdatalist, wherelist);
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(this.setIsfirstexpression("                    ", "OR", conditiongroup_nestlevel));
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        for (int i2 = 0; i2 < pkeys.length; ++i2) {
            String type2 = pkeys[i2].getType();
            type2 = JavaSourceGenerator.getProperType(type2);
            String name2 = name_o + "_" + pkeys[i2].getName();
            String cname2 = AppSchemaUtil.hasChildPart(name2) ? AppSchemaUtil.getChildPart(name2) : name2;
            String columnname = AppSchemaUtil.getHibernatePropertyName(pkeys[i2].getName());
            boolean isQuote = true;
            if (JavaSourceGenerator.isBasicType(type2)) {
                isQuote = false;
            }
            if (i2 == 0) {
                sb.append("                ");
                sb.append("sb.append(\" (\");");
                sb.append(CR);
            } else {
                sb.append("                ");
                sb.append("sb.append(\" AND \");");
                sb.append(CR);
            }
            sb.append("                ");
            sb.append("sb.append(\"");
            sb.append(id_alias);
            sb.append(".");
            sb.append(StringUtil.convertJavaString((String)columnname));
            sb.append("\");");
            sb.append(CR);
            sb.append(this.outputQuoteIdInWhere("                "));
            sb.append("                ");
            sb.append("sb.append(\" = \");");
            sb.append(CR);
            if (isQuote) {
                sb.append("                ");
                sb.append("sb.append(\"'\");");
                sb.append(CR);
            }
            sb.append("                ");
            if (type2.equals("String")) {
                sb.append("sb.append(SQLUtilities.replaceSpecialChar(");
                sb.append("__" + cname2);
                sb.append("));");
            } else {
                sb.append("sb.append(");
                sb.append("__" + cname2);
                sb.append(");");
            }
            sb.append(CR);
            if (!isQuote) continue;
            sb.append("                ");
            sb.append("sb.append(\"'\");");
            sb.append(CR);
        }
        sb.append("                ");
        sb.append("sb.append(\") \");");
        sb.append(CR);
        sb.append("                ");
        sb.append("count++;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (count > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("sb.append(\")) \");");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        if (isEmptycaseZero) {
            String columnname = this.getProperColumnName(name_o, 0);
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(this.setIsfirstexpression("            ", condition.getOperator(), conditiongroup_nestlevel));
            sb.append(this.gEmptycaseZero("            ", columnname));
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gSubQueryBegin(Condition condition, String basetab, String name, String prefix, String type, String cond, boolean isMultipleFlag, int indexOfCompositeKey) {
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            return this.gSubQueryBegin_refmodel(basetab, name, indexOfCompositeKey);
        }
        return this.gSubQueryBegin_thismodel(basetab, name, indexOfCompositeKey);
    }

    protected String gSubQueryBegin_refmodel(String basetab, String name, int indexOfCompositeKey) {
        String pkey2;
        Model smodel = this.getStoreModel();
        String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        Modelitem smitem = ExpressionGenerator_Hibernate.getModelitemConsideringCompositeKey(name, smodel, this.project);
        StringBuilder sb = new StringBuilder();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        PrimaryKey fpkey = pkeys[0];
        String pkeyPropertyName = AppSchemaUtil.getHibernatePropertyName(smodel, fpkey);
        String pkey1 = id_alias + "." + pkeyPropertyName;
        ArrayList<SubQueryFromData> fromdatalist = new ArrayList<SubQueryFromData>();
        ArrayList<String> wherelist = new ArrayList<String>();
        if (AppSchemaUtil.hasChildPart(name)) {
            String pname = AppSchemaUtil.getParentPart(name);
            String pname_alias = AppSchemaUtil.createHqlAliasName(pname);
            Modelitem parent_mitem = AppSchemaUtil.getModelitem(pname, smodel);
            String parent_mitem_packagename = AppSchemaUtil.getPackagename(smodel, this.project);
            String contfromcode = parent_mitem_packagename + AppSchemaUtil.getModelitemClassname(parent_mitem) + ".class.getName()";
            String contfromalias = pname_alias;
            pkey2 = contfromalias + "." + pkeyPropertyName;
            SubQueryFromData contfromdata = SubQueryFromDataImpl.createForCode(contfromcode, contfromalias);
            fromdatalist.add(contfromdata);
            this.generateSubQueryWhere_thismodel(basetab, smodel, id_alias, contfromalias, wherelist);
            String pkey3 = this.generateSubQuery_refmodel(basetab, indexOfCompositeKey, smodel, smitem, contfromalias, fromdatalist, wherelist);
            if (pkey3 == null) {
                return "";
            }
        } else {
            pkey2 = this.generateSubQuery_refmodel(basetab, indexOfCompositeKey, smodel, smitem, id_alias, fromdatalist, wherelist);
            if (pkey2 == null) {
                return "";
            }
        }
        this.outputSubqueryHeaderCode(sb, basetab, pkey1, pkey2, fromdatalist, wherelist);
        return sb.toString();
    }

    private String generateSubQuery_refmodel(String basetab, int indexOfCompositeKey, Model smodel, Modelitem smitem, String id_alias, List<SubQueryFromData> fromdatalist, List<String> wherelist) {
        String pkey3;
        boolean isCheckRelation;
        Modelitem[] smitem_relateditem_roleid_mitems;
        Model smitem_refmodel;
        Relation smitem_relation = AppSchemaUtil.getRelationTypeIsRef(smitem);
        String smitem_relation_idref = smitem_relation.getIdref();
        String smitem_relation_relateditem = smitem_relation.getRelateditem();
        String smitem_relation_name = smitem_relation.getName();
        Modelitem smitem_relateditem_mitem = AppSchemaUtil.getModelitem(smitem_relation_relateditem, smodel);
        if (smitem_relateditem_mitem == null) {
            Object[] o = new Object[]{smodel.getId(), smitem.getName(), smitem_relation_idref, smitem_relation_relateditem};
            logger.error(this.rman.getValue("value.relateditem.relation.null", o) + " (1)");
            return null;
        }
        Relation smitem_relateditem_mitem_relation = AppSchemaUtil.getRelationTypeExceptRef(smitem_relateditem_mitem);
        boolean isUseRefstoreModel = false;
        if (smitem_relateditem_mitem_relation != null) {
            smitem_refmodel = (Model)smitem_relation.getIdrefAsIRNode();
            String roleid = AppSchemaUtil.getRoleid(smitem_relateditem_mitem_relation, this.project);
            if (AppSchemaUtil.isCompositePrimaryKey(roleid)) {
                String[] tokens = AppSchemaUtil.decompositePrimaryKey(roleid);
                smitem_relateditem_roleid_mitems = new Modelitem[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    smitem_relateditem_roleid_mitems[i] = AppSchemaUtil.getModelitem(tokens[i], smitem_refmodel);
                }
            } else {
                smitem_relateditem_roleid_mitems = new Modelitem[]{AppSchemaUtil.getModelitem(roleid, smitem_refmodel)};
            }
        } else {
            ForeignKey fkey = AppSchemaUtil.getForeignKey(smitem_relateditem_mitem.getName(), smodel);
            if (fkey != null) {
                smitem_refmodel = (Model)fkey.getIdrefAsIRNode();
                PrimaryKey[] refmodel_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smitem_refmodel, this.project);
                if (refmodel_pkeys != null && refmodel_pkeys.length > 1) {
                    smitem_relateditem_roleid_mitems = new Modelitem[refmodel_pkeys.length];
                    for (int i = 0; i < refmodel_pkeys.length; ++i) {
                        smitem_relateditem_roleid_mitems[i] = AppSchemaUtil.getModelitem(StringUtils.isNotBlank((CharSequence)refmodel_pkeys[i].getRefname()) ? refmodel_pkeys[i].getRefname() : refmodel_pkeys[i].getName(), smitem_refmodel);
                        if (smitem_relateditem_roleid_mitems[i] != null) continue;
                        logger.error("complex key error, smitem_refmodel=" + smitem_refmodel.getId() + " " + Arrays.asList(refmodel_pkeys));
                        return null;
                    }
                    isUseRefstoreModel = true;
                } else {
                    String targetitemname = AppSchemaUtil.getForeignKeyTargetItemName(smitem_relateditem_mitem.getName(), fkey);
                    smitem_relateditem_roleid_mitems = new Modelitem[]{AppSchemaUtil.getModelitem(targetitemname, smitem_refmodel)};
                }
            } else {
                Object[] o = new Object[]{this.id, smitem.getName(), smitem_relation_idref, smitem_relation_relateditem};
                logger.error(this.rman.getValue("value.relateditem.relation.null", o) + " (2)");
                return null;
            }
        }
        String smitem_refmodel_classname = AppSchemaUtil.getClassname(smitem_refmodel);
        Modelitem smitem_name_mitem = AppSchemaUtil.getModelitem(smitem_relation_name, smitem_refmodel);
        if (smitem_name_mitem == null && (smitem_name_mitem = AppSchemaUtil.getModelitem(smitem_relation_name, smitem_refmodel = (Model)smitem_relation.getIdrefAsIRNode())) == null) {
            logger.error("[Internal Error] smitem_relation_name=" + smitem_relation_name + ", smitem_refmodel=" + smitem_refmodel.getId());
            return null;
        }
        String refmodel_id_alias = AppSchemaUtil.createHqlAliasName(smitem_refmodel.getId());
        refmodel_id_alias = this.findHqlAliasName(refmodel_id_alias, fromdatalist);
        SubQueryFromData fromdata = SubQueryFromDataImpl.createForClassname(smitem_refmodel_classname, refmodel_id_alias);
        fromdatalist.add(fromdata);
        boolean isThisModel = AppSchemaUtil.isStoreThismodel(smitem);
        if (isThisModel) {
            isCheckRelation = AppSchemaUtil.isCheckRelation(smitem_name_mitem);
        } else {
            Relation smitem_name_mitem_relation;
            isCheckRelation = false;
            if (("storeref".equals(smitem_name_mitem.getType()) || "masterref".equals(smitem_name_mitem.getType())) && (smitem_name_mitem_relation = AppSchemaUtil.getRelationTypeExceptRef(smitem_name_mitem)) != null && "check".equals(smitem_name_mitem_relation.getType())) {
                isCheckRelation = true;
            }
        }
        if (isCheckRelation || smitem_name_mitem.getMultiple()) {
            String innerjoinclassname = refmodel_id_alias + "." + AppSchemaUtil.getHibernatePropertyName(smitem_refmodel, smitem_name_mitem, indexOfCompositeKey);
            String innerjoinalias = AppSchemaUtil.getHibernatePropertyName(smitem_refmodel, smitem_name_mitem, indexOfCompositeKey);
            innerjoinalias = this.findHqlAliasName(innerjoinalias, fromdatalist);
            SubQueryFromData innerjoindata = SubQueryInnerJoinDataImpl.createForClassname(innerjoinclassname, innerjoinalias);
            fromdatalist.add(innerjoindata);
        }
        StringBuilder wheresb = new StringBuilder();
        for (int i = 0; i < smitem_relateditem_roleid_mitems.length; ++i) {
            if (i > 0) {
                wheresb.append(basetab);
                wheresb.append("sb.append(\" AND \");");
                wheresb.append(CR);
            }
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\"");
            wheresb.append(id_alias);
            wheresb.append(".");
            if (isUseRefstoreModel && i > 0) {
                wheresb.append(AppSchemaUtil.getHibernatePropertyName(smodel, smitem_relateditem_roleid_mitems[i], i));
            } else {
                wheresb.append(AppSchemaUtil.getHibernatePropertyName(smodel, smitem_relateditem_mitem, i));
            }
            wheresb.append("\");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\" = \");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\"");
            wheresb.append(refmodel_id_alias);
            wheresb.append(".");
            wheresb.append(AppSchemaUtil.getHibernatePropertyName(smitem_refmodel, smitem_relateditem_roleid_mitems[i], i));
            wheresb.append("\");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
        }
        wherelist.add(wheresb.toString());
        if (!isThisModel && AppSchemaUtil.getRelationTypeIsRef(smitem_name_mitem) != null && (pkey3 = this.generateSubQuery_refmodel(basetab, indexOfCompositeKey, smitem_refmodel, smitem_name_mitem, refmodel_id_alias, fromdatalist, wherelist)) == null) {
            return null;
        }
        String pkeyPropertyName1 = AppSchemaUtil.getHibernatePropertyName(smitem_refmodel, smitem_relateditem_roleid_mitems[0], indexOfCompositeKey);
        String pkey2 = refmodel_id_alias + "." + pkeyPropertyName1;
        return pkey2;
    }

    private String findHqlAliasName(String alias, List<SubQueryFromData> fromdatalist) {
        Model smodel = this.getStoreModel();
        return ExpressionGenerator_Hibernate.findHqlAliasName(alias, smodel, fromdatalist);
    }

    private static String findHqlAliasName(String alias, Model smodel, List<SubQueryFromData> fromdatalist) {
        String smodel_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        String newalias = alias;
        int cnt = 1;
        block0: while (true) {
            if (smodel_alias.equals(newalias)) {
                newalias = alias + "_" + cnt;
                ++cnt;
                continue;
            }
            for (SubQueryFromData fromdata : fromdatalist) {
                if (!fromdata.getAlias().equals(newalias)) continue;
                newalias = alias + "_" + cnt;
                ++cnt;
                continue block0;
            }
            break;
        }
        return newalias;
    }

    protected String gSubQueryBegin_thismodel(String basetab, String name, int indexOfCompositeKey) {
        String pkey2;
        String fromalias;
        Model smodel = this.getStoreModel();
        String id_alias = AppSchemaUtil.createHqlAliasName(smodel.getId());
        String classname = AppSchemaUtil.getClassname(smodel);
        Modelitem smitem = ExpressionGenerator_Hibernate.getModelitemConsideringCompositeKey(name, smodel, this.project);
        StringBuilder sb = new StringBuilder();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        PrimaryKey fpkey = pkeys[0];
        String pkeyPropertyName = AppSchemaUtil.getHibernatePropertyName(smodel, fpkey);
        String pkey1 = id_alias + "." + pkeyPropertyName;
        ArrayList<SubQueryFromData> fromdatalist = new ArrayList<SubQueryFromData>();
        if (AppSchemaUtil.hasChildPart(name)) {
            String pname = AppSchemaUtil.getParentPart(name);
            String pname_alias = AppSchemaUtil.createHqlAliasName(pname);
            Modelitem parent_mitem = AppSchemaUtil.getModelitem(pname, smodel);
            String parent_mitem_packagename = AppSchemaUtil.getPackagename(smodel, this.project);
            String fromcode = parent_mitem_packagename + AppSchemaUtil.getModelitemClassname(parent_mitem) + ".class.getName()";
            fromalias = pname_alias;
            pkey2 = fromalias + "." + pkeyPropertyName;
            SubQueryFromData fromdata = SubQueryFromDataImpl.createForCode(fromcode, fromalias);
            fromdatalist.add(fromdata);
        } else {
            String fromclassname = classname;
            fromalias = id_alias + "2";
            pkey2 = fromalias + "." + pkeyPropertyName;
            SubQueryFromData fromdata = SubQueryFromDataImpl.createForClassname(fromclassname, fromalias);
            fromdatalist.add(fromdata);
        }
        boolean isCheckRelation = AppSchemaUtil.isCheckRelation(smitem);
        if (isCheckRelation || smitem.getMultiple()) {
            String innerjoinclassname = fromalias + "." + AppSchemaUtil.getHibernatePropertyName(smodel, smitem, indexOfCompositeKey);
            String innerjoinalias = AppSchemaUtil.getHibernatePropertyName(smodel, smitem, indexOfCompositeKey);
            SubQueryFromData innerjoindata = SubQueryInnerJoinDataImpl.createForClassname(innerjoinclassname, innerjoinalias);
            fromdatalist.add(innerjoindata);
        }
        ArrayList<String> wherelist = new ArrayList<String>();
        this.generateSubQueryWhere_thismodel(basetab, smodel, id_alias, fromalias, wherelist);
        this.outputSubqueryHeaderCode(sb, basetab, pkey1, pkey2, fromdatalist, wherelist);
        return sb.toString();
    }

    private void generateSubQueryWhere_thismodel(String basetab, Model smodel, String id_alias, String fromalias, List<String> wherelist) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            StringBuilder wheresb = new StringBuilder();
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\"");
            wheresb.append(id_alias);
            wheresb.append(".");
            wheresb.append(AppSchemaUtil.getHibernatePropertyName(smodel, pkey));
            wheresb.append("\");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\" = \");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wheresb.append(basetab);
            wheresb.append("sb.append(\"");
            wheresb.append(fromalias);
            wheresb.append(".");
            wheresb.append(AppSchemaUtil.getHibernatePropertyName(smodel, pkey));
            wheresb.append("\");");
            wheresb.append(CR);
            wheresb.append(this.outputQuoteIdInWhere(basetab));
            wherelist.add(wheresb.toString());
        }
    }

    @Override
    protected String gSubQueryEnd(Condition condition, String basetab, String name, String prefix, String type, String cond, boolean isMultipleFlag) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("sb.append(\")) \");");
        sb.append(CR);
        return sb.toString();
    }

    protected String gEmptycaseZero(String basetab, String columnname) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\" IS NULL AND \");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\"");
        sb.append(StringUtil.convertJavaString((String)columnname));
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\" IS NOT NULL \");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.sql.invalidvalue"));
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected boolean isOutputSortColumn(Sortkey key) {
        String name = key.getContent();
        if (AppSchemaUtil.hasChildPart(name)) {
            return false;
        }
        Model smodel = this.getStoreModel();
        Modelitem smitem = AppSchemaUtil.getModelitem(name, smodel);
        boolean isMultipleFlag = ExpressionGenerator_Hibernate.isMultipleFlag(smitem);
        if (isMultipleFlag) {
            return false;
        }
        boolean isCheckRelation = AppSchemaUtil.isCheckRelation(smitem);
        if (isCheckRelation) {
            return false;
        }
        if (smitem != null && !AppSchemaUtil.isStoreThismodel(smitem)) {
            return false;
        }
        return !AppSchemaUtil.hasChildPart(name);
    }

    @Override
    protected boolean isEnableQuote() {
        return false;
    }

    @Override
    protected String callOutputConditionMethod() {
        String expressionMethodname = "outputCondition";
        StringBuilder sb = new StringBuilder();
        sb.append(expressionMethodname);
        sb.append("(sb, map");
        if (this.getExpressionHeaderType() == 4 || this.getExpressionHeaderType() == 5) {
            sb.append(", db_key, map_value");
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String callOutputWhereMainMethod(String expressionMethodname, String expressionVariablename, boolean isMainMethod) {
        StringBuilder sb = new StringBuilder();
        if (isMainMethod) {
            sb.append("isfirstexpression = ");
            sb.append(expressionMethodname);
            sb.append("(isfirstexpression, ");
            sb.append(expressionVariablename);
            sb.append(", map);");
        } else {
            sb.append(expressionMethodname);
            sb.append("(true, ");
            sb.append(expressionVariablename);
            sb.append(", map);");
        }
        return sb.toString();
    }

    private void outputSubqueryHeaderCode(StringBuilder sb, String basetab, String pkey1, String pkey2, List<SubQueryFromData> fromdatalist, List<String> wherelist) {
        int i;
        if (this.subqueryHeaderType == DbTypeManager.SubqueryHeaderType.IN) {
            this.outputSubqueryHeaderCode_IN(sb, basetab, pkey1, pkey2);
        } else if (this.subqueryHeaderType == DbTypeManager.SubqueryHeaderType.EXISTS) {
            this.outputSubqueryHeaderCode_EXISTS(sb, basetab);
        } else assert (false) : "unknown subqueryHeaderType " + (Object)((Object)this.subqueryHeaderType);
        for (i = 0; i < fromdatalist.size(); ++i) {
            fromdatalist.get(i).generateCode(sb, basetab, i);
        }
        sb.append(basetab);
        sb.append("sb.append(\" where ( \");");
        sb.append(CR);
        if (wherelist == null || wherelist.size() == 0) {
            return;
        }
        for (i = 0; i < wherelist.size(); ++i) {
            sb.append(wherelist.get(i));
            if (i + 1 >= wherelist.size()) continue;
            sb.append(basetab);
            sb.append("sb.append(\" AND \");");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("sb.append(\") AND (\");");
        sb.append(CR);
    }

    private void outputSubqueryHeaderCode_IN(StringBuilder sb, String basetab, String pkey1, String pkey2) {
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\"");
        sb.append(pkey1);
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\" IN (select \");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\"");
        sb.append(pkey2);
        sb.append("\");");
        sb.append(CR);
        sb.append(this.outputQuoteIdInWhere(basetab));
        sb.append(basetab);
        sb.append("sb.append(\" from \");");
        sb.append(CR);
    }

    private void outputSubqueryHeaderCode_EXISTS(StringBuilder sb, String basetab) {
        sb.append(basetab);
        sb.append("sb.append(\" EXISTS (from \");");
        sb.append(CR);
    }

    @Override
    protected String gAddCondition_flowstatus_search(Condition condition, String name, boolean isCheckboxFlag, int conditiongroup_nestlevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ").append("// ").append(name).append(" workflow status search").append(CR);
        sb.append("        ").append("int[] ").append("_").append(name).append(" = null;").append(CR);
        sb.append("        ");
        if (isCheckboxFlag) {
            sb.append("_").append(name).append(" = (int[])");
        } else {
            sb.append("Integer __").append(name).append(" = (Integer)");
        }
        sb.append("map.get(\"");
        sb.append(StringUtil.convertJavaString((String)this.getParameterMapKey(condition, name)));
        sb.append("\");").append(CR);
        if (!isCheckboxFlag) {
            sb.append("        ").append("if (").append("__").append(name).append(" != null) {").append(CR);
            sb.append("            ").append("_").append(name).append(" = new int[1];").append(CR);
            sb.append("            ").append("_").append(name).append("[0] = ");
            sb.append("__").append(name).append(".intValue();").append(CR);
            sb.append("        ").append("}").append(CR);
        }
        sb.append("        ").append("if (_").append(name).append(" == null || ").append("_").append(name).append(".length == 0) {").append(CR);
        sb.append("            ").append("return isfirstexpression;").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append(this.setIsfirstexpression("        ", "AND", conditiongroup_nestlevel));
        sb.append("        ").append("StringBuilder wfstatusSearchCondition = new StringBuilder();").append(CR);
        sb.append("        ").append("wfstatusSearchCondition.append(getFlowstatusSearchCondition(_").append(name).append("[0]));").append(CR);
        sb.append("        ").append("for (int i=1; i< ").append("_").append(name).append(".length; i++) {").append(CR);
        sb.append("            ").append("wfstatusSearchCondition.append(\"OR\").append(getFlowstatusSearchCondition(_").append(name).append("[i]));").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("        ").append("if (_").append(name).append(".length > 1) {").append(CR);
        sb.append("            ").append("wfstatusSearchCondition.insert(0, \"(\");").append(CR);
        sb.append("            ").append("wfstatusSearchCondition.append(\")\");").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append("        ").append("sb.append(wfstatusSearchCondition.toString());").append(CR);
        return sb.toString();
    }

    @Override
    protected String gAddCondition_cosntraintparticipant(Condition condition, int conditiongroup_nestlevel) {
        Model smodel = this.getStoreModel();
        String pkey_name = AppSchemaUtil.createPrimaryKeyName(AppSchemaUtil.getPrimaryKey(smodel));
        StringBuilder sb = new StringBuilder();
        sb.append("        ").append("// ").append(" workflow constraint participant").append(CR);
        sb.append("        ").append("if (!isValidPermission(new JFCAppPermission(\"admin\", \"all\"))) {").append(CR);
        sb.append("            ").append("WorkFlowManager wman = WorkFlowManager.getInstance(p);").append(CR);
        sb.append("            ").append("String logonUserId = p.user.getUsername();").append(CR);
        sb.append("            ").append("String mandatorUserId = wman.getUserIdByProxy(\"");
        sb.append(smodel.getId());
        sb.append("\", logonUserId, (ActionParameter) p);").append(CR);
        sb.append("            ").append("String proxyUserId = wman.getProxyByUserId(\"");
        sb.append(smodel.getId());
        sb.append("\", logonUserId, (ActionParameter) p);").append(CR);
        sb.append("            ").append("StringBuilder participantGroupids = null;").append(CR);
        sb.append("            ").append("int[] groupids = p.user.getGroupId();").append(CR);
        sb.append("            ").append("if (groupids != null && groupids.length > 0) {").append(CR);
        sb.append("                ").append("participantGroupids = new StringBuilder();").append(CR);
        sb.append("                ").append("participantGroupids.append(groupids[0]);").append(CR);
        sb.append("                ").append("for (int i=1; i< groupids.length; i++) {").append(CR);
        sb.append("                    ").append("participantGroupids.append(\",\").append(groupids[i]);").append(CR);
        sb.append("                ").append("}").append(CR);
        sb.append("            ").append("}").append(CR).append(CR);
        sb.append(this.setIsfirstexpression("            ", "AND", conditiongroup_nestlevel));
        sb.append("            ").append("sb.append(\" ").append(this.getProperColumnName(pkey_name)).append(" IN \");").append(CR);
        sb.append("            ").append("sb.append(\"(select ");
        sb.append(this.getCastedPkey(smodel, pkey_name, "_jfcworkstate.modelpkey_", this.project));
        sb.append(" \");").append(CR);
        sb.append("            ").append("sb.append(\"   from Jfcworkstate as _jfcworkstate \");").append(CR);
        sb.append("            ").append("sb.append(\"  where _jfcworkstate.modelname_ = '");
        sb.append(smodel.getId());
        sb.append("' \");").append(CR);
        sb.append("            ").append("sb.append(\"    and _jfcworkstate.event_ = 'Start' \");").append(CR);
        sb.append("            ").append("sb.append(\"    and _jfcworkstate.flowid_ IN (select _participants.id_ \");").append(CR);
        sb.append("            ").append("sb.append(\" from ");
        sb.append(this.project.getPackage());
        sb.append(".model.jfcparticipant_setting.Participants as _participants \");").append(CR);
        sb.append("            ").append("sb.append(\" where \");").append(CR).append(CR);
        sb.append("            ").append("boolean isProxyDefined = false;").append(CR);
        sb.append("            ").append("if (!\"\".equals(proxyUserId)) {").append(CR);
        sb.append("                ").append("isProxyDefined = true;").append(CR);
        sb.append("            ").append("} else {").append(CR);
        sb.append("                ").append("sb.append(\" _participants.participantName_ = '\").append(logonUserId).append(\"' \");").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("            ").append("boolean isMandatorDefined = false;").append(CR);
        sb.append("            ").append("if (!logonUserId.equals(mandatorUserId)) {").append(CR);
        sb.append("                ").append("if (!isProxyDefined) {").append(CR);
        sb.append("                    ").append("sb.append(\" or \");").append(CR);
        sb.append("                ").append("}").append(CR);
        sb.append("                ").append("sb.append(\" _participants.participantName_ = '\").append(mandatorUserId).append(\"' \");").append(CR);
        sb.append("                ").append("isMandatorDefined = true;").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("            ").append("boolean isGroupDefined = false;").append(CR);
        sb.append("            ").append("if (participantGroupids != null) {").append(CR);
        sb.append("                ").append("if (!isProxyDefined || isMandatorDefined) {").append(CR);
        sb.append("                    ").append("sb.append(\" or \");").append(CR);
        sb.append("                ").append("}").append(CR);
        sb.append("                ").append("sb.append(\" _participants.participantGroupid_ IN  (\").append(participantGroupids.toString()).append(\")\");").append(CR);
        sb.append("                ").append("isGroupDefined = true;").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("            ").append("if (isProxyDefined && !isMandatorDefined && !isGroupDefined) {").append(CR);
        sb.append("                ").append("sb.append(\" 1 = 0 \");").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("            ").append("sb.append(\"))\");").append(CR);
        sb.append("        ").append("}").append(CR);
        return sb.toString();
    }

    protected String getCastedPkey(Model model, String modelPkeyName, String workstatePkeyName, Project project) {
        String pkeyType = AppSchemaUtil.getPkeyType(model, modelPkeyName, "string", project);
        if (!("byte".equals(pkeyType) || "short".equals(pkeyType) || "int".equals(pkeyType) || "long".equals(pkeyType) || "date".equals(pkeyType) || "time".equals(pkeyType) || "datetime".equals(pkeyType))) {
            return workstatePkeyName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("cast(").append(workstatePkeyName);
        if ("byte".equals(pkeyType) || "short".equals(pkeyType) || "int".equals(pkeyType)) {
            sb.append(" as int)");
        } else if ("long".equals(pkeyType)) {
            sb.append(" as long)");
        } else if ("date".equals(pkeyType)) {
            sb.append(" as date)");
        } else if ("time".equals(pkeyType)) {
            sb.append(" as time)");
        } else if ("dateTime".equals(pkeyType)) {
            sb.append(" as timestamp)");
        }
        return sb.toString();
    }

    @Override
    protected boolean isGenerateCreateCountExpression() {
        return this.expressionHeaderType == 1;
    }

    @Override
    public void gCreateCountExpressionMethod_init(StringBuilder sb) {
        String expressionMethodname = "createCountExpression";
        String[] param = new String[]{this.rman.getValue("pbean.comment.createexpression.param")};
        sb.append(CommentGenerator.gComment(this.rman.getValue("pbean.comment.createexpression.hibernate"), param, this.rman.getValue("pbean.comment.createexpression.hibernate.ret")));
        sb.append("    ");
        sb.append("protected String ");
        sb.append(expressionMethodname);
        sb.append("(Map map) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder sb = new StringBuilder();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("// " + this.rman.getValue("pbean.comment.createexpression.hibernate.begin"));
        sb.append(CR);
        sb.append(CR);
    }

    @Override
    protected void gOutputCountExpressionHeaderMethod(StringBuilder sb) {
        sb.append("    ");
        sb.append("protected void outputCountExpressionHeader(StringBuilder sb) {");
        sb.append(CR);
        this.gExpressionHeader(sb, 2);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private static class SubQueryInnerJoinDataImpl
    implements SubQueryFromData {
        private String classname;
        private String alias;

        static SubQueryFromData createForClassname(String classname, String alias) {
            SubQueryInnerJoinDataImpl data = new SubQueryInnerJoinDataImpl();
            data.classname = classname;
            data.alias = alias;
            return data;
        }

        private SubQueryInnerJoinDataImpl() {
        }

        String getClassname() {
            return this.classname;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void generateCode(StringBuilder sb, String basetab, int i) {
            sb.append(basetab);
            sb.append("sb.append(\" inner join ");
            sb.append(this.getClassname());
            if (this.getAlias() != null) {
                sb.append(" as ");
                sb.append(this.getAlias());
            }
            sb.append("\");");
            sb.append(ISourceVariable.CR);
        }
    }

    private static class SubQueryFromDataImpl
    implements SubQueryFromData {
        private String classname;
        private String code;
        private String alias;

        static SubQueryFromData createForClassname(String classname, String alias) {
            SubQueryFromDataImpl data = new SubQueryFromDataImpl();
            data.classname = classname;
            data.alias = alias;
            return data;
        }

        static SubQueryFromData createForCode(String code, String alias) {
            SubQueryFromDataImpl data = new SubQueryFromDataImpl();
            data.code = code;
            data.alias = alias;
            return data;
        }

        private SubQueryFromDataImpl() {
        }

        String getClassname() {
            return this.classname;
        }

        String getCode() {
            return this.code;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void generateCode(StringBuilder sb, String basetab, int i) {
            if (this.getCode() != null) {
                if (i > 0) {
                    sb.append(basetab);
                    sb.append("sb.append(\" , \");");
                    sb.append(ISourceVariable.CR);
                }
                sb.append(basetab);
                sb.append("sb.append(");
                sb.append(this.getCode());
                sb.append(");");
                sb.append(ISourceVariable.CR);
                if (this.getAlias() != null) {
                    sb.append(basetab);
                    sb.append("sb.append(");
                    sb.append("\" as ");
                    sb.append(this.getAlias());
                    sb.append("\");");
                    sb.append(ISourceVariable.CR);
                }
            } else {
                sb.append(basetab);
                sb.append("sb.append(\"");
                if (i > 0) {
                    sb.append(" , ");
                }
                sb.append(this.getClassname());
                if (this.getAlias() != null) {
                    sb.append(" as ");
                    sb.append(this.getAlias());
                }
                sb.append("\");");
                sb.append(ISourceVariable.CR);
            }
        }
    }

    private static interface SubQueryFromData {
        public String getAlias();

        public void generateCode(StringBuilder var1, String var2, int var3);
    }
}

