/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.appschema.Filteritem;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterManagerGenerator
extends JavaSourceGenerator {
    public static final String Classname = "JFCFilterManager";
    public static final String SUB_PACKAGE_NAME = "app";
    private Map<String, Filterlist> filterlistMap;
    private static final Logger logger = LogManager.getLogger((String)FilterManagerGenerator.class.getName());
    protected String[] defaultImportStatement = new String[]{"java.util.*", "jp.jasminesoft.util.*", "jp.jasminesoft.jfc.FilterManager", "jp.jasminesoft.jfc.service.JfcConfig"};

    public FilterManagerGenerator(Project project) {
        super(project);
        this.filterlistMap = new HashMap<String, Filterlist>();
        ApplicationContextBean filterManager = new ApplicationContextBean("filterManager", project.getPackage() + "." + this.getSubpackageNameAsJavaRule() + "." + Classname, null, true);
        filterManager.addLookupMethod("getActionParameterContainer", "ActionParameterContainer");
        SpringApplicationContextContainer.addApplicationContextBean(filterManager);
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gFilterManager());
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends FilterManager");
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return rman.getValue("filterman.comment.explanation");
    }

    @Override
    public String getClassname() {
        return Classname;
    }

    @Override
    public String getSubpackageName() {
        return SUB_PACKAGE_NAME;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.getSubpackageName();
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            importList.add(this.defaultImportStatement[i]);
        }
        return importList.toArray(new String[0]);
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    protected String gFilterManager() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gDefaultConstructor());
        sb.append(this.gInitMethod());
        return sb.toString();
    }

    protected String gDefaultConstructor() {
        StringBuilder sb = new StringBuilder();
        sb.append(CommentGenerator.gComment(rman.getValue("java.comment.constructor"), null, null));
        sb.append("    ");
        sb.append("public ");
        sb.append(this.getClassname());
        sb.append("() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("super();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gInitMethod() {
        StringBuilder sb = new StringBuilder();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                if (!(ipc[i] instanceof Filterlist)) continue;
                Filterlist pt = (Filterlist)ipc[i];
                this.filterlistMap.put(pt.getId(), pt);
            }
        }
        sb.append(CommentGenerator.gComment(rman.getValue("filterman.comment.init"), null, null));
        sb.append("    ");
        sb.append("protected void init() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String jsp_encoding = JfcConfig.getStaticJspEncoding();");
        sb.append(CR);
        sb.append(CR);
        for (String key : this.filterlistMap.keySet()) {
            Filterlist pt = this.filterlistMap.get(key);
            sb.append(this.gDefineFilter(key, pt));
            sb.append("        ");
            sb.append("filterlistMap.put(\"" + key + "\", ");
            sb.append(key);
            sb.append(");");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gDefineFilter(String key, Filterlist pt) {
        Filteritem[] items = pt.getFilteritem();
        if (items.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            String modelchar;
            String pattern;
            Filteritem item = items[i];
            String type = item.getType();
            if (type == null || type.length() == 0) continue;
            if ("removeSpace".equals(type)) {
                sb.insert(0, "new StringRemoveSpaceFilter(");
                pattern = item.getContent();
                if (pattern == null || pattern.length() == 0) {
                    sb.append(")");
                    continue;
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"" + pattern + "\")");
                continue;
            }
            if ("encoding".equals(type)) {
                sb.insert(0, "new StringEncodeFilter(");
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("jsp_encoding)");
                continue;
            }
            if ("crlf".equals(type)) {
                sb.insert(0, "new StringCRLFFilter(");
                sb.append(")");
                continue;
            }
            if ("z2h".equals(type)) {
                modelchar = item.getContent();
                if (modelchar == null || modelchar.length() == 0) {
                    logger.warn(rman.getValue("filteritem.illegal.pattern.null", "z2h"));
                    continue;
                }
                if ("number".equals(modelchar)) {
                    sb.insert(0, "new StringConvNumZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                if ("alphabet".equals(modelchar)) {
                    sb.insert(0, "new StringConvAlphabetZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                if ("kana".equals(modelchar)) {
                    sb.insert(0, "new StringConvKanaZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                if ("kigou".equals(modelchar)) {
                    sb.insert(0, "new StringConvKigouZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                if ("minus".equals(modelchar)) {
                    sb.insert(0, "new StringConvMinusZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                if ("space".equals(modelchar)) {
                    sb.insert(0, "new StringConvSpaceZ2HFilter(");
                    sb.append(")");
                    continue;
                }
                Object[] o = new Object[]{"z2h", modelchar};
                logger.warn(rman.getValue("filteritem.illegal.pattern", o));
                continue;
            }
            if ("h2z".equals(type)) {
                modelchar = item.getContent();
                if (modelchar == null || modelchar.length() == 0) {
                    logger.warn(rman.getValue("filteritem.illegal.pattern.null", "h2z"));
                    continue;
                }
                if ("number".equals(modelchar)) {
                    sb.insert(0, "new StringConvNumH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                if ("alphabet".equals(modelchar)) {
                    sb.insert(0, "new StringConvAlphabetH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                if ("kana".equals(modelchar)) {
                    sb.insert(0, "new StringConvKanaH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                if ("kigou".equals(modelchar)) {
                    sb.insert(0, "new StringConvKigouH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                if ("minus".equals(modelchar)) {
                    sb.insert(0, "new StringConvMinusH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                if ("space".equals(modelchar)) {
                    sb.insert(0, "new StringConvSpaceH2ZFilter(");
                    sb.append(")");
                    continue;
                }
                Object[] o = new Object[]{"h2z", modelchar};
                logger.warn(rman.getValue("filteritem.illegal.pattern", o));
                continue;
            }
            if ("extract".equals(type)) {
                String extracttype = item.getContent();
                if (extracttype == null || extracttype.length() == 0) {
                    logger.warn(rman.getValue("filteritem.illegal.pattern.null", "extract"));
                    continue;
                }
                if ("number".equals(extracttype)) {
                    sb.insert(0, "new StringExtractNumberFilter(");
                    sb.append(")");
                    continue;
                }
                Object[] o = new Object[]{"extract", extracttype};
                logger.warn(rman.getValue("filteritem.illegal.pattern", o));
                continue;
            }
            if ("decodeXmlChar".equals(type)) {
                sb.insert(0, "new StringDecodeXMLCharFilter(");
                sb.append(")");
                continue;
            }
            if ("demand".equals(type)) {
                pattern = item.getContent();
                if (pattern == null || pattern.length() == 0) {
                    logger.warn(rman.getValue("filteritem.illegal.pattern.null", "demand"));
                    continue;
                }
                int length = pattern.length();
                if (length % 2 != 0) {
                    logger.warn(rman.getValue("filteritem.illegal.demand", pattern));
                    continue;
                }
                StringBuilder src = new StringBuilder();
                StringBuilder dst = new StringBuilder();
                for (int k = 0; k < length; ++k) {
                    char c = pattern.charAt(k);
                    if (k % 2 == 0) {
                        if (c == '\"') {
                            src.append("\\\"");
                            continue;
                        }
                        src.append(c);
                        continue;
                    }
                    if (c == '\"') {
                        dst.append("\\\"");
                        continue;
                    }
                    dst.append(c);
                }
                sb.insert(0, "new StringConvStrOnDemandFilter(");
                sb.append(", \"" + src.toString() + "\", ");
                sb.append("\"" + dst.toString() + "\"");
                sb.append(")");
                continue;
            }
            if ("normalize".equals(type)) {
                pattern = item.getContent();
                if (pattern == null || pattern.length() == 0) {
                    logger.warn(rman.getValue("filteritem.illegal.pattern.null", "normalize"));
                    continue;
                }
                if ("minus".equals(pattern)) {
                    sb.insert(0, "new StringNormalizeZenkakuMinusFilter(");
                    sb.append(")");
                    continue;
                }
                if ("hankaku_minus".equals(pattern)) {
                    sb.insert(0, "new StringNormalizeHankakuMinusFilter(");
                    sb.append(")");
                    continue;
                }
                Object[] o = new Object[]{"normalize", pattern};
                logger.warn(rman.getValue("filteritem.illegal.pattern", o));
                continue;
            }
            if ("url".equals(type)) {
                sb.insert(0, "new StringURLFilter(");
                sb.append(")");
                continue;
            }
            logger.warn(rman.getValue("filteritem.illegal", type));
        }
        sb.insert(0, "        StringFilter " + key + " = ");
        sb.append(";");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gGetterMethod() {
        StringBuilder sb = new StringBuilder();
        String[] msg_param = new String[]{"name " + rman.getValue("filterman.comment.filtername")};
        sb.append(CommentGenerator.gComment(rman.getValue("filterman.comment.getter"), msg_param, "StringFilter"));
        sb.append("    ");
        sb.append("public StringFilter getFilter(String name) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringFilter filter = ");
        sb.append("(StringFilter)filterlistMap.get(name);");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (filter == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("filter = new StringEmptyFilter();");
        sb.append(CR);
        sb.append("return filter;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

