/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JFCAppGenerator;
import jp.jasminesoft.jfc.gen.JspBodyGenerator_show;
import jp.jasminesoft.jfc.gen.JspPanelContentBase;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaymap;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator_show;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleMapScriptManager
implements ISourceVariable,
IGeneratorFactory {
    private static GoogleMapScriptManager _instance = null;
    public static final String HTML_IN_KEY_FILE_NAME = ".." + File.separator + "googlemap.html";
    public static final String HTML_IN_KEY_FILE_NAME_WIN = ".." + File.separator + "googlemap.htm";
    public static final String KEY_FILE_NAME = ".." + File.separator + "googlemap.key";
    private static final String TEMPLATE_DIR_NAME = "template" + File.separator + "googlemaps" + File.separator;
    private static final String TEMPLATE_DIR_NAME_V3 = "template" + File.separator + "googlemapsv3" + File.separator;
    private String gkey;
    private int googleMapsVersion;
    protected static ResourceManager rman;
    protected static Logger logger;
    private static boolean isOutputLicenseErrorMessage;
    private Project project;

    private GoogleMapScriptManager(Project project) throws InstantiationException {
        this.project = project;
        rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (!JFCAppGenerator.getIsGoogleMaps()) {
            if (!isOutputLicenseErrorMessage) {
                logger.error(rman.getValue("gen.limit.googlemaps"));
                isOutputLicenseErrorMessage = true;
            }
            throw new InstantiationException("license error");
        }
        this.init(project);
    }

    private void init(Project project) {
        this.gkey = "maps.google.com/maps/api/js?libraries=geometry";
        Environment env = project.getEnvironment();
        String apikey = env.getGooglmapsapikey();
        if (StringUtils.isNotBlank((String)apikey)) {
            this.gkey = this.gkey + "&key=" + apikey;
        }
        this.googleMapsVersion = 3;
    }

    public int getGoogleMapsVersion() {
        return this.googleMapsVersion;
    }

    public static GoogleMapScriptManager getInstance(Project project, boolean isCreateNewInstance) {
        if (isCreateNewInstance) {
            _instance = null;
            return GoogleMapScriptManager.getInstance(project);
        }
        return _instance;
    }

    public static GoogleMapScriptManager getInstance(Project project) {
        if (_instance == null) {
            try {
                _instance = new GoogleMapScriptManager(project);
            }
            catch (InstantiationException e) {
                _instance = null;
            }
        }
        return _instance;
    }

    public String getReadyScript() {
        if (this.gkey == null || this.gkey.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<c:choose>").append(CR);
        sb.append("<c:when test=\"${pageContext.request.secure}\">").append(CR);
        sb.append("<c:set var=\"__protocol\" value=\"https://\"/>").append(CR);
        sb.append("</c:when>").append(CR);
        sb.append("<c:otherwise>").append(CR);
        sb.append("<c:set var=\"__protocol\" value=\"http://\"/>").append(CR);
        sb.append("</c:otherwise>").append(CR);
        sb.append("</c:choose>").append(CR);
        sb.append("<script src=\"<c:out value=\"${__protocol}\"/><c:out value=\"${applicationScope['googlemap_key']}\"/>\" type=\"text/javascript\"></script>");
        sb.append(CR);
        sb.append("<script src=\"system/gmap");
        if (this.getGoogleMapsVersion() == 3) {
            sb.append("v3");
        }
        sb.append(".js\" type=\"text/javascript\"></script>");
        sb.append(CR);
        return sb.toString();
    }

    public String getThReadyScript() {
        if (StringUtils.isBlank((String)this.gkey)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<script th:src=\"|${!#strings.isEmpty(#request.secure) ? 'https' : 'http'}://${application.googlemap_key}|\"").append(" type=\"text/javascript\"></script>").append(CR);
        sb.append("<script src=\"system/gmap");
        if (this.getGoogleMapsVersion() == 3) {
            sb.append("v3");
        }
        sb.append(".js\" type=\"text/javascript\"></script>").append(CR);
        return sb.toString();
    }

    public String getScript(Presentation presentation) {
        if (this.gkey == null || this.gkey.length() == 0 || presentation == null) {
            return "";
        }
        IRNode node = presentation.getIdrefAsIRNode();
        if (node == null || !(node instanceof Action)) {
            return "";
        }
        Action action = (Action)node;
        String type = action.getType();
        if ("show".equals(type)) {
            return this.getScript_show(action, presentation);
        }
        if ("showList".equals(type)) {
            String filename = presentation.getFilename();
            if (filename == null || filename.length() == 0) {
                return this.getScript_showlist(action, presentation);
            }
            return this.getScript_showlist2(action, presentation);
        }
        if ("insert".equals(type)) {
            return this.getScript_insert(action, presentation);
        }
        if ("update".equals(type)) {
            return this.getScript_update(action, presentation);
        }
        if ("copy".equals(type)) {
            return this.getScript_insert(action, presentation);
        }
        if ("download".equals(type)) {
            return this.getScript_showlist(action, presentation);
        }
        logger.warn("** unknown type:" + type);
        return "";
    }

    protected String getTemplateDirName() {
        if (this.getGoogleMapsVersion() == 3) {
            return TEMPLATE_DIR_NAME_V3;
        }
        return TEMPLATE_DIR_NAME;
    }

    protected String getTemplateFilename(Presentation presentation, String basename) {
        StringBuilder sb = new StringBuilder(this.getTemplateDirName());
        sb.append(basename);
        if (AppSchemaUtil.isCSSLayout(presentation)) {
            sb.append("_th");
        }
        sb.append(".js");
        return sb.toString();
    }

    protected String getScript_show(Action action, Presentation presentation) {
        String tfilename = this.getTemplateFilename(presentation, "show");
        FileTemplateManager tplman = new FileTemplateManager(tfilename);
        if (!tplman.isValid()) {
            return "";
        }
        Model smodel = null;
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (smodel == null) {
            return "";
        }
        Model pmodel = AppSchemaUtil.getModel(this.project, smodel.getId(), "presentation");
        if (pmodel == null) {
            return "";
        }
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        if (displaymap == null) {
            return "";
        }
        Item[] items = displaymap.getItem();
        String prefix = "";
        this.prepareNameAttribute(items, pmodel, tplman, prefix);
        this.prepareIdAttribute(items, pmodel, tplman, prefix);
        return tplman.getResult();
    }

    protected String getScript_showlist(Action action, Presentation presentation) {
        String tfilename = this.getTemplateFilename(presentation, "showlist");
        FileTemplateManager tplman = new FileTemplateManager(tfilename);
        if (!tplman.isValid()) {
            return "";
        }
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, action);
        if (cmodel == null) {
            return "";
        }
        Model cpmodel = AppSchemaUtil.getModel(this.project, cmodel.getId(), "presentation");
        if (cpmodel == null) {
            return "";
        }
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        if (displaymap == null) {
            return "";
        }
        String address = this.createInitialValue();
        String lat1 = this.createInitialValue();
        String lat2 = this.createInitialValue();
        String lon1 = this.createInitialValue();
        String lon2 = this.createInitialValue();
        String styles = null;
        Item[] items = displaymap.getItem();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if ("address".equals(item.getName())) {
                address = this.createNameAttribute(item.getContent(), cpmodel);
                continue;
            }
            if ("latitude_cond1".equals(item.getName())) {
                lat1 = this.createNameAttribute(item.getContent(), cpmodel);
                continue;
            }
            if ("latitude_cond2".equals(item.getName())) {
                lat2 = this.createNameAttribute(item.getContent(), cpmodel);
                continue;
            }
            if ("longitude_cond1".equals(item.getName())) {
                lon1 = this.createNameAttribute(item.getContent(), cpmodel);
                continue;
            }
            if ("longitude_cond2".equals(item.getName())) {
                lon2 = this.createNameAttribute(item.getContent(), cpmodel);
                continue;
            }
            if (!"styles".equals(item.getName())) continue;
            styles = item.getContent();
        }
        tplman.addContent("address", address);
        tplman.addContent("lat1", lat1);
        tplman.addContent("lat2", lat2);
        tplman.addContent("lon1", lon1);
        tplman.addContent("lon2", lon2);
        tplman.addContent("styles", styles);
        return tplman.getResult();
    }

    protected String getScript_showlist2(Action action, Presentation presentation) {
        String tfilename = this.getTemplateFilename(presentation, "showlist2");
        FileTemplateManager tplman = new FileTemplateManager(tfilename);
        if (!tplman.isValid()) {
            return "";
        }
        Model smodel = null;
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (smodel == null) {
            return "";
        }
        Model lmodel = AppSchemaUtil.getModel(this.project, smodel.getId(), "list");
        if (lmodel == null) {
            return "";
        }
        Model lpmodel = AppSchemaUtil.getModel(this.project, lmodel.getId(), "presentation");
        if (lpmodel == null) {
            return "";
        }
        String modelname_lp = lpmodel.getId();
        String my_name = smodel.getId();
        String form_name = JspPanelContentBase.createActionId(action, modelname_lp);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        if (pkeys == null) {
            return "";
        }
        String pkey_name = AppSchemaUtil.createPrimaryKeyName(pkeys);
        ArrayList<Modelitem> mitemList = new ArrayList<Modelitem>();
        for (IModelChoice imc : smodel.getContent()) {
            if (!(imc instanceof Modelitem)) continue;
            mitemList.add((Modelitem)imc);
        }
        String pkey_val_formula = AppSchemaUtil.isCSSLayout(presentation) ? ThBodyGenerator_show.createPrimaryKeyExpr0(pkeys, pkey_name, mitemList, "item", smodel, this.project) : JspBodyGenerator_show.createPrimaryKeyExpr0(pkeys, pkey_name, mitemList, "item", smodel, this.project);
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        if (displaymap == null) {
            return "";
        }
        Item[] items = displaymap.getItem();
        String item_lat = this.createInitialValue();
        String item_lon = this.createInitialValue();
        String item_name = this.createInitialValue();
        String item_label = this.createInitialValue();
        String item_markercolor = this.createInitialValue();
        String item_markerurl = this.createInitialValue();
        String styles = null;
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if ("address".equals(item.getName())) {
                item_name = item.getContent();
                continue;
            }
            if ("latitude".equals(item.getName())) {
                item_lat = item.getContent();
                continue;
            }
            if ("longitude".equals(item.getName())) {
                item_lon = item.getContent();
                continue;
            }
            if ("label".equals(item.getName())) {
                item_label = item.getContent();
                continue;
            }
            if ("markercolor".equals(item.getName())) {
                item_markercolor = item.getContent();
                continue;
            }
            if ("markerurl".equals(item.getName())) {
                item_markerurl = item.getContent();
                continue;
            }
            if (!"styles".equals(item.getName())) continue;
            styles = item.getContent();
        }
        tplman.addContent("modelname_lp", modelname_lp);
        tplman.addContent("item_lat", StringUtil.convertELProperty((String)item_lat));
        tplman.addContent("item_lon", StringUtil.convertELProperty((String)item_lon));
        tplman.addContent("item_name", StringUtil.convertELProperty((String)item_name));
        tplman.addContent("item_label", StringUtil.convertELProperty((String)item_label));
        tplman.addContent("form_name", form_name);
        tplman.addContent("pkey_name", StringUtil.convertELProperty((String)pkey_name));
        tplman.addContent("pkey_val_formula", StringUtil.convertELProperty((String)pkey_val_formula));
        tplman.addContent("sendaction_pkey_name", pkey_name);
        tplman.addContent("my_name", StringUtil.convertELProperty((String)my_name));
        tplman.addContent("item_markercolor", StringUtil.convertELProperty((String)item_markercolor));
        tplman.addContent("item_markerurl", StringUtil.convertELProperty((String)item_markerurl));
        tplman.addContent("styles", styles);
        return tplman.getResult();
    }

    protected String getScript_insert(Action action, Presentation presentation) {
        return this.getScript_insert_and_update(action, presentation, "insert");
    }

    protected String getScript_update(Action action, Presentation presentation) {
        return this.getScript_insert_and_update(action, presentation, "update");
    }

    protected String getScript_insert_and_update(Action action, Presentation presentation, String basename) {
        String tfilename = this.getTemplateFilename(presentation, basename);
        FileTemplateManager tplman = new FileTemplateManager(tfilename);
        if (!tplman.isValid()) {
            return "";
        }
        Model smodel = null;
        IRNode node = action.getIdrefAsIRNode();
        if (node != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (smodel == null) {
            return "";
        }
        Model pmodel = AppSchemaUtil.getModel(this.project, smodel.getId(), "presentation");
        if (pmodel == null) {
            return "";
        }
        Displaymap displaymap = AppSchemaUtil.findDisplaymap(presentation);
        if (displaymap == null) {
            return "";
        }
        Item[] items = displaymap.getItem();
        this.prepareNameAttribute(items, pmodel, tplman, null);
        return tplman.getResult();
    }

    private void prepareNameAttribute(Item[] items, Model pmodel, FileTemplateManager tplman, String prefix) {
        String address = this.createInitialValue();
        String label = this.createInitialValue();
        String lat = this.createInitialValue();
        String lon = this.createInitialValue();
        String mbr = this.createInitialValue();
        String radius = this.createInitialValue();
        String scale = this.createInitialValue();
        String imageurl = this.createInitialValue();
        String markercolor = this.createInitialValue();
        String markerurl = this.createInitialValue();
        String styles = null;
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if ("address".equals(item.getName())) {
                address = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("label".equals(item.getName())) {
                lat = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("latitude".equals(item.getName())) {
                lat = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("longitude".equals(item.getName())) {
                lon = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("mbr".equals(item.getName())) {
                mbr = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("radius".equals(item.getName())) {
                radius = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("scale".equals(item.getName())) {
                scale = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("imageurl".equals(item.getName())) {
                imageurl = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("markercolor".equals(item.getName())) {
                markercolor = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("markerurl".equals(item.getName())) {
                markerurl = this.createNameAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if (!"styles".equals(item.getName())) continue;
            styles = item.getContent();
        }
        tplman.addContent("address", address);
        tplman.addContent("label", label);
        tplman.addContent("lat", lat);
        tplman.addContent("lon", lon);
        tplman.addContent("mbr", mbr);
        tplman.addContent("radius", radius);
        tplman.addContent("scale", scale);
        tplman.addContent("imageurl", imageurl);
        tplman.addContent("modelId", pmodel.getId());
        tplman.addContent("markercolor", markercolor);
        tplman.addContent("markerurl", markerurl);
        tplman.addContent("styles", styles);
    }

    private String createNameAttribute(String name, Model pmodel) {
        return this.createNameAttribute(name, pmodel, null);
    }

    private String createNameAttribute(String name, Model pmodel, String prefix) {
        if (name == null || name.length() == 0) {
            return this.createInitialValue();
        }
        String ret = "";
        if (!AppSchemaUtil.hasChildPart(name) && prefix != null) {
            ret = prefix;
        }
        return ret + AppSchemaUtil.createNameAttribute(this.project, name, pmodel, true, "1");
    }

    private void prepareIdAttribute(Item[] items, Model pmodel, FileTemplateManager tplman, String prefix) {
        String address = this.createInitialValue();
        String label = this.createInitialValue();
        String lat = this.createInitialValue();
        String lon = this.createInitialValue();
        String mbr = this.createInitialValue();
        String radius = this.createInitialValue();
        String scale = this.createInitialValue();
        String imageurl = this.createInitialValue();
        String markercolor = this.createInitialValue();
        String markerurl = this.createInitialValue();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if ("address".equals(item.getName())) {
                address = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("label".equals(item.getName())) {
                label = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("latitude".equals(item.getName())) {
                lat = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("longitude".equals(item.getName())) {
                lon = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("mbr".equals(item.getName())) {
                mbr = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("radius".equals(item.getName())) {
                radius = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("scale".equals(item.getName())) {
                scale = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("imageurl".equals(item.getName())) {
                imageurl = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if ("markercolor".equals(item.getName())) {
                markercolor = this.createIdAttribute(item.getContent(), pmodel, prefix);
                continue;
            }
            if (!"markerurl".equals(item.getName())) continue;
            markerurl = this.createIdAttribute(item.getContent(), pmodel, prefix);
        }
        tplman.addContent("address_id", address);
        tplman.addContent("label_id", label);
        tplman.addContent("lat_id", lat);
        tplman.addContent("lon_id", lon);
        tplman.addContent("mbr_id", mbr);
        tplman.addContent("radius_id", radius);
        tplman.addContent("scale_id", scale);
        tplman.addContent("imageurl_id", imageurl);
        tplman.addContent("modelId", pmodel.getId());
        tplman.addContent("markercolor_id", markercolor);
        tplman.addContent("markerurl_id", markerurl);
    }

    private String createIdAttribute(String name, Model pmodel, String prefix) {
        if (name == null || name.length() == 0) {
            return this.createInitialValue();
        }
        String ret = "";
        if (prefix != null) {
            ret = prefix;
        }
        return ret + AppSchemaUtil.createNameAttribute(this.project, name, pmodel, true, "1");
    }

    private String createInitialValue() {
        return "unknown";
    }

    public String getGooglemapKey() {
        if (StringUtils.isBlank((String)this.gkey)) {
            return null;
        }
        return StringUtil.decodeStringFromXML((String)this.gkey);
    }

    static {
        logger = LogManager.getLogger(GoogleMapScriptManager.class);
    }
}

