/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Buttonfield;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Sort;
import jp.jasminesoft.jfc.gen.appschema.Sortkey;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GridColumnsGenerator
implements ISourceVariable {
    protected Logger logger = LogManager.getLogger((String)GridColumnsGenerator.class.getName());
    protected Project project;
    protected Action action;
    protected String actiontype;
    protected String id;
    protected Presentation presentation;
    protected Model model;
    protected Model smodel;
    protected ResourceManager rman;

    public GridColumnsGenerator(Project project, Model smodel, Model model) {
        Action action1 = GridColumnsGenerator.getAction(project, smodel, model);
        if (action1 == null) {
            throw new IllegalStateException();
        }
        Presentation[] presentations = AppSchemaUtil.getPresentation(project, action1);
        if (presentations == null || presentations.length == 0) {
            throw new IllegalStateException();
        }
        Presentation pres = presentations[0];
        this.init(project, action1, pres, smodel, model);
    }

    public static Action getAction(Project project, Model smodel, Model model) {
        Action[] actions;
        if (model.getUpdatelist()) {
            return AppSchemaUtil.getUpdateListActionByModelId(project, smodel.getId());
        }
        for (Action action1 : actions = AppSchemaUtil.getActionsByModelIdAndType(project, smodel.getId(), "showList")) {
            if (action1.getUpdatelist()) continue;
            return action1;
        }
        return null;
    }

    public GridColumnsGenerator(Project project, Action action, Presentation presentation) {
        Model lpmodel = AppSchemaUtil.getModel(project, action);
        Model smodel = AppSchemaUtil.getStoreModel(lpmodel);
        this.init(project, action, presentation, smodel, lpmodel);
    }

    private void init(Project project, Action action, Presentation presentation, Model smodel, Model model) {
        this.project = project;
        this.action = action;
        this.actiontype = action.getType();
        this.id = action.getId();
        this.model = model;
        this.smodel = smodel;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.presentation = presentation;
    }

    public String process(String basetab) {
        List<Map<String, Object>> gridColumns = this.createGridColumns();
        if (gridColumns == null) {
            return "";
        }
        return this.toJsonString("  ", gridColumns);
    }

    public List<Map<String, Object>> createGridColumns() {
        List<Displaymodel> showListGridDisplaymodels = this.createShowListGridDisplaymodels();
        List<List<Map<String, Object>>> gridColumnsList = this.gCreateShowListGridFunc(showListGridDisplaymodels);
        if (gridColumnsList.size() < 1) {
            return null;
        }
        return gridColumnsList.get(0);
    }

    public List<Displaymodel> createShowListGridDisplaymodels() {
        Displaymodel[] searchListMobileDisplaymodels;
        ArrayList<Displaymodel> showListGridDisplaymodels = new ArrayList<Displaymodel>();
        if (this.presentation == null) {
            return showListGridDisplaymodels;
        }
        if (!"showList".equals(this.actiontype) && !"show".equals(this.actiontype)) {
            return showListGridDisplaymodels;
        }
        Panel bodyPanel = AppSchemaUtil.findBodyPanel(this.presentation);
        if (bodyPanel == null) {
            return showListGridDisplaymodels;
        }
        Displaymodel[] displaymodels = AppSchemaUtil.findDisplaymodel(bodyPanel);
        if (StringUtils.startsWith((String)this.id, (String)"searchList") && (searchListMobileDisplaymodels = AppSchemaUtil.getSearchListMobileDisplaymodel(this.project, this.id)) != null) {
            ArrayList<Displaymodel> displaymodelList = new ArrayList<Displaymodel>(Arrays.asList(displaymodels));
            displaymodelList.addAll(Arrays.asList(searchListMobileDisplaymodels));
            displaymodels = displaymodelList.toArray(new Displaymodel[0]);
        }
        if (displaymodels == null || displaymodels.length == 0) {
            return showListGridDisplaymodels;
        }
        for (Displaymodel displaymodel : displaymodels) {
            IDisplaymodelChoice[] idc;
            if (!"grid".equals(displaymodel.getShowListDisplayType()) || (idc = displaymodel.getContent()) == null) continue;
            showListGridDisplaymodels.add(displaymodel);
        }
        return showListGridDisplaymodels;
    }

    public List<List<Map<String, Object>>> gCreateShowListGridFunc(List<Displaymodel> showListGridDisplaymodels) {
        ArrayList<List<Map<String, Object>>> gridColumnsList = new ArrayList<List<Map<String, Object>>>();
        if (showListGridDisplaymodels.isEmpty()) {
            return gridColumnsList;
        }
        for (Displaymodel showListGridDisplaymodel : showListGridDisplaymodels) {
            ArrayList<Map<String, Object>> gridColumns = new ArrayList<Map<String, Object>>();
            this.gCreateGetGridColumsFunc(showListGridDisplaymodel, gridColumns);
            gridColumnsList.add(gridColumns);
        }
        return gridColumnsList;
    }

    protected void setButtonField(List<Map<String, Object>> gridColumns, boolean isUpdateList) {
        List<Buttonfield> bfs = AppSchemaUtil.getButtonfield(this.model);
        for (Buttonfield bf : bfs) {
            Map buttonField = CollectionUtils.toMap((Object[][])new Object[][]{{"id", bf.getName()}, {"field", bf.getLink().getLabel()}, {"label", ""}, {"sortable", Boolean.FALSE}, {"style", CollectionUtils.toMap((Object[][])new Object[][]{{"label", CollectionUtils.toMap((Object[][])new Object[][]{{"textAlign", "center"}, {"verticalAlign", "middle"}})}, {"value", CollectionUtils.toMap((Object[][])new Object[][]{{"textAlign", "center"}, {"verticalAlign", "middle"}})}})}});
            gridColumns.add(buttonField);
        }
    }

    protected Set<String> getSortKeyItems() {
        HashSet<String> sortKeyItems = new HashSet<String>();
        Sort sort = AppSchemaUtil.getSort(AppSchemaUtil.getActionByModelIdAndType(this.project, this.smodel.getId(), "showList"));
        if (sort == null) {
            return sortKeyItems;
        }
        Sortkey[] sortKeys = sort.getSortkey();
        if (sortKeys == null) {
            return sortKeyItems;
        }
        for (int i = 0; i < sortKeys.length; ++i) {
            sortKeyItems.add(sortKeys[i].getContent());
        }
        return sortKeyItems;
    }

    protected void setGridItemSortable(Displayitem displayitem, Modelitem storeModelitem, Set<String> sortKeyItems, Map<String, Object> gridColumn) {
        if (sortKeyItems.contains(displayitem.getName()) && storeModelitem != null && !storeModelitem.getTransient()) {
            return;
        }
        gridColumn.put("sortable", Boolean.FALSE);
    }

    protected void gCreateGetGridColumsFunc(Displaymodel showListGridDisplaymodel, ArrayList<Map<String, Object>> gridColumns) {
        if (this.presentation == null) {
            return;
        }
        String idref = showListGridDisplaymodel.getIdref();
        String modelId = "";
        boolean isUpdateList = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("idref " + idref);
        }
        if (StringUtils.contains((String)idref, (String)"_lp")) {
            modelId = StringUtils.substringBefore((String)idref, (String)"_lp");
        } else if (StringUtils.contains((String)idref, (String)"_ulp")) {
            modelId = StringUtils.substringBefore((String)idref, (String)"_ulp");
            isUpdateList = true;
        }
        this.setButtonField(gridColumns, isUpdateList);
        Model presentationModel = AppSchemaUtil.getModel(this.project, modelId, "presentation");
        Model storeModel = AppSchemaUtil.getStoreModel(presentationModel);
        IDisplaymodelChoice[] idc = showListGridDisplaymodel.getContent();
        Set<String> sortKeyItems = this.getSortKeyItems();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem displayitem;
            if (!(idc[i] instanceof Displayitem) || AppSchemaUtil.isHiddenDisplayitem(displayitem = (Displayitem)idc[i]) && !StringUtils.startsWith((String)this.presentation.getIdref(), (String)"updateList")) continue;
            LinkedHashMap<String, Object> gridColumn = new LinkedHashMap<String, Object>();
            String displayitemName = AppSchemaUtil.getChildPart(displayitem.getName());
            gridColumn.put("id", displayitemName);
            gridColumn.put("field", displayitemName);
            String label = displayitem.getLabelname();
            Modelitem presentationModelitem = AppSchemaUtil.getModelitem(displayitem.getName(), presentationModel);
            if (StringUtils.isBlank((String)label)) {
                label = presentationModelitem != null ? presentationModelitem.getLabel() : "";
            }
            gridColumn.put("label", label);
            Modelitem storeModelitem = AppSchemaUtil.getModelitem(displayitem.getName(), storeModel);
            this.setGridItemSortable(displayitem, storeModelitem, sortKeyItems, gridColumn);
            LinkedHashMap<String, String> labelStylesMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((String)displayitem.getThalign())) {
                labelStylesMap.put("textAlign", displayitem.getThalign());
            }
            if (StringUtils.isNotBlank((String)displayitem.getThvalign())) {
                labelStylesMap.put("verticalAlign", displayitem.getThvalign());
            }
            if (StringUtils.isNotBlank((String)displayitem.getLabelwidth())) {
                labelStylesMap.put("width", displayitem.getLabelwidth());
            }
            LinkedHashMap<String, String> valueStylesMap = new LinkedHashMap<String, String>();
            if (!"left".equals(displayitem.getAlign())) {
                valueStylesMap.put("textAlign", displayitem.getAlign());
            }
            if (StringUtils.isNotBlank((String)displayitem.getValign())) {
                valueStylesMap.put("verticalAlign", displayitem.getValign());
            }
            if (AppSchemaUtil.detectTextArea(storeModelitem, storeModel, this.project)) {
                valueStylesMap.put("whiteSpace", "pre");
            }
            LinkedHashMap<String, LinkedHashMap<String, String>> styleMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            if (labelStylesMap.size() > 0) {
                styleMap.put("label", labelStylesMap);
            }
            if (valueStylesMap.size() > 0) {
                styleMap.put("value", valueStylesMap);
            }
            gridColumn.put("style", styleMap);
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(storeModelitem);
            this.setWidgetTypeInGrid(isUpdateList, displayitem, relation, presentationModelitem, gridColumn);
            if (isUpdateList && storeModelitem != null && "storeref".equals(storeModelitem.getType()) && relation != null) {
                gridColumn.put("get", new JSFunction(new String[]{"item"}, new String[]{"var values = item[this.field];", "if (!(values instanceof Array) || values.length === 0) {", "  return '';", "}", "var cellValues = [];", "for (var i=0,l=values.length; i<l; i++) {", "  var value = values[i];", "  if (!value['choose']) {", "    continue;", "  }", "  cellValues.push(value['content']);", "}", "return cellValues.join();"}));
            }
            gridColumns.add(gridColumn);
        }
    }

    protected boolean isUpdateListGridNeedsRefresh(Project project, Model smodel, Modelitem storeModelitem, Displayitem displayitem) {
        if (AppSchemaUtil.isNeedReload(project, smodel, storeModelitem, displayitem) || AppSchemaUtil.hasAutocalcUsingModelitem(smodel, storeModelitem, project)) {
            return true;
        }
        Modelitem[] ref_mitems = AppSchemaUtil.getModelitem_InRefRelation(smodel, storeModelitem);
        return ref_mitems != null && ref_mitems.length > 0;
    }

    protected void setWidgetTypeInGrid(boolean isUpdateList, Displayitem displayitem, Relation relation, Modelitem modelitem, Map<String, Object> gridColumn) {
        String addressfield;
        String type;
        if (!isUpdateList && displayitem.getBarGauge() || isUpdateList && displayitem.getReadonly() && displayitem.getBarGauge()) {
            this.setBarGaugeProps(displayitem, gridColumn);
            return;
        }
        if (!isUpdateList || displayitem.getReadonly()) {
            return;
        }
        if (modelitem != null && modelitem.getCalendarinput()) {
            type = "dateTextbox";
        } else {
            type = displayitem.getType();
            if (!"pseudo_checkbox".equals(type) && relation != null) {
                type = AppSchemaUtil.getRelationType(relation, this.project);
            }
        }
        if ("file".equals(type)) {
            return;
        }
        gridColumn.put("type", type);
        if ("pseudo_checkbox".equals(type)) {
            gridColumn.put("pseudoCheckValue", displayitem.getPseudoCheckboxValue());
        }
        if ("zipcode".equals(type) && StringUtils.isNotBlank((String)(addressfield = AppSchemaUtil.getAddressfield(AppSchemaUtil.getModelitem(modelitem.getName(), this.smodel))))) {
            gridColumn.put("addressItemId", addressfield);
        }
        this.setInputFormat(displayitem, type, gridColumn);
        if (AppSchemaUtil.isHiddenDisplayitem(displayitem)) {
            gridColumn.put("hidden", Boolean.TRUE);
            gridColumn.put("unhidable", Boolean.TRUE);
        } else if ("search".equals(type)) {
            LinkedHashMap<String, Object> searchWindowMap = new LinkedHashMap<String, Object>();
            searchWindowMap.put("actionName", displayitem.getAction() + ".do");
            searchWindowMap.put("contentElement", relation.getRolecontent());
            LinkedHashMap<String, Integer> sizeMap = new LinkedHashMap<String, Integer>();
            sizeMap.put("width", displayitem.getSearchListWindowWidth());
            sizeMap.put("height", displayitem.getSearchListWindowHeight());
            searchWindowMap.put("size", sizeMap);
            gridColumn.put("searchWindow", searchWindowMap);
        }
    }

    protected void setInputFormat(Displayitem displayitem, String type, Map<String, Object> gridColumn) {
        if (!"dateTextbox".equals(type) && !"number".equals(type)) {
            return;
        }
        String format = null;
        if ("dateTextbox".equals(type) && StringUtils.isNotBlank((String)displayitem.getDateformat())) {
            format = displayitem.getDateformat();
        } else if ("number".equals(type) && StringUtils.isNotBlank((String)displayitem.getNumberformat())) {
            format = displayitem.getNumberformat();
            format = StringUtils.replace((String)format, (String)"\\", (String)"\\\\");
        }
        if (StringUtils.isBlank(format)) {
            return;
        }
        gridColumn.put("format", format);
    }

    protected void setBarGaugeProps(Displayitem displayitem, Map<String, Object> gridColumn) {
        gridColumn.put("type", "barGauge");
        LinkedHashMap<String, String> barGaugePropsMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((String)displayitem.getBarGaugeUnit())) {
            barGaugePropsMap.put("unit", displayitem.getBarGaugeUnit());
        }
        if (StringUtils.isNotBlank((String)displayitem.getBarGaugeMaxValue())) {
            barGaugePropsMap.put("maximum", displayitem.getBarGaugeMaxValue());
        }
        if (StringUtils.isNotBlank((String)displayitem.getBarGaugeColor())) {
            barGaugePropsMap.put("color", displayitem.getBarGaugeColor());
        }
        if (barGaugePropsMap.size() > 0) {
            gridColumn.put("barGaugeProps", barGaugePropsMap);
        }
    }

    public String toJsonString(String tab, List<Object> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(CR);
        boolean isFirst = true;
        for (Object item : list) {
            String code = this.toJsonString(tab + "  ", item);
            if (code == null) continue;
            if (!isFirst) {
                sb.append(",");
                sb.append(CR);
            }
            sb.append(tab + "  ");
            sb.append(code);
            isFirst = false;
        }
        if (!isFirst) {
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("]");
        return sb.toString();
    }

    public String toJsonString(String tab, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(CR);
        boolean isFirst = true;
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String code = this.toJsonString(tab + "  ", item.getValue());
            if (code == null) continue;
            if (!isFirst) {
                sb.append(",");
                sb.append(CR);
            }
            sb.append(tab + "  ");
            sb.append("\"");
            sb.append(item.getKey());
            sb.append("\"");
            sb.append(": ");
            sb.append(code);
            isFirst = false;
        }
        if (!isFirst) {
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("}");
        return sb.toString();
    }

    public String toJsonString(String tab, Object item) {
        if (item == null) {
            return "null";
        }
        if (item instanceof List) {
            List list = (List)item;
            return this.toJsonString(tab, list);
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            return this.toJsonString(tab, map);
        }
        if (item instanceof Boolean) {
            Boolean b = (Boolean)item;
            return b.toString();
        }
        if (item instanceof JSFunction) {
            JSFunction func = (JSFunction)item;
            return func.toJsonString(tab);
        }
        return "\"" + item.toString() + "\"";
    }

    public JsonJavaCode toJsonJavaCode(List<Object> list) {
        ArrayList<String> codes = new ArrayList<String>();
        HashSet<String> typeset = new HashSet<String>();
        for (Object item : list) {
            String lastcode;
            JsonJavaCode jjc = this.toJsonJavaCode(item);
            if (jjc == null) continue;
            typeset.add(jjc.typestr);
            if (codes.size() >= 1 && !(lastcode = (String)codes.get(codes.size() - 1)).endsWith(",")) {
                codes.set(codes.size() - 1, lastcode + ",");
            }
            Iterator<String> it = jjc.codes.iterator();
            while (it.hasNext()) {
                codes.add("  " + it.next());
            }
        }
        typeset.remove("null");
        String type = typeset.size() == 1 ? (String)typeset.iterator().next() : "Object";
        StringBuilder codebuf = new StringBuilder();
        codes.add(0, "Arrays.asList(");
        String lastcode = (String)codes.get(codes.size() - 1);
        codes.set(codes.size() - 1, lastcode + ")");
        return new JsonJavaCode("List<" + type + ">", codebuf.toString());
    }

    public JsonJavaCode toJsonJavaCode(Map<String, Object> map) {
        ArrayList<String> codes = new ArrayList<String>();
        HashSet<String> typeset = new HashSet<String>();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String lastcode;
            JsonJavaCode jjc = this.toJsonJavaCode(item.getValue());
            if (jjc == null) continue;
            typeset.add(jjc.typestr);
            if (codes.size() >= 1 && !(lastcode = (String)codes.get(codes.size() - 1)).endsWith(",")) {
                codes.set(codes.size() - 1, lastcode + ",");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("  ");
            sb.append("{ \"");
            sb.append(StringUtil.convertJavaString((String)item.getKey()));
            sb.append("\", ");
            Iterator<String> it = jjc.codes.iterator();
            if (it.hasNext()) {
                codes.add(sb.toString() + it.next());
            }
            while (it.hasNext()) {
                codes.add("  " + it.next());
            }
            String lastcode2 = (String)codes.get(codes.size() - 1);
            codes.set(codes.size() - 1, lastcode2 + " }");
        }
        typeset.remove("null");
        String type = typeset.size() == 1 ? (String)typeset.iterator().next() : "Object";
        String type3 = "Map<String, " + type + ">";
        codes.add(0, "CollectionUtils.toMap(new Object[][] {");
        String lastcode = (String)codes.get(codes.size() - 1);
        codes.set(codes.size() - 1, lastcode + "})");
        return new JsonJavaCode(type3, codes);
    }

    public JsonJavaCode toJsonJavaCode(Object item) {
        if (item == null) {
            return new JsonJavaCode("null", "null");
        }
        if (item instanceof List) {
            List list = (List)item;
            return this.toJsonJavaCode(list);
        }
        if (item instanceof Map) {
            Map map = (Map)item;
            return this.toJsonJavaCode(map);
        }
        if (item instanceof Boolean) {
            Boolean b = (Boolean)item;
            return new JsonJavaCode("Boolean", b.toString());
        }
        if (item instanceof JavaCode) {
            return new JsonJavaCode("Object", ((JavaCode)item).content);
        }
        if (item instanceof JSFunction) {
            JSFunction func = (JSFunction)item;
            return func.toJsonJavaCode();
        }
        return new JsonJavaCode("String", "\"" + StringUtil.convertJavaString((String)item.toString()) + "\"");
    }

    protected void append(StringBuilder sb, String tab, String[] codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((String)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }

    public class JsonJavaCode {
        String typestr;
        List<String> codes;

        JsonJavaCode(String typestr, String code) {
            this.typestr = typestr;
            this.codes = Arrays.asList(code);
        }

        JsonJavaCode(String typestr, String ... code) {
            this.typestr = typestr;
            this.codes = Arrays.asList(code);
        }

        JsonJavaCode(String typestr, List<String> codes) {
            this.typestr = typestr;
            this.codes = codes;
        }
    }

    public static class JavaCode {
        private String content;

        public JavaCode(String content) {
            this.content = content;
        }
    }

    public class JSFunction {
        String[] args;
        String[] codes;

        JSFunction(String[] args, String[] codes) {
            this.args = args;
            this.codes = codes;
        }

        public String toJsonString(String tab) {
            StringBuilder sb = new StringBuilder();
            this.gHeader(sb);
            sb.append(ISourceVariable.CR);
            GridColumnsGenerator.this.append(sb, tab + "  ", this.codes);
            sb.append(tab);
            sb.append("}");
            return sb.toString();
        }

        private void gHeader(StringBuilder sb) {
            sb.append("function(");
            boolean isFirst = true;
            for (String arg : this.args) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(arg);
                isFirst = false;
            }
            sb.append(") {");
        }

        public JsonJavaCode toJsonJavaCode() {
            return new JsonJavaCode("String", this._toJsonJavaCode());
        }

        public String[] _toJsonJavaCode() {
            ArrayList<String> codes1 = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            this.gHeader(sb);
            sb.append("\"");
            codes1.add(sb.toString());
            for (String s : this.codes) {
                sb = new StringBuilder();
                sb.append(" + \"");
                sb.append(StringUtil.convertJavaString((String)s));
                sb.append("\"");
                codes1.add(sb.toString());
            }
            codes1.add(" + \"}\"");
            return codes1.toArray(new String[codes1.size()]);
        }
    }
}

