/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AnormManagerGenerator;
import jp.jasminesoft.jfc.gen.AnormType;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ClassnameManager;
import jp.jasminesoft.jfc.gen.HelperButtonControlGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Optionfilter;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelperGenerator
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    protected Model model;
    protected ClassnameManager classnameman = new ClassnameManager();
    protected StringBuilder methodBuf;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator.class.getName());
    protected String[] defaultImportStatement = new String[]{"java.io.*", "java.math.BigDecimal", "java.math.RoundingMode", "java.util.*", "java.util.regex.*", "java.text.*", "java.sql.Connection", "java.sql.SQLException", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "jp.jasminesoft.util.*", "org.apache.commons.lang3.*", "org.apache.commons.lang3.math.NumberUtils", "org.apache.commons.lang3.mutable.MutableBoolean", "org.apache.commons.collections.map.LRUMap", "org.springframework.transaction.TransactionStatus", "org.springframework.transaction.support.TransactionCallback", "org.springframework.transaction.support.TransactionTemplate", AppSchemaUtil.getMyExcelFunctionStaticImport(this.project), "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.core.util.NullValueChecker", "jp.jasminesoft.jfc.core.util.StoreModelUtils", "jp.jasminesoft.jfc.dao.CriteriaConverter", "jp.jasminesoft.jfc.dao.DataBindingContext", "jp.jasminesoft.jfc.dao.FinderContext", "jp.jasminesoft.jfc.error.*", "jp.jasminesoft.jfc.hibernate.DetachedCriteria", "jp.jasminesoft.jfc.service.JFCEntityService", "jp.jasminesoft.jfc.tag.CheckLogonBase"};

    public HelperGenerator(Project project, Model model) {
        super(project);
        this.model = model;
        this.methodBuf = new StringBuilder();
    }

    @Override
    public String process0() {
        String cnt = this.gHelperMethod();
        if (StringUtils.isBlank((String)cnt)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.gGeneratorClassName());
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(cnt);
        if (this.methodBuf.length() > 0) {
            sb.append(CR);
            sb.append((CharSequence)this.methodBuf);
        }
        sb.append(this.gEnd());
        return sb.toString();
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(CR);
        return sb.toString();
    }

    public String getClassExplanation() {
        return this.getClassname();
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.getHelperClassname(this.model);
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.model);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return HelperGenerator.getSubpackageNameAsJavaRule(this.model);
    }

    public static String getSubpackageNameAsJavaRule(Model model) {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, model);
    }

    public static String getPackageNameAsJavaRule(Project project, Model model) {
        return project.getPackage() + "." + HelperGenerator.getSubpackageNameAsJavaRule(model);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            if (importList.contains(this.defaultImportStatement[i])) continue;
            importList.add(this.defaultImportStatement[i]);
        }
        importList.add("jp.jasminesoft.jfc.app.CommonService");
        JavaSourceGenerator.setImportStatement(this.model, this.project, importList);
        if ("presentation".equals(this.model.getType())) {
            Model smodel = null;
            IRNode node = this.model.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                smodel = (Model)node;
            }
            Map<String, Modelitem> itemMap = AppSchemaUtil.createPresentationModelitemMap(this.project, this.model, smodel);
            block1: for (Modelitem o : itemMap.values()) {
                Modelitem mitem;
                IModelitemChoice[] imic;
                if (!(o instanceof Modelitem) || (imic = (mitem = o).getContent()) == null) continue;
                for (int j = 0; j < imic.length; ++j) {
                    Optionfilter of;
                    if (!(imic[j] instanceof Optionfilter) || !"anorm".equals((of = (Optionfilter)imic[j]).getType())) continue;
                    AnormType anormType = AnormManagerGenerator.getAnormType(this.project);
                    if (anormType == AnormType.R5) {
                        importList.add("java.rmi.RemoteException");
                        break block1;
                    }
                    if (anormType != AnormType.R4) break block1;
                    importList.add("jp.jasminesoft.anorm.NormalizeException");
                    break block1;
                }
            }
            importList.add("jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase");
            importList.add("jp.jasminesoft.jfc.model.PresentationContainerBase");
        }
        return importList.toArray(new String[0]);
    }

    protected String gGeneratorClassName() {
        return "//" + this.getClass().getName() + CR;
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            this.classnameman.setPackagename(HelperGenerator.getPackageNameAsJavaRule(this.project, this.model));
        }
        if ((ary = this.getDefaultImport()) != null) {
            this.classnameman.setClassnames(ary);
        }
        sb.append(this.classnameman.outputPackageAndImportCode());
        sb.append("import ");
        if (this.project.getPackage() != null) {
            sb.append(this.project.getPackage());
            sb.append(".");
        }
        sb.append(SUB_PACKAGE_NAME);
        sb.append(".*");
        sb.append(";");
        sb.append(CR);
        sb.append("import ");
        sb.append(this.classnameman.getPackagename());
        sb.append(".*;");
        sb.append(CR);
        if (AppSchemaUtil.isStoreModel(this.model) || AppSchemaUtil.isConditionModel(this.model) || this instanceof HelperButtonControlGenerator) {
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.PARTICIPANTNODENAME;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFCURRENTUSERID;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFCURRENTGROUPID;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFNEXTUSERID;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFNEXTGROUPID;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFNEXTMAIL;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFNEXTUSERIDMAIL;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFNEXTGROUPIDMAIL;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFEVENT;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFLASTEVENT;").append(CR);
            sb.append("import static ").append(this.project.getPackage());
            sb.append(".app.jfcworkstate.JfcworkstateServiceImpl.WFAPPLICANTMAIL;").append(CR);
        }
        if ("presentation".equals(this.model.getType())) {
            sb.append("import static ").append("jp.jasminesoft.jfc.hibernate.NullValue.NULLVALUE;").append(CR);
            Model smodel = AppSchemaUtil.getStoreModel(this.model);
            String packagename_app = AppSchemaUtil.getPackagename_app(smodel, this.project);
            sb.append("import static ");
            sb.append(packagename_app);
            sb.append(JavaSourceGenerator.capFirst(smodel.getId())).append("Helper.*;").append(CR);
        }
        this.addSpecialImportStatement(sb);
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    public void addSpecialImportStatement(StringBuilder sb) {
    }

    protected boolean needsLoggerObject() {
        return true;
    }

    protected String gHelperMethod() {
        String cnt = this.gHelperMethod0();
        if (StringUtils.isBlank((String)cnt)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.needsLoggerObject()) {
            sb.append(this.gLoggerReady(this.getClassname()));
        }
        sb.append(cnt);
        return sb.toString();
    }

    protected abstract String gHelperMethod0();

    protected String gGetModelId(Model smodel) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("private final static String MODELID = \"");
        sb.append(StringUtil.convertJavaString((String)smodel.getId()));
        sb.append("\";");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("public String getModelId() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return MODELID;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

