/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGeneratorAddModelitemCsvHeaderDataMap
extends HelperGeneratorBaseTask {
    protected Project project;
    private Map<String, String> labels;
    protected Logger logger = LogManager.getLogger((String)HelperGeneratorAddModelitemCsvHeaderDataMap.class.getName());

    public HelperGeneratorAddModelitemCsvHeaderDataMap(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    public String getMethodname() {
        return "addModelitemCsvHeaderDataMap";
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        this.labels = AppSchemaUtil.createCsvHeaderMap(smodel, this.model);
        String[] msgParam = new String[]{"rowlist " + this.rman.getValue("helper.comment.addModelitemCsvHeaderDataMap.param.rowlist"), "data " + this.rman.getValue("helper.comment.addModelitemCsvHeaderDataMap.param.data"), "header " + this.rman.getValue("helper.comment.addModelitemCsvHeaderDataMap.param.header"), "p ActionParameter", "manager JFCErrorManager"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.addModelitemCsvHeader"), msgParam, this.rman.getValue("helper.comment.addModelitemCsvHeader.return")));
        sb.append("    ");
        sb.append("public void " + this.getMethodname() + "(");
        sb.append(CR);
        sb.append("            ");
        sb.append("ModelitemCsvRowList rowlist, String[] data, String[] header,");
        sb.append(CR);
        sb.append("            ");
        sb.append("ActionParameter p, JFCErrorManager manager) {");
        sb.append(CR);
        ArrayList<Modelitem> autokeyModelitems = new ArrayList<Modelitem>();
        boolean isMultiple = this.generateMethodCreateHeaderKeyVariable(sb, smodel, autokeyModelitems);
        sb.append(CR);
        this.generateMethodCreateCountVariable(sb, autokeyModelitems, isMultiple);
        sb.append(CR);
        this.generateMethodAddMap(sb, smodel);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private boolean generateMethodCreateHeaderKeyVariable(StringBuilder sb, Model smodel, List<Modelitem> autokeyModelitems) {
        String rkeyMultipleCount = "__jfc_common.csvHeader.multiple_count";
        sb.append("        ");
        sb.append("final String headerCommonMultipleCount =");
        sb.append(CR);
        sb.append("            ");
        sb.append("JFCUtils.getRValue(");
        sb.append("\"__jfc_common.csvHeader.multiple_count\", p.locale);");
        sb.append(CR);
        boolean isMultiple = false;
        for (IModelChoice imc : smodel.getContent()) {
            Modelitem smitem;
            if (!(imc instanceof Modelitem) || !(smitem = (Modelitem)imc).getMultiple()) continue;
            if (smitem.getHasChild()) {
                Modelitem autokeyMitem = AppSchemaUtil.getContainerAutokeyModelitem(smitem.getName(), smodel);
                this.generateMethodCreateHeaderKeyVariableHasChild(sb, smodel, smitem, autokeyMitem);
                autokeyModelitems.add(autokeyMitem);
                continue;
            }
            String label = this.labels.get(smitem.getName());
            String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName(), label);
            JFCAppResourceGenerator.put(rkey, label);
            sb.append("        ");
            sb.append("final String headerModel");
            sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
            sb.append(" =");
            sb.append(CR);
            sb.append("            ");
            sb.append("JFCUtils.getRValue(\"" + rkey + "\", p.locale);");
            sb.append(CR);
            isMultiple = true;
        }
        return isMultiple;
    }

    private void generateMethodCreateHeaderKeyVariableHasChild(StringBuilder sb, Model smodel, Modelitem smitem, Modelitem autokeyMitem) {
        String label = this.labels.get(smitem.getName());
        String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), smitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        sb.append("        ");
        sb.append("final String headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(" =");
        sb.append(CR);
        sb.append("            ");
        sb.append("JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale);");
        sb.append(CR);
        sb.append("        ");
        sb.append("final String headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(" = ");
        sb.append("headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(" + \"/\";");
        sb.append(CR);
        label = this.labels.get(autokeyMitem.getName());
        rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", smodel.getId(), autokeyMitem.getName(), label);
        JFCAppResourceGenerator.put(rkey, label);
        sb.append("        ");
        sb.append("final String headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(" =");
        sb.append(CR);
        sb.append("            ");
        sb.append("JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale);");
        sb.append(CR);
        sb.append("        ");
        sb.append("final String headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(" =");
        sb.append(CR);
        sb.append("            ");
        sb.append("headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(" + headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(";");
        sb.append(CR);
    }

    private void generateMethodCreateCountVariable(StringBuilder sb, ArrayList<Modelitem> autokeyModelitems, boolean isMultiple) {
        if (isMultiple) {
            sb.append("        ");
            sb.append("boolean hascount = false;");
            sb.append(CR);
            sb.append("        ");
            sb.append("int count = -1;");
            sb.append(CR);
        }
        for (Modelitem mitem : autokeyModelitems) {
            String pname = AppSchemaUtil.getParentPart(mitem.getName());
            sb.append("        ");
            sb.append("boolean hascount");
            sb.append(StringUtil.convertJavaVariableString((String)pname));
            sb.append(" = false;");
            sb.append(CR);
            sb.append("        ");
            sb.append("int count");
            sb.append(StringUtil.convertJavaVariableString((String)pname));
            sb.append(" = -1;");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("boolean isError = false;");
        sb.append(CR);
        sb.append("        ");
        sb.append("int len = header.length;");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (int i=0; i<len; i++) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("String h = header[i].trim();");
        sb.append(CR);
        sb.append("            ");
        sb.append("String v = data[i].trim();");
        sb.append(CR);
        this.generateMethodCreateCountVariableLoop(sb, autokeyModelitems, isMultiple);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (isError) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
    }

    private void generateMethodCreateCountVariableLoop(StringBuilder sb, ArrayList<Modelitem> autokeyModelitems, boolean isMultiple) {
        if (isMultiple) {
            this.generateMethodCreateCountVariableLoop1(sb, "headerCommonMultipleCount", "count", "hascount");
        }
        for (Modelitem mitem : autokeyModelitems) {
            String pname = AppSchemaUtil.getParentPart(mitem.getName());
            this.generateMethodCreateCountVariableLoop1(sb, "headerModel" + StringUtil.convertJavaVariableString((String)mitem.getName()), "count" + StringUtil.convertJavaVariableString((String)pname), "hascount" + StringUtil.convertJavaVariableString((String)pname));
        }
    }

    private void generateMethodCreateCountVariableLoop1(StringBuilder sb, String varHeader, String varCount, String varHascount) {
        String rkey = "error.addModelitemCsvHeaderDataMap.illegal_csv_header";
        sb.append("            ");
        sb.append("if (h.equals(" + varHeader + ")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (v.length() > 0) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("try {");
        sb.append(CR);
        sb.append("                        ");
        sb.append(varCount + " = Integer.parseInt(v);");
        sb.append(CR);
        sb.append("                        ");
        sb.append(varHascount + " = true;");
        sb.append(CR);
        sb.append("                    ");
        sb.append("} catch (NumberFormatException e) {");
        sb.append(CR);
        sb.append("                        ");
        sb.append("Object[] oa = {h, v};");
        sb.append(CR);
        sb.append("                        ");
        sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
        sb.append(CR);
        sb.append("                            ");
        sb.append("manager.getJfcerror(\"");
        sb.append("error.addModelitemCsvHeaderDataMap.illegal_csv_header");
        sb.append("\", oa, p.locale);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("p.errors.addJfcerror(_error);");
        sb.append(CR);
        sb.append("                        ");
        sb.append("isError = true;");
        sb.append(CR);
        sb.append("                    ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
    }

    private void generateMethodAddMap(StringBuilder sb, Model smodel) {
        Modelitem smitem;
        for (IModelChoice imc : smodel.getContent()) {
            if (!(imc instanceof Modelitem) || !(smitem = (Modelitem)imc).getMultiple() || !smitem.getHasChild()) continue;
            Modelitem autokeyMitem = AppSchemaUtil.getContainerAutokeyModelitem(smitem.getName(), smodel);
            sb.append("        ");
            sb.append("boolean isOutput");
            sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
            sb.append(" = false;");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("for (int i=0; i<len; i++) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("String h = header[i].trim();");
        sb.append(CR);
        sb.append("            ");
        sb.append("String v = data[i];");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (h.equals(headerCommonMultipleCount)) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        for (IModelChoice imc : smodel.getContent()) {
            if (!(imc instanceof Modelitem) || !(smitem = (Modelitem)imc).getMultiple()) continue;
            if (smitem.getHasChild()) {
                this.generateMethodAddMapHasChild(sb, smodel, smitem);
                continue;
            }
            this.generateMethodAddMapMultiple(sb, smitem);
        }
        sb.append("            ");
        sb.append("rowlist.addData(h, v);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
    }

    private void generateMethodAddMapHasChild(StringBuilder sb, Model smodel, Modelitem smitem) {
        Modelitem autokeyMitem = AppSchemaUtil.getContainerAutokeyModelitem(smitem.getName(), smodel);
        sb.append("            ");
        sb.append("if (h.equals(headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (h.startsWith(headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (!isOutput");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(") {");
        sb.append(CR);
        this.generateMethodAddMapHasChild1("                    ", sb, smitem, autokeyMitem);
        sb.append("                    ");
        sb.append("isOutput");
        sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
        sb.append(" = true;");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        this.generateMethodAddMapHasChild1("                ", sb, smitem, null);
        sb.append("                ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
    }

    private void generateMethodAddMapHasChild1(String tab, StringBuilder sb, Modelitem smitem, Modelitem autokeyMitem) {
        boolean isContainerId = autokeyMitem != null;
        sb.append(tab);
        sb.append("if (hascount");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(") {");
        sb.append(CR);
        sb.append(tab + "    ");
        if (isContainerId) {
            sb.append("rowlist.addContainerIdData(");
        } else {
            sb.append("rowlist.addContainerData(");
        }
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(", count");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(",");
        sb.append(CR);
        sb.append(tab + "        ");
        if (isContainerId) {
            sb.append("headerModel2");
            sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
            sb.append(",");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("Integer.toString(count");
            sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
            sb.append("));");
        } else {
            sb.append("h.substring(headerModel");
            sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
            sb.append(".length()), v);");
        }
        sb.append(CR);
        sb.append(tab);
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "    ");
        if (isContainerId) {
            sb.append("rowlist.addContainerIdDataForAppend(");
        } else {
            sb.append("rowlist.addContainerDataForAppend(");
        }
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("headerModel2");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(",");
        sb.append(CR);
        sb.append(tab + "        ");
        if (isContainerId) {
            sb.append("headerModel2");
            sb.append(StringUtil.convertJavaVariableString((String)autokeyMitem.getName()));
            sb.append(",");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("Integer.toString(count");
            sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
            sb.append("));");
        } else {
            sb.append("h.substring(headerModel");
            sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
            sb.append(".length()), v);");
        }
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    private void generateMethodAddMapMultiple(StringBuilder sb, Modelitem smitem) {
        sb.append("            ");
        sb.append("if (h.equals(headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(")) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (hascount) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("rowlist.addMultipleData(headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(", count, v);");
        sb.append(CR);
        sb.append("                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("rowlist.addMultipleDataForAppend(headerModel");
        sb.append(StringUtil.convertJavaVariableString((String)smitem.getName()));
        sb.append(", v);");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("continue;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
    }
}

