/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGeneratorCheckModelitemCsvHeader
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGeneratorCheckModelitemCsvHeader.class.getName());

    public HelperGeneratorCheckModelitemCsvHeader(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model rmodel = (Model)node;
        String[] msgParam = new String[]{"_header " + this.rman.getValue("helper.comment.checkModelitemCsvHeader.param.header"), "p ActionParameter", "_manager JFCErrorManager"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.checkModelitemCsvHeader"), msgParam, null));
        sb.append("    ");
        sb.append("public boolean checkModelitemCsvHeader(");
        sb.append(CR);
        sb.append("        ");
        sb.append("String[] _header, ActionParameter p, ");
        sb.append("JFCErrorManager _manager)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        IModelChoice[] rimc = rmodel.getContent();
        if (rimc == null || rimc.length == 0) {
            sb.append("        ");
            sb.append("return false;");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            return sb.toString();
        }
        this.gCheckCsvHeader(sb, "        ", this.model, rmodel);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gCheckCsvHeader(StringBuilder sb, String tab, Model model, Model rmodel) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(rmodel);
        if (pkeys.length == 0) {
            sb.append("        ");
            sb.append("return false;");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            return;
        }
        this.gCheckCsvHeaderDefineVarName(sb, tab, pkeys);
        sb.append(tab);
        sb.append("for (String _key : _header) {");
        sb.append(CR);
        this.checkCountColumn(sb, tab);
        Map<String, String> labels = AppSchemaUtil.createCsvHeaderMap(rmodel, model);
        this.checkPrimaryKey(sb, tab, rmodel, pkeys, labels);
        this.checkNormalCsvColumn(sb, tab);
        this.checkMultipleContainer(sb, tab, rmodel, labels);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        this.gCheckCsvHeaderFooter(sb, tab, pkeys);
    }

    private void gCheckCsvHeaderDefineVarName(StringBuilder sb, String tab, PrimaryKey[] pkeys) {
        sb.append(tab);
        sb.append("Set<String> _headerSet = new HashSet<String>(Arrays.asList(_header));");
        sb.append(CR);
        sb.append(tab);
        sb.append("boolean _hasMultipleCount = false;");
        sb.append(CR);
        sb.append(tab);
        if (pkeys.length == 1) {
            sb.append("boolean _hasPrimaryKey = false;");
        } else {
            sb.append("Set<String> _mitemnamePrimaryKey = new HashSet<String>();");
        }
        sb.append(CR);
        sb.append(tab);
        sb.append("List<String> _mitemnameAllCsv = new ArrayList<String>();");
        sb.append(CR);
        sb.append(tab);
        sb.append("Map<String,List<String>> _mitemnameModelitemCsvMultiple =");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("new LinkedHashMap<String,List<String>>();");
        sb.append(CR);
        sb.append(tab);
        sb.append("Map<String,List<String>> _mitemnameModelitemCsvContainer =");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("new LinkedHashMap<String,List<String>>();");
        sb.append(CR);
    }

    private void gCheckCsvHeaderFooter(StringBuilder sb, String tab, PrimaryKey[] pkeys) {
        if (pkeys.length > 1) {
            sb.append(tab);
            sb.append("boolean _hasPrimaryKey = _mitemnamePrimaryKey.size() == " + pkeys.length + ";");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("return checkModelitemCsvHeader(");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_hasMultipleCount, _hasPrimaryKey, _mitemnameAllCsv,");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_mitemnameModelitemCsvMultiple, _mitemnameModelitemCsvContainer,");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p, _manager);");
        sb.append(CR);
    }

    private void checkNormalCsvColumn(StringBuilder sb, String tab) {
        sb.append(tab + "    ");
        sb.append("if (getValidCsvHeader(_key, p, _headerSet)) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_mitemnameAllCsv.add(_key);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("continue;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
    }

    private void checkCountColumn(StringBuilder sb, String tab) {
        String rkey = "__jfc_common.csvHeader.multiple_count";
        sb.append(tab + "    ");
        sb.append("if (");
        sb.append("_key.equals(JFCUtils.getRValue(\"");
        sb.append(rkey);
        sb.append("\", p.locale))) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_hasMultipleCount = true;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("continue;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
    }

    private void checkPrimaryKey(StringBuilder sb, String tab, Model rmodel, PrimaryKey[] pkeys, Map<String, String> labels) {
        for (PrimaryKey pkey : pkeys) {
            String mitemname = pkey.getName();
            Modelitem rmitem = AppSchemaUtil.getModelitem(mitemname, rmodel);
            if (rmitem == null) continue;
            this.checkPrimaryKey(sb, tab, rmodel, pkeys.length > 1, labels, mitemname);
        }
    }

    private void checkPrimaryKey(StringBuilder sb, String tab, Model rmodel, boolean isMultiplePkey, Map<String, String> labels, String mitemname) {
        String label = labels.get(mitemname);
        if (label == null) {
            label = mitemname;
        }
        String rkey1 = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", rmodel.getId(), mitemname, label);
        JFCAppResourceGenerator.put(rkey1, label);
        sb.append(tab + "    ");
        sb.append("if (_key.equals(JFCUtils.getRValue(\"");
        sb.append(rkey1);
        sb.append("\", p.locale))) {");
        sb.append(CR);
        sb.append(tab + "        ");
        if (!isMultiplePkey) {
            sb.append("_hasPrimaryKey = true;");
        } else {
            sb.append("_mitemnamePrimaryKey.add(_key);");
        }
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("continue;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
    }

    private void checkMultipleContainer(StringBuilder sb, String tab, Model rmodel, Map<String, String> labels) {
        List<Modelitem> pmitems = AppSchemaUtil.getMultipleCsvOutputableModelitem(rmodel, this.model);
        for (Modelitem pmitem : pmitems) {
            String mitemname = pmitem.getName();
            Modelitem mitem = AppSchemaUtil.getModelitem(mitemname, rmodel);
            if (!mitem.getHasChild()) {
                this.checkMultiple(sb, tab, rmodel, labels, mitemname);
                continue;
            }
            Modelitem autokeyMitem = AppSchemaUtil.getContainerAutokeyModelitem(mitemname, rmodel);
            if (autokeyMitem == null) continue;
            this.checkContainer(sb, tab, rmodel, labels, mitemname);
        }
    }

    private void checkMultiple(StringBuilder sb, String tab, Model rmodel, Map<String, String> labels, String mitemname) {
        String label = labels.get(mitemname);
        if (label == null) {
            label = mitemname;
        }
        String rkey1 = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", rmodel.getId(), mitemname, label);
        JFCAppResourceGenerator.put(rkey1, label);
        sb.append(tab);
        sb.append("if (_key.equals(JFCUtils.getRValue(\"");
        sb.append(rkey1);
        sb.append("\", p.locale))) {");
        sb.append(CR);
        this.gAddCsvHeader(sb, tab + "    ", mitemname, "_mitemnameModelitemCsvMultiple");
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    private void checkContainer(StringBuilder sb, String tab, Model rmodel, Map<String, String> labels, String pmitemname) {
        Modelitem parentMitem = AppSchemaUtil.getModelitem(pmitemname, rmodel);
        String plabel = labels.get(parentMitem.getName());
        if (plabel == null) {
            plabel = parentMitem.getName();
        }
        String prkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", rmodel.getId(), parentMitem.getName(), plabel);
        JFCAppResourceGenerator.put(prkey, plabel);
        sb.append(tab);
        sb.append("if (_key.startsWith(JFCUtils.getRValue(\"");
        sb.append(prkey);
        sb.append("\", p.locale) + '/')) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("String s = _key.substring(JFCUtils.getRValue(\"");
        sb.append(prkey);
        sb.append("\", p.locale).length() + 1);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (getValidModelitemCsvHeader_" + pmitemname + "(s, p, _headerSet)) {");
        sb.append(CR);
        this.gAddCsvHeader(sb, tab + "        ", pmitemname, "_mitemnameModelitemCsvContainer");
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    private void gAddCsvHeader(StringBuilder sb, String tab, String pmitemname, String varMitemnameMap) {
        sb.append(tab);
        sb.append("List<String> _list = " + varMitemnameMap + ".get(\"" + pmitemname + "\");");
        sb.append(CR);
        sb.append(tab);
        sb.append("if (_list == null) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("_list = new ArrayList<String>();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(varMitemnameMap + ".put(\"" + pmitemname + "\", _list);");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("_list.add(_key);");
        sb.append(CR);
        sb.append(tab);
        sb.append("continue;");
        sb.append(CR);
    }
}

