/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_operation;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc_parser_handler;
import jp.jasminesoft.jfc.gen.IHelperGenerator_calc;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class HelperGenerator_calc_parser
implements IHelperGenerator_calc {
    protected static final String[] funclist = new String[]{"sum", "count", "avg", "max", "min", "first", "last", "slice", "join", "djoin", "ddjoin", "isnoselection", "checkif", "collect"};
    private static Map<String, String> defaultReplaceFunctionMap = new HashMap<String, String>();
    protected static final int FUNC_NONE = -1;
    protected static final int FUNC_SUM = 0;
    protected static final int FUNC_COUNT = 1;
    protected static final int FUNC_AVG = 2;
    protected static final int FUNC_MAX = 3;
    protected static final int FUNC_MIN = 4;
    protected static final int FUNC_FIRST = 5;
    protected static final int FUNC_LAST = 6;
    protected static final int FUNC_SLICE = 7;
    protected static final int FUNC_JOIN = 8;
    protected static final int FUNC_DJOIN = 9;
    protected static final int FUNC_DDJOIN = 10;
    protected static final int FUNC_ISNOSELECTION = 11;
    protected static final int FUNC_COLLECT = 13;
    private HelperGenerator_calc_parser_handler handler;

    public void setHandler(HelperGenerator_calc_parser_handler handler) {
        this.handler = handler;
    }

    public boolean process(String cnt) {
        if (this.handler == null) {
            return false;
        }
        StringBuilder var = null;
        int status = 0;
        boolean varMode = false;
        boolean quoteMode = false;
        boolean success = true;
        boolean isFoundFirstVar = false;
        int length = cnt.length();
        int beginVarnameSeparator = 0;
        for (int i = 0; i < length; ++i) {
            char c = cnt.charAt(i);
            if (c == '\"' && isFoundFirstVar) {
                if (varMode) {
                    boolean bl = quoteMode = !quoteMode;
                    if (var == null) continue;
                    var.append(c);
                    continue;
                }
                this.handler.process_formula_set(c);
                continue;
            }
            if (c == '$' && !quoteMode) {
                if (i + 1 >= length) continue;
                if (cnt.charAt(i + 1) == '{') {
                    varMode = true;
                    ++i;
                    ++beginVarnameSeparator;
                    continue;
                }
                this.handler.process_formula_set(c);
                continue;
            }
            if (c == ')' && varMode && var != null && !quoteMode) {
                if (!isFoundFirstVar) {
                    isFoundFirstVar = true;
                }
                var.append(c);
                continue;
            }
            if (c == '}' && varMode && var != null && !quoteMode) {
                if (--beginVarnameSeparator > 0) continue;
                status = this.handler.process_var_set(var.toString());
                if (status > 1) {
                    this.handler.process_parse_error(status, var.toString());
                    success = false;
                    break;
                }
                varMode = false;
                var = null;
                continue;
            }
            if (varMode) {
                if (var == null) {
                    var = new StringBuilder();
                }
                var.append(c);
                continue;
            }
            this.handler.process_formula_set(c);
        }
        if (varMode && var != null && (status = this.handler.process_var_set(var.toString())) > 1) {
            this.handler.process_parse_error(status, var.toString());
            success = false;
        }
        this.handler.process_finish();
        return success;
    }

    public static int getFunctionType(String var) {
        int retcode = -1;
        if (var == null || var.length() == 0) {
            return retcode;
        }
        for (int i = 0; i < funclist.length; ++i) {
            String rest;
            if (!var.startsWith(funclist[i]) || (rest = var.substring(funclist[i].length())).length() <= 0 || rest.charAt(0) != '(') continue;
            retcode = i;
            break;
        }
        return retcode;
    }

    public static String getModelitemNameIncludingFunction(String var, int funccode) {
        if (var == null || var.length() == 0) {
            return "";
        }
        if (funccode < 0 || funccode >= funclist.length) {
            return "";
        }
        int lastpos = var.endsWith(")") ? var.length() - 1 : var.length();
        String rest = var.substring(funclist[funccode].length() + 1, lastpos);
        return rest;
    }

    public static String normalize(String var) {
        if (var == null || var.length() == 0) {
            return "";
        }
        String ret = StringUtil.removePreAndPostWhitespace((String)var);
        if (ret.charAt(0) == '(' && ret.charAt(ret.length() - 1) == ')') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    public static String convertFunctionNames(String s) {
        return HelperGenerator_calc_parser.convertFunctionNames(s, null, null, null);
    }

    public static String convertFunctionNames(String s, String itemname) {
        return HelperGenerator_calc_parser.convertFunctionNames(s, null, itemname, null);
    }

    public static String convertFunctionNames(String s, Map<String, String> replaceFunctionMap) {
        return HelperGenerator_calc_parser.convertFunctionNames(s, replaceFunctionMap, null, null);
    }

    public static String convertFunctionNames(String s, Map<String, String> replaceFunctionMap, String itemname, Model model) {
        Object s2;
        StringBuilder sb;
        StringBuilder stmt;
        String helperClassname;
        String id;
        String classname;
        Map<String, String> targetMap = null;
        if (replaceFunctionMap == null || replaceFunctionMap.size() == 0) {
            targetMap = defaultReplaceFunctionMap;
        } else {
            targetMap = replaceFunctionMap;
            for (Map.Entry<String, String> entry : defaultReplaceFunctionMap.entrySet()) {
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
        while (((String)s).indexOf("WF_IS_ADMITUSER(") >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
            String classname2 = AppSchemaUtil.getClassname(model);
            String string = model.getId();
            String helperClassname2 = classname2 + "Helper";
            StringBuilder stmt2 = new StringBuilder();
            stmt2.append("((").append(helperClassname2).append(")p.appctx.getBean(\"");
            stmt2.append(helperClassname2).append("\"))");
            stmt2.append(".wf_isadmituser(p, \"").append(model.getId()).append("\", ").append(string);
            s = StringUtil.replace((String)s, (String)"WF_IS_ADMITUSER(", (String)stmt2.toString());
        }
        while (((String)s).indexOf("WF_LASTPROCESSDATE(") >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
            String modelId = HelperGenerator_calc_parser.getWorkflowModelId(model);
            String string = AppSchemaUtil.getClassname(model);
            String id3 = model.getId();
            String helperClassname3 = string + "Helper";
            StringBuilder stmt3 = new StringBuilder();
            stmt3.append("((").append(helperClassname3).append(")p.appctx.getBean(\"");
            stmt3.append(helperClassname3).append("\"))");
            stmt3.append(".wf_lastprocessdate(p, \"").append(modelId).append("\", ").append(id3);
            s = StringUtil.replace((String)s, (String)"WF_LASTPROCESSDATE(", (String)stmt3.toString());
        }
        while ((((String)s).indexOf("WF_LASTPROCESS_USERID(") >= 0 || ((String)s).indexOf("WF_LASTPROCESS_USERNAME(") >= 0) && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
            String funcName = StringUtils.substringBefore((String)s, (String)"(");
            String string = StringUtils.lowerCase((String)funcName);
            String modelId = HelperGenerator_calc_parser.getWorkflowModelId(model);
            classname = AppSchemaUtil.getClassname(model);
            id = model.getId();
            helperClassname = classname + "Helper";
            stmt = new StringBuilder();
            stmt.append("((").append(helperClassname).append(")p.appctx.getBean(\"");
            stmt.append(helperClassname).append("\")).");
            stmt.append(string).append("(p, \"").append(modelId).append("\", ").append(id);
            s = StringUtil.replace((String)s, (String)(funcName + "("), (String)stmt.toString());
        }
        while (((String)s).indexOf("AGCOUNT(") >= 0 && model != null && "store".equals(model.getType())) {
            int ptr = ((String)s).indexOf("AGCOUNT(");
            String string = ((String)s).substring(0, ptr);
            sb = new StringBuilder();
            sb.append(string);
            sb.append("JFCUtils.getAggregateCount(p, ");
            sb.append("\"").append(model.getId()).append("\", ");
            s = sb.toString();
        }
        while (((String)s).indexOf("AGSUM(") >= 0 && model != null && "store".equals(model.getType())) {
            int ptr = ((String)s).indexOf("AGSUM(");
            String string = ((String)s).substring(0, ptr);
            sb = new StringBuilder();
            sb.append(string);
            sb.append("JFCUtils.getAggregateSum(p, ");
            sb.append("\"").append(model.getId()).append("\", ");
            s = sb.toString();
        }
        while (((String)s).indexOf("AGAVG(") >= 0 && model != null && "store".equals(model.getType())) {
            int ptr = ((String)s).indexOf("AGAVG(");
            String string = ((String)s).substring(0, ptr);
            sb = new StringBuilder();
            sb.append(string);
            sb.append("JFCUtils.getAggregateAvg(p, ");
            sb.append("\"").append(model.getId()).append("\", ");
            s = sb.toString();
        }
        while (((String)s).indexOf("AGMAX(") >= 0 && model != null && "store".equals(model.getType())) {
            int ptr = ((String)s).indexOf("AGMAX(");
            String string = ((String)s).substring(0, ptr);
            sb = new StringBuilder();
            sb.append(string);
            sb.append("JFCUtils.getAggregateMax(p, ");
            sb.append("\"").append(model.getId()).append("\", ");
            s = sb.toString();
        }
        while (((String)s).indexOf("AGMIN(") >= 0 && model != null && "store".equals(model.getType())) {
            int ptr = ((String)s).indexOf("AGMIN(");
            String string = ((String)s).substring(0, ptr);
            sb = new StringBuilder();
            sb.append(string);
            sb.append("JFCUtils.getAggregateMin(p, ");
            sb.append("\"").append(model.getId()).append("\", ");
            s = sb.toString();
        }
        while (((String)s).indexOf("SESSION(") >= 0 && !((String)s).equals(s2 = HelperGenerator_calc_operation.preprocess_conv_session((String)s, itemname))) {
            s = s2;
        }
        for (Map.Entry entry : targetMap.entrySet()) {
            while (((String)s).indexOf((String)entry.getKey()) >= 0) {
                s = StringUtil.replace((String)s, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
            }
        }
        if (((String)s).indexOf("Me()") >= 0 && AppSchemaUtil.getModelitem(itemname, model) != null) {
            s = HelperGenerator_calc_operation.preprocess_replace((String)s, "Me()", "${" + itemname + "}");
        }
        if (StringUtils.isNotBlank((CharSequence)itemname)) {
            String[] functionPrefixes;
            int n;
            int n2;
            StringBuilder sb2;
            String beforePart;
            String afterPart;
            Model smodel;
            Model model2 = smodel = model != null ? AppSchemaUtil.getStoreModel(model) : null;
            if (model != null) {
                Modelitem _c_id;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\"");
                stringBuilder.append(smodel.getId()).append("_").append(AppSchemaUtil.getChildPart(itemname)).append("_");
                stringBuilder.append("\"");
                stringBuilder.append(" + getPrimaryKeyAsString(").append(smodel.getId()).append(", p)");
                if (AppSchemaUtil.hasChildPart(itemname) && (_c_id = AppSchemaUtil.getContainerIdItem(itemname, model)) != null) {
                    stringBuilder.append(" + \"_\" + ");
                    stringBuilder.append("__").append(AppSchemaUtil.getParentPart(itemname));
                    stringBuilder.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(_c_id.getName())));
                }
                itemname = stringBuilder.toString();
            }
            while (((String)s).indexOf("RAND()") >= 0) {
                int n3 = ((String)s).indexOf("RAND()");
                String beforePart2 = ((String)s).substring(0, n3);
                afterPart = ((String)s).substring(n3 + "RAND()".length());
                StringBuilder sb22 = new StringBuilder();
                sb22.append(beforePart2);
                sb22.append("JFCUtils.__rand(");
                sb22.append(itemname);
                sb22.append(", p)");
                sb22.append(afterPart);
                s = sb22.toString();
            }
            while (((String)s).indexOf("RANDBETWEEN(") >= 0) {
                int n4 = ((String)s).indexOf("RANDBETWEEN(");
                beforePart = ((String)s).substring(0, n4);
                afterPart = ((String)s).substring(n4 + "RANDBETWEEN(".length());
                sb2 = new StringBuilder();
                sb2.append(beforePart);
                sb2.append("JFCUtils.__randbetween(");
                sb2.append(itemname);
                sb2.append(", p, ");
                sb2.append(afterPart);
                s = sb2.toString();
            }
            while (((String)s).indexOf("RANDSTR(") >= 0) {
                int n5 = ((String)s).indexOf("RANDSTR(");
                beforePart = ((String)s).substring(0, n5);
                afterPart = ((String)s).substring(n5 + "RANDSTR(".length());
                sb2 = new StringBuilder();
                sb2.append(beforePart);
                sb2.append("JFCUtils.__randstr(");
                sb2.append(itemname);
                sb2.append(", p, ");
                sb2.append(afterPart);
                s = sb2.toString();
            }
            boolean bl = false;
            while (((String)s).indexOf("WF_USERID(", n2) >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
                int ptr = ((String)s).indexOf("WF_USERID(");
                for (int i = ptr + "WF_USERID(".length(); i < ((String)s).length(); ++i) {
                    char ch = ((String)s).charAt(i);
                    if (ch != ')') continue;
                    n2 = i;
                    break;
                }
                classname = AppSchemaUtil.getClassname(model);
                id = model.getId();
                helperClassname = classname + "Helper";
                stmt = new StringBuilder();
                stmt.append("((").append(helperClassname).append(")p.appctx.getBean(\"");
                stmt.append(helperClassname).append("\"))");
                stmt.append(".wf_nextuserid(p, \"").append(model.getId()).append("\", ").append(id);
                s = StringUtil.replace((String)s, (String)"WF_USERID(", (String)stmt.toString());
            }
            boolean bl2 = false;
            while (((String)s).indexOf("WF_GROUPID(", n) >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
                int ptr = ((String)s).indexOf("WF_GROUPID(");
                for (int i = ptr + "WF_GROUPID(".length(); i < ((String)s).length(); ++i) {
                    char ch = ((String)s).charAt(i);
                    if (ch != ')') continue;
                    n = i;
                    break;
                }
                classname = AppSchemaUtil.getClassname(model);
                id = model.getId();
                helperClassname = classname + "Helper";
                stmt = new StringBuilder();
                stmt.append("((").append(helperClassname).append(")p.appctx.getBean(\"");
                stmt.append(helperClassname).append("\"))");
                stmt.append(".wf_nextgroupid(p, \"").append(model.getId()).append("\", ").append(id);
                s = StringUtil.replace((String)s, (String)"WF_GROUPID(", (String)stmt.toString());
            }
            while (((String)s).indexOf("WF_APPLICANT(") >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
                String modelId = HelperGenerator_calc_parser.getWorkflowModelId(model);
                classname = AppSchemaUtil.getClassname(model);
                id = model.getId();
                helperClassname = classname + "Helper";
                stmt = new StringBuilder();
                stmt.append("((").append(helperClassname).append(")p.appctx.getBean(\"");
                stmt.append(helperClassname).append("\"))");
                stmt.append(".wf_applicant_userid(p, \"").append(modelId).append("\", ").append(id);
                s = StringUtil.replace((String)s, (String)"WF_APPLICANT(", (String)stmt.toString());
            }
            for (String functionPrefix : functionPrefixes = new String[]{"WF_NEXT_USERID_MAIL(", "WF_NEXT_GROUPID_MAIL(", "WF_NEXT_MAIL(", "WF_APPLICANT_MAIL("}) {
                int n6 = 0;
                while (((String)s).indexOf(functionPrefix, n6) >= 0 && model != null && "store".equals(model.getType()) && model.getWorkflow()) {
                    int ptr = ((String)s).indexOf(functionPrefix);
                    String beforePart3 = ((String)s).substring(0, ptr);
                    StringBuilder sb3 = new StringBuilder();
                    sb3.append(beforePart3);
                    sb3.append(functionPrefix.replace("_", ""));
                    sb3.append("p, ").append(model.getId()).append(", ");
                    s = sb3.toString();
                }
            }
        }
        return s;
    }

    protected static String getWorkflowModelId(Model model) {
        Model mainModel = AppSchemaUtil.getMainModel(model);
        if (mainModel == null) {
            return model.getId();
        }
        if (mainModel.getWorkflow()) {
            return mainModel.getId();
        }
        return model.getId();
    }

    static {
        defaultReplaceFunctionMap.put("TODAY()", "(java.sql.Date)p.request.getAttribute(\"__jfc_V_TODAY\")");
        defaultReplaceFunctionMap.put("NOW()", "(java.sql.Timestamp)p.request.getAttribute(\"__jfc_V_NOW\")");
        defaultReplaceFunctionMap.put("ANORMPART(", "NormalizeServerManager.getAnormResult(");
        defaultReplaceFunctionMap.put("USERNAME()", "((p.user!=null)?p.user.getUsername():\"\")");
        defaultReplaceFunctionMap.put("HASPRINCIPAL(", "JFCUtils.hasPrincipal(p.user,");
        defaultReplaceFunctionMap.put("USERINFO(", "JFCUtils.getJuserAttribute(p, ");
        defaultReplaceFunctionMap.put("HASMODELPERMISSION(", "JFCUtils.isValidPermission(p.user,");
        defaultReplaceFunctionMap.put("LOCALE()", "JFCUtils.getLocale(p)");
        defaultReplaceFunctionMap.put("LOCALEPART(", "JFCUtils.interpretContentByLocale(p, ");
        defaultReplaceFunctionMap.put("SCREENID()", "(String)p.request.getAttribute(\"__jfc_screen_id\")");
        defaultReplaceFunctionMap.put("SCREENUID()", "(String)p.request.getAttribute(\"__jfc_screen_nid\")");
        defaultReplaceFunctionMap.put("SCREENTYPE()", "(String)p.request.getAttribute(\"__jfc_screen_type\")");
        defaultReplaceFunctionMap.put("WIZARDPAGE()", "JFCUtils.getWizardPage(p)");
        defaultReplaceFunctionMap.put("RESULTSIZE()", "JFCUtils.getResultSize(p)");
        defaultReplaceFunctionMap.put("EVENT()", "JFCUtils.getEvent(p)");
        defaultReplaceFunctionMap.put("BROWSERTYPE()", "(String)p.request.getAttribute(\"__jfc_browser_type\")");
        defaultReplaceFunctionMap.put("CHANGELOG()", "JFCUtils.getAllChangelog(p)");
        defaultReplaceFunctionMap.put("GETOBJECT(", "JFCUtils.getObjectInRequestOrSessionAttribute(p, ");
        defaultReplaceFunctionMap.put("ATTRIBUTE(", "JFCUtils.getObjectInRequestOrSessionAttribute(p, ");
        defaultReplaceFunctionMap.put("WF_NEXT_USERID(", "WFNEXTUSERID(p, ");
        defaultReplaceFunctionMap.put("WF_NEXT_GROUPID(", "WFNEXTGROUPID(p, ");
        defaultReplaceFunctionMap.put("WF_CURRENT_USERID(", "WFCURRENTUSERID(p, ");
        defaultReplaceFunctionMap.put("WF_CURRENT_GROUPID(", "WFCURRENTGROUPID(p, ");
        defaultReplaceFunctionMap.put("WF_LASTPROCESSDATE(", "WFLASTPROCESSDATE(p, ");
        defaultReplaceFunctionMap.put("WF_EVENT(", "WFEVENT(p, ");
        defaultReplaceFunctionMap.put("WF_LASTEVENT(", "WFLASTEVENT(p, ");
        defaultReplaceFunctionMap.put("WF_APPLICANT_USERID(", "WFAPPLICANTUSERID(p, ");
        defaultReplaceFunctionMap.put("WF_LASTPROCESS_USERID(", "WFLASTPROCESSUSERID(p, ");
        defaultReplaceFunctionMap.put("WF_LASTPROCESS_USERNAME(", "WFLASTPROCESSUSERNAME(p, ");
        defaultReplaceFunctionMap.put("WORKDAY(", "HolidayManager.getInstance().getEigyoDayAsSQLDate(");
        defaultReplaceFunctionMap.put("NETWORKDAYS(", "HolidayManager.getInstance().getRestDay(");
        defaultReplaceFunctionMap.put("JGROUPID()", "JFCUtils.getJgroupid(p.user)");
        defaultReplaceFunctionMap.put("ISREST()", "JFCUtils.isRestAPI(p)");
        defaultReplaceFunctionMap.put("MESSAGE(", "JFCUtils.Message(p, ");
        defaultReplaceFunctionMap.put("ERRORMESSAGE(", "JFCUtils.ErrorMessage(p, ");
        defaultReplaceFunctionMap.put("HTTPSEND(", "ExcelFunction.httpsend(p.request, ");
        defaultReplaceFunctionMap.put("CLIENTHOST(", "JFCUtils.getRealIP(p.request");
        defaultReplaceFunctionMap.put("CLIENTHOSTNAME(", "JFCUtils.getClientHostname(p.request");
        defaultReplaceFunctionMap.put("SERVERHOSTNAME(", "JFCUtils.getServerIP(");
        defaultReplaceFunctionMap.put("GETENV(", "JFCUtils.getEnv(");
    }
}

