/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.LinkedHashSet;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_clearNullContent
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_clearNullContent.class.getName());

    public HelperGenerator_clearNullContent(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String classname = AppSchemaUtil.getClassname(this.model);
        String id = this.model.getId();
        Model rmodel = (Model)node;
        String rid = rmodel.getId();
        String fullclassname = null;
        if (rmodel.getType().equals("list") && this.model.getUpdatelist()) {
            rmodel = (Model)rmodel.getIdrefAsIRNode();
            classname = "Item";
            fullclassname = packagename + classname;
        } else {
            fullclassname = classname;
        }
        String[] msg_param = new String[]{id + " " + classname};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.clearNullContent"), msg_param, null));
        sb.append("    ");
        sb.append("public void clearNullContent(");
        sb.append(fullclassname);
        sb.append(" ");
        sb.append(id).append(") {");
        sb.append(CR);
        StringBuilder asb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        if (imc != null) {
            Modelitem pitem;
            Modelitem mitem;
            int i;
            LinkedHashSet<Modelitem> mitemSet = new LinkedHashSet<Modelitem>();
            for (i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Modelitem) || (mitem = AppSchemaUtil.getModelitem((pitem = (Modelitem)imc[i]).getName(), rmodel)) == null) continue;
                mitemSet.add(mitem);
            }
            for (i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Modelitem) || (mitem = AppSchemaUtil.getModelitem((pitem = (Modelitem)imc[i]).getName(), rmodel)) == null) continue;
                sb.append(this.gModelitemProcess(mitem, this.model, rmodel, "        ", 0, id, rid, mitemSet, asb));
            }
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append((CharSequence)asb);
        return sb.toString();
    }

    protected String gModelitemProcess(Modelitem item, Model model, Model rmodel, String basetab, int nestlevel, String id, String rid, Set<Modelitem> mitemSet, StringBuilder asb) {
        String item_name;
        if (item.getGeneration()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (item.getHasChild() && !model.getUpdatelist()) {
            String pname = AppSchemaUtil.getParentPart(item.getName()) + "/";
            int count = 0;
            for (Modelitem mitem : mitemSet) {
                String name = mitem.getName();
                if (!name.startsWith(pname)) continue;
                ++count;
            }
            if (count > 0) {
                sb.append(this.gHasChild(item, model, rmodel, basetab, nestlevel, id, rid, mitemSet, asb));
                return sb.toString();
            }
        }
        if (AppSchemaUtil.hasChildPart(item_name = item.getName()) && nestlevel == 0) {
            return "";
        }
        String cname = AppSchemaUtil.getChildPart(item_name);
        if (this.isMultiple(rid, item)) {
            sb.append("        ").append("clearNullContentMulti(").append(id).append(", ");
            sb.append(AppSchemaUtil.getPackagename(model, this.project));
            sb.append(AppSchemaUtil.getModelitemClassname(item)).append(".class, ");
            sb.append("\"").append(cname).append("\");").append(CR);
        } else {
            sb.append("        ").append("clearNullContent(").append(id).append(", ");
            sb.append(AppSchemaUtil.getPackagename(model, this.project));
            sb.append(AppSchemaUtil.getModelitemClassname(item)).append(".class, ");
            sb.append("\"").append(cname).append("\");").append(CR);
        }
        return sb.toString();
    }

    private boolean isMultiple(String modelid, Modelitem item) {
        Modelitem refmitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, modelid, item);
        String type = refmitem.getType();
        return item.getMultiple() || type.equals("storeref") || type.equals("masterref") || "combo".equals(item.getDualinputmethod());
    }

    protected String gHasChild(Modelitem item, Model model, Model rmodel, String basetab, int nestlevel, String id, String rid, Set<Modelitem> mitemSet, StringBuilder asb) {
        String prename;
        StringBuilder sb = new StringBuilder();
        if (nestlevel > 16) {
            this.logger.error(this.rman.getValue("helper.comment.nestover", model.getId()));
            return sb.toString();
        }
        String varname = prename = SourceGenerator.getElementNameByNestLevel(item.getName(), nestlevel);
        String pre_fullname = SourceGenerator.getFullNameByNestLevel(item.getName(), nestlevel);
        Modelitem pre_mitem = AppSchemaUtil.getModelitem(pre_fullname, model);
        String pre_mitem_classname = AppSchemaUtil.getModelitemClassname(pre_mitem);
        id = id == null ? model.getId() : id;
        rid = rid == null ? rmodel.getId() : rid;
        String packagename = AppSchemaUtil.getPackagename(model, this.project);
        String instancename = varname + "_p";
        sb.append(basetab);
        sb.append("{");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(packagename);
        sb.append(pre_mitem_classname + "[] ");
        sb.append(varname + "_ary = ");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (");
        sb.append("ArrayUtils.isNotEmpty(").append(varname).append("_ary)) {").append(CR);
        sb.append(basetab + "        ");
        sb.append("for (").append(packagename).append(pre_mitem_classname);
        sb.append(" ").append(instancename).append(" : ").append(varname).append("_ary) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("clearNullContent_" + varname + "(");
        sb.append(id).append(", ").append(varname + "_p);");
        sb.append(CR);
        this.gHasChild_container(item, model, rmodel, asb, nestlevel, id, rid, varname, mitemSet);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    private void gHasChild_container(Modelitem item, Model model, Model rmodel, StringBuilder asb, int nestlevel, String id, String rid, String varname, Set<Modelitem> mitemSet) {
        String classname = AppSchemaUtil.getClassname(model);
        String packagename = AppSchemaUtil.getPackagename(model, this.project);
        String pre_fullname = SourceGenerator.getFullNameByNestLevel(item.getName(), nestlevel);
        Modelitem pre_mitem = AppSchemaUtil.getModelitem(pre_fullname, model);
        String pre_mitem_classname = AppSchemaUtil.getModelitemClassname(pre_mitem);
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("public void clearNullContent_" + varname + "(");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname);
        sb.append(" ");
        sb.append(id + ",");
        sb.append(CR);
        sb.append("        ");
        sb.append(packagename);
        sb.append(pre_mitem_classname);
        sb.append(" ");
        sb.append(varname + "_p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        IModelChoice[] imc = rmodel.getContent();
        if (imc == null) {
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            asb.append((CharSequence)sb);
            return;
        }
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Modelitem)) continue;
            Modelitem _item = (Modelitem)imc[i];
            String _name = _item.getName();
            if (_name.charAt(0) == '/') {
                _name = _name.substring(1);
            }
            if (!_name.startsWith(varname + "/") && _name.indexOf("/" + varname + "/") <= 0 || _name.equals(varname + "/")) continue;
            sb.append(this.gModelitemProcess(_item, model, rmodel, "        ", nestlevel + 1, varname + "_p", varname, mitemSet, asb));
        }
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        asb.append((CharSequence)sb);
    }
}

