/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Filesize;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.FileUtil;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_filesize
extends HelperGeneratorBaseTask {
    protected Filesize filesize;
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_filesize.class.getName());

    public HelperGenerator_filesize(Project project, Model model, Modelitem item, Filesize filesize) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.filesize = filesize;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        boolean isZipCodeFlag = false;
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
            Modelitem sitem = AppSchemaUtil.getModelitem(this.item.getName(), smodel);
            if (sitem != null) {
                isZipCodeFlag = AppSchemaUtil.isZipCode(this.project, sitem, smodel);
            }
        }
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.filesize"));
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("if (StringUtils.isNotEmpty(s)) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("Object[] o = { ");
        sb.append("JFCUtils.getRValue(\"" + rkey + "\", p.locale), null, null");
        sb.append(" };");
        sb.append(CR);
        if (isZipCodeFlag) {
            sb.append(basetab + "            ");
            sb.append("if (s.length() > 0 && s.charAt(0) == '$')");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("s = s.substring(1);");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append("JFCUtils.waitUntilCanRead(s);").append(CR);
        sb.append(basetab + "            ");
        sb.append("long filelen = new File(s).length();");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("o[1] = Long.valueOf(filelen);");
        sb.append(CR);
        String maxstr = this.filesize.getMax();
        long max = -1L;
        if (maxstr != null) {
            try {
                max = FileUtil.getNumber((String)maxstr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (max < 0L) {
                this.logger.error("Illegal filesize element max attribute value " + maxstr);
            }
        }
        if (max >= 0L) {
            sb.append(basetab + "            ");
            sb.append("final long _max = " + max + "L;");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("if (filelen > _max) {");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("o[2] = Long.valueOf(_max);");
            sb.append(CR);
            this.generateSetErrorMessageCode(sb, basetab + "                ", this.filesize.getWarning(), name, this.createErrorCode("error.input.filesize.max"), rkey, relation);
            sb.append(basetab + "            ");
            sb.append("}");
            sb.append(CR);
        }
        String minstr = this.filesize.getMin();
        long min = -1L;
        if (minstr != null) {
            try {
                min = FileUtil.getNumber((String)minstr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (min < 0L) {
                this.logger.error("Illegal filesize element min attribute value " + minstr);
            }
        }
        if (min >= 0L) {
            sb.append(basetab + "            ");
            sb.append("final long _min = " + min + ";");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("if (filelen < _min) {");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("o[2] = Long.valueOf(_min);");
            sb.append(CR);
            this.generateSetErrorMessageCode(sb, basetab + "                ", this.filesize.getWarning(), name, "error.input.filesize.min", rkey, relation);
            sb.append(basetab + "            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }

    private void generateSetErrorMessageCode(StringBuilder sb, String tab, boolean warning, String name, String messageresourcekey, String rkey, Relation relation) {
        if (warning) {
            sb.append(tab);
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("manager.getJfcwarn(\"");
            sb.append(name).append("\", \"");
            sb.append(messageresourcekey + "\", o, p.locale);");
            sb.append(CR);
            sb.append(tab);
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(rkey);
            sb.append("\", \"" + messageresourcekey + "\");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, tab);
        } else {
            sb.append(tab);
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("manager.getJfcerror(\"");
            sb.append(name).append("\", \"");
            sb.append(messageresourcekey + "\", o, p.locale);");
            sb.append(CR);
            sb.append(tab);
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, tab);
        }
    }

    public static void main(String[] arg) throws Exception {
        System.out.println("arg[0]=" + arg[0]);
        System.out.println("getNumber(arg[0])=" + FileUtil.getNumber((String)arg[0]));
    }
}

