/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AnormManagerGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperPresentationGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_filter
extends HelperPresentationGenerator {
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_filter.class.getName());
    private String packagename;
    private String classname;
    private String fullclassname;
    private Model smodel;
    Map<String, String> filterMap = null;

    public HelperGenerator_filter(Project project, Model model) {
        super(project, model);
        this.smodel = (Model)model.getIdrefAsIRNode();
        this.packagename = AppSchemaUtil.getPackagename(model, project);
        this.classname = AppSchemaUtil.getClassname(model);
        if (this.smodel.getType().equals("list") && model.getUpdatelist()) {
            this.smodel = (Model)this.smodel.getIdrefAsIRNode();
            this.classname = "Item";
            this.fullclassname = this.packagename + this.classname;
        } else {
            this.fullclassname = this.classname;
        }
        this.filterMap = new LinkedHashMap<String, String>();
    }

    @Override
    public String getClassname() {
        AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project, "FilterHelper");
        return AppSchemaUtil.getHelperClassname(this.model, "FilterHelper");
    }

    protected boolean needsFilterObject() {
        return true;
    }

    @Override
    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends jp.jasminesoft.jfc.app.FilterHelper");
        sb.append("<").append(this.fullclassname).append(">");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gHelperMethod0() {
        StringBuilder sb = new StringBuilder();
        String id = this.model.getId();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        String[] msg_param = new String[]{id + " " + this.classname, "filterman Filter Manager", "itemSet set of the target"};
        sb.append(CommentGenerator.gComment(rman.getValue("struts.comment.filtering"), msg_param, null));
        sb.append("    ");
        sb.append("protected void filter0(");
        sb.append(this.fullclassname);
        sb.append(" ");
        sb.append(id);
        sb.append(", FilterManager filterman,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Set<String> itemSet)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        Map<String, Modelitem> itemMap = AppSchemaUtil.createPresentationModelitemMap(this.project, this.model, this.smodel);
        Object[] actions = AppSchemaUtil.getActionByModelId(this.project, this.smodel.getId());
        sb.append("$$$FILTERMAPCODE$$$");
        HashSet<String> processedItemNameSet = new HashSet<String>();
        IModelChoice[] simc = this.smodel.getContent();
        if (simc != null) {
            sb.append(CR);
            for (int i = 0; i < simc.length; ++i) {
                String fsrc;
                String elementname;
                Modelitem sitem;
                if (!(simc[i] instanceof Modelitem) || processedItemNameSet.contains((sitem = (Modelitem)simc[i]).getName()) || AppSchemaUtil.isGenerationModelitem(sitem.getName(), this.smodel)) continue;
                if (JavaSourceGenerator.isStringType(sitem.getType()) && ArrayUtils.isNotEmpty((Object[])actions)) {
                    boolean isRichTextarea = false;
                    block1: for (Object action : actions) {
                        Object[] presentations = AppSchemaUtil.getPresentation(this.project, (Action)action);
                        if (ArrayUtils.isEmpty((Object[])presentations)) continue;
                        for (Object presentation : presentations) {
                            Displayitem ditem = AppSchemaUtil.getDisplayitem(sitem.getName(), (Presentation)presentation);
                            if (ditem == null || !"rtextarea".equals(ditem.getType())) continue;
                            isRichTextarea = true;
                            break block1;
                        }
                    }
                    if (isRichTextarea) continue;
                }
                if ((elementname = sitem.getName()).charAt(0) == '/') {
                    elementname = elementname.substring(1);
                }
                int nestlevel = elementname.indexOf("/") > 0 ? 1 : 0;
                elementname = SourceGenerator.getElementNameByNestLevel(elementname, nestlevel);
                if (this.model.getUpdatelist()) {
                    boolean isok = false;
                    IModelChoice[] imc = this.model.getContent();
                    for (int j = 0; j < imc.length; ++j) {
                        Modelitem item;
                        if (!(imc[j] instanceof Modelitem) || !(item = (Modelitem)imc[j]).getName().equals(sitem.getName())) continue;
                        isok = true;
                        break;
                    }
                    if (!isok) continue;
                }
                if ((fsrc = this.gModelitemProcess(sitem, this.smodel, itemMap, "    ", nestlevel, null, null, processedItemNameSet)) == null || fsrc.length() <= 0) continue;
                sb.append("        ");
                sb.append("if (itemSet == null");
                sb.append(" || itemSet.contains(\"");
                sb.append(elementname);
                sb.append("\")");
                sb.append(") {");
                sb.append(CR);
                sb.append(fsrc);
                sb.append("        ");
                sb.append("}");
                sb.append(CR);
            }
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString().replace("$$$FILTERMAPCODE$$$", this.gFilterInitializeCode(this.filterMap, "        "));
    }

    protected String gFilterInitializeCode(Map<String, String> filterMap, String tab) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> uniqueCheckSet = new HashSet<String>();
        for (String filtername : filterMap.values()) {
            if (uniqueCheckSet.contains(filtername)) continue;
            uniqueCheckSet.add(filtername);
            sb.append(tab);
            sb.append("StringFilter ");
            sb.append(filtername);
            sb.append(" = filterman.getFilter(\"");
            sb.append(filtername);
            sb.append("\");");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gModelitemProcess(Modelitem ritem, Model rmodel, Map<String, Modelitem> itemMap, Set<String> processedItemNameSet) {
        return this.gModelitemProcess(ritem, rmodel, itemMap, "", 0, null, null, processedItemNameSet);
    }

    protected String gModelitemProcess(Modelitem ritem, Model rmodel, Map<String, Modelitem> itemMap, String basetab, int nestlevel, String id, String rid, Set<String> processedItemNameSet) {
        Relation _rrelation;
        String filtername;
        StringBuilder sb = new StringBuilder();
        Modelitem item = itemMap.get(ritem.getName());
        if (item == null) {
            return sb.toString();
        }
        if (ritem.getHasChild()) {
            sb.append(this.gHasChild(ritem, rmodel, itemMap, basetab, nestlevel, id, rid, processedItemNameSet));
            return sb.toString();
        }
        boolean isUpdateList = false;
        if (this.model.getUpdatelist()) {
            isUpdateList = true;
        }
        String string = filtername = item != null ? item.getFilter() : null;
        if (filtername == null || filtername.length() == 0) {
            if ("storeref".equals(ritem.getType())) {
                // empty if block
            }
            if (AppSchemaUtil.isAnormOption(item) && !isUpdateList) {
                sb.append(this.gAdaptFilter_anorm(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel));
            }
            return sb.toString();
        }
        String rtype = ritem.getType();
        if ("storeref".equals(rtype.toLowerCase()) && (_rrelation = AppSchemaUtil.getRelationTypeIsRef(ritem)) != null) {
            String p_ritem_filter;
            Modelitem p_ritem;
            Modelitem refmitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.model.getId(), ritem);
            rtype = refmitem.getType();
            if (!ritem.getTransient() && (p_ritem = AppSchemaUtil.getModelitem(ritem.getName(), this.model)) != null && StringUtils.isNotBlank((CharSequence)(p_ritem_filter = p_ritem.getFilter()))) {
                filtername = p_ritem_filter;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filtername) && !"storeref".equals(rtype)) {
            this.filterMap.put(AppSchemaUtil.getChildPart(ritem.getName()), filtername);
        }
        boolean isControlFlag = AppSchemaUtil.isControl(item);
        if (ritem.getMultiple() && !"condition".equals(rmodel.getType())) {
            sb.append(this.gAdaptMultiFilter(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel));
        } else if ("masterref".equals(rtype)) {
            sb.append(this.gAdaptRefFilter(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel, false));
        } else if ("storeref".equals(rtype)) {
            sb.append(this.gAdaptStorerefFilter(ritem, rmodel, id == null ? this.model.getId() : id, basetab, nestlevel, isControlFlag));
        } else if ("combo".equals(ritem.getDualinputmethod())) {
            if ("store".equals(rmodel.getType())) {
                sb.append(this.gAdaptRefFilter(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel));
            }
        } else if (AppSchemaUtil.isAnormOption(item) && !isUpdateList) {
            sb.append(this.gAdaptFilter_anorm(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel));
        } else {
            sb.append(this.gAdaptFilter(ritem, this.model, id == null ? this.model.getId() : id, filtername, basetab, nestlevel, isControlFlag));
        }
        processedItemNameSet.add(ritem.getName());
        return sb.toString();
    }

    protected String gHasChild(Modelitem ritem, Model rmodel, Map<String, Modelitem> itemMap, Set<String> processedItemNameSet) {
        return this.gHasChild(ritem, rmodel, itemMap, "", 0, null, null, processedItemNameSet);
    }

    protected String gHasChild(Modelitem ritem, Model rmodel, Map<String, Modelitem> itemMap, String basetab, int nestlevel, String id, String rid, Set<String> processedItemNameSet) {
        StringBuilder sb = new StringBuilder();
        if (nestlevel > 24) {
            this.logger.error(rman.getValue("helper.comment.nestover", this.model.getId()));
            return sb.toString();
        }
        String varname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, rmodel);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        id = id == null ? this.model.getId() : id;
        rid = rid == null ? rmodel.getId() : rid;
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("// " + varname + " : Multiple");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append(packagename);
        sb.append(fullname_mitem_classname + "[]");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(varname + "_p_ary = ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(varname + "_p_ary");
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (");
        sb.append(packagename);
        sb.append(fullname_mitem_classname);
        sb.append(" ");
        sb.append(varname + "_p");
        sb.append(" : ");
        sb.append(varname + "_p_ary");
        sb.append(") {").append(CR);
        IModelChoice[] imc = rmodel.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                if (!(imc[i] instanceof Modelitem)) continue;
                Modelitem _item = (Modelitem)imc[i];
                String _name = _item.getName();
                if (_name.charAt(0) == '/') {
                    _name = _name.substring(1);
                }
                if (!_name.startsWith(varname + "/") && _name.indexOf("/" + varname + "/") <= 0 || _name.equals(varname + "/")) continue;
                sb.append(this.gModelitemProcess(_item, rmodel, itemMap, basetab + "        ", nestlevel + 1, varname + "_p", varname, processedItemNameSet));
            }
        }
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        return this.gAdaptFilter(ritem, model, objectname, filtername, basetab, nestlevel, false);
    }

    protected String gAdaptFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel, boolean isControlFlag) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, model);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        String p_packagename = AppSchemaUtil.getPackagename(model, this.project);
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        String instancename = elementname;
        sb.append(basetab + "            ");
        sb.append(p_packagename);
        sb.append(fullname_mitem_classname);
        sb.append(" ");
        sb.append(instancename);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("String s = ");
        if (filtername != null) {
            sb.append(filtername);
            sb.append(".filter(");
            sb.append(instancename);
            sb.append(".getContent());");
        } else {
            sb.append(instancename);
            sb.append(".getContent();");
        }
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(instancename);
        sb.append(".setContent(s);");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptFilter_anorm(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, model);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        StringBuilder sb = new StringBuilder();
        String instancename = elementname;
        String proxyClassname = AnormManagerGenerator.getAnormServerProxyClassnameWithPackage(this.project);
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(fullname_mitem_classname);
        sb.append(" ");
        sb.append(instancename);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("String s = ");
        if (filtername != null) {
            sb.append(filtername);
            sb.append(".filter(");
            sb.append(instancename);
            sb.append(".getContent());");
        } else {
            sb.append(instancename);
            sb.append(".getContent();");
        }
        sb.append(CR);
        if (proxyClassname != null) {
            sb.append(basetab + "            ");
            sb.append(proxyClassname);
            sb.append(" __jfc_proxy = ");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("NormalizeServerManager.getInstance(getJfcConfig());");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("if (__jfc_proxy != null && ");
            sb.append(instancename);
            sb.append(".getAnorm()) {");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("String s0 = null;");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("try {");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("s0 = __jfc_proxy.normalize(s);");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("} catch (Exception e) {");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("s0 = null;");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("NormalizeServerManager.reset();");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("if (s0 != null && s0.length() > 0)");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("s = s0;");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append(instancename);
        sb.append(".setContent(s);");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptMultiFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, model);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(fullname_mitem_classname);
        sb.append("[] ");
        sb.append(elementname);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int i=0; i<");
        sb.append(elementname);
        sb.append(".length; i++) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append(elementname);
        sb.append("[i].setContent(");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(filtername);
        sb.append(".filter(");
        sb.append(elementname);
        sb.append("[i].getContent()));");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname));
        sb.append("(");
        sb.append(elementname);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptRefFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel) {
        return this.gAdaptRefFilter(ritem, model, objectname, filtername, basetab, nestlevel, true);
    }

    protected String gAdaptRefFilter(Modelitem ritem, Model model, String objectname, String filtername, String basetab, int nestlevel, boolean isNeedsIdFilter) {
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, model);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(fullname_mitem_classname);
        sb.append("[] ");
        sb.append(elementname);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int i=0; i<");
        sb.append(elementname);
        sb.append(".length; i++) {");
        sb.append(CR);
        if (isNeedsIdFilter) {
            sb.append(basetab + "                ");
            sb.append(elementname);
            sb.append("[i].setId(");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append(filtername);
            sb.append(".filter(");
            sb.append(elementname);
            sb.append("[i].getId()));");
            sb.append(CR);
        }
        sb.append(basetab + "                ");
        sb.append(elementname);
        sb.append("[i].setContent(");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(filtername);
        sb.append(".filter(");
        sb.append(elementname);
        sb.append("[i].getContent()));");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname));
        sb.append("(");
        sb.append(elementname);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gAdaptStorerefFilter(Modelitem ritem, Model model, String objectname, String basetab, int nestlevel, boolean isControlFlag) {
        Object[] actions;
        String fullname_mitem_packagename;
        String elementname = SourceGenerator.getElementNameByNestLevel(ritem.getName(), nestlevel);
        String fullname = SourceGenerator.getFullNameByNestLevel(ritem.getName(), nestlevel);
        Modelitem fullname_mitem = AppSchemaUtil.getModelitem(fullname, model);
        String fullname_mitem_classname = AppSchemaUtil.getModelitemClassname(fullname_mitem);
        Model pmodel = AppSchemaUtil.getModel(this.project, model.getId(), "presentation");
        String string = fullname_mitem_packagename = pmodel != null ? AppSchemaUtil.getPackagename(pmodel, this.project) : "";
        if (this.model.getUpdatelist() && fullname_mitem_packagename.endsWith("_p.")) {
            fullname_mitem_packagename = fullname_mitem_packagename.substring(0, fullname_mitem_packagename.length() - "_p.".length()) + "_ulp.";
        }
        StringBuilder sb = new StringBuilder();
        String filtername = null;
        String type = null;
        Model rmodel = null;
        Model rpmodel = null;
        Modelitem rmitem = null;
        Modelitem rpmitem = null;
        boolean needsOutputPackagename = false;
        IModelChoice[] imc = model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                IRNode node;
                if (!(imc[i] instanceof Modelitem)) continue;
                Modelitem item = (Modelitem)imc[i];
                String itemname = item.getName();
                if (itemname.indexOf("/") > 0) {
                    itemname = itemname.substring(itemname.indexOf("/") + 1);
                }
                if (!elementname.equals(itemname)) continue;
                if (!"storeref".equals(item.getType())) break;
                Relation rel = AppSchemaUtil.getRelationTypeExceptRef(item);
                if (rel == null) {
                    if (!ritem.getTransient()) {
                        rel = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(model, item);
                    }
                    if (rel == null) break;
                }
                if ((node = rel.getIdrefAsIRNode()) == null || !(node instanceof Model)) break;
                rmodel = (Model)node;
                String roleid_str = AppSchemaUtil.getRoleid(rel, this.project);
                String roleid = null;
                for (String _roleid : roleid_str.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP())) {
                    rmitem = AppSchemaUtil.getModelitem(_roleid, rmodel);
                    if (rmitem == null) continue;
                    if (roleid_str.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) > 0) {
                        if (!rmitem.getName().equals(rel.getRolecontent())) continue;
                        roleid = _roleid;
                        break;
                    }
                    roleid = _roleid;
                }
                if (roleid == null && roleid_str.indexOf(PrimaryKeyUtils.PKEY_SEPARATOR()) > 0) {
                    roleid = roleid_str.split(PrimaryKeyUtils.PKEY_SEPARATOR_REGEXP())[0];
                    rmitem = AppSchemaUtil.getModelitem(roleid, rmodel);
                }
                type = AppSchemaUtil.getModelitemType(this.project, rmodel.getId(), rmitem, "roleid");
                rpmodel = AppSchemaUtil.getModel(this.project, rmodel.getId(), "presentation");
                if (rpmodel == null) continue;
                rpmitem = AppSchemaUtil.getModelitem(roleid, rpmodel);
                if (rpmitem != null) {
                    filtername = rpmitem.getFilter();
                }
                if (rel.getIdref().equals(itemname)) {
                    needsOutputPackagename = true;
                }
                if (filtername != null) break;
            }
        }
        if (filtername == null) {
            Object[] o = new Object[]{model.getId(), elementname, rpmodel != null ? rpmodel.getId() : "(unknown model)", rpmitem != null ? rpmitem.getName() : "(unknown item, elementname=" + elementname + ")"};
            this.logger.error(rman.getValue("value.null.storeref.filter.filtername", o));
            return sb.toString();
        }
        if (type == null) {
            Object[] o = new Object[]{model.getId(), elementname, rmodel != null ? rmodel.getId() : "(unknown)", rmitem != null ? rmitem.getName() : "(unknown)"};
            this.logger.error(rman.getValue("value.null.storeref.filter.type", o));
            return sb.toString();
        }
        this.filterMap.put(elementname, filtername);
        if (JavaSourceGenerator.isDateOrTimeType(type)) {
            return "";
        }
        if (!needsOutputPackagename && ("condition".equals(model.getType()) || this.model.getUpdatelist()) && ArrayUtils.isNotEmpty((Object[])(actions = AppSchemaUtil.getActionByModelId(this.project, AppSchemaUtil.getStoreModel(model).getId())))) {
            for (Object action : actions) {
                Condition cond;
                if (!"showList".equals(((Action)action).getType()) || !((Action)action).getUpdatelist() || (cond = AppSchemaUtil.getCondition(AppSchemaUtil.getConditionlist((Action)action), elementname)) == null) continue;
                needsOutputPackagename = true;
                break;
            }
        }
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(" != null) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        if (needsOutputPackagename) {
            sb.append(fullname_mitem_packagename);
        }
        sb.append(fullname_mitem_classname);
        sb.append("[] ");
        sb.append(elementname);
        sb.append(" = ");
        sb.append(objectname);
        sb.append(JavaSourceGenerator.getterFullMethod(elementname));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("for (int i=0; i<");
        sb.append(elementname);
        sb.append(".length; i++) {");
        sb.append(CR);
        boolean isConditionModel = "condition".equals(this.smodel.getType());
        if (isConditionModel) {
            sb.append(basetab + "                ");
            sb.append("if (\"");
            sb.append("__w:noselection");
            sb.append("\".equals(");
            sb.append(elementname);
            sb.append("[i].getId())) {");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("continue;");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "                ");
        sb.append(elementname);
        sb.append("[i].setId(");
        if (JavaSourceGenerator.isBasicType(type)) {
            sb.append("StringUtil.");
            sb.append(type);
            sb.append("Value(");
        }
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(filtername);
        sb.append(".filter(");
        if (JavaSourceGenerator.isBasicType(type)) {
            sb.append(JavaSourceGenerator.getB2wc_method(type));
            sb.append("(");
        }
        sb.append(elementname);
        sb.append("[i].getId())");
        if (JavaSourceGenerator.isBasicType(type)) {
            sb.append("))");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(objectname);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(elementname));
        sb.append("(");
        sb.append(elementname);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

