/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getComparator
extends HelperGeneratorBaseTask {
    private Project project;
    private Modelitem modelitem;
    private boolean isSelfReferenceFlag;
    private SortOrder order = SortOrder.Descending;
    private String sortRule = "rolepriority";
    private boolean isJprincipalId;
    private Logger logger = LogManager.getLogger((String)HelperGenerator_getComparator.class.getName());

    public HelperGenerator_getComparator(Project project, Model model, String modelitemname) {
        this.project = project;
        this.model = model;
        this.modelitem = AppSchemaUtil.getModelitem(modelitemname, model);
        if (this.modelitem == null) {
            this.logger.error("No modelitem " + modelitemname + " in model " + model.getId() + " is found. skip.");
        }
        if ("storeref".equals(this.modelitem.getType())) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(this.modelitem);
            if (relation == null && !this.modelitem.getTransient()) {
                relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(model, this.modelitem);
            }
            if (relation != null && model != null && AppSchemaUtil.getRoleid(relation, project) != null && relation.getRolecontent() != null && relation.getIdref() != null && AppSchemaUtil.getRoleid(relation, project).equals(relation.getRolecontent()) && relation.getIdref().equals(AppSchemaUtil.getStoreModel(model).getId())) {
                this.isSelfReferenceFlag = true;
            }
            if (relation != null) {
                this.order = "descending".equals(relation.getOrder()) ? SortOrder.Descending : SortOrder.Ascending;
                if (StringUtils.isNotBlank((String)relation.getSortrule())) {
                    this.sortRule = relation.getSortrule();
                }
            }
        } else if ("masterref".equals(this.modelitem.getType())) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(this.modelitem);
            if (relation.getIdref().equals("jprincipal") && relation.getType().equals("check")) {
                this.isJprincipalId = true;
            }
            if (relation != null) {
                this.order = "descending".equals(relation.getOrder()) ? SortOrder.Descending : SortOrder.Ascending;
                if (StringUtils.isNotBlank((String)relation.getSortrule())) {
                    this.sortRule = relation.getSortrule();
                }
            }
        } else if ("combo".equals(this.modelitem.getDualinputmethod())) {
            this.isSelfReferenceFlag = true;
        } else if (this.modelitem.getTransient()) {
            this.isSelfReferenceFlag = true;
        }
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String classname = AppSchemaUtil.getModelitemClassname(this.modelitem);
        sb.append("    ");
        sb.append("public Comparator get" + classname + "Comparator() {");
        sb.append(CR);
        if (this.isJprincipalId) {
            this.process_jprincipalId(sb);
        } else if (this.isSelfReferenceFlag) {
            this.process_selfRef(sb);
        } else {
            this.process_normal(sb);
        }
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected void process_jprincipalId(StringBuilder sb) {
        sb.append("        ");
        sb.append("return getComparator(ComparatorPattern.CategoryPriorityId);").append(CR);
    }

    protected void process_selfRef(StringBuilder sb) {
        sb.append("        ");
        sb.append("return getSelfComparator();");
        sb.append(CR);
    }

    protected void process_normal(StringBuilder sb) {
        Relation relation;
        if ("sortkey".equals(this.sortRule)) {
            sb.append("        ");
            sb.append("return null;");
            sb.append(CR);
            return;
        }
        PrimaryKey[] r_pkeys = null;
        if ("storeref".equals(this.modelitem.getType()) && (relation = AppSchemaUtil.getRelationTypeExceptRef(this.modelitem)) != null) {
            Model rmodel = (Model)relation.getIdrefAsIRNode();
            r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        }
        if (r_pkeys == null || r_pkeys.length == 1) {
            sb.append("        ");
            sb.append("return getComparator(ComparatorPattern.");
            if ("rolepriority".equals(this.sortRule) || "rolecontent".equals(this.sortRule)) {
                if ("rolepriority".equals(this.sortRule)) {
                    sb.append("Priority");
                } else {
                    sb.append("Content");
                }
                if (this.order == SortOrder.Descending) {
                    sb.append("Decend");
                }
                sb.append("Id");
            } else {
                sb.append("Id");
                if (this.order == SortOrder.Descending) {
                    sb.append("Decend");
                }
            }
            sb.append(");").append(CR);
            return;
        }
        sb.append("        ");
        sb.append("org.apache.commons.collections.comparators.ComparatorChain cc = new org.apache.commons.collections.comparators.ComparatorChain();");
        sb.append(CR);
        if ("rolepriority".equals(this.sortRule) || "rolecontent".equals(this.sortRule)) {
            sb.append("        ");
            sb.append("cc.addComparator(new org.apache.commons.beanutils.BeanComparator(\"");
            if ("rolepriority".equals(this.sortRule)) {
                sb.append("priority");
            } else {
                sb.append("content");
            }
            sb.append("\"), ");
            if (this.order == SortOrder.Descending) {
                sb.append("true");
            } else {
                sb.append("false");
            }
            sb.append(");");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("cc.addComparator(new org.apache.commons.beanutils.BeanComparator(\"id\")");
        if ("roleid".equals(this.sortRule)) {
            sb.append(", ");
            if (this.order == SortOrder.Descending) {
                sb.append("true");
            } else {
                sb.append("false");
            }
        }
        sb.append(");");
        sb.append(CR);
        for (int i = 1; i < r_pkeys.length; ++i) {
            PrimaryKey r_pkey = r_pkeys[i];
            String name = r_pkey.getName() + "_jshpkey";
            sb.append("        ");
            sb.append("cc.addComparator(new org.apache.commons.beanutils.BeanComparator(\"");
            sb.append(JavaSourceGenerator.convertELProperty(name));
            sb.append("\")");
            if ("roleid".equals(this.sortRule)) {
                sb.append(", ");
                if (this.order == SortOrder.Descending) {
                    sb.append("true");
                } else {
                    sb.append("false");
                }
            }
            sb.append(");");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("return new org.apache.commons.collections.comparators.NullComparator(");
        sb.append("cc");
        sb.append(");");
        sb.append(CR);
    }

    private static enum SortOrder {
        Ascending,
        Descending;

    }
}

