/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getCsvTargetItemSet
extends HelperGeneratorBaseTask {
    private static final String TARGETITEM_PKEY_VARNAME = "TARGETITEM_PKEY";
    private static final String TARGETITEM_MULTIPLE_WO_CONT_VARNAME = "TARGETITEM_MULTIPLE_WO_CONT";
    private static final String TARGETITEM_MULTIPLE_WITH_CONT_VARNAME = "TARGETITEM_MULTIPLE";
    private static final String TARGETITEM_OTHER_VARNAME = "TARGETITEM_OTHER";
    private static final String TARGETITEM_CONT_VARNAME_HEADER = "TARGETITEM_CONT_";
    private static final String TARGETITEM_SET_VARNAME = "TARGETITEM_SET";
    private static final String TARGETITEM_MAIN_SET_VARNAME = "TARGETITEM_MAIN_SET";
    private static final String TARGETITEM_MULTIPLE_MAP_VARNAME = "TARGETITEM_MULTIPLE_MAP";
    protected Project project;
    protected Logger logger = LogManager.getLogger(HelperGenerator_getCsvTargetItemSet.class);

    public HelperGenerator_getCsvTargetItemSet(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            return sb.toString();
        }
        Map<String, Object> itemMap = AppSchemaUtil.devideMapByContainerName(smodel);
        List<Modelitem> pkeyMitems = this.getPrimaryKeyModelitem(smodel);
        this.gCsvTargetItem(sb, TARGETITEM_PKEY_VARNAME, smodel, this.model, pkeyMitems);
        List<Modelitem> mutipleMitems = this.getMultipleModelitem(smodel);
        this.gCsvTargetItem(sb, TARGETITEM_MULTIPLE_WO_CONT_VARNAME, smodel, this.model, mutipleMitems);
        HashSet<String> mitemnameSet = new HashSet<String>();
        this.addModelitemName(mitemnameSet, pkeyMitems);
        this.addModelitemName(mitemnameSet, mutipleMitems);
        List<Modelitem> otherMitems = this.getMainModelitem(smodel, itemMap, mitemnameSet);
        this.gCsvTargetItem(sb, TARGETITEM_OTHER_VARNAME, smodel, this.model, otherMitems);
        this.gCsvTargetItemContainer(sb, smodel, this.model, itemMap);
        List<String> contmitemnames = this.getContainerModelitemNames(itemMap);
        this.gVarInitStaticCode(sb, contmitemnames);
        this.gContainsMethod(sb);
        this.gGetCsvTargetItemSetMethod(sb);
        return sb.toString();
    }

    private void addModelitemName(Collection<String> set, List<Modelitem> mitems) {
        for (Modelitem mitem : mitems) {
            set.add(mitem.getName());
        }
    }

    private List<String> getContainerModelitemNames(Map<String, Object> itemMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : itemMap.keySet()) {
            Object o = itemMap.get(name);
            if (!(o instanceof Set)) continue;
            list.add(name);
        }
        return list;
    }

    private void gVarInitStaticCode(StringBuilder sb, List<String> contmitemnames) {
        String[] code = new String[]{"private final static Set<String> TARGETITEM_MAIN_SET;", "private final static Set<String> TARGETITEM_SET;", "private final static Map<String, String[]> TARGETITEM_MULTIPLE_MAP;", "private final static String[] TARGETITEM_MULTIPLE;", "static {"};
        this.append(sb, "    ", code);
        ArrayList<String> codes = new ArrayList<String>(Arrays.asList("HashSet<String> set = new HashSet<>(Arrays.asList(TARGETITEM_PKEY));", "set.addAll(Arrays.asList(TARGETITEM_OTHER));", "TARGETITEM_MAIN_SET = Collections.unmodifiableSet(new HashSet<String>(set));", "", "HashMap<String, String[]> map = new HashMap<>();", "for (String itemname : TARGETITEM_MULTIPLE_WO_CONT) {", "    map.put(itemname, new String[] { itemname });", "}", "List<String> list = new ArrayList<String>(Arrays.asList(TARGETITEM_MULTIPLE_WO_CONT));"));
        for (String name : contmitemnames) {
            codes.addAll(Arrays.asList("map.put(\"" + name + "\", " + TARGETITEM_CONT_VARNAME_HEADER + name + ");", "list.addAll(Arrays.asList(TARGETITEM_CONT_" + name + "));"));
        }
        codes.addAll(Arrays.asList("TARGETITEM_MULTIPLE_MAP = map;", "TARGETITEM_MULTIPLE = list.toArray(new String[list.size()]);", "", "set.addAll(list);", "TARGETITEM_SET = Collections.unmodifiableSet(set);"));
        this.append(sb, "        ", codes);
        code = new String[]{"}", ""};
        this.append(sb, "    ", code);
    }

    private void gContainsMethod(StringBuilder sb) {
        String[] code = new String[]{"public static boolean containsMultipleItem(Set<String> itemSet) {", "    return containsOne(itemSet, TARGETITEM_MULTIPLE);", "}", "", "public static boolean containsMultipleItem(", "        Set<String> itemSet, String itemname) {"};
        this.append(sb, "    ", code);
        code = new String[]{"if (itemSet == null) {", "    return true;", "}", "if (TARGETITEM_MULTIPLE_MAP.containsKey(itemname)) {", "    return containsOne(itemSet, TARGETITEM_MULTIPLE_MAP.get(itemname));", "}", "return false;"};
        this.append(sb, "        ", code);
        code = new String[]{"}"};
        this.append(sb, "    ", code);
    }

    private void gGetCsvTargetItemSetMethod(StringBuilder sb) {
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getCsvTargetItemSet"), null, null));
        String[] code = new String[]{"public static Set<String> getCsvTargetItemSet() {", "    return TARGETITEM_SET;", "}", "", "public static Set<String> getMainCsvTargetItemSet() {", "    return TARGETITEM_MAIN_SET;", "}", "", "public static Set<String> getModelitemCsvTargetItemSet(String itemname) {"};
        this.append(sb, "    ", code);
        code = new String[]{"HashSet<String> set = new HashSet<String>(Arrays.asList(TARGETITEM_PKEY));", "if (TARGETITEM_MULTIPLE_MAP.containsKey(itemname)) {", "    set.addAll(Arrays.asList(TARGETITEM_MULTIPLE_MAP.get(itemname)));", "}", "return Collections.unmodifiableSet(set);"};
        this.append(sb, "        ", code);
        code = new String[]{"}", ""};
        this.append(sb, "    ", code);
    }

    private void append(StringBuilder sb, String tab, List<String> codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }

    private void append(StringBuilder sb, String tab, String[] codes) {
        this.append(sb, tab, Arrays.asList(codes));
    }

    private List<Modelitem> getMainModelitem(Model smodel, Map<String, Object> itemMap, Set<String> ignoreMitemnameSet) {
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (String name : itemMap.keySet()) {
            Object o;
            if (ignoreMitemnameSet.contains(name) || !((o = itemMap.get(name)) instanceof Modelitem)) continue;
            list.add((Modelitem)o);
        }
        return list;
    }

    private void gCsvTargetItemContainer(StringBuilder sb, Model smodel, Model pmodel, Map<String, Object> itemMap) {
        ArrayList list = new ArrayList();
        for (String name : itemMap.keySet()) {
            Object o = itemMap.get(name);
            if (!(o instanceof Set)) continue;
            list.clear();
            Set set = (Set)o;
            this.gCsvTargetItem(sb, TARGETITEM_CONT_VARNAME_HEADER + name, smodel, pmodel, set);
        }
    }

    private List<Modelitem> getPrimaryKeyModelitem(Model smodel) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(smodel);
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        for (PrimaryKey pkey : pkeys) {
            Modelitem mitem = AppSchemaUtil.getModelitem(pkey.getName(), smodel);
            list.add(mitem);
        }
        return list;
    }

    private List<Modelitem> getMultipleModelitem(Model smodel) {
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            return list;
        }
        for (int i = 0; i < simc.length; ++i) {
            Modelitem mitem;
            if (!(simc[i] instanceof Modelitem) || !(mitem = (Modelitem)simc[i]).getMultiple() || mitem.getHasChild() || AppSchemaUtil.hasChildPart(mitem.getName())) continue;
            list.add(mitem);
        }
        return list;
    }

    private void gCsvTargetItem(StringBuilder sb, String varname, Model smodel, Model pmodel, Collection<Modelitem> list) {
        sb.append("    ");
        sb.append("private final static String[] " + varname + " = {");
        sb.append(CR);
        Iterator<Modelitem> it1 = list.iterator();
        while (it1.hasNext()) {
            Modelitem pitem;
            Modelitem mitem = it1.next();
            String itemname = mitem.getName();
            if (AppSchemaUtil.isGenerationModelitem(itemname, smodel) || !AppSchemaUtil.getCsvOutputable(smodel, itemname) || (pitem = AppSchemaUtil.getModelitem(mitem.getName(), pmodel)) == null || !pitem.getCsvOutput()) continue;
            if (AppSchemaUtil.hasChildPart(itemname)) {
                itemname = AppSchemaUtil.getChildPart(itemname);
            }
            sb.append("        ");
            sb.append("\"" + itemname + "\"");
            if (it1.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
    }
}

