/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getNumberFormat
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getNumberFormat.class.getName());
    private Map<String, String> numberFormatMap = new LinkedHashMap<String, String>();

    public HelperGenerator_getNumberFormat(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        IModelChoice[] smitems = smodel.getContent();
        IModelChoice[] pmitems = this.model.getContent();
        for (int i = 0; i < smitems.length; ++i) {
            if (!(smitems[i] instanceof Modelitem)) continue;
            Modelitem smitem = (Modelitem)smitems[i];
            Modelitem pmitem = null;
            if (pmitems != null) {
                for (int j = 0; j < pmitems.length; ++j) {
                    Modelitem mitem;
                    if (!(pmitems[j] instanceof Modelitem) || !(mitem = (Modelitem)pmitems[j]).getName().equals(smitem.getName())) continue;
                    pmitem = mitem;
                    break;
                }
            }
            if (pmitem == null || !AppSchemaUtil.isCsvUploadUpdate(pmitem)) continue;
            list.add(smitem);
            String numberformat = pmitem.getCsvUploadUpdateNumberformat();
            if (!StringUtils.isNotBlank((String)numberformat)) continue;
            this.numberFormatMap.put(pmitem.getName(), numberformat);
        }
        this.createNumberFormatMap(sb, "    ");
        return sb.toString();
    }

    private void createNumberFormatMap(StringBuilder sb, String tab) {
        sb.append(tab);
        sb.append("protected Map<String, String> numberFormatMap;");
        sb.append(CR);
        sb.append(tab);
        sb.append("private final static String[][] numberFormatMapStr = {");
        sb.append(CR);
        boolean isFirst = true;
        for (Map.Entry<String, String> nf : this.numberFormatMap.entrySet()) {
            if (!isFirst) {
                sb.append(",");
                sb.append(CR);
            } else {
                isFirst = false;
            }
            sb.append(tab + "    ");
            sb.append("{ \"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getChildPart(nf.getKey())));
            sb.append("\", \"");
            sb.append(StringUtil.convertJavaString((String)nf.getValue()));
            sb.append("\" }");
        }
        sb.append(CR);
        sb.append(tab);
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("{");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("numberFormatMap = new HashMap<String, String>(); ");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("for (String[] sa : numberFormatMapStr) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("numberFormatMap.put(sa[0], sa[1]);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("public String getNumberFormat(String mitemname) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return numberFormatMap.get(mitemname); ");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }
}

