/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_getPrimaryKeyForCsvData
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_getPrimaryKeyForCsvData.class.getName());

    public HelperGenerator_getPrimaryKeyForCsvData(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model rmodel = (Model)node;
        IModelChoice[] rimc = rmodel.getContent();
        if (rimc == null || rimc.length == 0) {
            return sb.toString();
        }
        ArrayList<Modelitem> pkey_mitems = new ArrayList<Modelitem>();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        Map<String, String> labels = AppSchemaUtil.createCsvHeaderMap(rmodel, this.model);
        for (int i = 0; i < rimc.length; ++i) {
            String label;
            Modelitem mitem;
            if (!(rimc[i] instanceof Modelitem) || (mitem = (Modelitem)rimc[i]).getMultiple() || mitem.getHasChild() || mitem.getName().indexOf("/") >= 0) continue;
            Modelitem pitem = null;
            if (imc != null) {
                for (int j = 0; !(j >= imc.length || imc[j] instanceof Modelitem && (pitem = (Modelitem)imc[j]).getName().equals(mitem.getName())); ++j) {
                }
            }
            if ((label = labels.get(mitem.getName())) == null) continue;
            boolean isPrimaryKey = false;
            for (int j = 0; j < pkeys.length; ++j) {
                PrimaryKey pkey = pkeys[j];
                if (!pkey.getName().equals(mitem.getName())) continue;
                isPrimaryKey = true;
                break;
            }
            if (pitem != null && !pitem.getCsvOutput() && !isPrimaryKey || !isPrimaryKey) continue;
            pkey_mitems.add(mitem);
        }
        StringBuilder sb_mitemnames = new StringBuilder();
        sb_mitemnames.append("    ");
        sb_mitemnames.append("public final static String[] GetPrimaryKeyForCsvData_ModelitemNames = {");
        sb_mitemnames.append(CR);
        StringBuilder sb_rkeys = new StringBuilder();
        sb_rkeys.append("    ");
        sb_rkeys.append("final static String[] GetPrimaryKeyForCsvData_LabelResourceKeys = {");
        sb_rkeys.append(CR);
        for (int i = 0; i < pkey_mitems.size(); ++i) {
            Modelitem mitem = (Modelitem)pkey_mitems.get(i);
            String label = labels.get(mitem.getName());
            String rkey = JFCAppResourceGenerator.createHelperResourceKey("csvHeader", rmodel.getId(), mitem.getName(), label);
            JFCAppResourceGenerator.put(rkey, label);
            sb_mitemnames.append("        ");
            sb_mitemnames.append("\"" + mitem.getName() + "\"");
            if (i + 1 < pkey_mitems.size()) {
                sb_mitemnames.append(",");
            }
            sb_mitemnames.append(CR);
            sb_rkeys.append("        ");
            sb_rkeys.append("\"" + rkey + "\"");
            if (i + 1 < pkey_mitems.size()) {
                sb_rkeys.append(",");
            }
            sb_rkeys.append(CR);
        }
        sb_mitemnames.append("    ");
        sb_mitemnames.append("};");
        sb_mitemnames.append(CR);
        sb_mitemnames.append(CR);
        sb.append((CharSequence)sb_mitemnames);
        sb_rkeys.append("    ");
        sb_rkeys.append("};");
        sb_rkeys.append(CR);
        sb_rkeys.append(CR);
        sb.append((CharSequence)sb_rkeys);
        sb.append(this.gGetPrimaryKeyLabelResourceKeys());
        sb.append(this.gGetPrimaryKeyForCsvDataMethod());
        return sb.toString();
    }

    private String gGetPrimaryKeyLabelResourceKeys() {
        StringBuilder sb = new StringBuilder();
        String[] msgParam = new String[]{};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getPrimaryKeyLabelResourceKeys"), msgParam, this.rman.getValue("helper.comment.getPrimaryKeyLabelResourceKeys.return")));
        sb.append("    ");
        sb.append("public String[] getPrimaryKeyLabelResourceKeys() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return GetPrimaryKeyForCsvData_LabelResourceKeys;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gGetPrimaryKeyForCsvDataMethod() {
        StringBuilder sb = new StringBuilder();
        String[] msg_param = new String[]{"data", "header"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.getPrimaryKeyForCsvData"), msg_param, this.rman.getValue("helper.comment.getPrimaryKeyForCsvData.return")));
        sb.append("    ");
        sb.append("public String[] getPrimaryKeyForCsvData(");
        sb.append(CR);
        sb.append("            ");
        sb.append("String[] _data, String[] _header, ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("int _rkeylen = GetPrimaryKeyForCsvData_LabelResourceKeys.length;");
        sb.append(CR);
        sb.append("        ");
        sb.append("String[] _ret = new String[_rkeylen];");
        sb.append(CR);
        sb.append("        ");
        sb.append("int _len = _header.length;");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_len > _data.length) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("_len = _data.length;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("for (int i = 0 ; i < _len ; i++) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("String _key = _header[i];");
        sb.append(CR);
        sb.append("            ");
        sb.append("String _content = _data[i];");
        sb.append(CR);
        sb.append("            ");
        sb.append("for (int j=0; j<_rkeylen; j++) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("String _rkey = GetPrimaryKeyForCsvData_LabelResourceKeys[j];");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (_key.equals(JFCUtils.getRValue(_rkey, p.locale))) {");
        sb.append(CR);
        sb.append("                  ");
        sb.append("_ret[j] = _content;");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("return _ret;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }
}

