/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Limit;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_limit
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Limit content;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_limit.class.getName());

    public HelperGenerator_limit(Project project, Model model, Modelitem item, Limit content) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.content = content;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        Unit unit;
        StringBuilder sb = new StringBuilder();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        sb.append(basetab).append("        ");
        boolean minflag = false;
        if (this.content.getType().equals("maximum")) {
            sb.append("// " + this.rman.getValue("helper.comment.limitcheck.max"));
        } else if (this.content.getType().equals("minimum")) {
            sb.append("// " + this.rman.getValue("helper.comment.limitcheck.min"));
            minflag = true;
        } else {
            this.logger.error(this.rman.getValue("helper.invalid.limitcheck"));
        }
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        int limitsize = this.content.getContent();
        int display_limitsize = this.content.getDisplay();
        if (display_limitsize == 0) {
            display_limitsize = limitsize;
        }
        sb.append(basetab).append("        ");
        sb.append("if (s != null) {").append(CR);
        Unit unit2 = unit = "byte".equals(this.content.getUnit()) ? Unit.Byte : Unit.Char;
        if (unit == Unit.Byte) {
            sb.append(basetab).append("            ");
            sb.append("int len = 0;").append(CR);
            sb.append(basetab).append("            ");
            sb.append("try {").append(CR);
            sb.append(basetab).append("                ");
            sb.append("len = s.getBytes(\"");
            sb.append(AppSchemaUtil.getByteCheckEncoding(this.project, smodel, this.item));
            sb.append("\").length;").append(CR);
            sb.append(basetab).append("            ");
            sb.append("} catch (java.io.UnsupportedEncodingException e) {").append(CR);
            sb.append(basetab).append("            ");
            sb.append("}").append(CR);
        } else {
            sb.append(basetab).append("            ");
            sb.append("int len = s.length();").append(CR);
        }
        sb.append(basetab).append("            ");
        if (minflag) {
            sb.append("if (len < ").append(limitsize).append(") {");
        } else {
            sb.append("if (len > ").append(limitsize).append(") {");
        }
        sb.append(CR);
        sb.append(basetab).append("                ");
        sb.append("Object[] o = { ");
        sb.append("JFCUtils.getRValue(\"").append(rkey).append("\", p.locale)");
        sb.append(", \"");
        sb.append(display_limitsize);
        sb.append("\" };").append(CR);
        sb.append(basetab).append("                ");
        String errcode = null;
        if (this.content.getWarning()) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =").append(CR);
            sb.append(basetab).append("                    ");
            if (minflag) {
                errcode = this.createErrorCodeKey("error.input.limit_short", unit);
                sb.append("manager.getJfcwarn(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode(errcode));
                sb.append("\", o, p.locale);");
            } else {
                errcode = this.createErrorCodeKey("error.input.limit_over", unit);
                sb.append("manager.getJfcwarn(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode(errcode));
                sb.append("\", o, p.locale);");
            }
            sb.append(CR);
            sb.append(basetab).append("                ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(rkey);
            sb.append("\", \"").append(this.createErrorCode(errcode)).append("\");").append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        } else {
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =").append(CR);
            sb.append(basetab).append("                    ");
            if (minflag) {
                errcode = this.createErrorCodeKey("error.input.limit_short", unit);
                sb.append("manager.getJfcerror(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode(errcode));
                sb.append("\", o, p.locale);");
            } else {
                errcode = this.createErrorCodeKey("error.input.limit_over", unit);
                sb.append("manager.getJfcerror(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode(errcode));
                sb.append("\", o, p.locale);");
            }
            sb.append(CR);
            sb.append(basetab).append("                ");
            sb.append("p.errors.addJfcerror(_error);").append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        }
        sb.append(basetab).append("            ");
        sb.append("}").append(CR);
        sb.append(basetab).append("        ");
        sb.append("}").append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }

    private String createErrorCodeKey(String errcode, Unit unit) {
        if (unit == Unit.Byte) {
            errcode = errcode + ".byte";
        }
        return errcode;
    }

    private static enum Unit {
        Byte,
        Char;

    }
}

