/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_input_check;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Range;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ByteRange;
import jp.jasminesoft.util.ComparableRange;
import jp.jasminesoft.util.DateRange;
import jp.jasminesoft.util.DoubleRange;
import jp.jasminesoft.util.ExcelFunction;
import jp.jasminesoft.util.FloatRange;
import jp.jasminesoft.util.IntegerRange;
import jp.jasminesoft.util.LongRange;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.ShortRange;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_range
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Range range;
    protected static final String[] supportType = new String[]{"byte", "short", "int", "float", "double", "long", "date"};
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_range.class.getName());
    private String fmt;
    private Map<String, String> replaceDateExpressionMap;
    private final String[] temp_date_ary = new String[]{"1900/1/1", "2999/1/1"};
    private final SimpleDateFormat checkTempDateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private String initDateExpressionInEachPattern = null;

    public HelperGenerator_range(Project project, Model model, Modelitem item, Range range) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.range = range;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.fmt = this.rman.getValue("__jfc_common.dateformat.output");
        if (StringUtils.isBlank((String)this.fmt)) {
            this.fmt = "yyyy-M-d";
        }
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        Model smodel = AppSchemaUtil.getStoreModel(this.model);
        Modelitem sitem = AppSchemaUtil.getModelitem(this.item.getName(), smodel);
        String type = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), sitem, "roleid");
        boolean isSupportType = false;
        for (int i = 0; i < supportType.length; ++i) {
            if (!supportType[i].equals(type)) continue;
            isSupportType = true;
            break;
        }
        if (!isSupportType) {
            Object[] o = new Object[]{smodel.getId(), sitem.getName(), type};
            this.logger.error(this.rman.getValue("helper.comment.range.notsupport", o));
            return "";
        }
        String delimiter = this.range.getDelimiter();
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = null;
        }
        StringBuilder sb = new StringBuilder();
        String name = HelperGenerator_input_check.getName4ErrorManager(this.item.getName(), this.model);
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        Relation relation = AppSchemaUtil.getRelationFromPModel(this.model, this.item);
        String rkey = null;
        if (smodel != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, smodel.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.range"));
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ");
            sb.append("if (_isContainsId) {").append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("if (StringUtils.isNotEmpty(s)) {");
        sb.append(CR);
        String rangeClass = this.getRangeClass(type);
        String rangeContent = this.range.getContent();
        if ("date".equals(type) && rangeContent.indexOf("now") >= 0) {
            this.replaceDateExpressionMap = new LinkedHashMap<String, String>();
            rangeContent = this.createReplaceDateExpressionMap(rangeContent);
        }
        if ("date".equals(type)) {
            sb.append(basetab + "            ");
            sb.append("java.util.Date d = DateTimeUtil.getDate(s);");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append(rangeClass);
        sb.append(" range = new ");
        sb.append(rangeClass);
        sb.append("(");
        if (delimiter == null) {
            if (this.replaceDateExpressionMap != null) {
                String ret;
                String target = rangeContent;
                StringBuilder sb0 = new StringBuilder();
                int i = 0;
                for (String key : this.replaceDateExpressionMap.keySet()) {
                    int ptr = target.indexOf(key);
                    if (ptr >= 0) {
                        String left = target.substring(0, Math.max(ptr, 0));
                        if (StringUtils.isNotBlank((String)left)) {
                            if ((left = left.trim()).equals("-") || left.equals(",") || left.startsWith("-") || left.endsWith("-")) {
                                if (left.length() > 1 && left.startsWith("-")) {
                                    left = left.substring(1);
                                }
                                if (i > 0) {
                                    sb0.append(" + ");
                                }
                                sb0.append("\"");
                                sb0.append(left);
                                sb0.append("\"");
                                sb0.append(" + ");
                            } else {
                                sb0.append("\"");
                                sb0.append(left);
                                sb0.append("\"");
                                sb0.append(" + ");
                            }
                        } else if (i > 0) {
                            sb0.append(" + \"-\" + ");
                        }
                        String expr = "TEXT(" + this.replaceDateExpressionMap.get(key) + ", \"yyyy/MM/dd\")";
                        sb0.append(expr);
                        int rest_ptr = ptr + key.length();
                        target = rest_ptr < target.length() ? target.substring(rest_ptr) : null;
                    }
                    ++i;
                }
                if (StringUtils.isNotBlank((String)target)) {
                    if ((target = target.trim()).equals("-")) {
                        sb0.append(" + \"-\"");
                    } else {
                        if (!sb0.toString().endsWith(" + \"-\" + ")) {
                            if (target.startsWith(",")) {
                                sb0.append(" + ");
                            } else {
                                sb0.append(" + \"-\" + ");
                            }
                        }
                        if (target.startsWith("-")) {
                            target = target.substring(1);
                        }
                        sb0.append("\"");
                        sb0.append(target);
                        sb0.append("\"");
                    }
                }
                if ((ret = sb0.toString()).endsWith(" + ")) {
                    ret = ret.substring(0, ret.length() - " + ".length());
                }
                sb.append(ret);
                this.initDateExpressionInEachPattern = ret;
            } else {
                sb.append("\"");
                sb.append(StringUtil.convertJavaString((String)rangeContent));
                sb.append("\"");
            }
            sb.append(");");
            sb.append(CR);
        } else {
            sb.append(");");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("range.setRangeSeparator(\"");
            sb.append(StringUtil.convertJavaString((String)delimiter));
            sb.append("\");");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("range.addRange(\"");
            sb.append(StringUtil.convertJavaString((String)rangeContent));
            sb.append("\");");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        if ("date".equals(type)) {
            sb.append("if (d == null) {");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("Object[] o = { ");
            sb.append("JFCUtils.getRValue(\"" + StringUtil.convertJavaString((String)rkey) + "\", p.locale)");
            sb.append(" };");
            sb.append(CR);
            sb.append(basetab + "                ");
            if (this.range.getWarning()) {
                sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
                sb.append(CR);
                sb.append(basetab + "                    ");
                sb.append("manager.getJfcwarn(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode("error.input.notdateformat"));
                sb.append("\", o, p.locale);");
                sb.append(CR);
                sb.append(basetab + "                ");
                sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
                sb.append(StringUtil.convertJavaString((String)rkey));
                sb.append("\", \"" + this.createErrorCode("error.input.notdateformat") + "\");");
            } else {
                sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
                sb.append(CR);
                sb.append(basetab + "                    ");
                sb.append("manager.getJfcerror(\"");
                sb.append(name).append("\", \"");
                sb.append(this.createErrorCode("error.input.notdateformat"));
                sb.append("\", o, p.locale);");
                sb.append(CR);
                sb.append(basetab + "                ");
                sb.append("p.errors.addJfcerror(_error);");
                sb.append(CR);
            }
            sb.append(basetab + "            ");
            sb.append("} else if (!range.isInclude(");
        } else {
            sb.append("if (!range.isInclude(");
        }
        if ("date".equals(type)) {
            sb.append("d");
        } else {
            String wc2bMethod = JavaSourceGenerator.getWc2b_method(type);
            sb.append("StringUtil");
            sb.append(wc2bMethod);
            sb.append("(s)");
        }
        sb.append(")) {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("Object[] o = { ");
        sb.append("JFCUtils.getRValue(\"" + StringUtil.convertJavaString((String)rkey) + "\", p.locale)");
        sb.append(",");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(this.expandContent(rangeContent, type));
        sb.append(" };");
        sb.append(CR);
        sb.append(basetab + "                ");
        if (this.range.getWarning()) {
            sb.append("jp.jasminesoft.jfc.error.Jfcwarn _warn =");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("manager.getJfcwarn(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.range"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("JFCHelperUtils.checkWarnedError(p, String.valueOf(s), _warn, \"");
            sb.append(StringUtil.convertJavaString((String)rkey));
            sb.append("\", \"" + this.createErrorCode("error.input.range") + "\");");
            sb.append(CR);
            HelperGenerator_input_check.generateWarnCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        } else {
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append("manager.getJfcerror(\"");
            sb.append(name).append("\", \"");
            sb.append(this.createErrorCode("error.input.range"));
            sb.append("\", o, p.locale);");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            HelperGenerator_input_check.generateErrorCode(this.multiFlag, this.model, this.item, relation, sb, basetab + "                ");
        }
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (AppSchemaUtil.hasControl(this.item) && AppSchemaUtil.hasChildPart(this.item.getName())) {
            sb.append(basetab + "        ").append("}").append(CR);
        }
        return sb.toString();
    }

    private String createReplaceDateExpressionMap(String content) {
        StringBuilder sb = new StringBuilder();
        int varnum = 1;
        int left = -1;
        int right = -1;
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch == '(') {
                if (left != -1) continue;
                left = i + 1;
                continue;
            }
            if (ch == ')') {
                right = i;
                if (left < 0) continue;
                String converted = this.convertNowExpression(content.substring(left, right));
                String d_key = ExcelFunction.TEXT((java.util.Date)this.getTemporaryDate(varnum), (String)"yyyy/MM/dd");
                this.replaceDateExpressionMap.put(d_key, converted);
                sb.append(d_key);
                left = -1;
                right = -1;
                ++varnum;
                continue;
            }
            if (ch == 'n' && left == -1 && i + 2 < length) {
                int j;
                if (content.charAt(i + 1) != 'o' || content.charAt(i + 2) != 'w') continue;
                boolean isFoundSeparator = false;
                for (j = i + 3; j < length; ++j) {
                    if (content.charAt(j) != '-' && content.charAt(j) != ',') continue;
                    isFoundSeparator = true;
                    break;
                }
                String converted = this.convertNowExpression(content.substring(i, j));
                String d_key = ExcelFunction.TEXT((java.util.Date)this.getTemporaryDate(varnum), (String)"yyyy/MM/dd");
                this.replaceDateExpressionMap.put(d_key, converted);
                sb.append(d_key);
                if (j < length) {
                    sb.append(content.charAt(j));
                }
                i = j;
                if (!isFoundSeparator) {
                    ++i;
                }
                ++varnum;
                continue;
            }
            if (left != -1) continue;
            sb.append(ch);
            if (ch != '-') continue;
            ++varnum;
        }
        return sb.toString();
    }

    private java.util.Date getTemporaryDate(int varnum) {
        Date temp_date = null;
        switch (varnum) {
            case 1: {
                temp_date = ExcelFunction.DATEVALUE((String)this.temp_date_ary[0]);
                break;
            }
            case 2: {
                temp_date = ExcelFunction.DATEVALUE((String)this.temp_date_ary[1]);
                break;
            }
            default: {
                temp_date = ExcelFunction.MOVEDAY((java.util.Date)ExcelFunction.DATEVALUE((String)this.temp_date_ary[1]), (int)(varnum - 2));
            }
        }
        return temp_date;
    }

    private String convertNowExpression(String s) {
        StringBuilder sb = new StringBuilder("DateTimeUtil.getDateWithNowFormat((java.sql.Date)p.request.getAttribute(\"V_TODAY\"), ");
        sb.append("\"");
        sb.append(s);
        sb.append("\"");
        sb.append(")");
        return sb.toString();
    }

    private String getRangeClass(String type) {
        if ("date".equals(type)) {
            return "DateRange";
        }
        String wrapperClass = JavaSourceGenerator.b2wc(type);
        return wrapperClass + "Range";
    }

    private ComparableRange createComparableRange(String rangeContent, String type) {
        if ("date".equals(type)) {
            return new DateRange(rangeContent);
        }
        if ("int".equals(type)) {
            return new IntegerRange(rangeContent);
        }
        if ("float".equals(type)) {
            return new FloatRange(rangeContent);
        }
        if ("double".equals(type)) {
            return new DoubleRange(rangeContent);
        }
        if ("long".equals(type)) {
            return new LongRange(rangeContent);
        }
        if ("short".equals(type)) {
            return new ShortRange(rangeContent);
        }
        if ("byte".equals(type)) {
            return new ByteRange(rangeContent);
        }
        return new ComparableRange(rangeContent);
    }

    private CaseType getCaseType(ComparableRange.RangeItem[] items) {
        CaseType casetype;
        if (items.length == 0) {
            casetype = CaseType.Unknown;
        } else if (items.length == 1) {
            Comparable min = items[0].getMinimum();
            Comparable max = items[0].getMaximum();
            casetype = min == null && max == null ? CaseType.Unknown : (min != null && max == null ? CaseType.Over : (min == null && max != null ? CaseType.Lower : (min.compareTo(max) == 0 ? CaseType.Single : CaseType.OverAndLower)));
        } else if (items.length == 2) {
            Comparable min0 = items[0].getMinimum();
            Comparable max0 = items[0].getMaximum();
            Comparable min1 = items[1].getMinimum();
            Comparable max1 = items[1].getMaximum();
            casetype = min0 == null && max0 != null && min1 != null && max1 == null || min0 != null && max0 == null && min1 == null && max1 != null ? CaseType.LowerOrOver : CaseType.Multiple;
        } else if (items.length > 2) {
            casetype = CaseType.Multiple;
        } else {
            assert (false);
            return null;
        }
        return casetype;
    }

    private String expandContent(String rangeContent, String type) {
        ComparableRange range = this.createComparableRange(rangeContent, type);
        ComparableRange.RangeItem[] items = range.getRangeItem();
        CaseType casetype = this.getCaseType(items);
        StringBuilder sb = new StringBuilder();
        if (casetype == CaseType.LowerOrOver) {
            Comparable c2;
            Comparable c1;
            Comparable min0 = items[0].getMinimum();
            Comparable max0 = items[0].getMaximum();
            Comparable min1 = items[1].getMinimum();
            Comparable max1 = items[1].getMaximum();
            if (min0 == null && max0 != null && min1 != null && max1 == null) {
                c1 = min1;
                c2 = max0;
            } else if (min0 != null && max0 == null && min1 == null && max1 != null) {
                c1 = min0;
                c2 = max1;
            } else {
                assert (false);
                return null;
            }
            if ("date".equals(type)) {
                sb.append("JFCUtils.getRValue(\"__jfc_common.range.beforeandafter.date\", ");
                sb.append(this.outputProperString(c1) + ", ");
                sb.append(this.outputProperString(c2) + ", ");
                sb.append("p.locale)");
            } else {
                int ptr = rangeContent.indexOf(",");
                if (ptr >= 0) {
                    String minstr = rangeContent.substring(0, ptr);
                    String maxstr = rangeContent.substring(ptr + 1);
                    minstr = minstr.substring(minstr.indexOf("-") + 1);
                    maxstr = maxstr.substring(0, maxstr.lastIndexOf("-"));
                    minstr = minstr.replace("(", "").replace(")", "");
                    maxstr = maxstr.replace("(", "").replace(")", "");
                    sb.append("JFCUtils.getRValue(\"__jfc_common.range.beforeandafter\", ");
                    sb.append(this.outputProperString((Comparable)((Object)minstr)) + ", ");
                    sb.append(this.outputProperString((Comparable)((Object)maxstr)) + ", ");
                } else {
                    sb.append("JFCUtils.getRValue(\"__jfc_common.range.beforeandafter\", ");
                    sb.append(this.outputProperString(c1) + ", ");
                    sb.append(this.outputProperString(c2) + ", ");
                }
                sb.append("p.locale)");
            }
        } else if (casetype == CaseType.Lower) {
            Comparable max = items[0].getMaximum();
            if ("date".equals(type)) {
                sb.append("JFCUtils.getRValue(\"__jfc_common.range.before.date\", ");
                sb.append(this.outputProperString(max) + ", ");
            } else {
                sb.append("JFCUtils.getRValue(\"__jfc_common.range.before\", ");
                String maxstr = rangeContent.replace("-", "");
                sb.append(this.outputProperString((Comparable)((Object)maxstr)) + ", ");
            }
            sb.append("p.locale)");
        } else if (casetype == CaseType.Over) {
            Comparable min = items[0].getMinimum();
            if ("date".equals(type)) {
                sb.append("JFCUtils.getRValue(\"__jfc_common.range.after.date\", ");
                sb.append(this.outputProperString(min) + ", ");
            } else {
                sb.append("JFCUtils.getRValue(\"__jfc_common.range.after\", ");
                String minstr = rangeContent.replace("-", "");
                sb.append(this.outputProperString((Comparable)((Object)minstr)) + ", ");
            }
            sb.append("p.locale)");
        } else if (casetype == CaseType.OverAndLower) {
            sb.append("JFCUtils.getRValue(\"__jfc_common.range.fromto\", ");
            if ("date".equals(type)) {
                Comparable min = items[0].getMinimum();
                Comparable max = items[0].getMaximum();
                sb.append(this.outputProperString(min) + ", ");
                sb.append(this.outputProperString(max) + ", ");
            } else if (StringUtils.contains((String)rangeContent, (String)"-")) {
                Pattern pattern = Pattern.compile("^\\(?(-?\\d+(?:\\.\\d+)?)\\)?-(\\d+(?:\\.\\d+)?)$");
                Matcher matcher = pattern.matcher(rangeContent);
                if (matcher.find()) {
                    sb.append(this.outputProperString((Comparable)((Object)matcher.group(1)))).append(", ");
                    sb.append(this.outputProperString((Comparable)((Object)matcher.group(2)))).append(", ");
                }
            } else {
                Comparable min = items[0].getMinimum();
                Comparable max = items[0].getMaximum();
                sb.append(this.outputProperString(min) + ", ");
                sb.append(this.outputProperString(max) + ", ");
            }
            sb.append("p.locale)");
        } else if (casetype == CaseType.Multiple) {
            sb.append("JFCUtils.getRValue(\"__jfc_common.range.each\", ");
            if (this.initDateExpressionInEachPattern != null) {
                String content = StringUtil.replaceAll((String)this.initDateExpressionInEachPattern, (String)"yyyy/MM/dd", (String)this.fmt);
                sb.append(content + ", ");
            } else {
                sb.append(this.outputProperString((Comparable)((Object)rangeContent)) + ", ");
            }
            sb.append("p.locale)");
        } else if (casetype == CaseType.Single) {
            Comparable min = items[0].getMinimum();
            sb.append(this.outputProperString(min));
        } else {
            sb.append(this.outputProperString((Comparable)((Object)rangeContent)));
        }
        return sb.toString();
    }

    private String outputProperString(Comparable c) {
        String ret = null;
        if (c instanceof java.util.Date) {
            if (this.replaceDateExpressionMap != null) {
                ret = this.replaceDateExpressionMap.get(this.checkTempDateFormat.format(c));
            }
            ret = ret == null ? "\"" + new SimpleDateFormat(this.fmt).format(c) + "\"" : "TEXT(" + ret + ", \"" + this.fmt + "\")";
        } else {
            ret = "\"" + StringUtil.convertJavaString((String)c.toString()) + "\"";
        }
        return ret;
    }

    private static enum CaseType {
        LowerOrOver,
        Lower,
        Over,
        OverAndLower,
        Multiple,
        Single,
        Unknown;

    }
}

