/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_basictype;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_datetime;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_master;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_masterref;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_storeref;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_string;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_s2p_reference
implements ISourceVariable {
    protected Project project;
    protected Model model;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_s2p_reference.class.getName());
    protected ResourceManager rman;
    protected StringBuilder asb;

    public HelperGenerator_s2p_reference(Project project, Model model, StringBuilder asb) {
        this.project = project;
        this.model = model;
        this.asb = asb;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    protected String process(Modelitem item, Model rmodel) {
        return this.process(item, rmodel, "", 0, null, null);
    }

    protected String process(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid) {
        Relation relation = AppSchemaUtil.getRelationTypeIsRef(item);
        if (relation == null) {
            Object[] o = new Object[]{rmodel.getId(), item.getName()};
            this.logger.error(this.rman.getValue("value.null.relation", o));
            return "";
        }
        Modelitem sitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, rmodel.getId(), item);
        String reftype = sitem.getType();
        if (reftype == null) {
            return "";
        }
        if (!(item.getMultiple() || sitem.getMultiple() && "store".equals(rmodel.getType()))) {
            return this.gReference_single(item, rmodel, basetab, nestlevel, id, rid, reftype);
        }
        return this.gReference_multi(item, rmodel, basetab, nestlevel, id, rid, reftype);
    }

    protected String gReference_single(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid, String reftype) {
        String ret = null;
        if ("string".equals(reftype) || "zipcode".equals(reftype)) {
            HelperGenerator_s2p_string hg = new HelperGenerator_s2p_string(this.project, this.model);
            ret = hg.gString_single(item, rmodel, basetab, nestlevel, id, rid);
        } else if (JavaSourceGenerator.isBasicType(reftype)) {
            HelperGenerator_s2p_basictype hg = new HelperGenerator_s2p_basictype(reftype, this.project, this.model);
            ret = hg.gBasictype_single(item, rmodel, basetab, nestlevel, id, rid);
        } else if (JavaSourceGenerator.isDateOrTimeType(reftype)) {
            HelperGenerator_s2p_datetime hg = new HelperGenerator_s2p_datetime(this.project, this.model);
            ret = hg.gDateTime_single(item, rmodel, basetab, nestlevel, id, rid);
        } else if ("masterref".equals(reftype)) {
            HelperGenerator_s2p_master hg = new HelperGenerator_s2p_master(this.project, this.model);
            HelperGenerator_s2p_masterref hg2 = new HelperGenerator_s2p_masterref(this.project, this.model);
            ret = hg.process(item, rmodel, basetab, nestlevel, id, rid);
            this.asb.append(hg2.process(item, rmodel, "", nestlevel, id, rid));
        } else if ("storeref".equals(reftype)) {
            HelperGenerator_s2p_master hg = new HelperGenerator_s2p_master(this.project, this.model);
            HelperGenerator_s2p_storeref hg2 = new HelperGenerator_s2p_storeref(this.project, this.model);
            ret = hg.process(item, rmodel, basetab, nestlevel, id, rid);
            this.asb.append(hg2.process(item, rmodel, "", nestlevel, id, rid));
        } else {
            Object[] o = new Object[]{rmodel.getId(), item.getName(), reftype};
            this.logger.error(this.rman.getValue("helper.comment.s2p.ref.invalidtype", o));
            ret = "        // Ignore type : " + reftype;
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    protected String gReference_multi(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid, String reftype) {
        String ret = null;
        if ("string".equals(reftype) || "zipcode".equals(reftype)) {
            HelperGenerator_s2p_string hg = new HelperGenerator_s2p_string(this.project, this.model);
            ret = hg.gString_multi(item, rmodel, basetab, nestlevel, id, rid);
        } else if (JavaSourceGenerator.isBasicType(reftype)) {
            HelperGenerator_s2p_basictype hg = new HelperGenerator_s2p_basictype(reftype, this.project, this.model);
            ret = hg.gBasictype_multi(item, rmodel, basetab, nestlevel, id, rid);
        } else if (JavaSourceGenerator.isDateOrTimeType(reftype)) {
            HelperGenerator_s2p_datetime hg = new HelperGenerator_s2p_datetime(this.project, this.model);
            ret = hg.gDateTime_multi(item, rmodel, basetab, nestlevel, id, rid);
        } else {
            Object[] o = new Object[]{rmodel.getId(), item.getName(), reftype};
            this.logger.error(this.rman.getValue("helper.comment.s2p.ref.invalidtype", o));
            ret = "        // Ignore type : " + reftype;
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }
}

