/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_control;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Control;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.Maxlength;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_s2p_string
implements ISourceVariable {
    protected Project project;
    protected Model model;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_s2p_string.class.getName());
    protected ResourceManager rman;

    public HelperGenerator_s2p_string(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    protected String process(Modelitem item, Model rmodel) {
        return this.process(item, rmodel, "", 0, null, null);
    }

    protected String process(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid) {
        if (!item.getMultiple()) {
            return this.gString_single(item, rmodel, basetab, nestlevel, id, rid);
        }
        return this.gString_multi(item, rmodel, basetab, nestlevel, id, rid);
    }

    protected String gString_single(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid) {
        String prename;
        StringBuilder sb = new StringBuilder();
        String itemname = item.getName();
        String varname = prename = SourceGenerator.getElementNameByNestLevel(itemname, nestlevel);
        String pre_fullname = SourceGenerator.getFullNameByNestLevel(itemname, nestlevel);
        Modelitem pre_mitem = AppSchemaUtil.getModelitem(pre_fullname, this.model);
        String pre_mitem_classname = AppSchemaUtil.getModelitemClassname(pre_mitem);
        if (varname == null) {
            this.logger.error(this.rman.getValue("helper.comment.nesterror", this.model.getId()));
            return sb.toString();
        }
        id = id == null ? this.model.getId() : id;
        rid = rid == null ? rmodel.getId() : rid;
        int length = -1;
        Modelitem pitem = AppSchemaUtil.getModelitem(itemname, this.model);
        Control controlHidden = AppSchemaUtil.getControlTypeIsHidden(pitem);
        Control controlReadonly = AppSchemaUtil.getControlTypeIsReadonly(pitem);
        Control controlContainerReadonly = nestlevel > 0 ? AppSchemaUtil.getContainerControlTypeIsReadonly(pre_mitem, this.model) : null;
        HelperGenerator_s2p_control hcon = HelperGenerator_s2p_control.getInstance(this.model.getId(), this.project, this);
        IModelitemChoice[] imic = item.getContent();
        if (imic != null) {
            for (int i = 0; i < imic.length; ++i) {
                if (!(imic[i] instanceof Maxlength)) continue;
                Maxlength maxlength = (Maxlength)imic[i];
                String _maxlength = maxlength.getContent();
                try {
                    length = Integer.parseInt(_maxlength);
                }
                catch (NumberFormatException e) {
                    length = -1;
                }
                break;
            }
        }
        boolean isFileType = false;
        if (itemname.endsWith("_jshfilename") || AppSchemaUtil.getModelitem(itemname + "_jshfilename", this.model) != null) {
            isFileType = true;
        }
        String _prepare = hcon.gPrepare(rmodel, pitem, basetab + "    ");
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.HelperGenerator_s2p.useframework." + this.model.getId()) && length <= 0 && StringUtils.isEmpty((String)_prepare) && controlHidden == null && controlReadonly == null && controlContainerReadonly == null) {
            sb.append(basetab + "        ");
            if ("zipcode".equals(item.getType())) {
                sb.append("s2p_zipcode(");
            } else {
                sb.append("s2p_string(");
            }
            sb.append(id).append(", ");
            sb.append(rid).append(", ");
            sb.append("\"").append(varname).append("\", ");
            sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
            sb.append(AppSchemaUtil.getModelitemClassname(item)).append(".class, ");
            boolean addSortFlag = false;
            if (nestlevel > 0 && !id.endsWith("_cp")) {
                sb.append("true, ");
                addSortFlag = true;
            }
            if (item.getI18n() && !this.model.getUpdatelist()) {
                if (!addSortFlag) {
                    sb.append("false, ");
                }
                sb.append("true, ");
            }
            sb.append("p, itemSet);").append(CR);
            return sb.toString();
        }
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("// " + varname + " : ");
        if (!isFileType) {
            sb.append(this.rman.getValue("helper.comment.string"));
        } else {
            sb.append(this.rman.getValue("helper.comment.file"));
        }
        sb.append(CR);
        if (length > 0) {
            sb.append(basetab + "        ");
            sb.append("int " + varname + "_len = (");
            sb.append(rid);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(" != null) ? ");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append(rid);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(".length() : ");
            sb.append(length);
            sb.append(";");
            sb.append(CR);
        }
        String instancename = "_" + varname;
        sb.append(basetab + "        ");
        sb.append("if (itemSet == null || itemSet.contains(\"" + varname + "\")) {");
        sb.append(CR);
        if (StringUtils.isNotBlank((String)_prepare)) {
            sb.append(_prepare);
            sb.append(CR);
        }
        String mtab = "";
        if (controlHidden != null) {
            sb.append(basetab + "            ");
            sb.append("if (ret) {");
            sb.append(CR);
            mtab = "    ";
        }
        sb.append(basetab + mtab + "            ");
        sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
        sb.append(pre_mitem_classname);
        sb.append(" ");
        sb.append(instancename + "0 =");
        sb.append(CR);
        sb.append(basetab + mtab + "                ");
        sb.append("(");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(" != null) ? ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(" : null;");
        sb.append(CR);
        sb.append(basetab + mtab + "            ");
        sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
        sb.append(pre_mitem_classname);
        sb.append(" ");
        sb.append(instancename);
        sb.append(" = new ");
        sb.append(AppSchemaUtil.getPackagename(this.model, this.project));
        sb.append(pre_mitem_classname);
        sb.append("();");
        sb.append(CR);
        String target_id = rid;
        if (controlHidden != null || controlReadonly != null) {
            String rpackagename = AppSchemaUtil.getPackagename(rmodel, this.project);
            String rclassname = AppSchemaUtil.getClassname(rmodel);
            if (AppSchemaUtil.hasChildPart(item.getName())) {
                String pname = AppSchemaUtil.getParentPart(item.getName());
                Modelitem cont_mitem = AppSchemaUtil.getModelitem(pname, rmodel);
                if (cont_mitem != null) {
                    String cont_mitem_classname = AppSchemaUtil.getModelitemClassname(cont_mitem);
                    sb.append(basetab + mtab + "            ");
                    sb.append(rpackagename);
                    sb.append(rclassname);
                    sb.append(" __target_model = ");
                    sb.append("(mode == UPDATE && ");
                    sb.append("__" + rmodel.getId() + "_preserve_init");
                    sb.append(" != null");
                    sb.append(" && ");
                    sb.append("p.cmd != CommandType.GetXml && ");
                    sb.append("p.cmd != CommandType.AsIs && ");
                    sb.append("p.cmd != CommandType.UserDefined && ");
                    sb.append("p.cmd != CommandType.BackInsert && ");
                    if (StringUtils.isNotBlank((String)rmodel.getRealFilenameRefModelitemFooter()) || AppSchemaUtil.isReadOnly(this.project, item, rmodel)) {
                        sb.append(rid);
                        sb.append(JavaSourceGenerator.getterFullMethod(varname));
                        sb.append(" == null");
                    } else {
                        sb.append("p.request != null && p.request.getParameter(\"");
                        sb.append(id);
                        sb.append(StringUtil.convertJavaVariableString((String)"/"));
                        sb.append(varname);
                        sb.append("\") == null");
                    }
                    sb.append(" && !JFCUtils.isInputErrorOrClearOrAddRemoveAction(p)");
                    sb.append(") ? ");
                    sb.append("__" + rmodel.getId() + "_preserve_init");
                    sb.append(" : ");
                    sb.append(rmodel.getId());
                    sb.append(";");
                    sb.append(CR);
                    sb.append(basetab + mtab + "            ");
                    sb.append(rpackagename);
                    sb.append(cont_mitem_classname);
                    sb.append("[] ");
                    sb.append("__target_" + pname + "_ary = ");
                    sb.append("__target_model");
                    sb.append(JavaSourceGenerator.getterFullMethod(pname));
                    sb.append(";");
                    sb.append(CR);
                    sb.append(basetab + mtab + "            ");
                    sb.append(rpackagename);
                    sb.append(cont_mitem_classname);
                    sb.append(" __target = ");
                    sb.append("(");
                    sb.append("__target_" + pname + "_ary != null && i < ");
                    sb.append("__target_" + pname + "_ary.length) ? ");
                    sb.append("__target_" + pname + "_ary[i] : " + pname + ";");
                    sb.append(CR);
                    target_id = "__target";
                }
            } else {
                sb.append(basetab + mtab + "            ");
                sb.append(rpackagename);
                sb.append(rclassname);
                sb.append(" __target = ");
                sb.append("(mode == UPDATE && ");
                sb.append("__" + rmodel.getId() + "_preserve_init");
                sb.append(" != null");
                sb.append(" && ");
                if (StringUtils.isNotBlank((String)rmodel.getRealFilenameRefModelitemFooter()) || AppSchemaUtil.isReadOnly(this.project, item, rmodel)) {
                    sb.append(rid);
                    sb.append(JavaSourceGenerator.getterFullMethod(varname));
                    sb.append(" == null");
                } else {
                    sb.append("p.request != null && p.request.getParameter(\"");
                    sb.append(id);
                    sb.append(StringUtil.convertJavaVariableString((String)"/"));
                    sb.append(varname);
                    sb.append("\") == null");
                }
                sb.append(" && p.cmd != CommandType.GetXml");
                sb.append(" && p.cmd != CommandType.AsIs");
                sb.append(" && p.cmd != CommandType.UserDefined");
                sb.append(" && p.cmd != CommandType.BackInsert");
                sb.append(" && !JFCUtils.isInputErrorOrClearButton(p)");
                sb.append(") ? ");
                sb.append("__" + rmodel.getId() + "_preserve_init");
                sb.append(" : ");
                sb.append(rmodel.getId());
                sb.append(";");
                sb.append(CR);
                target_id = "__target";
            }
        }
        if (length > 0) {
            sb.append(basetab + mtab + "            ");
            sb.append("if (");
            sb.append(rid);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(" == null)");
            sb.append(CR);
            sb.append(basetab + mtab + "                ");
            sb.append(instancename);
            sb.append(".setContent(\"\");");
            sb.append(CR);
            sb.append(basetab + mtab + "            ");
            sb.append("else {");
            sb.append(CR);
            sb.append(basetab + mtab + "                ");
            sb.append(instancename);
            sb.append(".setContent(");
            sb.append(target_id);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(CR);
            sb.append(basetab + mtab + "                    ");
            sb.append(".substring(0, Math.min(" + length + ", ");
            sb.append(varname + "_len");
            sb.append(")));");
            sb.append(CR);
            sb.append(basetab + mtab + "            ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append(basetab + mtab + "            ");
            sb.append(instancename);
            sb.append(".setContent(");
            sb.append(target_id);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(");");
            sb.append(CR);
        }
        sb.append(basetab + mtab + "            ");
        sb.append("if (");
        sb.append(instancename + "0 != null) {");
        sb.append(CR);
        sb.append(basetab + mtab + "                ");
        sb.append(instancename);
        sb.append(".setErrorcode(");
        sb.append(instancename + "0");
        sb.append(".getErrorcode());");
        sb.append(CR);
        sb.append(hcon.gSetErrorcode(instancename, basetab + mtab + "                "));
        sb.append(basetab + mtab + "            ");
        sb.append("}");
        sb.append(CR);
        if (controlReadonly != null && controlReadonly.getClear()) {
            sb.append(basetab + mtab + "            ").append("if (!ret) {").append(CR);
            sb.append(basetab + mtab + "                ");
            sb.append(instancename);
            sb.append(".setContent(null);");
            sb.append(CR);
            sb.append(basetab + mtab + "            ").append("}").append(CR);
        }
        sb.append(basetab + mtab + "            ");
        sb.append(id);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(varname));
        sb.append("(");
        sb.append(instancename);
        sb.append(");");
        sb.append(CR);
        if (nestlevel > 0 && controlReadonly == null) {
            HelperGenerator_s2p.setSortableProcess(id, varname, controlContainerReadonly, basetab + mtab + "            ", sb);
        }
        if (controlReadonly != null) {
            sb.append(hcon.gFinish(rmodel, instancename, id, pitem, basetab + mtab + "    "));
        }
        if (controlHidden != null) {
            sb.append(basetab + mtab + "        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gString_multi(Modelitem item, Model rmodel, String basetab, int nestlevel, String id, String rid) {
        String prename;
        StringBuilder sb = new StringBuilder();
        String varname = prename = SourceGenerator.getElementNameByNestLevel(item.getName(), nestlevel);
        String pre_fullname = SourceGenerator.getFullNameByNestLevel(item.getName(), nestlevel);
        Modelitem pre_mitem = AppSchemaUtil.getModelitem(pre_fullname, this.model);
        String pre_mitem_classname = AppSchemaUtil.getModelitemClassname(pre_mitem);
        if (varname == null) {
            this.logger.error(this.rman.getValue("helper.comment.nesterror", this.model.getId()));
            return sb.toString();
        }
        id = id == null ? this.model.getId() : id;
        rid = rid == null ? rmodel.getId() : rid;
        int length = -1;
        Modelitem pitem = AppSchemaUtil.getModelitem(item.getName(), this.model);
        Control controlHidden = AppSchemaUtil.getControlTypeIsHidden(pitem);
        Control controlReadonly = AppSchemaUtil.getControlTypeIsReadonly(pitem);
        String instancename = "_" + varname;
        HelperGenerator_s2p_control hcon = HelperGenerator_s2p_control.getInstance(this.model.getId(), this.project, this);
        IModelitemChoice[] imic = item.getContent();
        if (imic != null) {
            for (int i = 0; i < imic.length; ++i) {
                if (!(imic[i] instanceof Maxlength)) continue;
                Maxlength maxlength = (Maxlength)imic[i];
                String _maxlength = maxlength.getContent();
                try {
                    length = Integer.parseInt(_maxlength);
                }
                catch (NumberFormatException e) {
                    length = -1;
                }
                break;
            }
        }
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.HelperGenerator_s2p.useframework." + this.model.getId()) && length <= 0 && controlHidden == null && controlReadonly == null) {
            sb.append(basetab + "        ");
            sb.append("s2p_multistring(");
            sb.append(id).append(", ");
            sb.append(rid).append(", ");
            sb.append("\"").append(varname).append("\", ");
            sb.append(AppSchemaUtil.getModelitemClassname(item));
            sb.append(".class, ");
            sb.append("p, itemSet);").append(CR);
            return sb.toString();
        }
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("// " + varname + " : Multiple String");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (itemSet == null || itemSet.contains(\"" + varname + "\")) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("String[] ");
        sb.append(varname + "_ary = ");
        sb.append(rid);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(";");
        sb.append(CR);
        if (controlHidden != null) {
            sb.append(basetab + "            ");
            sb.append("if (");
            sb.append(varname + "_ary");
            sb.append(" == null || ");
            sb.append(varname + "_ary");
            sb.append(".length == 0");
            sb.append(" && mode == UPDATE");
            sb.append(") {");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("if (");
            sb.append("__" + rmodel.getId() + "_preserve_init");
            sb.append(" != null");
            sb.append(" && ");
            sb.append("__" + rid);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(" == null");
            sb.append(" && (p.action != null && !p.action.startsWith(\"Clear\") && !\"AllClear\".equals(p.action))");
            sb.append(" && p.errors.sizeJfcerror() == 0");
            sb.append(") {");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append(varname + "_ary");
            sb.append(" = ");
            sb.append("__" + rmodel.getId() + "_preserve_init");
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(";");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(basetab + "                    ");
            sb.append(varname + "_ary");
            sb.append(" = ");
            sb.append("__" + rid);
            sb.append(JavaSourceGenerator.getterFullMethod(varname));
            sb.append(";");
            sb.append(CR);
            sb.append(basetab + "                ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append("int size = ");
        sb.append(varname + "_ary.length;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("List<");
        sb.append(pre_mitem_classname);
        sb.append("> ");
        sb.append(varname + "_list = new ArrayList<");
        sb.append(pre_mitem_classname);
        sb.append(">();");
        sb.append(CR);
        if (controlHidden != null || controlReadonly != null) {
            sb.append(hcon.gPrepare(rmodel, pitem, basetab + "    "));
            sb.append(CR);
        }
        sb.append(basetab + "            ");
        sb.append(pre_mitem_classname);
        sb.append("[] ");
        sb.append(instancename + "0_ary =");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("(");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(" != null) ?");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(varname));
        sb.append(" : null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("int _size = (");
        sb.append(instancename + "0_ary != null) ? ");
        sb.append(instancename + "0_ary.length : 0;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(pre_mitem_classname);
        sb.append(" " + instancename);
        sb.append(" = null;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (");
        sb.append(varname + "_ary != null");
        if (controlHidden != null) {
            sb.append(" && ret");
        }
        sb.append(") {");
        sb.append(CR);
        sb.append(this.gHelperString_multi(id, rid, rmodel, varname, pre_mitem_classname, basetab, item, pitem, length, controlReadonly, hcon));
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (");
        sb.append(varname + "_list.size() == 0");
        if (controlHidden != null) {
            sb.append(" && ret");
        }
        sb.append(") {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append(instancename);
        sb.append(" = new ");
        sb.append(pre_mitem_classname);
        sb.append("();");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append(instancename);
        sb.append(".setId(1);");
        sb.append(CR);
        if (controlReadonly != null) {
            sb.append(hcon.gFinish(rmodel, instancename, id, pitem, basetab + "        "));
        }
        sb.append(basetab + "                ");
        sb.append(varname + "_list.add(");
        sb.append(instancename);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(id);
        sb.append(".");
        sb.append(JavaSourceGenerator.setterMethod(varname));
        sb.append("(");
        sb.append(varname + "_list.toArray(new ");
        sb.append(pre_mitem_classname);
        sb.append("[0])");
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gHelperString_multi(String id, String rid, Model rmodel, String varname, String classname, String basetab, Modelitem item, Modelitem pitem, int length, Control control, HelperGenerator_s2p_control hcon) {
        StringBuilder sb = new StringBuilder();
        String instancename = "_" + varname;
        sb.append(basetab + "                ");
        sb.append("int _idx = 1;");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("for (int i=0; i<Math.max(size, _size); i++) {");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append(instancename + " = new ");
        sb.append(classname);
        sb.append("();");
        sb.append(CR);
        if (length > 0) {
            sb.append(basetab + "                    ");
            sb.append("int _len = ");
            sb.append(varname + "_ary[i].length();");
            sb.append(CR);
        }
        sb.append(basetab + "                    ");
        sb.append(instancename + ".setId(_idx++);");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("if (size > i && ");
        sb.append(varname + "_ary[i] != null) {");
        sb.append(CR);
        sb.append(basetab + "                        ");
        sb.append(instancename + ".setContent(" + varname + "_ary[i]");
        if (length > 0) {
            sb.append(CR);
            sb.append(basetab + "                        ");
            sb.append(".substring(0, Math.min(" + length + ", ");
            sb.append("_len");
            sb.append("))");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("if (_size > i &&");
        sb.append(instancename + "0_ary[i] != null) {");
        sb.append(CR);
        sb.append(basetab + "                        ");
        sb.append(instancename);
        sb.append(".setErrorcode(");
        sb.append(instancename + "0_ary[i]");
        sb.append(".getErrorcode());");
        sb.append(CR);
        sb.append(basetab + "                        ");
        sb.append("if (StringUtils.isNotBlank(");
        sb.append(instancename + ".getErrorcode()");
        sb.append(")) {");
        sb.append(CR);
        sb.append(basetab + "                            ");
        sb.append(instancename);
        sb.append(".setContent(");
        sb.append(instancename + "0_ary[i]");
        sb.append(".getContent());");
        sb.append(CR);
        sb.append(basetab + "                        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("}");
        sb.append(CR);
        if (control != null && !"hidden".equals(control.getType())) {
            sb.append(hcon.gFinish(rmodel, instancename, id, pitem, basetab + "            "));
        }
        sb.append(basetab + "                    ");
        sb.append(varname + "_list.add(" + instancename + ");");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

