/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_getControlTypeMap;
import jp.jasminesoft.jfc.gen.HelperGenerator_getStorerefModelitemIdAsString;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_control;
import jp.jasminesoft.jfc.gen.HelperGenerator_toCsvDataHeaderModelitem;
import jp.jasminesoft.jfc.gen.HelperGenerator_toCsvDataModelitem;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TabManager;
import jp.jasminesoft.jfc.gen.appschema.Csvcontrol;
import jp.jasminesoft.jfc.gen.appschema.CsvoutputParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_toCsvData
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_toCsvData.class.getName());

    public HelperGenerator_toCsvData(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        String id = this.model.getId();
        String classname = AppSchemaUtil.getClassname(this.model);
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        String sid = smodel.getId();
        String sclassname = AppSchemaUtil.getClassname(smodel);
        String[] msg_param = new String[]{sid + " " + sclassname, id + " " + classname, "colMap column size", "p ActionParameter", "getallmodelitem boolean", "storedata store model data", "targetitems targetitems"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvData"), msg_param, null));
        sb.append("    ").append("@Override").append(CR);
        sb.append("    ").append("public String[] toCsvData(");
        sb.append(sclassname);
        sb.append(" ");
        sb.append(sid);
        sb.append(", ");
        sb.append(classname);
        sb.append(" ");
        sb.append(id);
        sb.append(", Map colMap, ActionParameter p, boolean getallmodelitem, List<Serializable> storedata, Collection<String> targetitems) { ");
        sb.append(CR);
        this.process0(id, classname, sid, sclassname, smodel, sb, new TabManager(8));
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected void process0(String id, String classname, String sid, String sclassname, Model smodel, StringBuilder sb, TabManager tm) {
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            sb.append(tm.toString());
            sb.append("return new String[0];");
            sb.append(CR);
            return;
        }
        this.outputBeginCode(sb, tm);
        Map<String, Object> itemMap = AppSchemaUtil.devideMapByContainerName(smodel);
        if (this instanceof HelperGenerator_toCsvDataHeaderModelitem || this instanceof HelperGenerator_toCsvDataModelitem) {
            PrimaryKey[] pkeys;
            LinkedHashMap<String, Object> n_itemMap = new LinkedHashMap<String, Object>();
            for (PrimaryKey pkey : pkeys = AppSchemaUtil.getPrimaryKey(smodel)) {
                String name = pkey.getName();
                if (!itemMap.containsKey(name)) continue;
                n_itemMap.put(name, itemMap.get(name));
            }
            for (String name : itemMap.keySet()) {
                if (n_itemMap.containsKey(name)) continue;
                n_itemMap.put(name, itemMap.get(name));
            }
            itemMap = n_itemMap;
        }
        for (String name : itemMap.keySet()) {
            int spacecount;
            Object o = itemMap.get(name);
            if (o instanceof Modelitem) {
                Modelitem mitem = (Modelitem)o;
                spacecount = tm.getSpaceCount();
                this.process0_modelitem(id, classname, sid, sclassname, smodel, name, mitem, tm, sb);
                if (spacecount == tm.getSpaceCount()) continue;
                this.logger.warn("spacecount is wrong (1) " + id + " " + sid + " " + mitem);
                continue;
            }
            if (!(o instanceof Set)) continue;
            Set set = (Set)o;
            spacecount = tm.getSpaceCount();
            this.process0_container(id, classname, sid, sclassname, smodel, name, set, tm, sb);
            if (spacecount == tm.getSpaceCount()) continue;
            this.logger.warn("spacecount is wrong (2) " + id + " " + sid + " " + set);
        }
        this.outputEndCode(sb, tm);
    }

    protected boolean useStoredata() {
        return true;
    }

    protected String outputCallGetCsvTargetItemSet() {
        return "getCsvTargetItemSet()";
    }

    protected void outputBeginCode(StringBuilder sb, TabManager tm) {
        sb.append(tm.toString());
        sb.append("List<String> list = new ArrayList<String>();");
        sb.append(CR);
        if (this.useStoredata()) {
            sb.append(tm.toString());
            sb.append("List<Serializable> storedata_orig = storedata;");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("if (storedata != null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("storedata = new ArrayList<Serializable>();");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tm.toString());
        sb.append("Map<String, List<Integer>> itemBeginCntMap = new HashMap<String, List<Integer>>();");
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("Map<String, List<Integer>> itemEndCntMap = new HashMap<String, List<Integer>>();");
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("Set<String> targetSet;");
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("if (targetitems == null) {");
        sb.append(CR);
        String codeCallGetCsvTargetItemSet = this.outputCallGetCsvTargetItemSet();
        tm.addSpaceCount(4);
        if (codeCallGetCsvTargetItemSet != null) {
            sb.append(tm.toString());
            sb.append("if (getallmodelitem) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("targetSet = null;");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("} else {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("targetSet = new HashSet<String>(" + codeCallGetCsvTargetItemSet + ");");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append(tm.toString());
            sb.append("targetSet = null;");
            sb.append(CR);
        }
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("} else if (targetitems instanceof Set) {");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("targetSet = (Set<String>) targetitems;");
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("} else {");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("targetSet = new HashSet<String>(targetitems);");
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    protected void outputEndCode(StringBuilder sb, TabManager tm) {
        sb.append(CR);
        sb.append(tm.toString());
        if (this.useStoredata()) {
            sb.append("if (targetitems == null || targetitems instanceof Set) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("if (storedata != null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("storedata_orig.addAll(storedata);");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("} else {");
            sb.append(CR);
        } else {
            sb.append("if (targetitems != null && !(targetitems instanceof Set)) {");
            sb.append(CR);
        }
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("List<String> newlist = new ArrayList<String>();");
        sb.append(CR);
        if (this.useStoredata()) {
            sb.append(tm.toString());
            sb.append("ArrayList<Serializable> newstoredata = null;");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("if (storedata != null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("newstoredata = new ArrayList<Serializable>();");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        }
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("sortTargetitems(");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("targetitems, itemBeginCntMap, itemEndCntMap,");
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("list, newlist, ");
        if (this.useStoredata()) {
            sb.append("storedata, newstoredata");
        } else {
            sb.append("null, null");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("list = newlist;");
        sb.append(CR);
        if (this.useStoredata()) {
            sb.append(tm.toString());
            sb.append("if (storedata != null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("storedata_orig.addAll(newstoredata);");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        }
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("return ");
        sb.append("(String[])list.toArray(new String[0])");
        sb.append(";");
        sb.append(CR);
    }

    protected void process0_modelitem(String id, String classname, String sid, String sclassname, Model smodel, String name, Modelitem mitem, TabManager tm, StringBuilder orig_sb) {
        CsvoutputParameterModelitem cpm;
        if (mitem.getGeneration()) {
            return;
        }
        Modelitem pitem = AppSchemaUtil.getModelitem(name, this.model);
        if (pitem == null) {
            return;
        }
        if (!AppSchemaUtil.getCsvOutputable(smodel, name)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CR);
        sb.append(tm.toString());
        sb.append("addItemCountMap(itemBeginCntMap, \"" + name + "\", list.size());");
        sb.append(CR);
        Csvcontrol csvcontrol = AppSchemaUtil.getCsvcontrolTypeIsDownload(pitem, smodel);
        if (csvcontrol != null) {
            sb.append(tm.toString());
            sb.append("{");
            sb.append(CR);
            tm.addSpaceCount(4);
            String basetab = tm.toString();
            basetab = basetab.length() >= 8 ? basetab.substring(8) : "";
            HelperGenerator_s2p_control hc = HelperGenerator_s2p_control.getInstance(this.model.getId(), HelperGenerator_s2p_control.Mode.StoreModel, this.project, this);
            sb.append(hc.gPrepare(csvcontrol, basetab));
        }
        boolean outputPermissionDenyColumn = (cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem)) != null && cpm.getOutputPermissionDenyColumn();
        String methodname = HelperGenerator_getControlTypeMap.getGetControlTypeItemMethod(sid, pitem);
        methodname = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname;
        sb.append(tm.toString());
        sb.append("if (");
        if (csvcontrol != null) {
            sb.append("ret && ");
        }
        if (!pitem.getCsvOutput()) {
            sb.append(this.outputGetallmodelitemCode(mitem.getName()));
            sb.append(" && ");
        }
        sb.append(methodname + " != JFCControlUtil.ControlType.Hidden) {");
        sb.append(CR);
        tm.addSpaceCount(4);
        ProcessType p_pattern = this.process_all(id, classname, sid, sclassname, smodel, mitem, pitem, sb, tm);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        if (outputPermissionDenyColumn) {
            sb.append("} else {");
        } else {
            String methodname_permonly = HelperGenerator_getControlTypeMap.getGetControlTypeItemPermOnlyMethod(pitem);
            methodname_permonly = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname_permonly;
            sb.append("} else if (");
            if (csvcontrol != null) {
                sb.append("ret && ");
            }
            if (!pitem.getCsvOutput()) {
                sb.append(this.outputGetallmodelitemCode(mitem.getName()));
                sb.append(" && ");
            }
            sb.append(methodname_permonly + " != JFCControlUtil.ControlType.Hidden) {");
        }
        sb.append(CR);
        tm.addSpaceCount(4);
        EmptyProcessType e_pattern = this.process_empty(id, mitem, pitem, smodel, sb, tm.toString());
        if (csvcontrol == null && pitem.getCsvOutput() && !outputPermissionDenyColumn && !mitem.getGeneration()) {
            if ((p_pattern == ProcessType.Normal || p_pattern == ProcessType.DualInput) && e_pattern == EmptyProcessType.Single) {
                StringBuilder nsb = new StringBuilder();
                tm.addSpaceCount(-4);
                nsb.append(tm.toString());
                if (p_pattern == ProcessType.Normal) {
                    nsb.append("toCsvDataNormal(");
                } else if (p_pattern == ProcessType.DualInput) {
                    nsb.append("toCsvDataDualInput(");
                }
                nsb.append(sid).append(", ").append(id).append(", ");
                nsb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                String tmp = sb.toString();
                int ptr = tmp.indexOf("storedata.add(");
                tmp = tmp.substring(ptr + "storedata.add(".length());
                ptr = tmp.indexOf(")");
                String part = tmp.substring(0, ptr - 1);
                nsb.append(part).append("()");
                if (part.indexOf(".URelaxer") > 0) {
                    nsb.append(")");
                }
                nsb.append(", ");
                nsb.append("list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                orig_sb.append(nsb.toString());
                return;
            }
            if (p_pattern == ProcessType.StorerefMultiple && e_pattern == EmptyProcessType.Single) {
                sb = new StringBuilder();
                tm.addSpaceCount(-4);
                sb.append(tm.toString());
                sb.append("toCsvDataModelref(").append(sid).append(", ").append(id).append(", ");
                sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                orig_sb.append(sb.toString());
                return;
            }
            if (p_pattern == ProcessType.RefCheckMultiColumnSingleInt && e_pattern == EmptyProcessType.Check_Multiple) {
                sb = new StringBuilder();
                tm.addSpaceCount(-4);
                sb.append(tm.toString());
                sb.append("toCsvDataModelCheckSingleInt(").append(sid).append(", ").append(id).append(", ");
                sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                orig_sb.append(sb.toString());
                return;
            }
            if (p_pattern == ProcessType.Normal_Multiple && e_pattern == EmptyProcessType.Normal_Multiple) {
                Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
                String type = JavaSourceGenerator.b2wc(JavaSourceGenerator.getProperType(smitem2.getType()));
                sb = new StringBuilder();
                tm.addSpaceCount(-4);
                sb.append(tm.toString());
                sb.append("toCsvDataMultiple(").append(sid).append(", ").append(id).append(", ");
                sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                sb.append(type).append(".class, ");
                sb.append("list, storedata, colMap, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                orig_sb.append(sb.toString());
                return;
            }
        } else if (csvcontrol == null && !pitem.getCsvOutput() && p_pattern == ProcessType.Normal) {
            StringBuilder nsb = new StringBuilder();
            tm.addSpaceCount(-4);
            nsb.append(tm.toString());
            nsb.append("toCsvDataNormalCheckTargetSet(");
            nsb.append(sid).append(", ").append(id).append(", ");
            nsb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
            String tmp = sb.toString();
            int ptr = tmp.indexOf("storedata.add(");
            tmp = tmp.substring(ptr + "storedata.add(".length());
            ptr = tmp.indexOf(")");
            String part = tmp.substring(0, ptr - 1);
            nsb.append(part).append("()");
            if (part.indexOf(".URelaxer") > 0) {
                nsb.append(")");
            }
            nsb.append(", ");
            nsb.append("list, storedata, getallmodelitem, targetSet, p);").append(CR);
            orig_sb.append(nsb.toString());
            return;
        }
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        if (csvcontrol != null) {
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tm.toString());
        sb.append("addItemCountMap(itemEndCntMap, \"" + name + "\", list.size());");
        sb.append(CR);
        sb.append(CR);
        orig_sb.append(sb.toString());
    }

    protected void process0_container(String id, String classname, String sid, String sclassname, Model smodel, String name, Set<Modelitem> set, TabManager tm, StringBuilder orig_sb) {
        boolean firstFlag = true;
        String _parentname = null;
        boolean parent_outputPermissionDenyColumn = false;
        boolean parent_pmitem_csvOutput = false;
        for (Modelitem mitem : set) {
            Modelitem pitem = AppSchemaUtil.getModelitem(mitem.getName(), this.model);
            if (!AppSchemaUtil.getCsvOutputable(smodel, mitem.getName())) continue;
            if (firstFlag) {
                String parentname = AppSchemaUtil.getParentPart(pitem.getName());
                Modelitem parent_pmitem = AppSchemaUtil.getModelitem(parentname, this.model);
                parent_pmitem_csvOutput = parent_pmitem.getCsvOutput();
                _parentname = "_" + name;
                orig_sb.append(CR);
                orig_sb.append(tm.toString());
                orig_sb.append("if (");
                orig_sb.append("(targetSet == null || containsMultipleItem(targetSet, \"" + name + "\"))");
                tm.addSpaceCount(4);
                String methodname = HelperGenerator_getControlTypeMap.getGetControlTypeItemMethod(sid, parent_pmitem);
                methodname = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname;
                String methodname_permonly = HelperGenerator_getControlTypeMap.getGetControlTypeItemPermOnlyMethod(parent_pmitem);
                methodname_permonly = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname_permonly;
                CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(parent_pmitem);
                boolean bl = parent_outputPermissionDenyColumn = cpm != null && cpm.getOutputPermissionDenyColumn();
                if (parent_outputPermissionDenyColumn) {
                    if (!parent_pmitem_csvOutput) {
                        orig_sb.append(" &&");
                        orig_sb.append(CR);
                        orig_sb.append(tm.toString());
                        orig_sb.append(this.outputGetallmodelitemCode(mitem.getName()));
                    }
                    orig_sb.append(") {");
                    orig_sb.append(CR);
                } else {
                    if (!parent_pmitem_csvOutput) {
                        orig_sb.append(" &&");
                        orig_sb.append(CR);
                        orig_sb.append(tm.toString());
                        orig_sb.append(this.outputGetallmodelitemCode(mitem.getName()));
                    }
                    orig_sb.append(" &&");
                    orig_sb.append(CR);
                    orig_sb.append(tm.toString());
                    orig_sb.append(methodname_permonly + " != JFCControlUtil.ControlType.Hidden) {");
                    orig_sb.append(CR);
                }
                orig_sb.append(tm.toString());
                orig_sb.append("JFCControlUtil.ControlType parent_control = " + methodname + ";");
                orig_sb.append(CR);
                this.process0_container_beginloop(smodel, parent_pmitem, _parentname, id, name, tm.toString(), orig_sb);
                tm.addSpaceCount(4);
                firstFlag = false;
            }
            StringBuilder sb = new StringBuilder();
            String methodname = HelperGenerator_getControlTypeMap.getGetControlTypeItemMethod(sid, pitem);
            methodname = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname;
            CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem);
            boolean outputPermissionDenyColumn = cpm != null && cpm.getOutputPermissionDenyColumn();
            sb.append(tm.toString());
            sb.append("if (");
            if (parent_pmitem_csvOutput && !pitem.getCsvOutput()) {
                sb.append(this.outputGetallmodelitemCode(mitem.getName()));
                sb.append(" && ");
            }
            sb.append("parent_control != JFCControlUtil.ControlType.Hidden &&");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append(methodname + " != JFCControlUtil.ControlType.Hidden)");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("{");
            sb.append(CR);
            tm.addSpaceCount(4);
            ProcessType p_pattern = this.process_all(_parentname + "[k]", classname, sid, sclassname, smodel, mitem, pitem, sb, tm);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            if (outputPermissionDenyColumn) {
                sb.append("} else {");
            } else {
                String methodname_permonly = HelperGenerator_getControlTypeMap.getGetControlTypeItemPermOnlyMethod(pitem);
                methodname_permonly = AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project) + "." + methodname_permonly;
                sb.append("} else if (");
                if (parent_pmitem_csvOutput && !pitem.getCsvOutput()) {
                    sb.append(this.outputGetallmodelitemCode(mitem.getName()));
                    sb.append(" && ");
                }
                sb.append(methodname_permonly + " != JFCControlUtil.ControlType.Hidden) {");
            }
            sb.append(CR);
            tm.addSpaceCount(4);
            EmptyProcessType e_pattern = this.process_empty(_parentname + "[k]", mitem, pitem, smodel, sb, tm.toString());
            sb.append("// p_pattern=" + (Object)((Object)p_pattern) + ",e_pattern=" + (Object)((Object)e_pattern) + " " + pitem.getCsvOutput() + " " + !outputPermissionDenyColumn + CR);
            if (pitem.getCsvOutput() && !outputPermissionDenyColumn && !mitem.getGeneration()) {
                if ((p_pattern == ProcessType.Normal || p_pattern == ProcessType.DualInput) && e_pattern == EmptyProcessType.Single) {
                    StringBuilder nsb = new StringBuilder();
                    tm.addSpaceCount(-4);
                    nsb.append(tm.toString());
                    if (p_pattern == ProcessType.Normal) {
                        nsb.append("toCsvDataNormal(");
                    } else if (p_pattern == ProcessType.DualInput) {
                        nsb.append("toCsvDataDualInput(");
                    }
                    nsb.append("parent_control, ");
                    nsb.append("_s_").append(name).append("[k]").append(", ");
                    nsb.append(_parentname).append("[k]").append(", ");
                    nsb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                    nsb.append("\"").append(mitem.getName().replace('/', '$')).append("\", ");
                    String tmp = sb.toString();
                    int ptr = tmp.indexOf("storedata.add(");
                    tmp = tmp.substring(ptr + "storedata.add(".length());
                    ptr = tmp.indexOf(")");
                    String part = tmp.substring(0, ptr - 1);
                    nsb.append(part).append("()");
                    if (part.indexOf(".URelaxer") > 0) {
                        nsb.append(")");
                    }
                    nsb.append(", ");
                    nsb.append("list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                    orig_sb.append(nsb.toString());
                    continue;
                }
                if (p_pattern == ProcessType.StorerefMultiple && e_pattern == EmptyProcessType.Single) {
                    sb = new StringBuilder();
                    tm.addSpaceCount(-4);
                    sb.append(tm.toString());
                    sb.append("toCsvDataModelref(");
                    sb.append("parent_control, ");
                    sb.append("_s_").append(name).append("[k]").append(", ");
                    sb.append(_parentname).append("[k]").append(", ");
                    sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                    sb.append("\"").append(mitem.getName().replace('/', '$')).append("\", ");
                    sb.append("list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                    orig_sb.append(sb.toString());
                    continue;
                }
                if (p_pattern == ProcessType.RefCheckMultiColumnSingleInt && e_pattern == EmptyProcessType.Check_Multiple) {
                    sb = new StringBuilder();
                    tm.addSpaceCount(-4);
                    sb.append(tm.toString());
                    sb.append("toCsvDataModelCheckSingleInt(");
                    sb.append("parent_control, ");
                    sb.append("_s_").append(name).append("[k]").append(", ");
                    sb.append(_parentname).append("[k]").append(", ");
                    sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                    sb.append("\"").append(mitem.getName().replace('/', '$')).append("\", ");
                    sb.append("list, storedata, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                    orig_sb.append(sb.toString());
                    continue;
                }
                if (p_pattern == ProcessType.Normal_Multiple && e_pattern == EmptyProcessType.Normal_Multiple) {
                    Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
                    String type = JavaSourceGenerator.b2wc(JavaSourceGenerator.getProperType(smitem2.getType()));
                    sb = new StringBuilder();
                    tm.addSpaceCount(-4);
                    sb.append(tm.toString());
                    sb.append("toCsvDataMultiple(");
                    sb.append("parent_control, ");
                    sb.append("_s_").append(name).append("[k]").append(", ");
                    sb.append(_parentname).append("[k]").append(", ");
                    sb.append("\"").append(AppSchemaUtil.getChildPart(pitem.getName())).append("\", ");
                    sb.append("\"").append(mitem.getName().replace('/', '$')).append("\", ");
                    sb.append(type).append(".class, ");
                    sb.append("list, storedata, colMap, p, targetSet, itemBeginCntMap, itemEndCntMap);").append(CR);
                    orig_sb.append(sb.toString());
                    continue;
                }
            }
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
            orig_sb.append(sb.toString());
        }
        if (!firstFlag) {
            tm.addSpaceCount(-4);
            this.process0_container_endloop(smodel, name, set, tm.toString(), orig_sb);
            tm.addSpaceCount(-4);
            orig_sb.append(tm.toString());
            orig_sb.append("}");
            orig_sb.append(CR);
        }
    }

    protected ProcessType process_all(String id, String classname, String sid, String sclassname, Model smodel, Modelitem mitem, Modelitem pitem, StringBuilder sb, TabManager tm) {
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
        if ("combo".equals(mitem.getDualinputmethod()) && "store".equals(smodel.getType())) {
            return this.process_dualinput(id, sid, mitem, pitem, sb, tm.toString());
        }
        if ("masterref".equals(smitem2.getType()) || "storeref".equals(smitem2.getType())) {
            return this.process_ref(id, mitem, pitem, smodel, sb, tm.toString());
        }
        return this.process_normal(id, classname, sid, sclassname, smodel, mitem, pitem, sb, tm.toString());
    }

    protected void process0_container_beginloop(Model smodel, Modelitem parent_pmitem, String _parentname, String id, String name, String basetab, StringBuilder sb) {
        String _p_classname = AppSchemaUtil.getModelitemClassname(parent_pmitem);
        String _p_packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        Modelitem parent_smitem = AppSchemaUtil.getModelitem(parent_pmitem.getName(), smodel);
        String _s_classname = AppSchemaUtil.getModelitemClassname(parent_smitem);
        String _s_packagename = AppSchemaUtil.getPackagename(smodel, this.project);
        sb.append(basetab);
        sb.append(_s_packagename);
        sb.append(_s_classname);
        sb.append("[]");
        sb.append(" _s");
        sb.append(_parentname);
        sb.append(" = ");
        sb.append(smodel.getId());
        sb.append(JavaSourceGenerator.getterFullMethod(name));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab);
        sb.append(_p_packagename);
        sb.append(_p_classname);
        sb.append("[]");
        sb.append(" ");
        sb.append(_parentname);
        sb.append(" = ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(name));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("int _length = Math.min(_s").append(_parentname).append(".length, ");
        sb.append(_parentname).append(".length);").append(CR);
        sb.append(basetab);
        sb.append("for (int k=0; k<_length; k++) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("p.request.setAttribute(\"__" + name + "\", _s" + _parentname + "[k]);");
        sb.append(CR);
    }

    protected void process0_container_endloop(Model smodel, String name, Set<Modelitem> set, String basetab, StringBuilder sb) {
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("Integer _count = (Integer)colMap.get(\"");
        sb.append(name);
        sb.append("\");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (_count == null) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("_count = Integer.valueOf(1);");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("int diff = _count.intValue() - ");
        sb.append("_" + name + ".length;");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (_count.intValue() == 0) diff = 1;");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (diff > 0) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int l=0; l<diff; l++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("Integer _rownum;");
        sb.append(CR);
        for (Modelitem mitem : set) {
            if (!AppSchemaUtil.getCsvOutputable(smodel, mitem.getName())) continue;
            String cname = AppSchemaUtil.getChildPart(mitem.getName());
            sb.append(basetab + "        ");
            sb.append("_rownum = (Integer)colMap.get(\"");
            sb.append(cname + ":rownum");
            sb.append("\");");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("if (_rownum != null) {");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("addItemCountMap(itemBeginCntMap, \"");
            sb.append(cname);
            sb.append("\", list.size());");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("addMultipleEmpty(list, storedata, _rownum);");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("addItemCountMap(itemEndCntMap, \"");
            sb.append(cname);
            sb.append("\", list.size());");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    protected ProcessType process_dualinput(String id, String sid, Modelitem mitem, Modelitem pitem, StringBuilder sb, String basetab) {
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        sb.append(basetab);
        sb.append(packagename);
        sb.append(AppSchemaUtil.getModelitemClassname(mitem));
        sb.append("[] values = ");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
        sb.append(";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("String s = \"\";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("for (int i=0; i<values.length; i++) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (values[i].getChoose()) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("s = ");
        sb.append("values[i].getContent();");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("break;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("list.add(s);");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab, sid + JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
        return ProcessType.DualInput;
    }

    protected ProcessType process_normal(String id, String classname, String sid, String sclassname, Model smodel, Modelitem mitem, Modelitem pitem, StringBuilder sbm, String basetab) {
        ProcessType ret = ProcessType.None;
        StringBuilder sb = new StringBuilder();
        String _packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        boolean isMultiple = false;
        Modelitem smitem2 = mitem;
        if (!"storeref".equals(mitem.getType())) {
            isMultiple = mitem.getMultiple();
        } else {
            smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
            isMultiple = smitem2.getMultiple();
        }
        String _classname = AppSchemaUtil.getModelitemClassname(pitem);
        String _instancename = "_" + AppSchemaUtil.getChildPart(pitem.getName());
        if (isMultiple) {
            _instancename = _instancename + "s";
        }
        sb.append(basetab);
        sb.append(_packagename);
        sb.append(_classname);
        if (isMultiple) {
            sb.append("[]");
        }
        sb.append(" ");
        sb.append(_instancename);
        sb.append(" = ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
        sb.append(";");
        sb.append(CR);
        if (isMultiple) {
            String _s_instancename = "_s" + _instancename;
            sb.append(basetab);
            sb.append(JavaSourceGenerator.getProperType(mitem.getType()));
            sb.append("[] ");
            sb.append(_s_instancename);
            sb.append(" = null;");
            sb.append(CR);
            sb.append(basetab);
            sb.append("if (" + sid + " != null) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append(_s_instancename);
            sb.append(" = ");
            sb.append(sid);
            sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
            sb.append(";");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("for (int k=0; k<");
            sb.append(_instancename);
            sb.append(".length; k++) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("String s = ");
            sb.append(_instancename + "[k].getContent();");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("s = (s == null) ? \"\" : s;");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("list.add(s);");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("if (storedata != null) {");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("if (" + _s_instancename + " != null && ");
            sb.append(_s_instancename + ".length > k) {");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("storedata.add(");
            sb.append(_s_instancename);
            sb.append("[k]);");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("storedata.add(null);");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("Integer _count = (Integer)colMap.get(\"");
            sb.append(AppSchemaUtil.getChildPart(pitem.getName()));
            sb.append("\");");
            sb.append(CR);
            sb.append(basetab);
            sb.append("if (_count == null) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_count = Integer.valueOf(1);");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("int diff = _count.intValue() - ");
            sb.append(_instancename + ".length;");
            sb.append(CR);
            sb.append(basetab);
            sb.append("if (diff > 0) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("for (int k=0; k<diff; k++) {");
            sb.append(CR);
            this.gAddEmptyCode(sb, basetab + "        ");
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            ret = ProcessType.Normal_Multiple;
        } else {
            boolean hasChildPart = AppSchemaUtil.hasChildPart(mitem.getName());
            String _s_cont_instancename = "_s_" + AppSchemaUtil.getParentPart(pitem.getName()) + "[k]";
            sb.append(basetab).append("list.add(StringUtils.defaultString(").append(_instancename).append(".getContent()));").append(CR);
            sb.append(basetab);
            sb.append("if (storedata != null) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("storedata.add(");
            if ("juser".equals(sid) && "passwd".equals(mitem.getName())) {
                sb.append("\"\"");
            } else {
                if (AppSchemaUtil.isMust(mitem, smodel)) {
                    if (hasChildPart) {
                        sb.append(_s_cont_instancename);
                    } else {
                        sb.append(sid);
                    }
                    sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
                } else {
                    sb.append(JavaSourceGenerator.getterFullMethodAsObject(hasChildPart ? _s_cont_instancename : sid, AppSchemaUtil.getChildPart(mitem.getName()), smitem2.getType()));
                }
                ret = ProcessType.Normal;
            }
            sb.append(");");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
        }
        sbm.append(sb.toString());
        return ret;
    }

    protected ProcessType process_ref(String id, Modelitem mitem, Modelitem pitem, Model smodel, StringBuilder sb, String basetab) {
        PrimaryKey[] pkeys;
        Model refsmodel;
        String _packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        boolean isCompositeKey = false;
        if (relation != null && (refsmodel = AppSchemaUtil.getModel(this.project, relation.getIdref())) != null && (pkeys = AppSchemaUtil.getPrimaryKey(refsmodel)) != null && pkeys.length > 1) {
            isCompositeKey = true;
        }
        boolean isMultiple = this.chaseRelationElement(mitem);
        if (relation == null) {
            return ProcessType.None;
        }
        IRNode node = relation.getIdrefAsIRNode();
        Model master = null;
        if (node != null && node instanceof Model) {
            master = (Model)node;
        }
        String varname = "value" + (isMultiple ? "s" : "");
        String type = smitem2.getType();
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem);
        boolean outputStorerefPrimaryKey = cpm != null && cpm.getOutputStorerefPrimaryKey();
        sb.append(basetab);
        sb.append(_packagename);
        sb.append(AppSchemaUtil.getModelitemClassname(mitem));
        if (isMultiple) {
            sb.append("[]");
        }
        sb.append(" ");
        sb.append(varname);
        sb.append(" =");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(id);
        sb.append(JavaSourceGenerator.getterFullMethod(AppSchemaUtil.getChildPart(mitem.getName())));
        sb.append(";");
        sb.append(CR);
        if ("check".equals(relation.getType()) && master != null && ("masterref".equals(type) || "storeref".equals(type))) {
            return this.process_ref_check(id, mitem, pitem, sb, basetab, _packagename, smitem2, varname, type);
        }
        if ("ref".equals(relation.getType()) && isMultiple) {
            sb.append(basetab);
            sb.append("if (" + varname + " != null && " + varname + ".length > 0) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("list.add(" + varname + "[0].getContent());");
            sb.append(CR);
            this.gAddStoredataCode(sb, basetab + "    ", varname + "[0].getContent()");
            if (outputStorerefPrimaryKey) {
                String methodcall2;
                String methodcall;
                if (isCompositeKey) {
                    methodcall2 = methodcall = HelperGenerator_getStorerefModelitemIdAsString.getMethodname(mitem) + "(" + varname + "[0])";
                } else {
                    methodcall = varname + "[0].getIdAsString()";
                    methodcall2 = varname + "[0].getId()";
                }
                sb.append(basetab + "    ");
                sb.append("list.add(");
                sb.append(methodcall);
                sb.append(");");
                sb.append(CR);
                this.gAddStoredataCode(sb, basetab + "    ", methodcall2);
            }
            sb.append(basetab);
            sb.append("} else {");
            sb.append(CR);
            this.gAddEmptyCode(sb, basetab + "    ");
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            return !outputStorerefPrimaryKey ? ProcessType.StorerefMultipleRef : ProcessType.StorerefMultipleRefPKey;
        }
        if (isMultiple) {
            sb.append(basetab);
            sb.append("boolean isChoose = false;");
            sb.append(CR);
            sb.append(basetab);
            sb.append("for (int i=0; i<" + varname + ".length; i++) {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("if (" + varname + "[i].getChoose()) {");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("list.add(" + varname + "[i].getContent());");
            sb.append(CR);
            this.gAddStoredataCode(sb, basetab + "        ", varname + "[i].getContent()");
            if (outputStorerefPrimaryKey) {
                String methodcall2;
                String methodcall;
                if (isCompositeKey) {
                    methodcall2 = methodcall = HelperGenerator_getStorerefModelitemIdAsString.getMethodname(mitem) + "(" + varname + "[i])";
                } else {
                    methodcall = varname + "[i].getIdAsString()";
                    methodcall2 = varname + "[i].getId()";
                }
                sb.append(basetab + "        ");
                sb.append("list.add(" + methodcall + ");");
                sb.append(CR);
                this.gAddStoredataCode(sb, basetab + "        ", methodcall2);
            }
            sb.append(basetab + "        ");
            sb.append("isChoose = true;");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("break;");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            sb.append(basetab);
            sb.append("if (!isChoose) {");
            sb.append(CR);
            this.gAddEmptyCode(sb, basetab + "    ", outputStorerefPrimaryKey);
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
            return !outputStorerefPrimaryKey ? ProcessType.StorerefMultiple : ProcessType.StorerefMultiplePKey;
        }
        sb.append(basetab);
        sb.append("if (" + varname + " != null) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("list.add(" + varname + ".getContent());");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab + "    ", varname + ".getContent()");
        if (outputStorerefPrimaryKey) {
            String methodcall2;
            String methodcall;
            if (isCompositeKey) {
                methodcall2 = methodcall = HelperGenerator_getStorerefModelitemIdAsString.getMethodname(mitem) + "(" + varname + ")";
            } else {
                methodcall = varname + ".getIdAsString()";
                methodcall2 = varname + ".getId()";
            }
            sb.append(basetab + "    ");
            sb.append("list.add(" + methodcall + ");");
            sb.append(CR);
            this.gAddStoredataCode(sb, basetab + "    ", methodcall2);
        }
        sb.append(basetab);
        sb.append("} else {");
        sb.append(CR);
        this.gAddEmptyCode(sb, basetab + "    ", outputStorerefPrimaryKey);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        return !outputStorerefPrimaryKey ? ProcessType.Storeref : ProcessType.StorerefPKey;
    }

    protected ProcessType process_ref_check(String id, Modelitem mitem, Modelitem pitem, StringBuilder sb, String basetab, String _packagename, Modelitem smitem2, String varname, String type) {
        boolean outputOneColumnForCheckbox;
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem);
        boolean bl = outputOneColumnForCheckbox = cpm != null && cpm.getOutputOneColumnForCheckbox();
        if (outputOneColumnForCheckbox) {
            return this.process_ref_check_onecolumn(id, mitem, pitem, sb, basetab, smitem2, varname);
        }
        return this.process_ref_check_multicolumn(id, mitem, pitem, sb, basetab, _packagename, smitem2, varname, type);
    }

    protected ProcessType process_ref_check_onecolumn(String id, Modelitem mitem, Modelitem pitem, StringBuilder sb, String basetab, Modelitem smitem2, String varname) {
        PrimaryKey[] pkeys;
        Model refsmodel;
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem);
        String separator = cpm.getSeparatorOneColumnForCheckbox();
        separator = separator != null && separator.length() > 0 ? separator.substring(0, 1) : ",";
        boolean outputStorerefPrimaryKey = cpm != null && cpm.getOutputStorerefPrimaryKey();
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        boolean isCompositeKey = false;
        if (relation != null && (refsmodel = AppSchemaUtil.getModel(this.project, relation.getIdref())) != null && (pkeys = AppSchemaUtil.getPrimaryKey(refsmodel)) != null && pkeys.length > 1) {
            isCompositeKey = true;
        }
        sb.append(basetab);
        sb.append("StringBuilder sb_content = new StringBuilder();");
        sb.append(CR);
        if (outputStorerefPrimaryKey) {
            sb.append(basetab);
            sb.append("StringBuilder sb_id = new StringBuilder();");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("for (int j=0; " + varname + " != null && j<" + varname + ".length; j++) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname + "[j].getChoose()) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (sb_content.length() > 0) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("sb_content.append(\"" + separator + "\");");
        sb.append(CR);
        if (outputStorerefPrimaryKey) {
            sb.append(basetab + "            ");
            sb.append("sb_id.append(\"" + separator + "\");");
            sb.append(CR);
        }
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("sb_content.append(" + varname + "[j].getContent());");
        sb.append(CR);
        if (outputStorerefPrimaryKey) {
            String methodcall = isCompositeKey ? HelperGenerator_getStorerefModelitemIdAsString.getMethodname(mitem) + "(" + varname + "[j])" : varname + "[j].getIdAsString()";
            sb.append(basetab + "        ");
            sb.append("sb_id.append(" + methodcall + ");");
            sb.append(CR);
        }
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("list.add(sb_content.toString());");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab, "sb_content.toString()");
        if (outputStorerefPrimaryKey) {
            sb.append(basetab);
            sb.append("list.add(sb_id.toString());");
            sb.append(CR);
            this.gAddStoredataCode(sb, basetab, "sb_id.toString()");
        }
        return ProcessType.RefCheckOneColumn;
    }

    protected ProcessType process_ref_check_multicolumn(String id, Modelitem mitem, Modelitem pitem, StringBuilder sb, String basetab, String _packagename, Modelitem smitem2, String varname, String type) {
        Relation _relation;
        sb.append(basetab);
        sb.append(_packagename);
        sb.append(AppSchemaUtil.getModelitemClassname(mitem));
        sb.append("[] code_m =");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project)).append(".");
        sb.append("get").append(AppSchemaUtil.getModelitemClassname(mitem)).append("_all(p);");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (code_m != null && code_m.length > 0) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int i=0; i<code_m.length; i++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("boolean outputFlag = false;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("for (int j=0; " + varname + " != null && j<" + varname + ".length; j++) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("if (");
        PrimaryKey[] _r_pkeys = null;
        String[] reftypes = AppSchemaUtil.decompositePrimaryKey(AppSchemaUtil.getModelitemType(this.project, id, smitem2, "roleid"));
        if (reftypes != null && reftypes.length > 1 && (_relation = AppSchemaUtil.getRelation(smitem2)) != null) {
            Model _rmodel = (Model)_relation.getIdrefAsIRNode();
            _r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(_rmodel, this.project);
        }
        String reftype = null;
        for (int i = 0; i < reftypes.length; ++i) {
            reftype = reftypes[i];
            String judge = " == ";
            if ("storeref".equals(type) && !JavaSourceGenerator.isBasicType(reftype)) {
                judge = ".equals(";
            }
            String getter = i == 0 ? JavaSourceGenerator.getterFullMethod("id") : JavaSourceGenerator.getterFullMethod(_r_pkeys[i].getName() + "_jshpkey");
            sb.append("code_m[i]" + getter);
            sb.append(judge);
            sb.append(varname + "[j]" + getter);
            if (!judge.equals(" == ")) {
                sb.append(")");
            }
            if (i >= reftypes.length - 1) continue;
            sb.append(" && ");
        }
        sb.append(") {");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("if (" + varname + "[j].getChoose()) {");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("list.add(\"1\");");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab + "                    ", "1");
        sb.append(basetab + "                ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(basetab + "                    ");
        sb.append("list.add(\"0\");");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab + "                    ", "0");
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("outputFlag = true;");
        sb.append(CR);
        sb.append(basetab + "                ");
        sb.append("break;");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (!outputFlag) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("list.add(\" \");");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab + "            ", "\" \"");
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("} else {");
        sb.append(CR);
        this.gAddEmptyCode(sb, basetab + "    ");
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        if (reftypes != null && reftypes.length > 1) {
            return ProcessType.RefCheckMultiColumnCompositeKey;
        }
        if ("int".equals(reftype) || "int[]".equals(reftype)) {
            return ProcessType.RefCheckMultiColumnSingleInt;
        }
        return ProcessType.RefCheckMultiColumn;
    }

    protected EmptyProcessType process_empty(String id, Modelitem mitem, Modelitem pitem, Model smodel, StringBuilder sb, String basetab) {
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
        if ("combo".equals(mitem.getDualinputmethod()) && "store".equals(smodel.getType())) {
            return this.gAddEmptyCode(sb, basetab);
        }
        if ("masterref".equals(smitem2.getType()) || "storeref".equals(smitem2.getType())) {
            return this.process_empty_ref(id, mitem, pitem, smodel, sb, basetab);
        }
        if (mitem.getMultiple()) {
            return this.process_empty_normal_multiple(id, mitem, pitem, smodel, sb, basetab);
        }
        return this.gAddEmptyCode(sb, basetab);
    }

    protected EmptyProcessType process_empty_ref(String id, Modelitem mitem, Modelitem pitem, Model smodel, StringBuilder sb, String basetab) {
        boolean outputStorerefPrimaryKey;
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        IRNode node = null;
        if (relation != null) {
            node = relation.getIdrefAsIRNode();
        }
        Model master = null;
        if (node != null && node instanceof Model) {
            master = (Model)node;
        }
        String type = smitem2.getType();
        CsvoutputParameterModelitem cpm = AppSchemaUtil.getCsvoutputParameterModelitem(pitem);
        boolean bl = outputStorerefPrimaryKey = cpm != null && cpm.getOutputStorerefPrimaryKey();
        if (relation != null && "check".equals(relation.getType()) && master != null && ("masterref".equals(type) || "storeref".equals(type))) {
            boolean outputOneColumnForCheckbox;
            boolean bl2 = outputOneColumnForCheckbox = cpm != null && cpm.getOutputOneColumnForCheckbox();
            if (!outputOneColumnForCheckbox) {
                return this.process_empty_check_multiple(id, mitem, pitem, smodel, sb, basetab);
            }
        }
        return this.gAddEmptyCode(sb, basetab, outputStorerefPrimaryKey);
    }

    private EmptyProcessType process_empty_check_multiple(String id, Modelitem mitem, Modelitem pitem, Model smodel, StringBuilder sb, String basetab) {
        String _packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        Modelitem smitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem);
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem2);
        if (relation == null) {
            return EmptyProcessType.None;
        }
        sb.append(basetab);
        sb.append(_packagename);
        sb.append(AppSchemaUtil.getModelitemClassname(mitem));
        sb.append("[] code_m =");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(this.model, this.project)).append(".");
        sb.append("get").append(AppSchemaUtil.getModelitemClassname(mitem)).append("_all(p);");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (code_m != null && code_m.length > 0) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int i=0; i<code_m.length; i++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("list.add(\" \");");
        sb.append(CR);
        this.gAddStoredataCode(sb, basetab + "        ", "\" \"");
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("} else {");
        sb.append(CR);
        this.gAddEmptyCode(sb, basetab + "    ");
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        return EmptyProcessType.Check_Multiple;
    }

    protected EmptyProcessType process_empty_normal_multiple(String id, Modelitem mitem, Modelitem pitem, Model smodel, StringBuilder sb, String basetab) {
        sb.append(basetab);
        sb.append("Integer _count = (Integer)colMap.get(\"");
        sb.append(AppSchemaUtil.getChildPart(pitem.getName()));
        sb.append("\");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (_count == null) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("_count = Integer.valueOf(1);");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("for (int k=0; k<_count.intValue(); k++) {");
        sb.append(CR);
        this.gAddEmptyCode(sb, basetab + "    ");
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        return EmptyProcessType.Normal_Multiple;
    }

    protected boolean chaseRelationElement(Modelitem mitem) {
        boolean isChaseRelationElement = false;
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        if (relation != null) {
            isChaseRelationElement = true;
        } else {
            relation = AppSchemaUtil.getRelationTypeIsRef(mitem);
            IRNode node = relation.getIdrefAsIRNode();
            if (node != null && node instanceof Model) {
                Model rmodel = (Model)node;
                Modelitem rmitem = AppSchemaUtil.getModelitem(relation.getName(), rmodel);
                if (rmitem != null) {
                    if ("masterref".equals(rmitem.getType())) {
                        isChaseRelationElement = true;
                    } else if ("storeref".equals(rmitem.getType())) {
                        isChaseRelationElement = this.chaseRelationElement(rmitem);
                    }
                }
            }
        }
        return isChaseRelationElement;
    }

    private EmptyProcessType gAddEmptyCode(StringBuilder sb, String basetab) {
        return this.gAddEmptyCode(sb, basetab, 1);
    }

    private EmptyProcessType gAddEmptyCode(StringBuilder sb, String basetab, boolean isdual) {
        return this.gAddEmptyCode(sb, basetab, isdual ? 2 : 1);
    }

    private EmptyProcessType gAddEmptyCode(StringBuilder sb, String basetab, int cnt) {
        if (cnt == 1) {
            sb.append(basetab).append("addSingleEmpty(list, storedata);").append(CR);
            return EmptyProcessType.Single;
        }
        sb.append(basetab).append("addMultipleEmpty(list, storedata, ").append(cnt).append(");").append(CR);
        return EmptyProcessType.Multiple;
    }

    private void gAddStoredataCode(StringBuilder sb, String basetab, String valuecode) {
        sb.append(basetab);
        sb.append("if (storedata != null) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("storedata.add(").append(valuecode).append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    protected String outputGetallmodelitemCode(String itemname) {
        return "(getallmodelitem || targetSet != null && targetSet.contains(\"" + AppSchemaUtil.getChildPart(itemname) + "\"))";
    }

    protected String outputGetallmodelitemContainerCode(String containeritemname) {
        return "(getallmodelitem || targetSet != null)";
    }

    protected static enum EmptyProcessType {
        None,
        Single,
        Multiple,
        Normal_Multiple,
        Check_Multiple,
        Unsupported;

    }

    protected static enum ProcessType {
        None,
        Normal,
        DualInput,
        RefCheckOneColumn,
        RefCheckMultiColumn,
        Storeref,
        StorerefMultiple,
        StorerefMultipleRef,
        Normal_Multiple,
        Storeref_Header,
        DataHeader,
        Unsupported,
        StorerefMultiplePKey,
        StorerefPKey,
        StorerefMultipleRefPKey,
        RefCheckMultiColumnCompositeKey,
        RefCheckMultiColumnSingleInt;

    }
}

