/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TabManager;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_toCsvDataHeaderCount
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_toCsvDataHeaderCount.class.getName());

    public HelperGenerator_toCsvDataHeaderCount(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        Model smodel = (Model)node;
        String sid = smodel.getId();
        String sclassname = AppSchemaUtil.getClassname(smodel);
        TabManager tm = new TabManager(4);
        String[] msg_param = new String[]{"colMap column size"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvDataHeaderCount"), msg_param, null));
        sb.append(tm.toString());
        sb.append("public static void toCsvDataHeaderCount(");
        sb.append("Map colMap) {");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("toCsvDataHeaderCount(").append("(").append(sclassname).append(")null, colMap, false);");
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        msg_param = new String[]{sid + " " + sclassname, "colMap column size"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvDataHeaderCount"), msg_param, null));
        sb.append(tm.toString());
        sb.append("public static void toCsvDataHeaderCount(");
        sb.append(sclassname + " " + sid);
        sb.append(", Map colMap) {");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("toCsvDataHeaderCount(" + sid + ", colMap, false);");
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        msg_param = new String[]{"colMap column size", "getallmodelitem boolean"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvDataHeaderCount"), msg_param, null));
        sb.append(tm.toString());
        sb.append("public static void toCsvDataHeaderCount(");
        sb.append("Map colMap, boolean getallmodelitem) {");
        sb.append(CR);
        tm.addSpaceCount(4);
        sb.append(tm.toString());
        sb.append("toCsvDataHeaderCount(").append("(").append(sclassname).append(")null, colMap, getallmodelitem);");
        sb.append(CR);
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        String[] msgparam = new String[]{"entity " + sclassname, "colMap column size", "getallmodelitem boolean"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvDataHeaderCount"), msgparam, null));
        String[] code = new String[]{"public static void toCsvDataHeaderCount(", "    " + sclassname + " entity, Map colMap, boolean getallmodelitem) {", "    toCsvDataHeaderCount(entity, colMap, getallmodelitem, null);", "}", "", "private static <SItem> void toCsvDataHeaderCount(", "    " + sclassname + " entity, String itemname,", "    Class<SItem> sItemClazz, Map colMap, Set<String> itemSet) {", "    if (itemSet != null && !containsMultipleItem(itemSet, itemname)) {", "        return;", "    }", "    toCsvDataHeaderCount(entity, itemname, sItemClazz, colMap);", "}", ""};
        this.append(sb, "    ", code);
        msgparam = new String[]{sid + " " + sclassname, "colMap column size", "getallmodelitem boolean", "itemSet itemSet"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.toCsvDataHeaderCount"), msgparam, null));
        code = new String[]{"public static void toCsvDataHeaderCount(", "    " + sclassname + " " + sid + ", Map colMap, boolean getallmodelitem, Set<String> itemSet) {", "    if (getallmodelitem) {", "        itemSet = null;", "    }"};
        this.append(sb, "    ", code);
        tm.addSpaceCount(4);
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            sb.append(tm.toString());
            sb.append("return ;");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
            return sb.toString();
        }
        for (int i = 0; i < simc.length; ++i) {
            Modelitem mitem;
            if (!(simc[i] instanceof Modelitem) || !(mitem = (Modelitem)simc[i]).getMultiple()) continue;
            Modelitem pitem = null;
            if (imc != null) {
                for (int j = 0; !(j >= imc.length || imc[j] instanceof Modelitem && (pitem = (Modelitem)imc[j]).getName().equals(mitem.getName())); ++j) {
                }
            }
            if (pitem == null || !AppSchemaUtil.getCsvOutputable(smodel, mitem.getName())) continue;
            String _packagename = AppSchemaUtil.getPackagename(smodel, this.project);
            String _classname = AppSchemaUtil.getModelitemClassname(pitem);
            String _instancename = "_" + pitem.getName() + "s";
            if (pitem.getCsvOutput() && !JavaSourceGenerator.isBasicType(mitem.getType())) {
                sb.append(tm.toString());
                sb.append("toCsvDataHeaderCount(").append(sid).append(", ");
                sb.append("\"").append(pitem.getName()).append("\", ");
                if (mitem.getHasChild()) {
                    sb.append(_packagename);
                    sb.append(_classname);
                } else {
                    sb.append(JavaSourceGenerator.getProperType(mitem.getType()));
                }
                sb.append(".class, ");
                sb.append("colMap, itemSet);").append(CR);
                continue;
            }
            if (!pitem.getCsvOutput()) {
                sb.append(tm.toString());
                sb.append("if (getallmodelitem) {");
                sb.append(CR);
                tm.addSpaceCount(4);
            }
            sb.append(tm.toString());
            if (mitem.getHasChild()) {
                sb.append(_packagename);
                sb.append(_classname);
            } else {
                sb.append(JavaSourceGenerator.getProperType(mitem.getType()));
            }
            sb.append("[] ");
            sb.append(_instancename);
            sb.append(" = ");
            sb.append(sid);
            sb.append(JavaSourceGenerator.getterFullMethod(mitem.getName()));
            sb.append(";");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("if (");
            sb.append(_instancename);
            sb.append(" != null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("Integer _count = (Integer)colMap.get(\"");
            sb.append(pitem.getName());
            sb.append("\");");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("if (_count == null) {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("_count = Integer.valueOf(");
            sb.append(_instancename);
            sb.append(".length);");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("colMap.put(\"");
            sb.append(pitem.getName());
            sb.append("\", _count);");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("} else {");
            sb.append(CR);
            tm.addSpaceCount(4);
            sb.append(tm.toString());
            sb.append("_count = Integer.valueOf(Math.max(");
            sb.append(_instancename);
            sb.append(".length, _count.intValue()));");
            sb.append(CR);
            sb.append(tm.toString());
            sb.append("colMap.put(\"");
            sb.append(pitem.getName());
            sb.append("\", _count);");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
            if (pitem.getCsvOutput()) continue;
            tm.addSpaceCount(-4);
            sb.append(tm.toString());
            sb.append("}");
            sb.append(CR);
        }
        tm.addSpaceCount(-4);
        sb.append(tm.toString());
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void append(StringBuilder sb, String tab, String[] codes) {
        for (String code : codes) {
            if (code == null) continue;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(tab);
                sb.append(code);
            }
            sb.append(CR);
        }
    }
}

