/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperGenerator_validator
extends HelperGeneratorBaseTask {
    protected Project project;
    private Model smodel_;
    private Modelitem sitem_;
    private String itemname_;
    private String type_;
    private boolean isValid_;
    protected static final String[] supportType = new String[]{"byte", "short", "int", "long"};
    protected Logger logger = LogManager.getLogger((String)HelperGenerator_validator.class.getName());

    public HelperGenerator_validator(Project project, Model model, Modelitem item) {
        this.project = project;
        this.model = model;
        this.item = item;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.itemname_ = item.getName();
        if (this.itemname_.endsWith("jshparam")) {
            this.itemname_ = this.itemname_.substring(0, this.itemname_.length() - "jshparam".length() - 1);
        }
        this.smodel_ = AppSchemaUtil.getStoreModel(model);
        this.sitem_ = AppSchemaUtil.getModelitem(this.itemname_, this.smodel_);
        if (this.sitem_ != null) {
            this.type_ = this.sitem_.getType();
            boolean isSupportType = false;
            for (int i = 0; i < supportType.length; ++i) {
                if (!supportType[i].equals(this.type_)) continue;
                isSupportType = true;
                break;
            }
            if (isSupportType) {
                this.isValid_ = true;
            }
        }
    }

    public boolean isValid() {
        return this.isValid_;
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        String label = this.item.getLabel();
        if (label == null || label.length() == 0) {
            label = this.item.getName();
        }
        String rkey = null;
        if (this.smodel_ != null) {
            String label_i18n = AppSchemaUtil.getLabeli18n(this.item, this.smodel_.getId(), this.model, this.project);
            rkey = JFCAppResourceGenerator.createModelResourceKey(this.smodel_.getId(), this.item.getName(), label_i18n);
            JFCAppResourceGenerator.put(rkey, label_i18n);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(basetab + "        ");
        sb.append("// " + this.rman.getValue("helper.comment.validator"));
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (StringUtils.isNotEmpty(s)) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("try {").append(CR);
        String ttype = HelperGenerator_validator.getProperType(this.type_);
        String getter = "BasicTypeUtil.isValid" + ttype + "Range";
        String lower_v = "BasicTypeUtil.getLower" + ttype + "AsBigDecimal()";
        String upper_v = "BasicTypeUtil.getUpper" + ttype + "AsBigDecimal()";
        sb.append(basetab + "                ");
        sb.append("if (!").append(getter).append("(s)) {").append(CR);
        sb.append(basetab + "                    ");
        sb.append("Object[] o = { ");
        sb.append("JFCUtils.getRValue(\"" + StringUtil.convertJavaString((String)rkey) + "\", p.locale)");
        sb.append(", ");
        sb.append(lower_v);
        sb.append(", ");
        sb.append(upper_v);
        sb.append(" };").append(CR);
        sb.append(basetab + "                    ");
        sb.append("jp.jasminesoft.jfc.error.Jfcerror _error =").append(CR);
        sb.append(basetab + "                        ");
        sb.append("manager.getJfcerror(\"");
        sb.append(this.createErrorCode("error.input.validator.range"));
        sb.append("\", o, p.locale);").append(CR);
        sb.append(basetab + "                    ");
        sb.append("p.errors.addJfcerror(_error);").append(CR);
        sb.append(basetab + "                    ");
        sb.append("values");
        sb.append(".setErrorcode(_error.getContent());").append(CR);
        sb.append(basetab + "                ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("} catch (NumberFormatException e) {").append(CR);
        sb.append(basetab + "            ");
        sb.append("}").append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    public static String getProperType(String type) {
        if ("int".equals(type)) {
            return "Int";
        }
        if ("long".equals(type)) {
            return "Long";
        }
        if ("short".equals(type)) {
            return "Short";
        }
        if ("byte".equals(type)) {
            return "Byte";
        }
        return type;
    }
}

