/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.generator.DataOwnerMethodGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_addChildNode;
import jp.jasminesoft.jfc.gen.HelperGenerator_addNode;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeImport;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeInsert;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeInsert_setDefaultValue;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeShow;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeShow_setDefaultValue;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeUpdate;
import jp.jasminesoft.jfc.gen.HelperGenerator_beforeUpdate_setDefaultValue;
import jp.jasminesoft.jfc.gen.HelperGenerator_calc;
import jp.jasminesoft.jfc.gen.HelperGenerator_calcChild;
import jp.jasminesoft.jfc.gen.HelperGenerator_clear;
import jp.jasminesoft.jfc.gen.HelperGenerator_copyUsingFormula;
import jp.jasminesoft.jfc.gen.HelperGenerator_derive;
import jp.jasminesoft.jfc.gen.HelperGenerator_getFileList;
import jp.jasminesoft.jfc.gen.HelperGenerator_getPrimaryKey;
import jp.jasminesoft.jfc.gen.HelperGenerator_getPrimaryKeyName;
import jp.jasminesoft.jfc.gen.HelperGenerator_initialize;
import jp.jasminesoft.jfc.gen.HelperGenerator_isIgnoreCalc;
import jp.jasminesoft.jfc.gen.HelperGenerator_logicalDelete;
import jp.jasminesoft.jfc.gen.HelperGenerator_removeChildNode;
import jp.jasminesoft.jfc.gen.HelperGenerator_resolvForeignKey;
import jp.jasminesoft.jfc.gen.HelperGenerator_resolvRelatedItem;
import jp.jasminesoft.jfc.gen.HelperGenerator_saveAsGeneration;
import jp.jasminesoft.jfc.gen.HelperGenerator_sortChildNode;
import jp.jasminesoft.jfc.gen.HelperGenerator_validate;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.RelatedModelNode;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Cascade;
import jp.jasminesoft.jfc.gen.appschema.DefaultValue;
import jp.jasminesoft.jfc.gen.appschema.Derive;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperStoreGenerator
extends HelperGenerator {
    protected Logger logger = LogManager.getLogger((String)HelperStoreGenerator.class.getName());
    protected HelperGenerator_isIgnoreCalc isIgnoreCalcMethod;
    protected RelatedModelNode rootNode;

    public HelperStoreGenerator(Project project, Model model) {
        super(project, model);
        this.isIgnoreCalcMethod = new HelperGenerator_isIgnoreCalc(project, model);
        this.rootNode = new RelatedModelNode(model);
        if (model != null) {
            this.gSetRelatedParentModelList(this.rootNode, new HashSet<String>());
        }
    }

    @Override
    public String gClassDeclaration() {
        String s_classname = AppSchemaUtil.getClassname(this.model);
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends jp.jasminesoft.jfc.app.EntityHelper<");
        sb.append(s_classname);
        sb.append(", ");
        sb.append(new StoreModel(this.model).getPrimarykey().getClassName());
        sb.append(">");
        sb.append(CR);
        return sb.toString();
    }

    protected void gSetRelatedParentModelList(RelatedModelNode node, Set<String> processedRelatedModelNodeSet) {
        for (IProjectChoice ipc : this.project.getContent()) {
            Cascade[] cascades;
            Action _action;
            if (!(ipc instanceof Action) || !"insert".equals((_action = (Action)ipc).getType()) && !"copy".equals(_action.getType()) && !"update".equals(_action.getType()) || (cascades = AppSchemaUtil.getCascade(_action)) == null || cascades.length == 0) continue;
            for (Cascade cascade : cascades) {
                String modelid = cascade.getContent();
                Model mainmodel = AppSchemaUtil.getModel(this.project, modelid);
                Object[] submodels = AppSchemaUtil.getSubmodels(mainmodel, this.project);
                HashSet<String> modelidSet = new HashSet<String>();
                modelidSet.add(modelid);
                if (ArrayUtils.isNotEmpty((Object[])submodels)) {
                    for (Object submodel : submodels) {
                        modelidSet.add(((Model)submodel).getId());
                    }
                }
                boolean bingo = false;
                for (String mid : modelidSet) {
                    if (!node.getModel().getId().equals(mid)) continue;
                    bingo = true;
                    break;
                }
                if (!bingo) continue;
                Model parent_model = (Model)_action.getIdrefAsIRNode();
                node.addParent(parent_model);
            }
        }
        if (node.size() > 0) {
            for (RelatedModelNode n_node : node.getParentNode()) {
                if (processedRelatedModelNodeSet.contains(n_node.getModel().getId())) continue;
                processedRelatedModelNodeSet.add(n_node.getModel().getId());
                this.gSetRelatedParentModelList(n_node, processedRelatedModelNodeSet);
            }
        }
    }

    @Override
    public String[] getDefaultImport() {
        Object[] ss = super.getDefaultImport();
        ArrayList<String> importList = new ArrayList<String>();
        this.getRelatedModelClass(this.rootNode, importList);
        if (TextSearchUtil.isTextsearchNecessary4(this.project, this.model)) {
            importList.add("jp.jasminesoft.jfc.textsearch.Indexer");
            importList.add("jp.jasminesoft.jfc.textsearch.IndexerException");
            importList.add("jp.jasminesoft.jfc.textsearch.Model2Map");
        }
        if (importList.size() > 0) {
            for (String s : importList) {
                ss = (String[])ArrayUtils.add((Object[])ss, (Object)s);
            }
        }
        return ss;
    }

    protected void getRelatedModelClass(RelatedModelNode node, List<String> importList) {
        if (node.size() > 0) {
            for (RelatedModelNode parent_node : node.getParentNode()) {
                StringBuilder psb = new StringBuilder();
                psb.append(AppSchemaUtil.getPackagename(parent_node.getModel(), this.project));
                psb.append(AppSchemaUtil.getClassname(parent_node.getModel()));
                importList.add(psb.toString());
                this.getRelatedModelClass(parent_node, importList);
            }
        }
    }

    @Override
    protected String gHelperMethod0() {
        Map<String, Modelitem> icopyActionMap;
        Derive derive;
        StringBuilder sb = new StringBuilder();
        HelperGeneratorBaseTask hgt = null;
        this.outputItemDefs(sb);
        if (this.model.getId().equals("jfcstartworkstate") || this.model.getId().equals("jfcsuspendworkstate")) {
            sb.append(this.outputExpandItemsDeclaration(this.project, this.model));
        }
        hgt = new HelperGenerator_getPrimaryKey(this.project, this.model);
        sb.append(hgt.process());
        hgt = new HelperGenerator_getPrimaryKeyName(this.project, this.model);
        sb.append(hgt.process());
        hgt = new HelperGenerator_validate(this.project, this.model);
        sb.append(hgt.process());
        Action insertAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.model.getId(), "insert");
        if (insertAction != null && (derive = AppSchemaUtil.getDerive(insertAction)) != null) {
            PrimaryKey[] d_pkeys;
            String methodName = derive.getName();
            String dmodelId = derive.getContent();
            Model dmodel = AppSchemaUtil.getModel(this.project, dmodelId);
            if (dmodel != null && (d_pkeys = AppSchemaUtil.getPrimaryKey(dmodel)) != null && d_pkeys.length > 0) {
                hgt = new HelperGenerator_derive(this.project, this.model, dmodel, methodName);
                sb.append(hgt.process());
            }
        }
        hgt = new HelperGenerator_initialize(this.project, this.model, this);
        sb.append(hgt.process());
        hgt = new HelperGenerator_clear(this.project, this.model, this);
        sb.append(hgt.process());
        hgt = new HelperGenerator_resolvForeignKey(this.project, this.model);
        sb.append(hgt.process());
        hgt = new HelperGenerator_resolvRelatedItem(this.project, this.model);
        sb.append(hgt.process());
        hgt = new HelperGenerator_beforeShow(this.project, this.model, this);
        sb.append(hgt.process());
        hgt = new HelperGenerator_beforeShow_setDefaultValue(this.project, this.model, this);
        sb.append(hgt.process());
        Modelitem ownerModelitem = null;
        if (this.model.getIdref() == null || this.model.getIdref().length() == 0) {
            hgt = new HelperGenerator_beforeUpdate(this.project, this.model, this);
            sb.append(hgt.process());
            hgt = new HelperGenerator_beforeUpdate_setDefaultValue(this.project, this.model, this);
            sb.append(hgt.process());
            hgt = new HelperGenerator_beforeInsert(this.project, this.model, this);
            sb.append(hgt.process());
            hgt = new HelperGenerator_beforeInsert_setDefaultValue(this.project, this.model, this);
            sb.append(hgt.process());
            if (StringUtils.isNotBlank((CharSequence)this.model.getUseGeneration())) {
                hgt = new HelperGenerator_saveAsGeneration(this.project, this.model, this);
                sb.append(hgt.process());
            }
            hgt = new HelperGenerator_beforeImport(this.project, this.model, this);
            sb.append(hgt.process());
            IModelChoice[] imc = this.model.getContent();
            if (imc != null) {
                Modelitem mitem;
                int i;
                for (i = 0; i < imc.length; ++i) {
                    if (!(imc[i] instanceof Modelitem)) continue;
                    mitem = (Modelitem)imc[i];
                    if ("owner".equals(mitem.getGroupDataType())) {
                        ownerModelitem = mitem;
                    }
                    if (mitem.getHasChild() && mitem.getMultiple()) {
                        hgt = new HelperGenerator_addChildNode(this.project, this.model, mitem, this);
                        sb.append(hgt.process());
                        hgt = new HelperGenerator_sortChildNode(this.project, this.model, mitem, this);
                        sb.append(hgt.process());
                        continue;
                    }
                    if (!mitem.getMultiple()) continue;
                    hgt = new HelperGenerator_addNode(this.project, this.model, mitem, this);
                    sb.append(hgt.process());
                }
                for (i = 0; i < imc.length; ++i) {
                    if (!(imc[i] instanceof Modelitem) || !(mitem = (Modelitem)imc[i]).getHasChild() || !mitem.getMultiple()) continue;
                    hgt = new HelperGenerator_removeChildNode(this.project, this.model, mitem, this);
                    sb.append(hgt.process());
                }
            }
        }
        if ((icopyActionMap = AppSchemaUtil.getIcopyActionMap(this.model)).size() > 0) {
            hgt = new HelperGenerator_copyUsingFormula(this.project, this.model, icopyActionMap);
            sb.append(hgt.process());
        }
        boolean needsIgnoreCalcMethod = false;
        if (AppSchemaUtil.hasAutocalc(this.model, true, this.project)) {
            hgt = new HelperGenerator_calc(this.project, this.model, this);
            sb.append(hgt.process());
            needsIgnoreCalcMethod = true;
        } else {
            for (IModelChoice imc : this.model.getContent()) {
                DefaultValue dv;
                if (!(imc instanceof DefaultValue) || !(dv = (DefaultValue)imc).getType().equals("operation")) continue;
                needsIgnoreCalcMethod = true;
                break;
            }
        }
        if (needsIgnoreCalcMethod) {
            sb.append(this.isIgnoreCalcMethod.process());
        }
        hgt = new HelperGenerator_calcChild(this.project, this.model, this);
        sb.append(hgt.process());
        if (this.model.getLogicalDelete()) {
            hgt = new HelperGenerator_logicalDelete(this.project, this.model);
            sb.append(hgt.process());
        }
        hgt = new HelperGenerator_getFileList(this.project, this.model);
        sb.append(hgt.process());
        sb.append(this.generateClearCacheMethod());
        if (TextSearchUtil.isTextsearchNecessary4(this.project, this.model)) {
            sb.append(CR);
            sb.append(this.generateIndexMethod());
        }
        sb.append(new DataOwnerMethodGenerator(ownerModelitem).generateContent());
        return sb.toString();
    }

    protected String generateClearCacheMethod() {
        StringBuilder sb = new StringBuilder();
        sb.append("        ").append("// ").append(rman.getValue("pbean.comment.usecache")).append(CR);
        sb.append("        ").append(this.project.getPackage()).append(".app.CacheManager cman").append(CR);
        sb.append("                ").append("= ").append(this.project.getPackage()).append(".app.CacheManager.getInstance(p);").append(CR);
        String contentPreparingChacheManager = sb.toString();
        StoreModel storeModel = new StoreModel(this.model);
        sb = new StringBuilder();
        sb.append("    ").append("/** {@inheritDoc} **/").append(CR);
        sb.append("    ").append("public void clearCacheAfterInsert(").append(storeModel.getClassName()).append(" entity, ActionParameter p) {").append(CR);
        sb.append(contentPreparingChacheManager);
        sb.append("        ").append("cman.clear").append(storeModel.getClassName()).append("_insert(entity);").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append(CR);
        sb.append("    ").append("/** {@inheritDoc} **/").append(CR);
        sb.append("    ").append("public void clearCacheAfterUpdate(").append(storeModel.getClassName()).append(" entity, ActionParameter p) {").append(CR);
        sb.append(contentPreparingChacheManager);
        sb.append("        ").append("cman.clear").append(storeModel.getClassName()).append("_update(entity);").append(CR);
        sb.append("    ").append("}").append(CR);
        sb.append(CR);
        sb.append("    ").append("/** {@inheritDoc} **/").append(CR);
        sb.append("    ").append("public void clearCacheAfterDelete(").append(storeModel.getClassName()).append(" entity, ActionParameter p) {").append(CR);
        sb.append(contentPreparingChacheManager);
        sb.append("        ").append("cman.clear").append(storeModel.getClassName()).append("_delete(entity);").append(CR);
        sb.append("    ").append("}").append(CR);
        return sb.toString();
    }

    protected String generateIndexMethod() {
        StringBuilder sb = new StringBuilder();
        String mclassname = AppSchemaUtil.getClassname(this.model);
        HashMap<String, String> tmpParams = new HashMap<String, String>();
        tmpParams.put("mclassname", mclassname);
        if (AppSchemaUtil.isSubModel(this.model)) {
            tmpParams.put("indexModelId", this.model.getMainmodelidref());
        } else {
            tmpParams.put("indexModelId", this.model.getId());
        }
        sb.append(VelocityUtils.mergeContent((String)"template/javasrc/textsearch/add_delete_update_index.vm", tmpParams));
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void outputItemDefs(StringBuilder sb) {
        StringBuilder sb0 = new StringBuilder();
        for (IModelChoice imc : this.model.getContent()) {
            Modelitem mitem;
            if (!(imc instanceof Modelitem) || (mitem = (Modelitem)imc).getGeneration()) continue;
            String mname = AppSchemaUtil.getChildPart(mitem.getName());
            String rname = JavaSourceGenerator.convertInstanceNameInRelaxerObject(mname);
            if (sb0.length() > 0) {
                sb0.append(",").append(CR);
            }
            sb0.append("        ");
            sb0.append("{ ");
            sb0.append("\"").append(rname).append("\", ");
            sb0.append("\"").append(mname).append("\"");
            sb0.append(" }");
        }
        if (sb0.length() > 0) {
            sb.append("    ");
            sb.append("public static final String[][] itemNameArrayInRelaxerObject_ = {");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
            sb.append("    ");
            sb.append("};");
            sb.append(CR).append(CR);
        }
    }

    private String outputExpandItemsDeclaration(Project project, Model model) {
        LinkedHashMap<String, String> map = null;
        for (IModelChoice imc : model.getContent()) {
            DefaultValue dv;
            if (!(imc instanceof DefaultValue) || !(dv = (DefaultValue)imc).getType().equals("itemname") || !dv.getAction().equals("showlist")) continue;
            if (map == null) {
                map = new LinkedHashMap<String, String>();
            }
            map.put(dv.getContent(), dv.getName());
        }
        if (map == null) {
            return "    public static final String[][] expandItems_ = null;" + CR + CR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("public static final String[][] expandItems_ = {").append(CR);
        for (Map.Entry entry : map.entrySet()) {
            sb.append("        ").append("{ \"").append((String)entry.getKey()).append("\", \"");
            sb.append((String)entry.getValue()).append("\" },").append(CR);
        }
        sb.delete(sb.lastIndexOf(","), sb.length());
        sb.append(CR).append("    ").append("};").append(CR).append(CR);
        return sb.toString();
    }
}

