/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.View;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperTotalGenerator
extends HelperGenerator {
    protected Logger logger = LogManager.getLogger((String)HelperTotalGenerator.class.getName());
    protected String[] defaultImportStatement = new String[]{"java.util.*", "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.app.ITotalProcessor"};

    public HelperTotalGenerator(Project project, Model model) {
        super(project, model);
    }

    @Override
    public String[] getDefaultImport() {
        ArrayList<String> importList = new ArrayList<String>();
        for (int i = 0; i < this.defaultImportStatement.length; ++i) {
            if (importList.contains(this.defaultImportStatement[i])) continue;
            importList.add(this.defaultImportStatement[i]);
        }
        importList.add("jp.jasminesoft.jfc.dao.FinderContext");
        importList.add("jp.jasminesoft.jfc.dao.TotalViewScroller");
        importList.add("jp.jasminesoft.jfc.service.JFCEntityService");
        JavaSourceGenerator.setImportStatement(this.model, this.project, importList);
        return importList.toArray(new String[0]);
    }

    protected boolean needsFilterObject() {
        return false;
    }

    @Override
    protected boolean needsLoggerObject() {
        return false;
    }

    @Override
    protected String gHelperMethod0() {
        Action[] actions;
        StringBuilder sb = new StringBuilder();
        Action action = null;
        Model smodel = null;
        int position = 0;
        IRNode node = this.model.getIdrefAsIRNode();
        if (node != null && node instanceof Model && (actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, (smodel = (Model)node).getId(), "showList")) != null && actions.length > 0) {
            block0: for (int i = 0; i < actions.length; ++i) {
                IRNode[] dmodels;
                if (!"total".equals(actions[i].getView()) || (dmodels = AppSchemaUtil.getDataitemAsModel(actions[i], "list")) == null || dmodels.length <= 0) continue;
                position = 0;
                IRNode[] iRNodeArray = dmodels;
                int n = iRNodeArray.length;
                for (int j = 0; j < n; ++j) {
                    Model model_t;
                    IRNode model_tp = iRNodeArray[j];
                    node = ((Model)model_tp).getIdrefAsIRNode();
                    if (node != null && node instanceof Model && (model_t = (Model)node).getId().equals(this.model.getId())) {
                        action = actions[i];
                        break block0;
                    }
                    ++position;
                }
            }
        }
        if (action == null) {
            this.logger.error(rman.getValue("struts.total.null.action", smodel.getId()));
            return sb.toString();
        }
        View view = null;
        int count = 0;
        for (IActionChoice iac : action.getContent()) {
            if (!(iac instanceof View)) continue;
            View _view = (View)iac;
            if (position == count) {
                view = _view;
                break;
            }
            ++count;
        }
        if (view == null) {
            this.logger.error(rman.getValue("struts.total.null.view", action.getId()));
            return sb.toString();
        }
        Item[] _items = view.getItem();
        if (_items == null || _items.length == 0) {
            this.logger.error(rman.getValue("struts.total.null.viewitem", action.getId()));
            return sb.toString();
        }
        boolean errorFlag = false;
        for (int i = 0; i < _items.length; ++i) {
            Item _item = _items[i];
            String name = _item.getName();
            String itemname = _item.getContent();
            Modelitem mitem = AppSchemaUtil.getModelitem(itemname, smodel);
            if (mitem == null) continue;
            boolean useCheckInDimension = false;
            if ("dimension".equals(name) && ("masterref".equals(mitem.getType()) || "storeref".equals(mitem.getType()))) {
                Relation rel = AppSchemaUtil.getRelationTypeExceptRef(mitem);
                if (rel != null) {
                    if ("check".equals(rel.getType())) {
                        useCheckInDimension = true;
                    }
                } else if ("storeref".equals(mitem.getType()) && (rel = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null && "check".equals(AppSchemaUtil.getRelationType(rel, this.project))) {
                    useCheckInDimension = true;
                }
            }
            if (!useCheckInDimension) continue;
            Object[] o = new Object[]{smodel.getId(), mitem.getName()};
            this.logger.error(rman.getValue("helper.illegal.total.dimension.check", o));
            errorFlag = true;
        }
        if (errorFlag) {
            return sb.toString();
        }
        String[] msg_param = new String[]{"entityService JFCEntityService", "finderContext FinderContext", "__processorList List", "p ActionParameter"};
        sb.append(CommentGenerator.gComment(rman.getValue("helper.comment.total.callprocessor"), msg_param, null));
        sb.append("    ");
        sb.append("public void total(");
        sb.append("JFCEntityService entityService, FinderContext finderContext,");
        sb.append(CR);
        sb.append("        ");
        sb.append("List<ITotalProcessor> __processorList,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("TotalViewScroller scroller = new TotalViewScroller(p);");
        sb.append(CR);
        sb.append("        ");
        sb.append("scroller.setFinderContext(finderContext);");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (ITotalProcessor __processor : __processorList) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("__processor.init();");
        sb.append(CR);
        sb.append("            ");
        sb.append("scroller.addProcessor(__processor);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("entityService.scroll(scroller);").append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

