/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.HelperGeneratorBaseTask;
import jp.jasminesoft.jfc.gen.HelperGenerator_p2s_datetime;
import jp.jasminesoft.jfc.gen.HelperGenerator_s2p_storeref_common;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperUpdateListPGenerator_isChanged
extends HelperGeneratorBaseTask {
    protected Project project;
    protected Logger logger = LogManager.getLogger((String)HelperUpdateListPGenerator_isChanged.class.getName());

    public HelperUpdateListPGenerator_isChanged(Project project, Model model) {
        this.project = project;
        this.model = model;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    }

    @Override
    public String process() {
        return this.process("");
    }

    @Override
    public String process(String basetab) {
        String fullclassname;
        StringBuilder sb = new StringBuilder();
        IRNode node = this.model.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            Object[] o = new Object[]{this.model.getId(), this.model.getIdref()};
            this.logger.error(this.rman.getValue("value.null.rmodel", o));
            return sb.toString();
        }
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        String classname = AppSchemaUtil.getClassname(this.model);
        Model rmodel = (Model)node;
        if (rmodel.getType().equals("list") && this.model.getUpdatelist()) {
            rmodel = (Model)rmodel.getIdrefAsIRNode();
            classname = "Item";
            fullclassname = packagename + classname;
        } else {
            fullclassname = classname;
        }
        String[] msg_param = new String[]{"item1 " + fullclassname, "mode1 CREATEOBJECT or others", "item2 " + fullclassname, "mode2 CREATEOBJECT or others", "p ActionParameter", "itemSet set of the target item"};
        sb.append(CommentGenerator.gComment(this.rman.getValue("helper.comment.isChanged"), msg_param, null));
        sb.append("    ");
        sb.append("public boolean isChanged(");
        sb.append(CR);
        sb.append("        ");
        sb.append(fullclassname);
        sb.append(" item1,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int mode1,");
        sb.append(CR);
        sb.append("        ");
        sb.append(fullclassname);
        sb.append(" item2,");
        sb.append(CR);
        sb.append("        ");
        sb.append("int mode2,");
        sb.append(CR);
        sb.append("        ");
        sb.append("ActionParameter p,");
        sb.append(CR);
        sb.append("        ");
        sb.append("Set itemSet)");
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (item1 == null || item2 == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("return false;");
        sb.append(CR);
        sb.append(CR);
        Model targetmodel = AppSchemaUtil.getStoreModel(rmodel);
        HashSet<String> mitemNameSet = new HashSet<String>();
        IModelChoice[] imc = this.model.getContent();
        if (imc != null) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem mitem;
                Modelitem targetitem;
                if (!(imc[i] instanceof Modelitem) || (targetitem = AppSchemaUtil.getModelitem((mitem = (Modelitem)imc[i]).getName(), targetmodel)).getGeneration()) continue;
                mitemNameSet.add(mitem.getName());
            }
        }
        HashSet<String> processedItemNameSet = new HashSet<String>();
        StringBuilder asb = new StringBuilder();
        IModelChoice[] rimc = rmodel.getContent();
        if (rimc == null) {
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        for (int i = 0; i < rimc.length; ++i) {
            Modelitem ritem;
            if (!(rimc[i] instanceof Modelitem) || !mitemNameSet.contains((ritem = (Modelitem)rimc[i]).getName()) || processedItemNameSet.contains(ritem.getName())) continue;
            sb.append(this.gModelitemProcess(ritem, rmodel, asb, "        ", processedItemNameSet));
        }
        sb.append("        ");
        sb.append("return false;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(asb.toString());
        return sb.toString();
    }

    protected String gModelitemProcess(Modelitem item, Model rmodel, StringBuilder asb, String basetab, Set<String> processedItemNameSet) {
        Modelitem _mitem;
        String relationtype = this.getRelationType(item, rmodel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rmodel.getId()=" + rmodel.getId());
            this.logger.debug("item.getName()=" + item.getName());
            this.logger.debug("item.getType()=" + item.getType());
            this.logger.debug("relationtype=" + relationtype);
        }
        if (relationtype != null) {
            if (relationtype.equals("check")) {
                return this.gModelitemProcess_master_check(item, rmodel, asb, basetab, processedItemNameSet);
            }
            return this.gModelitemProcess_master(item, rmodel, asb, basetab, processedItemNameSet);
        }
        String itemtype = item.getType();
        if ("storeref".equals(itemtype) && (_mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, rmodel.getId(), item)) != null) {
            itemtype = _mitem.getType();
        }
        if (JavaSourceGenerator.isDateOrTimeType(itemtype) || "float".equals(itemtype) || "double".equals(itemtype)) {
            return this.gModelitemProcess_dateOrFloat(item, itemtype, rmodel, asb, basetab, processedItemNameSet);
        }
        return this.gModelitemProcess_normal(item, rmodel, asb, basetab, processedItemNameSet);
    }

    private String getRelationType(Modelitem sitem, Model smodel) {
        String type = sitem.getType() == null ? "string" : sitem.getType();
        Relation relation = null;
        if ("storeref".equals(type)) {
            Modelitem _mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), sitem);
            if (_mitem == null) {
                return null;
            }
            type = _mitem.getType();
            relation = AppSchemaUtil.getRelationTypeExceptRef(_mitem);
        } else if ("masterref".equals(type)) {
            relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
        }
        if (relation != null) {
            return relation.getType();
        }
        if ("combo".equals(sitem.getDualinputmethod()) && "store".equals(smodel.getType())) {
            return "combo";
        }
        return null;
    }

    protected String gModelitemProcess_normal(Modelitem item, Model rmodel, StringBuilder asb, String basetab, Set<String> processedItemNameSet) {
        StringBuilder sb = new StringBuilder();
        String _name = item.getName();
        if (_name == null || _name.length() == 0) {
            return "";
        }
        if (AppSchemaUtil.hasChildPart(_name)) {
            _name = AppSchemaUtil.getChildPart(_name);
            return sb.toString();
        }
        String varname1 = "_" + _name + "1";
        String varname2 = "_" + _name + "2";
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("String " + varname1 + " =");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("(item1.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("() != null) ? item1.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("().getContent() : null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname1 + " != null && " + varname1 + ".equals(\"\")) " + varname1 + " = null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("String " + varname2 + " =");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("(item2.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("() != null) ? item2.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("().getContent() : null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname2 + " != null && " + varname2 + ".equals(\"\")) " + varname2 + " = null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if ((" + varname1 + " == null && " + varname2 + " != null) ||");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("        (" + varname1 + " != null && !" + varname1 + ".equals(" + varname2 + ")))");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("{");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("return true;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        processedItemNameSet.add(item.getName());
        StringBuilder _sb = new StringBuilder();
        _sb.append(this.gOutputContent(_name, sb.toString(), basetab));
        _sb.append(CR);
        return _sb.toString();
    }

    protected String gModelitemProcess_dateOrFloat(Modelitem item, String itemtype, Model rmodel, StringBuilder asb, String basetab, Set<String> processedItemNameSet) {
        StringBuilder sb = new StringBuilder();
        String _name = item.getName();
        if (_name == null || _name.length() == 0) {
            return "";
        }
        if (AppSchemaUtil.hasChildPart(_name)) {
            _name = AppSchemaUtil.getChildPart(_name);
            return sb.toString();
        }
        String varname = "_" + _name;
        String varname1 = varname + "1";
        String varname2 = varname + "2";
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("String " + varname1 + " =");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("(item1.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("() != null) ? item1.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("().getContent() : null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname1 + " != null && " + varname1 + ".equals(\"\")) " + varname1 + " = null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("String " + varname2 + " =");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("(item2.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("() != null) ? item2.");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("().getContent() : null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname2 + " != null && " + varname2 + ".equals(\"\")) " + varname2 + " = null;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if ((" + varname1 + " == null && " + varname2 + " != null) ||");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("        (" + varname1 + " != null && " + varname2 + " == null))");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("{");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("return true;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (" + varname1 + " != null && " + varname2 + " != null) {");
        sb.append(CR);
        if (JavaSourceGenerator.isDateOrTimeType(itemtype)) {
            this.gModelitem_date(item, rmodel, basetab + "        ", sb, varname, varname1, varname2);
        } else {
            this.gModelitem_float(item, itemtype, rmodel, basetab + "        ", sb, varname, varname1, varname2);
        }
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        processedItemNameSet.add(item.getName());
        StringBuilder _sb = new StringBuilder();
        _sb.append(this.gOutputContent(_name, sb.toString(), basetab));
        _sb.append(CR);
        return _sb.toString();
    }

    protected void gModelitem_date(Modelitem item, Model rmodel, String basetab, StringBuilder sb, String varname, String varname1, String varname2) {
        String varname_formats = varname + "_formats";
        String patternName = HelperGenerator_p2s_datetime.getFormatPatternName(this.project, rmodel, item);
        sb.append(basetab);
        sb.append("String[] ");
        sb.append(varname_formats);
        sb.append(" = ");
        sb.append("DateFormatManager.getInstance().");
        sb.append("getFormatArrayByName(\"").append(patternName).append("\");");
        sb.append(CR);
        boolean isWarekiFlag = AppSchemaUtil.isWareki(item);
        String methodName = HelperGenerator_p2s_datetime.getSQLDateMethodName(this.project, item, rmodel.getId());
        sb.append(basetab);
        sb.append("Date _date");
        sb.append(varname1);
        sb.append(" = ");
        sb.append(methodName);
        sb.append("(");
        sb.append(varname1);
        sb.append(", ");
        sb.append(varname_formats);
        sb.append(", JFCUtils.createLocale(p.locale), ");
        sb.append(isWarekiFlag);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("Date _date");
        sb.append(varname2);
        sb.append(" = ");
        sb.append(methodName);
        sb.append("(");
        sb.append(varname2);
        sb.append(", ");
        sb.append(varname_formats);
        sb.append(", JFCUtils.createLocale(p.locale), ");
        sb.append(isWarekiFlag);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if ((_date");
        sb.append(varname1);
        sb.append(" == null && _date").append(varname2).append(" != null) ||").append(CR);
        sb.append(basetab + "    ").append("(_date").append(varname1).append(" != null && !_date").append(varname1);
        sb.append(".equals(_date");
        sb.append(varname2);
        sb.append(")))");
        sb.append(CR);
        sb.append(basetab).append("{").append(CR);
        sb.append(basetab + "    ");
        sb.append("return true;");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    protected void gModelitem_float(Modelitem item, String itemtype, Model rmodel, String basetab, StringBuilder sb, String varname, String varname1, String varname2) {
        String itemtypec = SourceGenerator.capFirst(itemtype);
        sb.append(basetab);
        sb.append(itemtype);
        sb.append(" _num");
        sb.append(varname1);
        sb.append(" = NumberUtils.to");
        sb.append(itemtypec);
        sb.append("(");
        sb.append(varname1);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append(itemtype);
        sb.append(" _num");
        sb.append(varname2);
        sb.append(" = NumberUtils.to");
        sb.append(itemtypec);
        sb.append("(");
        sb.append(varname2);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (_num");
        sb.append(varname1);
        sb.append(" != _num");
        sb.append(varname2);
        sb.append(") {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("return true;");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
    }

    protected String gModelitemProcess_master(Modelitem item, Model rmodel, StringBuilder asb, String basetab, Set<String> processedItemNameSet) {
        Modelitem mitem;
        StringBuilder sb = new StringBuilder();
        String _name = item.getName();
        if (_name == null || _name.length() == 0) {
            return "";
        }
        if (AppSchemaUtil.hasChildPart(_name)) {
            _name = AppSchemaUtil.getChildPart(_name);
            return sb.toString();
        }
        String varname1 = "_" + _name + "1";
        String varname2 = "_" + _name + "2";
        sb.append(CR);
        Relation relation = null;
        if ("storeref".equals(item.getType()) && (relation = AppSchemaUtil.getRelationTypeExceptRef(item)) == null && (mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, rmodel.getId(), item)) != null && "storeref".equals(mitem.getType())) {
            relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        }
        List<String[]> setid2rcode = null;
        if (relation != null) {
            String roleid = AppSchemaUtil.getRoleid(relation, this.project);
            String rolecontent = relation.getRolecontent();
            Model smodel = (Model)relation.getIdrefAsIRNode();
            setid2rcode = HelperGenerator_s2p_storeref_common.createSetId2RCode(roleid, rolecontent, smodel, this.project);
        }
        sb.append(this.gModelitemProcess_master_loop(basetab + "    ", _name, varname1, "item1", "mode1", setid2rcode));
        sb.append(this.gModelitemProcess_master_loop(basetab + "    ", _name, varname2, "item2", "mode2", setid2rcode));
        if (setid2rcode == null || setid2rcode.size() == 1) {
            sb.append(basetab + "    ");
            sb.append("if ((" + varname1 + " == null && ");
            sb.append(varname2 + " != null) ||");
            sb.append(CR);
            sb.append(basetab + "            ");
            sb.append("(" + varname1 + " != null && !");
            sb.append(varname1 + ".equals(" + varname2 + ")))");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("{");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("return true;");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
        } else {
            for (String[] s : setid2rcode) {
                sb.append(basetab + "    ");
                sb.append("if ((" + varname1 + s[1] + " == null && ");
                sb.append(varname2 + s[1] + " != null) ||");
                sb.append(CR);
                sb.append(basetab + "            ");
                sb.append("(" + varname1 + s[1] + " != null && !");
                sb.append(varname1 + s[1] + ".equals(" + varname2 + s[1] + ")))");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("{");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("return true;");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("}");
                sb.append(CR);
            }
        }
        processedItemNameSet.add(item.getName());
        StringBuilder _sb = new StringBuilder();
        _sb.append(this.gOutputContent(_name, sb.toString(), basetab));
        _sb.append(CR);
        return _sb.toString();
    }

    private String gModelitemProcess_master_loop(String basetab, String _name, String modelitem_varname, String item_varname, String mode_varname, List<String[]> setid2rcode) {
        StringBuilder sb = new StringBuilder();
        String cnt_varname = modelitem_varname + "cnt";
        if (setid2rcode == null || setid2rcode.size() == 1) {
            sb.append(basetab);
            sb.append("String " + modelitem_varname + " = null;");
            sb.append(CR);
        } else {
            for (String[] s : setid2rcode) {
                sb.append(basetab);
                sb.append("String " + modelitem_varname + s[1] + " = null;");
                sb.append(CR);
            }
        }
        sb.append(basetab);
        sb.append("if (" + mode_varname + " == CREATEOBJECT) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (");
        sb.append(item_varname);
        sb.append(JavaSourceGenerator.sizeFullMethod(_name));
        sb.append(" > 0) {");
        sb.append(CR);
        if (setid2rcode == null || setid2rcode.size() == 1) {
            sb.append(basetab + "        ");
            sb.append(modelitem_varname + " = " + item_varname + ".");
            sb.append(JavaSourceGenerator.getterMethod(_name));
            sb.append("(0).getIdAsString();");
            sb.append(CR);
        } else {
            for (String[] s : setid2rcode) {
                sb.append(basetab + "        ");
                sb.append(modelitem_varname + s[1] + " = ");
                sb.append(JavaSourceGenerator.getterFullMethodAsObject(item_varname + "." + JavaSourceGenerator.getterMethod(_name) + "(0)", s[0], "string"));
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("} else {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int " + cnt_varname + "=0 ; " + cnt_varname + " < ");
        sb.append(item_varname);
        sb.append(JavaSourceGenerator.sizeFullMethod(_name));
        sb.append("; " + cnt_varname + "++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (!" + item_varname + ".");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("(" + cnt_varname + ").getChoose()) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append("continue;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (" + item_varname + ".");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("(" + cnt_varname + ").getNoId()) {");
        sb.append(CR);
        if (setid2rcode == null || setid2rcode.size() == 1) {
            sb.append(basetab + "            ");
            sb.append(modelitem_varname + " = null;");
            sb.append(CR);
        } else {
            for (String[] s : setid2rcode) {
                sb.append(basetab + "            ");
                sb.append(modelitem_varname + s[1] + " = null;");
                sb.append(CR);
            }
        }
        sb.append(basetab + "            ");
        sb.append("break;");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        if (setid2rcode == null || setid2rcode.size() <= 1) {
            sb.append(basetab + "        ");
            sb.append(modelitem_varname + " = " + item_varname + ".");
            sb.append(JavaSourceGenerator.getterMethod(_name));
            sb.append("(" + cnt_varname + ").getIdAsString();");
            sb.append(CR);
        } else {
            for (String[] s : setid2rcode) {
                sb.append(basetab + "        ");
                sb.append(modelitem_varname + s[1] + " = ");
                sb.append(JavaSourceGenerator.getterFullMethodAsObject(item_varname + "." + JavaSourceGenerator.getterMethod(_name) + "(" + cnt_varname + ")", s[0], "string"));
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(basetab + "        ");
        sb.append("break;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gModelitemProcess_master_check(Modelitem item, Model rmodel, StringBuilder asb, String basetab, Set<String> processedItemNameSet) {
        Modelitem mitem;
        StringBuilder sb = new StringBuilder();
        String _name = item.getName();
        if (_name == null || _name.length() == 0) {
            return "";
        }
        if (AppSchemaUtil.hasChildPart(_name)) {
            _name = AppSchemaUtil.getChildPart(_name);
            return sb.toString();
        }
        String varname1 = "_" + _name + "1";
        String varname2 = "_" + _name + "2";
        sb.append(CR);
        Relation relation = null;
        if ("storeref".equals(item.getType()) && (relation = AppSchemaUtil.getRelationTypeExceptRef(item)) == null && (mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, rmodel.getId(), item)) != null && "storeref".equals(mitem.getType())) {
            relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        }
        List<String[]> setid2rcode = null;
        if (relation != null) {
            String roleid = AppSchemaUtil.getRoleid(relation, this.project);
            String rolecontent = relation.getRolecontent();
            Model smodel = (Model)relation.getIdrefAsIRNode();
            setid2rcode = HelperGenerator_s2p_storeref_common.createSetId2RCode(roleid, rolecontent, smodel, this.project);
        }
        sb.append(this.gModelitemProcess_master_check_loop(basetab + "    ", _name, varname1, "item1", "mode1", "_ids1", setid2rcode));
        sb.append(this.gModelitemProcess_master_check_loop(basetab + "    ", _name, varname2, "item2", "mode2", "_ids2", setid2rcode));
        sb.append(basetab + "    ");
        sb.append("if (!_ids1.equals(_ids2)) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("return true;");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        processedItemNameSet.add(item.getName());
        StringBuilder _sb = new StringBuilder();
        _sb.append(this.gOutputContent(_name, sb.toString(), basetab));
        _sb.append(CR);
        return _sb.toString();
    }

    private String gModelitemProcess_master_check_loop(String basetab, String _name, String modelitem_varname, String item_varname, String mode_varname, String set_varname, List<String[]> setid2rcode) {
        StringBuilder sb = new StringBuilder();
        String cnt_varname = modelitem_varname + "cnt";
        sb.append(basetab);
        sb.append("Set<String> " + set_varname + " = new HashSet<String>();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (" + mode_varname + " == CREATEOBJECT) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int " + cnt_varname + "=0 ; " + cnt_varname + " < ");
        sb.append(item_varname);
        sb.append(JavaSourceGenerator.sizeFullMethod(_name));
        sb.append("; " + cnt_varname + "++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append(set_varname + ".add(");
        if (setid2rcode == null || setid2rcode.size() <= 1) {
            sb.append(item_varname + ".");
            sb.append(JavaSourceGenerator.getterMethod(_name));
            sb.append("(" + cnt_varname + ").getIdAsString());");
        } else {
            boolean isFirst = true;
            for (String[] s : setid2rcode) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("+PrimaryKeyUtils.PKEY_SEPARATOR()+");
                }
                sb.append(JavaSourceGenerator.getterFullMethodAsObject(item_varname + "." + JavaSourceGenerator.getterMethod(_name) + "(" + cnt_varname + ")", s[0], "string"));
            }
            sb.append(");");
        }
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("} else {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("for (int " + cnt_varname + "=0 ; " + cnt_varname + " < ");
        sb.append(item_varname);
        sb.append(JavaSourceGenerator.sizeFullMethod(_name));
        sb.append("; " + cnt_varname + "++) {");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("if (");
        sb.append(item_varname + ".");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("(" + cnt_varname + ").getChoose() && !");
        sb.append(item_varname + ".");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("(" + cnt_varname + ").getNoId()) {");
        sb.append(CR);
        sb.append(basetab + "            ");
        sb.append(set_varname + ".add(");
        sb.append(item_varname + ".");
        sb.append(JavaSourceGenerator.getterMethod(_name));
        sb.append("(" + cnt_varname + ").getIdAsString());");
        sb.append(CR);
        sb.append(basetab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gOutputContent(String _name, String _content, String tab) {
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("if (itemSet == null");
        sb.append(" || itemSet.contains(\"");
        sb.append(_name);
        sb.append("\")");
        sb.append(") {");
        sb.append(_content);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }
}

