/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.appgen.model.store.CompositeKeyGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.InitdbImportXslGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.VariableValidator_database;
import jp.jasminesoft.jfc.gen.appschema.Checkitem;
import jp.jasminesoft.jfc.gen.appschema.Checklist;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.HibernateParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Validation;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HibernateMappingGenerator
extends ConfigGenerator {
    private static Logger logger = LogManager.getLogger(HibernateMappingGenerator.class);
    private String quoteid = "\"";
    private Model model;
    private PrimaryKey[] primarykey;
    private HashSet<String> primarykey_name_set;
    private Checkitem[] checkitems = null;
    private List<String> addClassDefinitionList;
    private CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();

    public HibernateMappingGenerator(Project project, Model model) {
        super(project);
        this.model = model;
        Environment env = project.getEnvironment();
        Database dbcfg = null;
        if (env != null) {
            dbcfg = AppSchemaUtil.getDatabase(env);
        }
        String quoteid = null;
        if (model.getUseQuoteid()) {
            if (dbcfg != null) {
                quoteid = dbcfg.getQuoteidForHibernate();
            }
            if (quoteid != null) {
                this.quoteid = quoteid;
            }
        } else {
            this.quoteid = "";
        }
        this.primarykey = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, project);
        this.primarykey_name_set = new HashSet();
        for (int i = 0; i < this.primarykey.length; ++i) {
            String name = this.primarykey[i].getName();
            String refname = this.primarykey[i].getRefname();
            if (StringUtils.isNotBlank((String)refname)) {
                this.primarykey_name_set.add(refname);
                continue;
            }
            this.primarykey_name_set.add(name);
        }
        this.checkitems = HibernateMappingGenerator.getCheckitem(model);
        this.addClassDefinitionList = new ArrayList<String>();
    }

    public static Checkitem[] getCheckitem(Model model) {
        Checklist checklist;
        Checkitem[] checkitems = null;
        Validation validation = AppSchemaUtil.getValidation(model);
        if (validation != null && (checklist = validation.getChecklist()) != null) {
            checkitems = checklist.getCheckitem();
        }
        return checkitems;
    }

    @Override
    public String getFileSuffix() {
        return ".hbm.xml";
    }

    @Override
    public String getFilename() {
        return this.model.getId();
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClass("    ", null));
        sb.append(CR);
        IModelChoice[] imc = this.model.getContent();
        for (int i = 0; i < imc.length; ++i) {
            boolean isHasChild;
            Modelitem mitem;
            if (!(imc[i] instanceof Modelitem) || this.primarykey_name_set.contains((mitem = (Modelitem)imc[i]).getName()) || !(isHasChild = mitem.getHasChild())) continue;
            sb.append(this.gClass("    ", mitem));
            sb.append(CR);
        }
        for (String s : this.addClassDefinitionList) {
            sb.append(s);
            sb.append(CR);
        }
        sb.append(this.generateNamedQuery());
        sb.append(this.gFooter());
        return sb.toString();
    }

    private void addSpecialDefinition(Model model, StringBuilder sb) {
        if (!model.getId().equals("juser")) {
            return;
        }
        Environment environment = this.project.getEnvironment();
        String encoding = DbTypeManager.getDatabaseCharEncoding(environment);
        int length = DbTypeManager.getMaxTableNameLength(environment);
        boolean isquote = VariableValidator_database.isQuote(model, AppSchemaUtil.getDatabase(environment));
        String tablename = VariableValidator_database.createUniqueName("juser$preference_item", "", length, encoding, isquote, new HashSet<String>(), this.rman, logger);
        tablename = this.convertTablename(tablename);
        String _quoteid = WebStringEncodeUtilities.replaceCharEntity((String)this.quoteid);
        sb.append("        <list name=\"preferenceItem_\" table=\"").append(_quoteid).append(tablename).append(_quoteid).append("\" cascade=\"all\" lazy=\"true\">" + CR);
        sb.append("            <key>" + CR);
        sb.append("                <column name=\"").append(_quoteid).append("userid").append(_quoteid).append("\"/>" + CR);
        sb.append("            </key>" + CR);
        sb.append("            <index type=\"integer\">" + CR);
        sb.append("                <column name=\"").append(_quoteid).append("cid").append(_quoteid).append("\"/>" + CR);
        sb.append("            </index>" + CR);
        sb.append("            <composite-element class=\"PreferenceItem\">" + CR);
        sb.append("                <property name=\"key_\">" + CR);
        sb.append("                    <column name=\"").append(_quoteid).append("key2").append(_quoteid).append("\"/>" + CR);
        sb.append("                </property>" + CR);
        sb.append("                <property name=\"content_\">" + CR);
        sb.append("                    <column name=\"").append(_quoteid).append("content").append(_quoteid).append("\"/>" + CR);
        sb.append("                </property>" + CR);
        sb.append("            </composite-element>" + CR);
        sb.append("        </list>" + CR);
    }

    protected String generateNamedQuery() {
        if (!"juser".equals(this.model.getId())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    <sql-query name=\"getGroupidByUserid\">" + CR);
        sb.append("      <return-scalar column=\"jgroupid\" type=\"int\"/>" + CR);
        sb.append("      <![CDATA[" + CR);
        sb.append("        SELECT " + this.quote("jgroupid") + CR);
        sb.append("        FROM " + this.quote(this.convertTablename("juser$jgroupid")) + CR);
        sb.append("        WHERE " + this.quote("userid") + " = :userid" + CR);
        sb.append("      ]]>" + CR);
        sb.append("    </sql-query>" + CR);
        return sb.toString();
    }

    protected String quote(String name) {
        if (StringUtils.isBlank((String)name)) {
            return name;
        }
        return this.quoteid + name + this.quoteid;
    }

    private String gHeader() {
        String enc = JavaSourceGenerator.getEncoding(this.project);
        String packagename = AppSchemaUtil.getPackagename(this.model, this.project);
        if (packagename.endsWith(".")) {
            packagename = packagename.substring(0, packagename.length() - 1);
        }
        String classname = AppSchemaUtil.getClassname(this.model);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"");
        sb.append(enc);
        sb.append("\"?>");
        sb.append(CR);
        sb.append("<!DOCTYPE hibernate-mapping SYSTEM");
        sb.append(CR);
        sb.append("    \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">");
        sb.append(CR);
        sb.append(CR);
        sb.append("<hibernate-mapping auto-import=\"false\" default-lazy=\"false\" default-access=\"field\"");
        sb.append(CR);
        sb.append("      package=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)packagename));
        sb.append("\">");
        sb.append(CR);
        sb.append(CR);
        sb.append("    <import class=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)classname));
        sb.append("\"/>");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("</hibernate-mapping>");
        sb.append(CR);
        return sb.toString();
    }

    private String gClass(String tab, Modelitem container_mitem) {
        String tablename;
        String classname;
        if (container_mitem == null) {
            classname = AppSchemaUtil.getClassname(this.model);
            tablename = this.getModelTablename();
        } else {
            tablename = this.getModelitemTablename(container_mitem);
            classname = AppSchemaUtil.getModelitemClassname(container_mitem);
        }
        if (StringUtils.isBlank((String)tablename)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("<class name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)classname));
        sb.append("\" table=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)tablename));
        sb.append("\">");
        sb.append(CR);
        sb.append(this.gCacheElement(tab + "    "));
        sb.append(this.gPrimaryKey(tab + "    ", container_mitem));
        sb.append(this.gVersion(tab + "    ", container_mitem));
        sb.append(this.gModelitem(tab + "    ", container_mitem));
        if (container_mitem == null) {
            this.addSpecialDefinition(this.model, sb);
        }
        sb.append(tab);
        sb.append("</class>");
        sb.append(CR);
        return sb.toString();
    }

    private String gPrimaryKey(String tab, Modelitem container_mitem) {
        return this.gPrimaryKey(tab, container_mitem, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String gPrimaryKey(String tab, Modelitem container_mitem, boolean isSpecial_CheckBoxModel) {
        StringBuilder sb = new StringBuilder();
        if (this.primarykey.length == 1 && container_mitem == null && !isSpecial_CheckBoxModel) {
            String name = this.primarykey[0].getRefname();
            if (StringUtils.isBlank((String)name)) {
                name = this.primarykey[0].getName();
            }
            Modelitem mitem = AppSchemaUtil.getModelitem(name, this.model);
            String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, mitem);
            sb.append(tab);
            sb.append("<id name=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
            sb.append("\">");
            sb.append(CR);
            sb.append(this.gColumn_PrimaryKey(tab + "    ", this.primarykey[0], mitem, 0));
            sb.append(tab);
            sb.append("</id>");
            sb.append(CR);
            sb.append(CR);
            return sb.toString();
        }
        sb.append(tab);
        sb.append("<composite-id");
        if (container_mitem == null) {
            CompositeKeyGenerator ckgen = new CompositeKeyGenerator(this.project, this.model);
            sb.append(" mapped=\"true\"");
            sb.append(" class=\"");
            sb.append(ckgen.getClassFileName());
            sb.append("\"");
        }
        sb.append(">");
        sb.append(CR);
        HashMap<Modelitem, Integer> usedModelitemMap = new HashMap<Modelitem, Integer>();
        for (PrimaryKey pkey : this.primarykey) {
            String name = pkey.getName();
            String refname = pkey.getRefname();
            Modelitem mitem = null;
            mitem = StringUtils.isNotBlank((String)refname) ? AppSchemaUtil.getModelitem(refname, this.model) : AppSchemaUtil.getModelitem(name, this.model);
            if (mitem == null) continue;
            String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, pkey);
            sb.append(tab);
            sb.append("    <key-property name=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
            sb.append("\">");
            sb.append(CR);
            int index = 0;
            if (usedModelitemMap.containsKey(mitem)) {
                index = (Integer)usedModelitemMap.get(mitem);
                usedModelitemMap.put(mitem, index++);
            } else {
                usedModelitemMap.put(mitem, 0);
            }
            Modelitem c_mitem = null;
            if (container_mitem == null) {
                c_mitem = mitem;
            } else {
                try {
                    c_mitem = new Modelitem(mitem.makeDocument());
                }
                catch (ParserConfigurationException e) {
                    c_mitem = (Modelitem)mitem.clone();
                }
                finally {
                    if (c_mitem != null) {
                        c_mitem.setUniqueKey(null);
                    } else {
                        c_mitem = mitem;
                    }
                }
            }
            sb.append(this.gColumn_PrimaryKey(tab + "        ", pkey, c_mitem, index));
            sb.append(tab);
            sb.append("    </key-property>");
            sb.append(CR);
        }
        if (container_mitem != null) {
            String hibernate_propertyname = null;
            hibernate_propertyname = isSpecial_CheckBoxModel ? AppSchemaUtil.getHibernatePropertyName(container_mitem.getName() + "jshid") : AppSchemaUtil.getHibernatePropertyName(this.model, container_mitem, "jshid");
            sb.append(tab);
            sb.append("    <key-property name=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
            sb.append("\">");
            sb.append(CR);
            sb.append(this.gColumn_ContainerPrimaryKey(tab + "        ", container_mitem));
            sb.append(tab);
            sb.append("    </key-property>");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("</composite-id>");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private boolean isContainerModelitem(Modelitem mitem, Modelitem container_mitem) {
        if (container_mitem == null) {
            int _idx = mitem.getName().indexOf("/");
            boolean isChildFlag = _idx > 0;
            if (isChildFlag) {
                return false;
            }
        } else {
            String container_name = container_mitem.getName() + "/";
            if (!mitem.getName().startsWith(container_name)) {
                return false;
            }
        }
        return true;
    }

    protected String gVersion(String tab, Modelitem containerMitem) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank((String)this.model.getOptimisticLock())) {
            return sb.toString();
        }
        if (containerMitem != null) {
            return sb.toString();
        }
        Modelitem mitem = AppSchemaUtil.getModelitem(this.model.getOptimisticLock(), this.model);
        String hibernatePropertyname = AppSchemaUtil.getHibernatePropertyName(this.model, mitem);
        sb.append(tab);
        sb.append("<version name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernatePropertyname));
        sb.append("\"");
        sb.append(" type=\"long\"");
        sb.append(" unsaved-value=\"negative\"");
        sb.append(">");
        sb.append(CR);
        sb.append(this.gColumn_Normal(tab + "    ", mitem));
        sb.append(tab);
        sb.append("</version>");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gModelitem(String tab, Modelitem container_mitem) {
        StringBuilder sb = new StringBuilder();
        IModelChoice[] imc = this.model.getContent();
        for (int i = 0; i < imc.length; ++i) {
            if (!(imc[i] instanceof Modelitem)) continue;
            Modelitem mitem = (Modelitem)imc[i];
            if (mitem.getTransient() && mitem.getFormula() != null) {
                if (!this.isContainerModelitem(mitem, container_mitem)) continue;
                sb.append(this.gProperty(tab, mitem));
                sb.append(CR);
                continue;
            }
            if (!AppSchemaUtil.isStoreThismodel(mitem) || !mitem.getUseRelax() || mitem.getGeneration() || this.primarykey_name_set.contains(mitem.getName()) || mitem.getName().equals(this.model.getOptimisticLock()) || !this.isContainerModelitem(mitem, container_mitem)) continue;
            boolean isHasChild = mitem.getHasChild();
            if (isHasChild) {
                sb.append(this.gArrayChild(tab, mitem, container_mitem));
                sb.append(CR);
                continue;
            }
            boolean isMultipleFlag = mitem.getMultiple();
            if (isMultipleFlag) {
                sb.append(this.gArrayMultiple(tab, mitem, container_mitem));
                sb.append(CR);
                continue;
            }
            boolean isCheckRelation = AppSchemaUtil.isCheckRelation(mitem);
            if (isCheckRelation) {
                sb.append(this.gArrayMultiple(tab, mitem, container_mitem));
                sb.append(CR);
                continue;
            }
            boolean isAutokey = mitem.getAutokey();
            if (isAutokey) {
                sb.append(this.gPropertyAutokey(tab, mitem, container_mitem));
                sb.append(CR);
                continue;
            }
            sb.append(this.gProperty(tab, mitem));
            sb.append(CR);
        }
        return sb.toString();
    }

    private String gProperty(String tab, Modelitem mitem) {
        boolean isRefCompositeKey = false;
        boolean isRefRelation = false;
        PrimaryKey[] pkeys = null;
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        if (relation == null) {
            relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.model, mitem);
            isRefRelation = true;
        }
        if (relation != null) {
            Model __rmodel = AppSchemaUtil.getIdrefAsIRNode(this.project, relation);
            if (__rmodel == null) {
                logger.error("No relation/@iderf model is found." + mitem);
                return "";
            }
            pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(__rmodel, this.project);
            if (pkeys != null && pkeys.length > 1) {
                isRefCompositeKey = true;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!isRefCompositeKey) {
            String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, mitem);
            sb.append(tab);
            sb.append("<property name=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
            sb.append("\">");
            sb.append(CR);
            sb.append(this.gColumn_Normal(tab + "    ", mitem));
            sb.append(tab);
            sb.append("</property>");
            sb.append(CR);
        } else {
            for (int i = 0; i < pkeys.length; ++i) {
                Modelitem c_mitem = null;
                try {
                    c_mitem = new Modelitem(mitem.makeDocument());
                }
                catch (ParserConfigurationException e) {
                    c_mitem = (Modelitem)mitem.clone();
                }
                String orig = c_mitem.getName();
                c_mitem.setName(orig + "_" + pkeys[i].getName());
                String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, c_mitem);
                sb.append(tab);
                sb.append("<property name=\"");
                sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
                sb.append("\">");
                sb.append(CR);
                if (!isRefRelation) {
                    sb.append(this.gColumn_Normal(tab + "    ", c_mitem, orig, i));
                } else {
                    sb.append(this.gColumn_Normal(tab + "    ", mitem, i));
                }
                sb.append(tab);
                sb.append("</property>");
                sb.append(CR);
            }
        }
        return sb.toString();
    }

    private String gPropertyAutokey(String tab, Modelitem mitem, Modelitem container_mitem) {
        StringBuilder sb = new StringBuilder();
        String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, mitem);
        String container_columnname = this.getColumnnameWithJshid(container_mitem);
        if (StringUtils.isBlank((String)container_columnname)) {
            return "";
        }
        sb.append(tab);
        sb.append("<property name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
        sb.append("\" formula=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)container_columnname));
        sb.append("+1\"/>");
        sb.append(CR);
        return sb.toString();
    }

    public String gArrayChild(String tab, Modelitem mitem, Modelitem container_mitem) {
        String hibernate_propertyname = AppSchemaUtil.getHibernatePropertyName(this.model, mitem);
        String tablename = this.getModelitemTablename(mitem);
        String classname = AppSchemaUtil.getModelitemClassname(mitem);
        if (StringUtils.isBlank((String)tablename)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("<list name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
        sb.append("\" table=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)tablename));
        sb.append("\" cascade=\"all-delete-orphan\" lazy=\"true\" inverse=\"true\">");
        sb.append(CR);
        sb.append(this.gPrimaryKeyColumn(tab + "    ", container_mitem));
        sb.append(tab);
        sb.append("    <index type=\"integer\">");
        sb.append(CR);
        sb.append(this.gColumn_ContainerPrimaryKey(tab + "        ", mitem));
        sb.append(tab);
        sb.append("    </index>");
        sb.append(CR);
        sb.append(tab);
        sb.append("    <one-to-many class=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)classname));
        sb.append("\"/>");
        sb.append(CR);
        sb.append(tab);
        sb.append("</list>");
        sb.append(CR);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String gArrayMultiple(String tab, Modelitem mitem, Modelitem container_mitem) {
        String type;
        boolean isCompositeKeyInCheckbox = false;
        PrimaryKey[] r_pkeys = null;
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
        if (relation == null) {
            relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.model, mitem);
        }
        if (relation != null) {
            Model rmodel = AppSchemaUtil.getIdrefAsIRNode(this.project, relation);
            if (rmodel == null) {
                logger.error("No relation/@iderf model is found." + mitem);
                return "";
            }
            r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
            if (r_pkeys != null && r_pkeys.length > 1 && "check".equals(relation.getType())) {
                isCompositeKeyInCheckbox = true;
            }
        }
        if ((type = AppSchemaUtil.getModelitemType(this.project, this.model.getId(), mitem, "roleid")).endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
        }
        if (type.equals("dateTime")) {
            type = "timestamp";
        }
        String hibernate_propertyname = null;
        hibernate_propertyname = !isCompositeKeyInCheckbox ? AppSchemaUtil.getHibernatePropertyName(this.model, mitem) : AppSchemaUtil.getHibernatePropertyName(mitem.getName());
        String tablename = this.getModelitemTablename(mitem);
        String classname = AppSchemaUtil.getModelitemClassname(mitem);
        if (StringUtils.isBlank((String)tablename)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("<list name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname));
        sb.append("\" table=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)tablename));
        sb.append("\" cascade=\"all\" lazy=\"true\"");
        if (isCompositeKeyInCheckbox) {
            sb.append(" inverse=\"true\"");
        }
        sb.append(">");
        sb.append(CR);
        sb.append(this.gPrimaryKeyColumn(tab + "    ", container_mitem));
        if (!isCompositeKeyInCheckbox) {
            sb.append(tab);
            sb.append("    <index type=\"integer\">");
            sb.append(CR);
            sb.append(this.gColumn_ContainerPrimaryKey(tab + "        ", mitem));
            sb.append(tab);
            sb.append("    </index>");
            sb.append(CR);
            sb.append(tab);
            sb.append("    <element type=\"");
            sb.append(type);
            sb.append("\">");
            sb.append(CR);
            sb.append(this.gColumn_Normal(tab + "        ", mitem));
            sb.append(tab);
            sb.append("    </element>");
            sb.append(CR);
        } else {
            HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(mitem);
            String _columnname = mitem.getName() + "jshid";
            hp.setListIndexColumnname(_columnname);
            sb.append(tab);
            sb.append("    <index type=\"integer\">");
            sb.append(CR);
            sb.append(this.gColumn_ContainerPrimaryKey(tab + "        ", mitem));
            sb.append(tab);
            sb.append("    </index>");
            sb.append(CR);
            sb.append(tab);
            sb.append("    <one-to-many class=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)classname));
            sb.append("\"/>");
            sb.append(CR);
            StringBuilder sb2 = new StringBuilder();
            String tab2 = "    ";
            sb2.append(tab2);
            sb2.append("<class name=\"");
            sb2.append(WebStringEncodeUtilities.replaceCharEntity((String)classname));
            sb2.append("\" table=\"");
            sb2.append(WebStringEncodeUtilities.replaceCharEntity((String)tablename));
            sb2.append("\">");
            sb2.append(CR);
            Modelitem c_mitem = null;
            try {
                c_mitem = new Modelitem(mitem.makeDocument());
            }
            catch (ParserConfigurationException e) {
                c_mitem = (Modelitem)mitem.clone();
            }
            finally {
                if (c_mitem != null) {
                    c_mitem.setUniqueKey(null);
                } else {
                    c_mitem = mitem;
                }
            }
            sb2.append(this.gPrimaryKey(tab2 + "    ", c_mitem, true));
            for (int i = 0; i < r_pkeys.length; ++i) {
                PrimaryKey r_pkey = r_pkeys[i];
                try {
                    c_mitem = new Modelitem(mitem.makeDocument());
                }
                catch (ParserConfigurationException e) {
                    c_mitem = (Modelitem)mitem.clone();
                }
                c_mitem.setName(r_pkey.getName());
                String hibernate_propertyname2 = AppSchemaUtil.getHibernatePropertyName(this.model, c_mitem);
                sb2.append(tab2 + "    ");
                sb2.append("<property name=\"");
                sb2.append(WebStringEncodeUtilities.replaceCharEntity((String)hibernate_propertyname2));
                sb2.append("\">");
                sb2.append(CR);
                sb2.append(this.gColumn_Normal(tab2 + "        ", c_mitem, i));
                sb2.append(tab2 + "    ");
                sb2.append("</property>");
                sb2.append(CR);
            }
            sb2.append(tab2);
            sb2.append("</class>");
            sb2.append(CR);
            this.addClassDefinitionList.add(sb2.toString());
        }
        sb.append(tab);
        sb.append("</list>");
        sb.append(CR);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String gPrimaryKeyColumn(String tab, Modelitem container_mitem) {
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("<key>");
        sb.append(CR);
        HashMap<Modelitem, Integer> usedModelitemMap = new HashMap<Modelitem, Integer>();
        for (PrimaryKey pkey : this.primarykey) {
            String name = pkey.getName();
            String refname = pkey.getRefname();
            Modelitem mitem = null;
            mitem = StringUtils.isNotBlank((String)refname) ? AppSchemaUtil.getModelitem(refname, this.model) : AppSchemaUtil.getModelitem(name, this.model);
            if (mitem == null) continue;
            int index = 0;
            if (usedModelitemMap.containsKey(mitem)) {
                index = (Integer)usedModelitemMap.get(mitem);
                usedModelitemMap.put(mitem, index++);
            } else {
                usedModelitemMap.put(mitem, 0);
            }
            Modelitem c_mitem = null;
            try {
                c_mitem = new Modelitem(mitem.makeDocument());
            }
            catch (ParserConfigurationException e) {
                c_mitem = (Modelitem)mitem.clone();
            }
            finally {
                if (c_mitem != null) {
                    c_mitem.setUniqueKey(null);
                } else {
                    c_mitem = mitem;
                }
            }
            sb.append(this.gColumn_PrimaryKey(tab + "    ", pkey, c_mitem, index));
        }
        if (container_mitem != null) {
            sb.append(this.gColumn_ContainerPrimaryKey(tab + "    ", container_mitem));
        }
        sb.append(tab);
        sb.append("</key>");
        sb.append(CR);
        return sb.toString();
    }

    private String gColumn_Normal(String tab, Modelitem mitem) {
        return this.gColumn_Normal(tab, mitem, 0);
    }

    private String gColumn_Normal(String tab, Modelitem mitem, int index) {
        return this.gColumn_Normal(tab, mitem, null, index);
    }

    private String gColumn_Normal(String tab, Modelitem mitem, String orig_name, int index) {
        StringBuilder sb = new StringBuilder();
        if (mitem.getTransient() && mitem.getFormula() != null) {
            String value = mitem.getFormula();
            value = StringUtil.replaceAll((String)value, (String)"<", (String)"&lt;");
            value = StringUtil.replaceAll((String)value, (String)">", (String)"&gt;");
            sb.append(tab);
            sb.append("<formula>");
            sb.append(value);
            sb.append("</formula>");
            sb.append(CR);
            return sb.toString();
        }
        String columnname = this.getColumnname(mitem, index);
        sb.append(tab);
        sb.append("<column name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)columnname));
        sb.append("\"");
        if (this.isMustFlag(this.model, mitem)) {
            sb.append(" not-null=\"true\"");
            sb.append(this.defaultValue(mitem));
        }
        if (mitem.getUnique()) {
            sb.append(" unique=\"true\"");
        }
        if (mitem.getUniqueKey() != null) {
            sb.append(" unique-key=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)mitem.getUniqueKey()));
            sb.append("\"");
        }
        sb.append(this.gColumnSqltype(columnname, mitem, orig_name));
        sb.append("/>");
        sb.append(CR);
        return sb.toString();
    }

    private String defaultValue(Modelitem mitem) {
        Database database = ModelUtils.getSubDatabase(this.model);
        if (database == null) {
            database = AppSchemaUtil.getDatabase(this.project.getEnvironment());
        }
        if (!database.getColumnDefault()) {
            return "";
        }
        String value = InitdbImportXslGenerator.createDefaultValue(this.model, mitem, null, -1, this.project);
        String type = AppSchemaUtil.getModelitemType(this.project, this.model.getId(), mitem, "roleid");
        if (value.indexOf("(") >= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" default=\"");
        if (!JavaSourceGenerator.isBasicType(type)) {
            value = "'" + value + "'";
        }
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)value));
        sb.append("\"");
        return sb.toString();
    }

    private boolean isMustFlag(Model model, Modelitem mitem) {
        if (AppSchemaUtil.isCheckRelation(mitem)) {
            return false;
        }
        return HibernateMappingGenerator.isMust(model, mitem, this.checkitems);
    }

    public static boolean isMust(Model model, Modelitem mitem) {
        return HibernateMappingGenerator.isMust(model, mitem, HibernateMappingGenerator.getCheckitem(model));
    }

    private static boolean isMust(Model model, Modelitem mitem, Checkitem[] checkitems) {
        if (!AppSchemaUtil.isStoreThismodel(mitem)) {
            return false;
        }
        String modelitemname = mitem.getName();
        String elemname = AppSchemaUtil.getChildPart(modelitemname);
        if (checkitems != null) {
            for (int j = 0; j < checkitems.length; ++j) {
                Checkitem checkitem = checkitems[j];
                if (!elemname.equals(checkitem.getName()) || !"EQ".equals(checkitem.getCond()) || !"null".equals(checkitem.getValue())) continue;
                return true;
            }
        }
        return mitem.getMust();
    }

    private String gColumn_PrimaryKey(String tab, PrimaryKey pkey, Modelitem mitem, int index) {
        StringBuilder sb = new StringBuilder();
        String columnname = null;
        columnname = pkey != null && StringUtils.isNotBlank((String)pkey.getRefname()) && mitem.getRdbcolumnname() != null && mitem.getRdbcolumnname().indexOf(",") < 0 ? this.getColumnname(pkey) : this.getColumnname(mitem, index);
        sb.append(tab);
        sb.append("<column name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)columnname));
        sb.append("\"");
        if (mitem.getUniqueKey() != null) {
            sb.append(" unique-key=\"");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)mitem.getUniqueKey()));
            sb.append("\"");
        }
        sb.append(this.gColumnSqltype(columnname, mitem));
        sb.append("/>");
        sb.append(CR);
        return sb.toString();
    }

    private String gColumn_ContainerPrimaryKey(String tab, Modelitem container_mitem) {
        StringBuilder sb = new StringBuilder();
        String columnname = this.getColumnnameWithJshid(container_mitem);
        if (StringUtils.isBlank((String)columnname)) {
            return "";
        }
        sb.append(tab);
        sb.append("<column name=\"");
        sb.append(WebStringEncodeUtilities.replaceCharEntity((String)columnname));
        sb.append("\"/>");
        sb.append(CR);
        return sb.toString();
    }

    private String gColumnSqltype(String columnname, Modelitem mitem) {
        return this.gColumnSqltype(columnname, mitem, null);
    }

    private String gColumnSqltype(String columnname, Modelitem mitem, String orig_name) {
        StringBuilder sb = new StringBuilder();
        if (mitem.getInherit() && "storeref".equals(mitem.getType())) {
            PrimaryKey[] r_pkeys;
            Relation relation = AppSchemaUtil.getRelation(mitem);
            Model rmodel = AppSchemaUtil.getIdrefAsIRNode(this.project, relation);
            if (rmodel == null) {
                logger.error("No relation/@iderf model is found." + mitem);
                return "";
            }
            if ("ref".equals(relation.getType())) {
                String type = "";
                Relation last_r = AppSchemaUtil.getRelatedLastRelation(relation);
                if (last_r != null) {
                    String rdbdatatype;
                    Model last_mo = (Model)last_r.getIdrefAsIRNode();
                    Modelitem last_mi = null;
                    if ("ref".equals(last_r.getType())) {
                        last_mi = AppSchemaUtil.getModelitemConsideringCompositeKey(last_r.getName(), last_mo);
                    } else {
                        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(last_mo, this.project);
                        if (pkeys != null && pkeys.length == 1) {
                            last_mi = AppSchemaUtil.getModelitem(pkeys[0].getName(), last_mo);
                        } else if (pkeys != null && pkeys.length > 1) {
                            logger.warn("[BR 13696] last_r has complex key, please check this pattern: " + last_r + " -> " + last_mo.getId());
                        }
                    }
                    if (last_mi != null && StringUtils.isNotBlank((String)(rdbdatatype = last_mi.getRdbdatatype()))) {
                        type = this.gColumnSqltype(null, last_mi);
                    }
                    return type;
                }
                Relation rel0 = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.project, rmodel, mitem);
                if (rel0 == null) {
                    String rdbdatatype;
                    Modelitem r_mitem = AppSchemaUtil.getModelitemConsideringCompositeKey(relation.getName(), rmodel);
                    if (r_mitem != null && StringUtils.isNotBlank((String)(rdbdatatype = r_mitem.getRdbdatatype()))) {
                        type = this.gColumnSqltype(null, r_mitem);
                    }
                    return type;
                }
            }
            if ((r_pkeys = AppSchemaUtil.getPrimaryKey(rmodel)) != null && r_pkeys.length == 1) {
                Modelitem r_mitem = AppSchemaUtil.getModelitemConsideringCompositeKey(r_pkeys[0], rmodel);
                String type = this.gColumnSqltype(null, r_mitem);
                return type;
            }
            if (r_pkeys != null) {
                int index = -1;
                String rdbcolumnname = mitem.getRdbcolumnname();
                if (StringUtils.isNotBlank((String)rdbcolumnname) && rdbcolumnname.indexOf(",") > 0) {
                    String[] tokens = rdbcolumnname.split(",");
                    for (int i = 0; i < tokens.length; ++i) {
                        String token = tokens[i].trim();
                        if (this.quoteid != null) {
                            token = this.quoteid + token + this.quoteid;
                        }
                        if (!columnname.equals(token)) continue;
                        index = i;
                        break;
                    }
                }
                for (int i = 0; i < r_pkeys.length; ++i) {
                    String n_columnname;
                    PrimaryKey r_pkey = r_pkeys[i];
                    Modelitem r_mitem = AppSchemaUtil.getModelitemConsideringCompositeKey(r_pkey, rmodel);
                    if (orig_name == null) {
                        n_columnname = AppSchemaUtil.getChildPart(mitem.getName()) + "_" + r_pkey.getName();
                        n_columnname = SourceGenerator.convertRdbColumnname(n_columnname);
                        if (this.quoteid != null) {
                            n_columnname = this.quoteid + n_columnname + this.quoteid;
                        }
                        if (!n_columnname.equals(columnname) && i != index) continue;
                        String type = this.gColumnSqltype(n_columnname, r_mitem);
                        return type;
                    }
                    n_columnname = AppSchemaUtil.getChildPart(orig_name) + "_" + r_pkey.getName();
                    if (this.quoteid != null) {
                        n_columnname = this.quoteid + n_columnname + this.quoteid;
                    }
                    if (!n_columnname.equals(columnname) && i != index) continue;
                    String type = this.gColumnSqltype(n_columnname, r_mitem);
                    return type;
                }
            }
        } else {
            String rdbdatatype = mitem.getRdbdatatype();
            if (rdbdatatype != null && !rdbdatatype.equals("")) {
                if ("storeref".equals(mitem.getType())) {
                    PrimaryKey[] r_pkeys;
                    Relation relation = AppSchemaUtil.getRelation(mitem);
                    Model rmodel = AppSchemaUtil.getIdrefAsIRNode(this.project, relation);
                    PrimaryKey[] primaryKeyArray = r_pkeys = rmodel != null ? AppSchemaUtil.getPrimaryKey(rmodel) : null;
                    if (r_pkeys != null && r_pkeys.length > 1) {
                        Object[] o = new Object[]{this.model.getId(), mitem.getName(), rdbdatatype};
                        logger.warn(this.rman.getValue("HibernateMappingGenerator.rdbdatatype.ignore.complexkey", o));
                        rdbdatatype = null;
                    }
                }
                if (rdbdatatype != null) {
                    sb.append(" sql-type=\"");
                    sb.append(WebStringEncodeUtilities.replaceCharEntity((String)rdbdatatype));
                    sb.append("\"");
                }
            } else {
                HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(mitem);
                Integer column_length = null;
                if (hp != null) {
                    column_length = hp.getColumnLengthAsInteger();
                }
                if (column_length != null && column_length > 0) {
                    sb.append(" length=\"");
                    sb.append(column_length);
                    sb.append("\"");
                }
            }
        }
        return sb.toString();
    }

    private String getModelTablename() {
        String tablename = TablenameGenerator.createTableName(this.model);
        tablename = this.convertTablename(tablename);
        if (this.quoteid != null) {
            tablename = this.quoteid + tablename + this.quoteid;
        }
        return tablename;
    }

    private String getModelitemTablename(Modelitem mitem) {
        HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(mitem);
        if (hp == null) {
            if (!mitem.getTransient()) {
                logger.error("HibernateParameterModelitem is null in model " + this.model.getId() + " modelitem " + mitem.getName());
            }
            return null;
        }
        String tablename = hp.getListTablename();
        tablename = this.convertTablename(tablename);
        if (this.quoteid != null) {
            tablename = this.quoteid + tablename + this.quoteid;
        }
        return tablename;
    }

    private String convertTablename(String tablename) {
        String key = "jp.jasminesoft.jfc.gen.HibernateMappingGenerator.tablename.separator";
        String tablenameSeparator = this.compatibilityManager.getStringValue(key = key + "." + this.model.getId());
        if (StringUtils.isNotBlank((String)tablenameSeparator)) {
            tablename = tablename.replace("$", tablenameSeparator);
        }
        return tablename;
    }

    private String getColumnname(PrimaryKey pkey) {
        String columnname = AppSchemaUtil.createFullPrimaryKeyName(pkey);
        String key = "jp.jasminesoft.jfc.gen.HibernateMappingGenerator.primaryKey.columnName.snakeCase";
        if (!this.compatibilityManager.getBooleanValue(key = key + "." + this.model.getId())) {
            columnname = SourceGenerator.convertRdbColumnname(columnname);
        }
        if (this.quoteid != null) {
            columnname = this.quoteid + columnname + this.quoteid;
        }
        return columnname;
    }

    private String getColumnname(Modelitem mitem, int index) {
        String columnname = AppSchemaUtil.getProperColumnName(this.project, this.model, mitem, index);
        if (this.quoteid != null) {
            columnname = this.quoteid + columnname + this.quoteid;
        }
        return columnname;
    }

    private String getColumnnameWithJshid(Modelitem container_mitem) {
        HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(container_mitem);
        if (hp == null) {
            if (!container_mitem.getTransient()) {
                logger.error("HibernateParameterModelitem is null in model " + this.model.getId() + " modelitem " + container_mitem.getName());
            }
            return null;
        }
        String columnname = hp.getListIndexColumnname();
        if (this.quoteid != null) {
            columnname = this.quoteid + columnname + this.quoteid;
        }
        return columnname;
    }

    protected String gCacheElement(String basetab) {
        return "";
    }
}

